/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.dfs.DataStorage;
import org.apache.hadoop.dfs.DatanodeID;
import org.apache.hadoop.dfs.Storage;
import org.apache.hadoop.dfs.StorageInfo;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

class DatanodeRegistration
extends DatanodeID
implements Writable {
    StorageInfo storageInfo = new StorageInfo();

    public DatanodeRegistration() {
        this("");
    }

    public DatanodeRegistration(String nodeName) {
        super(nodeName);
    }

    void setInfoPort(int infoPort) {
        this.infoPort = infoPort;
    }

    void setIpcPort(int ipcPort) {
        this.ipcPort = ipcPort;
    }

    void setStorageInfo(DataStorage storage) {
        this.storageInfo = new StorageInfo(storage);
        this.storageID = storage.getStorageID();
    }

    void setName(String name) {
        this.name = name;
    }

    public int getVersion() {
        return this.storageInfo.getLayoutVersion();
    }

    public String getRegistrationID() {
        return Storage.getRegistrationID(this.storageInfo);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.name + ", storageID=" + this.storageID + ", infoPort=" + this.infoPort + ", ipcPort=" + this.ipcPort + ")";
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeShort(this.ipcPort);
        out.writeInt(this.storageInfo.getLayoutVersion());
        out.writeInt(this.storageInfo.getNamespaceID());
        out.writeLong(this.storageInfo.getCTime());
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.ipcPort = in.readShort() & 0xFFFF;
        this.storageInfo.layoutVersion = in.readInt();
        this.storageInfo.namespaceID = in.readInt();
        this.storageInfo.cTime = in.readLong();
    }

    static {
        WritableFactories.setFactory(DatanodeRegistration.class, new WritableFactory(){

            public Writable newInstance() {
                return new DatanodeRegistration();
            }
        });
    }
}

