/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.dfs.DatanodeID;
import org.apache.hadoop.dfs.UpgradeCommand;

class DatanodeStatsCommand
extends UpgradeCommand {
    DatanodeID datanodeId;
    int blocksUpgraded;
    int blocksRemaining;
    int errors;

    DatanodeStatsCommand() {
        super(300, 0, (short)0);
        this.datanodeId = new DatanodeID();
    }

    public DatanodeStatsCommand(short status, DatanodeID dn, int blocksUpgraded, int blocksRemaining, int errors, int version) {
        super(300, version, status);
        this.datanodeId = new DatanodeID(dn);
        this.blocksUpgraded = blocksUpgraded;
        this.blocksRemaining = blocksRemaining;
        this.errors = errors;
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.datanodeId.readFields(in);
        this.blocksUpgraded = in.readInt();
        this.blocksRemaining = in.readInt();
        this.errors = in.readInt();
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.datanodeId.write(out);
        out.writeInt(this.blocksUpgraded);
        out.writeInt(this.blocksRemaining);
        out.writeInt(this.errors);
    }
}

