/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.datanode.metrics.FSDatasetMBean;
import org.apache.hadoop.util.DiskChecker;

public interface FSDatasetInterface
extends FSDatasetMBean {
    public long getMetaDataLength(Block var1) throws IOException;

    public MetaDataInputStream getMetaDataInputStream(Block var1) throws IOException;

    public boolean metaFileExists(Block var1) throws IOException;

    public long getLength(Block var1) throws IOException;

    public Block getStoredBlock(long var1) throws IOException;

    public InputStream getBlockInputStream(Block var1) throws IOException;

    public InputStream getBlockInputStream(Block var1, long var2) throws IOException;

    public BlockWriteStreams writeToBlock(Block var1, boolean var2) throws IOException;

    public void updateBlock(Block var1, Block var2) throws IOException;

    public void finalizeBlock(Block var1) throws IOException;

    public void unfinalizeBlock(Block var1) throws IOException;

    public Block[] getBlockReport();

    public boolean isValidBlock(Block var1);

    public void invalidate(Block[] var1) throws IOException;

    public void checkDataDir() throws DiskChecker.DiskErrorException;

    public String toString();

    public void shutdown();

    public long getChannelPosition(Block var1, BlockWriteStreams var2) throws IOException;

    public void setChannelPosition(Block var1, BlockWriteStreams var2, long var3, long var5) throws IOException;

    public static class BlockWriteStreams {
        OutputStream dataOut;
        OutputStream checksumOut;

        BlockWriteStreams(OutputStream dOut, OutputStream cOut) {
            this.dataOut = dOut;
            this.checksumOut = cOut;
        }
    }

    public static class MetaDataInputStream
    extends FilterInputStream {
        private long length;

        MetaDataInputStream(InputStream stream, long len) {
            super(stream);
            this.length = len;
        }

        public long getLength() {
            return this.length;
        }
    }
}

