/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.BlocksMap;
import org.apache.hadoop.dfs.DFSFileInfo;
import org.apache.hadoop.dfs.DatanodeDescriptor;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.FSEditLog;
import org.apache.hadoop.dfs.FSImage;
import org.apache.hadoop.dfs.FSNamesystem;
import org.apache.hadoop.dfs.INode;
import org.apache.hadoop.dfs.INodeDirectory;
import org.apache.hadoop.dfs.INodeDirectoryWithQuota;
import org.apache.hadoop.dfs.INodeFile;
import org.apache.hadoop.dfs.INodeFileUnderConstruction;
import org.apache.hadoop.dfs.NameNode;
import org.apache.hadoop.dfs.QuotaExceededException;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FSDirectory
implements FSConstants,
Closeable {
    FSNamesystem namesystem = null;
    final INodeDirectoryWithQuota rootDir;
    FSImage fsImage;
    boolean ready = false;
    private MetricsRecord directoryMetrics = null;

    public FSDirectory(FSNamesystem ns, Configuration conf) throws IOException {
        this(new FSImage(), ns, conf);
        this.fsImage.setCheckpointDirectories(FSImage.getCheckpointDirs(conf, null));
    }

    public FSDirectory(FSImage fsImage, FSNamesystem ns, Configuration conf) throws IOException {
        this.rootDir = new INodeDirectoryWithQuota("", ns.createFsOwnerPermissions(new FsPermission(493)), Integer.MAX_VALUE);
        this.fsImage = fsImage;
        this.namesystem = ns;
        this.initialize(conf);
    }

    private void initialize(Configuration conf) {
        MetricsContext metricsContext = MetricsUtil.getContext("dfs");
        this.directoryMetrics = MetricsUtil.createRecord(metricsContext, "FSDirectory");
        this.directoryMetrics.setTag("sessionId", conf.get("session.id"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFSImage(Collection<File> dataDirs, FSConstants.StartupOption startOpt) throws IOException {
        if (startOpt == FSConstants.StartupOption.FORMAT) {
            this.fsImage.setStorageDirectories(dataDirs);
            this.fsImage.format();
            startOpt = FSConstants.StartupOption.REGULAR;
        }
        try {
            if (this.fsImage.recoverTransitionRead(dataDirs, startOpt)) {
                this.fsImage.saveFSImage();
            }
            FSEditLog editLog = this.fsImage.getEditLog();
            assert (editLog != null) : "editLog must be initialized";
            if (!editLog.isOpen()) {
                editLog.open();
            }
            this.fsImage.setCheckpointDirectories(null);
        }
        catch (IOException e) {
            this.fsImage.close();
            throw e;
        }
        FSDirectory fSDirectory = this;
        synchronized (fSDirectory) {
            this.ready = true;
            this.notifyAll();
        }
    }

    private void incrDeletedFileCount(int count) {
        this.directoryMetrics.incrMetric("files_deleted", count);
        this.directoryMetrics.update();
    }

    @Override
    public void close() throws IOException {
        this.fsImage.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForReady() {
        if (!this.ready) {
            FSDirectory fSDirectory = this;
            synchronized (fSDirectory) {
                while (!this.ready) {
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INodeFileUnderConstruction addFile(String path, PermissionStatus permissions, short replication, long preferredBlockSize, String clientName, String clientMachine, DatanodeDescriptor clientNode, long generationStamp) throws IOException {
        this.waitForReady();
        long modTime = FSNamesystem.now();
        if (!this.mkdirs(new Path(path).getParent().toString(), permissions, true, modTime)) {
            return null;
        }
        INodeFileUnderConstruction newNode = new INodeFileUnderConstruction(permissions, replication, preferredBlockSize, modTime, clientName, clientMachine, clientNode);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            newNode = this.addNode(path, newNode, false);
        }
        if (newNode == null) {
            NameNode.stateChangeLog.info((Object)("DIR* FSDirectory.addFile: failed to add " + path + " to the file system"));
            return null;
        }
        this.fsImage.getEditLog().logOpenFile(path, newNode);
        NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.addFile: " + path + " is added to the file system"));
        return newNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INode unprotectedAddFile(String path, PermissionStatus permissions, Block[] blocks, short replication, long modificationTime, long preferredBlockSize) {
        INode newNode = blocks == null ? new INodeDirectory(permissions, modificationTime) : new INodeFile(permissions, blocks.length, replication, modificationTime, preferredBlockSize);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            try {
                newNode = this.addNode(path, newNode, false);
                if (newNode != null && blocks != null) {
                    int nrBlocks = blocks.length;
                    INodeFile newF = (INodeFile)newNode;
                    for (int i = 0; i < nrBlocks; ++i) {
                        newF.setBlock(i, this.namesystem.blocksMap.addINode(blocks[i], newF));
                    }
                }
            }
            catch (IOException e) {
                return null;
            }
            return newNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INodeDirectory addToParent(String src, INodeDirectory parentINode, PermissionStatus permissions, Block[] blocks, short replication, long modificationTime, long quota, long preferredBlockSize) {
        INode newNode = blocks == null ? (quota >= 0L ? new INodeDirectoryWithQuota(permissions, modificationTime, quota) : new INodeDirectory(permissions, modificationTime)) : new INodeFile(permissions, blocks.length, replication, modificationTime, preferredBlockSize);
        INodeDirectory newParent = null;
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            try {
                newParent = this.rootDir.addToParent(src, newNode, parentINode, false);
            }
            catch (FileNotFoundException e) {
                return null;
            }
            if (newParent == null) {
                return null;
            }
            if (blocks != null) {
                int nrBlocks = blocks.length;
                INodeFile newF = (INodeFile)newNode;
                for (int i = 0; i < nrBlocks; ++i) {
                    newF.setBlock(i, this.namesystem.blocksMap.addINode(blocks[i], newF));
                }
            }
        }
        return newParent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Block addBlock(String path, INode file, Block block) throws IOException {
        this.waitForReady();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INodeFile fileNode = (INodeFile)file;
            this.namesystem.blocksMap.addINode(block, fileNode);
            BlocksMap.BlockInfo blockInfo = this.namesystem.blocksMap.getStoredBlock(block);
            fileNode.addBlock(blockInfo);
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.addFile: " + path + " with " + block + " block is added to the in-memory " + "file system"));
        }
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persistBlocks(String path, INodeFileUnderConstruction file) throws IOException {
        this.waitForReady();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            this.fsImage.getEditLog().logOpenFile(path, file);
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.persistBlocks: " + path + " with " + file.getBlocks().length + " blocks is persisted to the file system"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeFile(String path, INodeFile file) throws IOException {
        this.waitForReady();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            this.fsImage.getEditLog().logCloseFile(path, file);
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.closeFile: " + path + " with " + file.getBlocks().length + " blocks is persisted to the file system"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeBlock(String path, INodeFileUnderConstruction fileNode, Block block) throws IOException {
        this.waitForReady();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            fileNode.removeBlock(block);
            this.namesystem.blocksMap.removeINode(block);
            this.namesystem.corruptReplicas.removeFromCorruptReplicasMap(block);
            this.fsImage.getEditLog().logOpenFile(path, fileNode);
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.addFile: " + path + " with " + block + " block is added to the file system"));
        }
        return true;
    }

    public boolean renameTo(String src, String dst) throws QuotaExceededException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.renameTo: " + src + " to " + dst));
        }
        this.waitForReady();
        long now = FSNamesystem.now();
        if (!this.unprotectedRenameTo(src, dst, now)) {
            return false;
        }
        this.fsImage.getEditLog().logRename(src, dst, now);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unprotectedRenameTo(String src, String dst, long timestamp) throws QuotaExceededException {
        byte[][] srcComponents = INode.getPathComponents(src);
        INode[] srcInodes = new INode[srcComponents.length];
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            this.rootDir.getExistingPathINodes(srcComponents, srcInodes);
            if (srcInodes[srcInodes.length - 1] == null) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because source does not exist"));
                return false;
            }
            if (srcInodes.length == 1) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because source is the root"));
                return false;
            }
            if (this.isDir(dst)) {
                dst = dst + "/" + new Path(src).getName();
            }
            byte[][] dstComponents = INode.getPathComponents(dst);
            INode[] dstInodes = new INode[dstComponents.length];
            this.rootDir.getExistingPathINodes(dstComponents, dstInodes);
            if (dstInodes[dstInodes.length - 1] != null) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination exists"));
                return false;
            }
            INode srcChild = null;
            try {
                srcChild = this.removeChild(srcInodes, srcInodes.length - 1);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (srcChild == null) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because the source can not be removed"));
                return false;
            }
            INode dstChild = null;
            QuotaExceededException failureByQuota = null;
            try {
                srcChild.setLocalName(dstComponents[dstInodes.length - 1]);
                dstChild = this.addChild(dstInodes, dstInodes.length - 1, srcChild, false);
            }
            catch (QuotaExceededException qe) {
                failureByQuota = qe;
            }
            if (dstChild != null) {
                NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.unprotectedRenameTo: " + src + " is renamed to " + dst));
                srcInodes[srcInodes.length - 2].setModificationTime(timestamp);
                dstInodes[dstInodes.length - 2].setModificationTime(timestamp);
                return true;
            }
            NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst));
            try {
                this.addChild(srcInodes, srcInodes.length - 1, srcChild, false);
            }
            catch (IOException ignored) {
                // empty catch block
            }
            if (failureByQuota != null) {
                throw failureByQuota;
            }
            return false;
        }
    }

    Block[] setReplication(String src, short replication, int[] oldReplication) throws IOException {
        this.waitForReady();
        Block[] fileBlocks = this.unprotectedSetReplication(src, replication, oldReplication);
        if (fileBlocks != null) {
            this.fsImage.getEditLog().logSetReplication(src, replication);
        }
        return fileBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Block[] unprotectedSetReplication(String src, short replication, int[] oldReplication) throws IOException {
        if (oldReplication == null) {
            oldReplication = new int[]{-1};
        }
        Block[] fileBlocks = null;
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode inode = this.rootDir.getNode(src);
            if (inode == null) {
                return null;
            }
            if (inode.isDirectory()) {
                return null;
            }
            INodeFile fileNode = (INodeFile)inode;
            oldReplication[0] = fileNode.getReplication();
            fileNode.setReplication(replication);
            fileBlocks = fileNode.getBlocks();
        }
        return fileBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPreferredBlockSize(String filename) throws IOException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode fileNode = this.rootDir.getNode(filename);
            if (fileNode == null) {
                throw new IOException("Unknown file: " + filename);
            }
            if (fileNode.isDirectory()) {
                throw new IOException("Getting block size of a directory: " + filename);
            }
            return ((INodeFile)fileNode).getPreferredBlockSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean exists(String src) {
        src = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode inode = this.rootDir.getNode(src);
            if (inode == null) {
                return false;
            }
            return inode.isDirectory() ? true : ((INodeFile)inode).getBlocks() != null;
        }
    }

    void setPermission(String src, FsPermission permission) throws IOException {
        this.unprotectedSetPermission(src, permission);
        this.fsImage.getEditLog().logSetPermissions(src, permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unprotectedSetPermission(String src, FsPermission permissions) throws FileNotFoundException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode inode = this.rootDir.getNode(src);
            if (inode == null) {
                throw new FileNotFoundException("File does not exist: " + src);
            }
            inode.setPermission(permissions);
        }
    }

    void setOwner(String src, String username, String groupname) throws IOException {
        this.unprotectedSetOwner(src, username, groupname);
        this.fsImage.getEditLog().logSetOwner(src, username, groupname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unprotectedSetOwner(String src, String username, String groupname) throws FileNotFoundException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode inode = this.rootDir.getNode(src);
            if (inode == null) {
                throw new FileNotFoundException("File does not exist: " + src);
            }
            if (username != null) {
                inode.setUser(username);
            }
            if (groupname != null) {
                inode.setGroup(groupname);
            }
        }
    }

    public INode delete(String src, Collection<Block> deletedBlocks) {
        NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.delete: " + src));
        this.waitForReady();
        long now = FSNamesystem.now();
        INode deletedNode = this.unprotectedDelete(src, now, deletedBlocks);
        if (deletedNode != null) {
            this.fsImage.getEditLog().logDelete(src, now);
        }
        return deletedNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirEmpty(String src) {
        boolean dirNotEmpty = true;
        if (!this.isDir(src)) {
            return true;
        }
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode targetNode = this.rootDir.getNode(src);
            assert (targetNode != null) : "should be taken care in isDir() above";
            if (((INodeDirectory)targetNode).getChildren().size() != 0) {
                dirNotEmpty = false;
            }
        }
        return dirNotEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INode unprotectedDelete(String src, long modificationTime, Collection<Block> deletedBlocks) {
        src = this.normalizePath(src);
        String[] names = INode.getPathNames(src);
        byte[][] components = INode.getPathComponents(names);
        INode[] inodes = new INode[components.length];
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            this.rootDir.getExistingPathINodes(components, inodes);
            INode targetNode = inodes[inodes.length - 1];
            if (targetNode == null) {
                NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because it does not exist"));
                return null;
            }
            if (inodes.length == 1) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because the root is not allowed to be deleted"));
                return null;
            }
            try {
                this.removeChild(inodes, inodes.length - 1);
                inodes[inodes.length - 2].setModificationTime(modificationTime);
                ArrayList<Block> v = new ArrayList<Block>();
                int filesRemoved = targetNode.collectSubtreeBlocksAndClear(v);
                this.incrDeletedFileCount(filesRemoved);
                for (Block b : v) {
                    this.namesystem.blocksMap.removeINode(b);
                    this.namesystem.corruptReplicas.removeFromCorruptReplicasMap(b);
                    if (deletedBlocks == null) continue;
                    deletedBlocks.add(b);
                }
                NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.unprotectedDelete: " + src + " is removed"));
                return targetNode;
            }
            catch (IOException e) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because " + e.getMessage()));
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceNode(String path, INodeFile oldnode, INodeFile newnode) throws IOException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            if (!oldnode.removeNode()) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.replaceNode: failed to remove " + path));
                throw new IOException("FSDirectory.replaceNode: failed to remove " + path);
            }
            this.rootDir.addNode(path, newnode);
            for (BlocksMap.BlockInfo b : newnode.getBlocks()) {
                this.namesystem.blocksMap.addINode(b, newnode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DFSFileInfo[] getListing(String src) {
        String srcs = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode targetNode = this.rootDir.getNode(srcs);
            if (targetNode == null) {
                return null;
            }
            if (!targetNode.isDirectory()) {
                return new DFSFileInfo[]{new DFSFileInfo(srcs, targetNode)};
            }
            List<INode> contents = ((INodeDirectory)targetNode).getChildren();
            DFSFileInfo[] listing = new DFSFileInfo[contents.size()];
            if (!srcs.endsWith("/")) {
                srcs = srcs + "/";
            }
            int i = 0;
            for (INode cur : contents) {
                listing[i] = new DFSFileInfo(srcs + cur.getLocalName(), cur);
                ++i;
            }
            return listing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DFSFileInfo getFileInfo(String src) {
        String srcs = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode targetNode = this.rootDir.getNode(srcs);
            if (targetNode == null) {
                return null;
            }
            return new DFSFileInfo(srcs, targetNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Block[] getFileBlocks(String src) {
        this.waitForReady();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode targetNode = this.rootDir.getNode(src);
            if (targetNode == null) {
                return null;
            }
            if (targetNode.isDirectory()) {
                return null;
            }
            return ((INodeFile)targetNode).getBlocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INodeFile getFileINode(String src) {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode inode = this.rootDir.getNode(src);
            if (inode == null || inode.isDirectory()) {
                return null;
            }
            return (INodeFile)inode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidToCreate(String src) {
        String srcs = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            return srcs.startsWith("/") && !srcs.endsWith("/") && this.rootDir.getNode(srcs) == null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDir(String src) {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode node = this.rootDir.getNode(this.normalizePath(src));
            return node != null && node.isDirectory();
        }
    }

    private static void updateCount(INode[] inodes, int numOfINodes, long deltaCount) throws QuotaExceededException {
        int i;
        if (numOfINodes > inodes.length) {
            numOfINodes = inodes.length;
        }
        ArrayList<INodeDirectoryWithQuota> inodesWithQuota = new ArrayList<INodeDirectoryWithQuota>(numOfINodes);
        try {
            for (i = 0; i < numOfINodes; ++i) {
                if (inodes[i].getQuota() < 0L) continue;
                INodeDirectoryWithQuota quotaINode = (INodeDirectoryWithQuota)inodes[i];
                quotaINode.updateNumItemsInTree(deltaCount);
                inodesWithQuota.add(quotaINode);
            }
        }
        catch (QuotaExceededException e) {
            for (INodeDirectoryWithQuota quotaINode : inodesWithQuota) {
                try {
                    quotaINode.updateNumItemsInTree(-deltaCount);
                }
                catch (IOException ingored) {}
            }
            e.setPathName(FSDirectory.getFullPathName(inodes, i));
            throw e;
        }
    }

    private static String getFullPathName(INode[] inodes, int pos) {
        StringBuilder fullPathName = new StringBuilder();
        for (int i = 1; i <= pos; ++i) {
            fullPathName.append('/').append(inodes[i].getLocalName());
        }
        return fullPathName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean mkdirs(String src, PermissionStatus permissions, boolean inheritPermission, long now) throws FileNotFoundException, QuotaExceededException {
        src = this.normalizePath(src);
        String[] names = INode.getPathNames(src);
        byte[][] components = INode.getPathComponents(names);
        INode[] inodes = new INode[components.length];
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            int i;
            this.rootDir.getExistingPathINodes(components, inodes);
            StringBuilder pathbuilder = new StringBuilder();
            for (i = 1; i < inodes.length && inodes[i] != null; ++i) {
                pathbuilder.append("/" + names[i]);
                if (inodes[i].isDirectory()) continue;
                throw new FileNotFoundException("Parent path is not a directory: " + pathbuilder);
            }
            while (i < inodes.length) {
                pathbuilder.append("/" + names[i]);
                String cur = pathbuilder.toString();
                this.unprotectedMkdir(inodes, i, components[i], permissions, inheritPermission || i != components.length - 1, now);
                if (inodes[i] == null) {
                    return false;
                }
                this.fsImage.getEditLog().logMkDir(cur, inodes[i]);
                NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.mkdirs: created directory " + cur));
                ++i;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INode unprotectedMkdir(String src, PermissionStatus permissions, long timestamp) throws QuotaExceededException {
        byte[][] components = INode.getPathComponents(src);
        INode[] inodes = new INode[components.length];
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            this.rootDir.getExistingPathINodes(components, inodes);
            this.unprotectedMkdir(inodes, inodes.length - 1, components[inodes.length - 1], permissions, false, timestamp);
            return inodes[inodes.length - 1];
        }
    }

    private void unprotectedMkdir(INode[] inodes, int pos, byte[] name, PermissionStatus permission, boolean inheritPermission, long timestamp) throws QuotaExceededException {
        inodes[pos] = this.addChild(inodes, pos, new INodeDirectory(name, permission, timestamp), inheritPermission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends INode> T addNode(String src, T child, boolean inheritPermission) throws QuotaExceededException {
        byte[][] components = INode.getPathComponents(src);
        child.setLocalName(components[components.length - 1]);
        INode[] inodes = new INode[components.length];
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            this.rootDir.getExistingPathINodes(components, inodes);
            return this.addChild(inodes, inodes.length - 1, child, inheritPermission);
        }
    }

    private <T extends INode> T addChild(INode[] pathComponents, int pos, T child, boolean inheritPermission) throws QuotaExceededException {
        long childSize = child.numItemsInTree();
        FSDirectory.updateCount(pathComponents, pos, childSize);
        T addedNode = ((INodeDirectory)pathComponents[pos - 1]).addChild(child, inheritPermission);
        if (addedNode == null) {
            FSDirectory.updateCount(pathComponents, pos, -childSize);
        }
        return addedNode;
    }

    private INode removeChild(INode[] pathComponents, int pos) throws QuotaExceededException {
        INode removedNode = ((INodeDirectory)pathComponents[pos - 1]).removeChild(pathComponents[pos]);
        if (removedNode != null) {
            FSDirectory.updateCount(pathComponents, pos, -removedNode.numItemsInTree());
        }
        return removedNode;
    }

    String normalizePath(String src) {
        if (src.length() > 1 && src.endsWith("/")) {
            src = src.substring(0, src.length() - 1);
        }
        return src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContentSummary getContentSummary(String src) throws IOException {
        String srcs = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode targetNode = this.rootDir.getNode(srcs);
            if (targetNode == null) {
                throw new FileNotFoundException("File does not exist: " + srcs);
            }
            return targetNode.computeContentSummary();
        }
    }

    void updateCountForINodeWithQuota() throws QuotaExceededException {
        FSDirectory.updateCountForINodeWithQuota(this.rootDir);
    }

    private static long updateCountForINodeWithQuota(INode node) throws QuotaExceededException {
        long count = 1L;
        if (node.isDirectory()) {
            INodeDirectory dNode = (INodeDirectory)node;
            for (INode child : dNode.getChildren()) {
                count += FSDirectory.updateCountForINodeWithQuota(child);
            }
            if (dNode.getQuota() >= 0L) {
                ((INodeDirectoryWithQuota)dNode).setCount(count);
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unprotectedSetQuota(String src, long quota) throws FileNotFoundException, QuotaExceededException {
        String srcs = this.normalizePath(src);
        byte[][] components = INode.getPathComponents(src);
        INode[] inodes = new INode[components.length == 1 ? 1 : 2];
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            this.rootDir.getExistingPathINodes(components, inodes);
            INode targetNode = inodes[inodes.length - 1];
            if (targetNode == null || !targetNode.isDirectory()) {
                throw new FileNotFoundException("Directory does not exist: " + srcs);
            }
            INodeDirectory dirNode = (INodeDirectory)targetNode;
            if (dirNode instanceof INodeDirectoryWithQuota) {
                ((INodeDirectoryWithQuota)dirNode).setQuota(quota);
            } else {
                INodeDirectoryWithQuota newNode = new INodeDirectoryWithQuota(quota, dirNode);
                assert (inodes.length == 2);
                INodeDirectory parent = (INodeDirectory)inodes[0];
                parent.replaceChild(newNode);
            }
        }
    }

    void setQuota(String src, long quota) throws FileNotFoundException, QuotaExceededException {
        this.unprotectedSetQuota(src, quota);
        this.fsImage.getEditLog().logSetQuota(src, quota);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unprotectedClearQuota(String src) throws IOException {
        String srcs = this.normalizePath(src);
        byte[][] components = INode.getPathComponents(src);
        INode[] inodes = new INode[components.length == 1 ? 1 : 2];
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            this.rootDir.getExistingPathINodes(components, inodes);
            INode targetNode = inodes[inodes.length - 1];
            if (targetNode == null || !targetNode.isDirectory()) {
                throw new FileNotFoundException("Directory does not exist: " + srcs);
            }
            if (targetNode instanceof INodeDirectoryWithQuota) {
                INodeDirectoryWithQuota dirNode = (INodeDirectoryWithQuota)targetNode;
                INodeDirectory newNode = new INodeDirectory(dirNode);
                if (dirNode == this.rootDir) {
                    throw new IOException("Can't clear the root's quota");
                }
                INodeDirectory parent = (INodeDirectory)inodes[0];
                parent.replaceChild(newNode);
            }
        }
    }

    void clearQuota(String src) throws IOException {
        this.unprotectedClearQuota(src);
        this.fsImage.getEditLog().logClearQuota(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long totalInodes() {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            return this.rootDir.numItemsInTree();
        }
    }
}

