/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.DatanodeDescriptor;
import org.apache.hadoop.dfs.DatanodeID;
import org.apache.hadoop.dfs.FSDirectory;
import org.apache.hadoop.dfs.FSImage;
import org.apache.hadoop.dfs.FSNamesystem;
import org.apache.hadoop.dfs.INode;
import org.apache.hadoop.dfs.INodeFile;
import org.apache.hadoop.dfs.INodeFileUnderConstruction;
import org.apache.hadoop.dfs.NameNode;
import org.apache.hadoop.dfs.NameNodeMetrics;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FSEditLog {
    private static final byte OP_ADD = 0;
    private static final byte OP_RENAME = 1;
    private static final byte OP_DELETE = 2;
    private static final byte OP_MKDIR = 3;
    private static final byte OP_SET_REPLICATION = 4;
    @Deprecated
    private static final byte OP_DATANODE_ADD = 5;
    @Deprecated
    private static final byte OP_DATANODE_REMOVE = 6;
    private static final byte OP_SET_PERMISSIONS = 7;
    private static final byte OP_SET_OWNER = 8;
    private static final byte OP_CLOSE = 9;
    private static final byte OP_SET_GENSTAMP = 10;
    private static final byte OP_SET_QUOTA = 11;
    private static final byte OP_CLEAR_QUOTA = 12;
    private static int sizeFlushBuffer = 524288;
    private ArrayList<EditLogOutputStream> editStreams = null;
    private FSImage fsimage = null;
    private long txid = 0L;
    private long synctxid = 0L;
    private long lastPrintTime;
    private boolean isSyncRunning;
    private long numTransactions;
    private long totalTimeTransactions;
    private NameNodeMetrics metrics;
    private static final ThreadLocal<TransactionId> myTransactionId = new ThreadLocal<TransactionId>(){

        @Override
        protected synchronized TransactionId initialValue() {
            return new TransactionId(Long.MAX_VALUE);
        }
    };
    private static final LongWritable longWritable = new LongWritable();

    FSEditLog(FSImage image) {
        this.fsimage = image;
        this.isSyncRunning = false;
        this.metrics = NameNode.getNameNodeMetrics();
        this.lastPrintTime = FSNamesystem.now();
    }

    private File getEditFile(int idx) {
        return this.fsimage.getEditFile(idx);
    }

    private File getEditNewFile(int idx) {
        return this.fsimage.getEditNewFile(idx);
    }

    private int getNumStorageDirs() {
        return this.fsimage.getNumStorageDirs();
    }

    synchronized int getNumEditStreams() {
        return this.editStreams == null ? 0 : this.editStreams.size();
    }

    boolean isOpen() {
        return this.getNumEditStreams() > 0;
    }

    synchronized void open() throws IOException {
        this.totalTimeTransactions = 0L;
        this.numTransactions = 0L;
        int size = this.getNumStorageDirs();
        if (this.editStreams == null) {
            this.editStreams = new ArrayList(size);
        }
        for (int idx = 0; idx < size; ++idx) {
            File eFile = this.getEditFile(idx);
            try {
                EditLogOutputStream eStream = new EditLogOutputStream(eFile);
                this.editStreams.add(eStream);
                continue;
            }
            catch (IOException e) {
                FSNamesystem.LOG.warn((Object)("Unable to open edit log file " + eFile));
                this.fsimage.processIOError(idx);
                --idx;
            }
        }
    }

    synchronized void createEditLogFile(File name) throws IOException {
        EditLogOutputStream eStream = new EditLogOutputStream(name);
        eStream.create();
        eStream.close();
    }

    synchronized void createNewIfMissing() throws IOException {
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            File newFile = this.getEditNewFile(idx);
            if (newFile.exists()) continue;
            this.createEditLogFile(newFile);
        }
    }

    synchronized void close() throws IOException {
        while (this.isSyncRunning) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException ie) {}
        }
        if (this.editStreams == null) {
            return;
        }
        this.printStatistics(true);
        this.totalTimeTransactions = 0L;
        this.numTransactions = 0L;
        for (int idx = 0; idx < this.editStreams.size(); ++idx) {
            EditLogOutputStream eStream = this.editStreams.get(idx);
            try {
                eStream.flushAndSync();
                eStream.close();
                continue;
            }
            catch (IOException e) {
                this.processIOError(idx);
                --idx;
            }
        }
        this.editStreams.clear();
    }

    synchronized void processIOError(int index) {
        if (this.editStreams == null || this.editStreams.size() <= 1) {
            FSNamesystem.LOG.fatal((Object)"Fatal Error : All storage directories are inaccessible.");
            Runtime.getRuntime().exit(-1);
        }
        assert (index < this.getNumStorageDirs());
        assert (this.getNumStorageDirs() == this.editStreams.size());
        this.editStreams.remove(index);
        this.fsimage.processIOError(index);
    }

    private void processIOError(ArrayList<EditLogOutputStream> errorStreams) {
        if (errorStreams == null) {
            return;
        }
        for (int idx = 0; idx < errorStreams.size(); ++idx) {
            EditLogOutputStream eStream = errorStreams.get(idx);
            int j = 0;
            for (j = 0; j < this.editStreams.size() && this.editStreams.get(j) != eStream; ++j) {
            }
            if (j == this.editStreams.size()) {
                FSNamesystem.LOG.error((Object)"Unable to find sync log on which  IO error occured. Fatal Error.");
                Runtime.getRuntime().exit(-1);
            }
            this.processIOError(j);
        }
        int failedStreamIdx = 0;
        while (failedStreamIdx >= 0) {
            failedStreamIdx = this.fsimage.incrementCheckpointTime();
            if (failedStreamIdx < 0) continue;
            this.processIOError(failedStreamIdx);
        }
    }

    boolean existsNew() throws IOException {
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            if (!this.getEditNewFile(idx).exists()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int loadFSEdits(File edits) throws IOException {
        FSNamesystem fsNamesys = FSNamesystem.getFSNamesystem();
        FSDirectory fsDir = fsNamesys.dir;
        int numEdits = 0;
        int logVersion = 0;
        INode old = null;
        String clientName = null;
        String clientMachine = null;
        String path = null;
        int numOpAdd = 0;
        int numOpClose = 0;
        int numOpDelete = 0;
        int numOpRename = 0;
        int numOpSetRepl = 0;
        int numOpMkDir = 0;
        int numOpSetPerm = 0;
        int numOpSetOwner = 0;
        int numOpSetGenStamp = 0;
        int numOpOther = 0;
        long startTime = FSNamesystem.now();
        if (edits != null) {
            block50: {
                DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(edits)));
                try {
                    int opcode;
                    in.mark(4);
                    boolean available = true;
                    try {
                        logVersion = in.readByte();
                    }
                    catch (EOFException e) {
                        available = false;
                    }
                    if (available) {
                        in.reset();
                        logVersion = in.readInt();
                        if (logVersion < -16) {
                            throw new IOException("Unexpected version of the file system log file: " + logVersion + ". Current version = " + -16 + ".");
                        }
                    }
                    assert (logVersion <= -7) : "Unsupported version " + logVersion;
                    block21: while (true) {
                        long timestamp = 0L;
                        long mtime = 0L;
                        long blockSize = 0L;
                        opcode = -1;
                        try {
                            opcode = in.readByte();
                        }
                        catch (EOFException e) {
                            break block50;
                        }
                        ++numEdits;
                        switch (opcode) {
                            case 0: 
                            case 9: {
                                int length = in.readInt();
                                if (-7 == logVersion && length != 3 || logVersion < -7 && length != 4) {
                                    throw new IOException("Incorrect data format. logVersion is " + logVersion + " but writables.length is " + length + ". ");
                                }
                                path = FSImage.readString(in);
                                short replication = FSEditLog.adjustReplication(FSEditLog.readShort(in));
                                mtime = FSEditLog.readLong(in);
                                if (logVersion < -7) {
                                    blockSize = FSEditLog.readLong(in);
                                }
                                Block[] blocks = null;
                                if (logVersion <= -14) {
                                    blocks = FSEditLog.readBlocks(in);
                                } else {
                                    BlockTwo oldblk = new BlockTwo();
                                    int num = in.readInt();
                                    blocks = new Block[num];
                                    for (int i = 0; i < num; ++i) {
                                        oldblk.readFields(in);
                                        blocks[i] = new Block(oldblk.blkid, oldblk.len, 0L);
                                    }
                                }
                                if (-8 <= logVersion && blockSize == 0L) {
                                    if (blocks.length > 1) {
                                        blockSize = blocks[0].getNumBytes();
                                    } else {
                                        long first = blocks.length == 1 ? blocks[0].getNumBytes() : 0L;
                                        blockSize = Math.max(fsNamesys.getDefaultBlockSize(), first);
                                    }
                                }
                                PermissionStatus permissions = fsNamesys.getUpgradePermission();
                                if (logVersion <= -11) {
                                    permissions = PermissionStatus.read(in);
                                }
                                if (opcode == 0 && logVersion <= -12) {
                                    clientName = FSImage.readString(in);
                                    clientMachine = FSImage.readString(in);
                                    if (-13 <= logVersion) {
                                        FSEditLog.readDatanodeDescriptorArray(in);
                                    }
                                } else {
                                    clientName = "";
                                    clientMachine = "";
                                }
                                if (FSNamesystem.LOG.isDebugEnabled()) {
                                    FSNamesystem.LOG.debug((Object)(opcode + ": " + path + " numblocks : " + blocks.length + " clientHolder " + clientName + " clientMachine " + clientMachine));
                                }
                                old = fsDir.unprotectedDelete(path, mtime, null);
                                INodeFile node = (INodeFile)fsDir.unprotectedAddFile(path, permissions, blocks, replication, mtime, blockSize);
                                if (opcode == 0) {
                                    ++numOpAdd;
                                    INodeFileUnderConstruction cons = new INodeFileUnderConstruction(node.getLocalNameBytes(), node.getReplication(), node.getModificationTime(), node.getPreferredBlockSize(), node.getBlocks(), node.getPermissionStatus(), clientName, clientMachine, null);
                                    fsDir.replaceNode(path, node, cons);
                                    fsNamesys.leaseManager.addLease(cons.clientName, path);
                                    continue block21;
                                }
                                if (opcode != 9 || !old.isUnderConstruction()) continue block21;
                                INodeFileUnderConstruction cons = (INodeFileUnderConstruction)old;
                                fsNamesys.leaseManager.removeLease(cons.clientName, path);
                                continue block21;
                            }
                            case 4: {
                                ++numOpSetRepl;
                                path = FSImage.readString(in);
                                short replication = FSEditLog.adjustReplication(FSEditLog.readShort(in));
                                fsDir.unprotectedSetReplication(path, replication, null);
                                continue block21;
                            }
                            case 1: {
                                ++numOpRename;
                                int length = in.readInt();
                                if (length != 3) {
                                    throw new IOException("Incorrect data format. Mkdir operation.");
                                }
                                String s = FSImage.readString(in);
                                String d = FSImage.readString(in);
                                timestamp = FSEditLog.readLong(in);
                                fsDir.unprotectedRenameTo(s, d, timestamp);
                                fsNamesys.changeLease(s, d);
                                continue block21;
                            }
                            case 2: {
                                ++numOpDelete;
                                int length = in.readInt();
                                if (length != 2) {
                                    throw new IOException("Incorrect data format. delete operation.");
                                }
                                path = FSImage.readString(in);
                                old = fsDir.unprotectedDelete(path, timestamp = FSEditLog.readLong(in), null);
                                if (old == null || !old.isUnderConstruction()) continue block21;
                                INodeFileUnderConstruction cons = (INodeFileUnderConstruction)old;
                                fsNamesys.leaseManager.removeLease(cons.clientName, path);
                                continue block21;
                            }
                            case 3: {
                                ++numOpMkDir;
                                PermissionStatus permissions = fsNamesys.getUpgradePermission();
                                int length = in.readInt();
                                if (length != 2) {
                                    throw new IOException("Incorrect data format. Mkdir operation.");
                                }
                                path = FSImage.readString(in);
                                timestamp = FSEditLog.readLong(in);
                                if (logVersion <= -11) {
                                    permissions = PermissionStatus.read(in);
                                }
                                fsDir.unprotectedMkdir(path, permissions, timestamp);
                                continue block21;
                            }
                            case 10: {
                                ++numOpSetGenStamp;
                                long lw = in.readLong();
                                fsDir.namesystem.setGenerationStamp(lw);
                                continue block21;
                            }
                            case 5: {
                                ++numOpOther;
                                FSImage.DatanodeImage nodeimage = new FSImage.DatanodeImage();
                                nodeimage.readFields(in);
                                continue block21;
                            }
                            case 6: {
                                ++numOpOther;
                                DatanodeID nodeID = new DatanodeID();
                                nodeID.readFields(in);
                                continue block21;
                            }
                            case 7: {
                                ++numOpSetPerm;
                                if (logVersion > -11) {
                                    throw new IOException("Unexpected opcode " + opcode + " for version " + logVersion);
                                }
                                fsDir.unprotectedSetPermission(FSImage.readString(in), FsPermission.read(in));
                                continue block21;
                            }
                            case 8: {
                                ++numOpSetOwner;
                                if (logVersion > -11) {
                                    throw new IOException("Unexpected opcode " + opcode + " for version " + logVersion);
                                }
                                fsDir.unprotectedSetOwner(FSImage.readString(in), FSImage.readString(in), FSImage.readString(in));
                                continue block21;
                            }
                            case 11: {
                                if (logVersion > -16) {
                                    throw new IOException("Unexpected opcode " + opcode + " for version " + logVersion);
                                }
                                fsDir.unprotectedSetQuota(FSImage.readString(in), FSEditLog.readLongWritable(in));
                                continue block21;
                            }
                            case 12: {
                                if (logVersion > -16) {
                                    throw new IOException("Unexpected opcode " + opcode + " for version " + logVersion);
                                }
                                fsDir.unprotectedClearQuota(FSImage.readString(in));
                                continue block21;
                            }
                        }
                        break;
                    }
                    throw new IOException("Never seen opcode " + opcode);
                }
                finally {
                    in.close();
                }
            }
            FSImage.LOG.info((Object)("Edits file " + edits.getName() + " of size " + edits.length() + " edits # " + numEdits + " loaded in " + (FSNamesystem.now() - startTime) / 1000L + " seconds."));
        }
        if (FSImage.LOG.isDebugEnabled()) {
            FSImage.LOG.debug((Object)("numOpAdd = " + numOpAdd + " numOpClose = " + numOpClose + " numOpDelete = " + numOpDelete + " numOpRename = " + numOpRename + " numOpSetRepl = " + numOpSetRepl + " numOpMkDir = " + numOpMkDir + " numOpSetPerm = " + numOpSetPerm + " numOpSetOwner = " + numOpSetOwner + " numOpSetGenStamp = " + numOpSetGenStamp + " numOpOther = " + numOpOther));
        }
        if (logVersion != -16) {
            ++numEdits;
        }
        return numEdits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long readLongWritable(DataInputStream in) throws IOException {
        LongWritable longWritable = FSEditLog.longWritable;
        synchronized (longWritable) {
            FSEditLog.longWritable.readFields(in);
            return FSEditLog.longWritable.get();
        }
    }

    static short adjustReplication(short replication) {
        short maxReplication;
        FSNamesystem fsNamesys = FSNamesystem.getFSNamesystem();
        short minReplication = fsNamesys.getMinReplication();
        if (replication < minReplication) {
            replication = minReplication;
        }
        if (replication > (maxReplication = fsNamesys.getMaxReplication())) {
            replication = maxReplication;
        }
        return replication;
    }

    synchronized void logEdit(byte op, Writable ... writables) {
        assert (this.getNumEditStreams() > 0) : "no editlog streams";
        long start = FSNamesystem.now();
        for (int idx = 0; idx < this.editStreams.size(); ++idx) {
            EditLogOutputStream eStream = this.editStreams.get(idx);
            try {
                DataOutputStream od = eStream.getOutputStream();
                od.write(op);
                for (Writable w : writables) {
                    w.write(od);
                }
                continue;
            }
            catch (IOException ie) {
                this.processIOError(idx);
            }
        }
        ++this.txid;
        TransactionId id = myTransactionId.get();
        id.txid = this.txid;
        long end = FSNamesystem.now();
        ++this.numTransactions;
        this.totalTimeTransactions += end - start;
        this.metrics.transactions.inc(end - start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logSync() {
        ArrayList<EditLogOutputStream> errorStreams = null;
        long syncStart = 0L;
        TransactionId id = myTransactionId.get();
        long mytxid = id.txid;
        FSEditLog fSEditLog = this;
        synchronized (fSEditLog) {
            assert (this.getNumEditStreams() > 0) : "no editlog streams";
            this.printStatistics(false);
            while (mytxid > this.synctxid && this.isSyncRunning) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException ie) {}
            }
            if (mytxid <= this.synctxid) {
                return;
            }
            syncStart = this.txid;
            this.isSyncRunning = true;
            for (int idx = 0; idx < this.editStreams.size(); ++idx) {
                EditLogOutputStream eStream = this.editStreams.get(idx);
                eStream.swap();
            }
        }
        long start = FSNamesystem.now();
        for (int idx = 0; idx < this.editStreams.size(); ++idx) {
            EditLogOutputStream eStream = this.editStreams.get(idx);
            try {
                eStream.flushAndSyncOld();
                continue;
            }
            catch (IOException ie) {
                if (errorStreams == null) {
                    errorStreams = new ArrayList<EditLogOutputStream>(1);
                }
                errorStreams.add(eStream);
                FSNamesystem.LOG.error((Object)"Unable to sync edit log. Fatal Error.");
            }
        }
        long elapsed = FSNamesystem.now() - start;
        FSEditLog fSEditLog2 = this;
        synchronized (fSEditLog2) {
            this.processIOError(errorStreams);
            this.synctxid = syncStart;
            this.isSyncRunning = false;
            this.notifyAll();
        }
        this.metrics.syncs.inc(elapsed);
    }

    private void printStatistics(boolean force) {
        long now = FSNamesystem.now();
        if (this.lastPrintTime + 60000L > now && !force) {
            return;
        }
        if (this.editStreams == null) {
            return;
        }
        this.lastPrintTime = now;
        StringBuffer buf = new StringBuffer();
        buf.append("Number of transactions: " + this.numTransactions + " Total time for transactions(ms): " + this.totalTimeTransactions);
        buf.append(" Number of syncs: " + this.editStreams.get(0).getNumSync());
        buf.append(" SyncTimes(ms): ");
        for (int idx = 0; idx < this.editStreams.size(); ++idx) {
            EditLogOutputStream eStream = this.editStreams.get(idx);
            buf.append(eStream.getTotalSyncTime());
            buf.append(" ");
        }
        FSNamesystem.LOG.info((Object)buf);
    }

    void logOpenFile(String path, INodeFileUnderConstruction newNode) throws IOException {
        Writable[] nameReplicationPair = new UTF8[]{new UTF8(path), FSEditLog.toLogReplication(newNode.getReplication()), FSEditLog.toLogLong(newNode.getModificationTime()), FSEditLog.toLogLong(newNode.getPreferredBlockSize())};
        this.logEdit((byte)0, new ArrayWritable(UTF8.class, nameReplicationPair), new ArrayWritable(Block.class, newNode.getBlocks()), newNode.getPermissionStatus(), new UTF8(newNode.getClientName()), new UTF8(newNode.getClientMachine()));
    }

    void logCloseFile(String path, INodeFile newNode) {
        Writable[] nameReplicationPair = new UTF8[]{new UTF8(path), FSEditLog.toLogReplication(newNode.getReplication()), FSEditLog.toLogLong(newNode.getModificationTime()), FSEditLog.toLogLong(newNode.getPreferredBlockSize())};
        this.logEdit((byte)9, new ArrayWritable(UTF8.class, nameReplicationPair), new ArrayWritable(Block.class, newNode.getBlocks()), newNode.getPermissionStatus());
    }

    void logMkDir(String path, INode newNode) {
        Writable[] info = new UTF8[]{new UTF8(path), FSEditLog.toLogLong(newNode.getModificationTime())};
        this.logEdit((byte)3, new ArrayWritable(UTF8.class, info), newNode.getPermissionStatus());
    }

    void logRename(String src, String dst, long timestamp) {
        Writable[] info = new UTF8[]{new UTF8(src), new UTF8(dst), FSEditLog.toLogLong(timestamp)};
        this.logEdit((byte)1, new ArrayWritable(UTF8.class, info));
    }

    void logSetReplication(String src, short replication) {
        this.logEdit((byte)4, new UTF8(src), FSEditLog.toLogReplication(replication));
    }

    void logSetQuota(String src, long quota) {
        this.logEdit((byte)11, new UTF8(src), new LongWritable(quota));
    }

    void logClearQuota(String src) {
        this.logEdit((byte)12, new UTF8(src));
    }

    void logSetPermissions(String src, FsPermission permissions) {
        this.logEdit((byte)7, new UTF8(src), permissions);
    }

    void logSetOwner(String src, String username, String groupname) {
        UTF8 u = new UTF8(username == null ? "" : username);
        UTF8 g = new UTF8(groupname == null ? "" : groupname);
        this.logEdit((byte)8, new UTF8(src), u, g);
    }

    void logDelete(String src, long timestamp) {
        Writable[] info = new UTF8[]{new UTF8(src), FSEditLog.toLogLong(timestamp)};
        this.logEdit((byte)2, new ArrayWritable(UTF8.class, info));
    }

    void logGenerationStamp(long genstamp) {
        this.logEdit((byte)10, new LongWritable(genstamp));
    }

    private static UTF8 toLogReplication(short replication) {
        return new UTF8(Short.toString(replication));
    }

    private static UTF8 toLogLong(long timestamp) {
        return new UTF8(Long.toString(timestamp));
    }

    synchronized long getEditLogSize() throws IOException {
        assert (this.getNumStorageDirs() == this.editStreams.size());
        long size = 0L;
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            EditLogOutputStream eStream = this.editStreams.get(idx);
            assert (size == 0L || size == this.getEditFile(idx).length() + (long)eStream.getBufSize());
            size = this.getEditFile(idx).length() + (long)eStream.getBufSize();
        }
        return size;
    }

    synchronized void rollEditLog() throws IOException {
        if (this.existsNew()) {
            for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
                if (this.getEditNewFile(idx).exists()) continue;
                throw new IOException("Inconsistent existance of edits.new " + this.getEditNewFile(idx));
            }
            return;
        }
        this.close();
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            try {
                EditLogOutputStream eStream = new EditLogOutputStream(this.getEditNewFile(idx));
                eStream.create();
                this.editStreams.add(eStream);
                continue;
            }
            catch (IOException e) {
                this.processIOError(idx);
                --idx;
            }
        }
    }

    synchronized void purgeEditLog() throws IOException {
        if (!this.existsNew()) {
            throw new IOException("Attempt to purge edit log but edits.new does not exist.");
        }
        this.close();
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            if (this.getEditNewFile(idx).renameTo(this.getEditFile(idx))) continue;
            this.getEditFile(idx).delete();
            if (this.getEditNewFile(idx).renameTo(this.getEditFile(idx))) continue;
            this.fsimage.processIOError(idx);
            --idx;
        }
        this.open();
    }

    synchronized File getFsEditName() throws IOException {
        return this.getEditFile(0);
    }

    synchronized long getFsEditTime() {
        return this.getEditFile(0).lastModified();
    }

    static void setBufferCapacity(int size) {
        sizeFlushBuffer = size;
    }

    private static DatanodeDescriptor[] readDatanodeDescriptorArray(DataInput in) throws IOException {
        DatanodeDescriptor[] locations = new DatanodeDescriptor[in.readInt()];
        for (int i = 0; i < locations.length; ++i) {
            locations[i] = new DatanodeDescriptor();
            locations[i].readFieldsFromFSEditLog(in);
        }
        return locations;
    }

    private static short readShort(DataInputStream in) throws IOException {
        return Short.parseShort(FSImage.readString(in));
    }

    private static long readLong(DataInputStream in) throws IOException {
        return Long.parseLong(FSImage.readString(in));
    }

    private static Block[] readBlocks(DataInputStream in) throws IOException {
        int numBlocks = in.readInt();
        Block[] blocks = new Block[numBlocks];
        for (int i = 0; i < numBlocks; ++i) {
            blocks[i] = new Block();
            blocks[i].readFields(in);
        }
        return blocks;
    }

    static /* synthetic */ int access$000() {
        return sizeFlushBuffer;
    }

    static class BlockTwo
    implements Writable {
        long blkid = 0L;
        long len = 0L;

        BlockTwo() {
        }

        public void write(DataOutput out) throws IOException {
            out.writeLong(this.blkid);
            out.writeLong(this.len);
        }

        public void readFields(DataInput in) throws IOException {
            this.blkid = in.readLong();
            this.len = in.readLong();
        }

        static {
            WritableFactories.setFactory(BlockTwo.class, new WritableFactory(){

                public Writable newInstance() {
                    return new BlockTwo();
                }
            });
        }
    }

    static class EditLogOutputStream {
        private FileChannel fc;
        private FileOutputStream fp;
        private DataOutputStream od;
        private DataOutputStream od1;
        private DataOutputStream od2;
        private ByteArrayOutputStream buf1;
        private ByteArrayOutputStream buf2;
        private int bufSize = FSEditLog.access$000();
        private long numSync;
        private long totalTimeSync;

        EditLogOutputStream(File name) throws IOException {
            this.buf1 = new ByteArrayOutputStream(this.bufSize);
            this.buf2 = new ByteArrayOutputStream(this.bufSize);
            this.od1 = new DataOutputStream(this.buf1);
            this.od2 = new DataOutputStream(this.buf2);
            this.od = this.od1;
            this.fp = new FileOutputStream(name, true);
            this.fc = this.fp.getChannel();
            this.totalTimeSync = 0L;
            this.numSync = 0L;
        }

        DataOutputStream getOutputStream() {
            return this.od;
        }

        void flushAndSync() throws IOException {
            this.flush();
            this.fc.force(true);
        }

        void create() throws IOException {
            this.fc.truncate(0L);
            this.od.writeInt(-16);
            this.flushAndSync();
        }

        private void flush() throws IOException {
            ByteArrayOutputStream buf = this.getBuffer();
            if (buf.size() == 0) {
                return;
            }
            buf.writeTo(this.fp);
            buf.reset();
        }

        void close() throws IOException {
            if (this.getBufSize() != 0) {
                throw new IOException("FSEditStream has " + this.getBufSize() + " bytes still to be flushed and cannot " + "closed.");
            }
            this.od.close();
            this.fp.close();
            this.buf2 = null;
            this.buf1 = null;
            this.od2 = null;
            this.od1 = null;
            this.od = null;
        }

        int getBufSize() {
            return this.getBuffer().size();
        }

        private ByteArrayOutputStream getBuffer() {
            if (this.od == this.od1) {
                return this.buf1;
            }
            return this.buf2;
        }

        void swap() {
            this.od = this.od == this.od1 ? this.od2 : this.od1;
        }

        void flushAndSyncOld() throws IOException {
            ++this.numSync;
            ByteArrayOutputStream oldbuf = this.od == this.od1 ? this.buf2 : this.buf1;
            long start = FSNamesystem.now();
            oldbuf.writeTo(this.fp);
            oldbuf.reset();
            this.fc.force(true);
            long end = FSNamesystem.now();
            this.totalTimeSync += end - start;
        }

        long getTotalSyncTime() {
            return this.totalTimeSync;
        }

        long getNumSync() {
            return this.numSync;
        }
    }

    private static class TransactionId {
        public long txid;

        TransactionId(long value) {
            this.txid = value;
        }
    }
}

