/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.BlocksMap;
import org.apache.hadoop.dfs.CheckpointSignature;
import org.apache.hadoop.dfs.DatanodeDescriptor;
import org.apache.hadoop.dfs.DatanodeID;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.FSDirectory;
import org.apache.hadoop.dfs.FSEditLog;
import org.apache.hadoop.dfs.FSNamesystem;
import org.apache.hadoop.dfs.INode;
import org.apache.hadoop.dfs.INodeDirectory;
import org.apache.hadoop.dfs.INodeFile;
import org.apache.hadoop.dfs.INodeFileUnderConstruction;
import org.apache.hadoop.dfs.InconsistentFSStateException;
import org.apache.hadoop.dfs.NameNode;
import org.apache.hadoop.dfs.Storage;
import org.apache.hadoop.dfs.StorageInfo;
import org.apache.hadoop.dfs.UpgradeManagerNamenode;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.WritableComparable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FSImage
extends Storage {
    private static final SimpleDateFormat DATE_FORM = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected long checkpointTime = -1L;
    private FSEditLog editLog = null;
    private boolean isUpgradeFinalized = false;
    private Collection<File> checkpointDirs;
    private volatile FSConstants.CheckpointStates ckptState = FSConstants.CheckpointStates.START;
    private static final FsPermission FILE_PERM = new FsPermission(0);
    private static final byte[] PATH_SEPARATOR = INode.string2Bytes("/");
    private static final UTF8 U_STR = new UTF8();

    FSImage() {
        super(FSConstants.NodeType.NAME_NODE);
        this.editLog = new FSEditLog(this);
    }

    FSImage(Collection<File> fsDirs) throws IOException {
        this();
        this.setStorageDirectories(fsDirs);
    }

    FSImage(StorageInfo storageInfo) {
        super(FSConstants.NodeType.NAME_NODE, storageInfo);
    }

    FSImage(File imageDir) throws IOException {
        this();
        ArrayList<File> dirs = new ArrayList<File>(1);
        dirs.add(imageDir);
        this.setStorageDirectories(dirs);
    }

    void setStorageDirectories(Collection<File> fsDirs) throws IOException {
        this.storageDirs = new ArrayList(fsDirs.size());
        Iterator<File> it = fsDirs.iterator();
        while (it.hasNext()) {
            this.addStorageDir(new Storage.StorageDirectory(this, it.next()));
        }
    }

    void setCheckpointDirectories(Collection<File> dirs) {
        this.checkpointDirs = dirs;
    }

    File getImageFile(int imageDirIdx, NameNodeFile type) {
        return FSImage.getImageFile(this.getStorageDir(imageDirIdx), type);
    }

    static File getImageFile(Storage.StorageDirectory sd, NameNodeFile type) {
        return new File(sd.getCurrentDir(), type.getName());
    }

    File getEditFile(int idx) {
        return this.getImageFile(idx, NameNodeFile.EDITS);
    }

    File getEditNewFile(int idx) {
        return this.getImageFile(idx, NameNodeFile.EDITS_NEW);
    }

    File[] getFileNames(NameNodeFile type) {
        File[] list = new File[this.getNumStorageDirs()];
        int i = 0;
        for (Storage.StorageDirectory sd : this.storageDirs) {
            list[i++] = FSImage.getImageFile(sd, type);
        }
        return list;
    }

    File[] getImageFiles() {
        return this.getFileNames(NameNodeFile.IMAGE);
    }

    File[] getEditsFiles() {
        return this.getFileNames(NameNodeFile.EDITS);
    }

    File[] getTimeFiles() {
        return this.getFileNames(NameNodeFile.TIME);
    }

    boolean recoverTransitionRead(Collection<File> dataDirs, FSConstants.StartupOption startOpt) throws IOException {
        assert (startOpt != FSConstants.StartupOption.FORMAT) : "NameNode formatting should be performed before reading the image";
        if (startOpt == FSConstants.StartupOption.IMPORT && (this.checkpointDirs == null || this.checkpointDirs.isEmpty())) {
            throw new IOException("Cannot import image from a checkpoint. \"fs.checkpoint.dir\" is not set.");
        }
        this.storageDirs = new ArrayList(dataDirs.size());
        ArrayList<Storage.StorageState> dataDirStates = new ArrayList<Storage.StorageState>(dataDirs.size());
        boolean isFormatted = false;
        for (File dataDir : dataDirs) {
            Storage.StorageState curState;
            Storage.StorageDirectory sd = new Storage.StorageDirectory(this, dataDir);
            try {
                curState = sd.analyzeStorage(startOpt);
                switch (curState) {
                    case NON_EXISTENT: {
                        throw new InconsistentFSStateException(sd.root, "storage directory does not exist or is not accessible.");
                    }
                    case NOT_FORMATTED: {
                        break;
                    }
                    case NORMAL: {
                        break;
                    }
                    default: {
                        sd.doRecover(curState);
                    }
                }
                if (curState != Storage.StorageState.NOT_FORMATTED && startOpt != FSConstants.StartupOption.ROLLBACK) {
                    sd.read();
                    isFormatted = true;
                }
                if (startOpt == FSConstants.StartupOption.IMPORT && isFormatted) {
                    throw new IOException("Cannot import image from a checkpoint.  NameNode already contains an image in " + sd.root);
                }
            }
            catch (IOException ioe) {
                sd.unlock();
                throw ioe;
            }
            this.addStorageDir(sd);
            ((AbstractList)dataDirStates).add(curState);
        }
        if (dataDirs.size() == 0) {
            throw new IOException("All specified directories are not accessible or do not exist.");
        }
        if (!isFormatted && startOpt != FSConstants.StartupOption.ROLLBACK && startOpt != FSConstants.StartupOption.IMPORT) {
            throw new IOException("NameNode is not formatted.");
        }
        if (this.layoutVersion < -3) {
            FSImage.checkVersionUpgradable(this.layoutVersion);
        }
        if (startOpt != FSConstants.StartupOption.UPGRADE && this.layoutVersion < -3 && this.layoutVersion != -16) {
            throw new IOException("\nFile system image contains an old layout version " + this.layoutVersion + ".\nAn upgrade to version " + -16 + " is required.\nPlease restart NameNode with -upgrade option.");
        }
        this.verifyDistributedUpgradeProgress(startOpt);
        this.checkpointTime = 0L;
        block17: for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            Storage.StorageDirectory sd = this.getStorageDir(idx);
            Storage.StorageState curState = (Storage.StorageState)((Object)((AbstractList)dataDirStates).get(idx));
            switch (curState) {
                case NON_EXISTENT: {
                    assert (false) : (Object)((Object)Storage.StorageState.NON_EXISTENT) + " state cannot be here";
                }
                case NOT_FORMATTED: {
                    LOG.info((Object)("Storage directory " + sd.root + " is not formatted."));
                    LOG.info((Object)"Formatting ...");
                    sd.clearDirectory();
                    continue block17;
                }
            }
        }
        switch (startOpt) {
            case UPGRADE: {
                this.doUpgrade();
                return false;
            }
            case IMPORT: {
                this.doImportCheckpoint();
                return true;
            }
            case ROLLBACK: {
                this.doRollback();
                break;
            }
        }
        return this.loadFSImage();
    }

    private void doUpgrade() throws IOException {
        if (this.getDistributedUpgradeState()) {
            this.loadFSImage();
            this.initializeDistributedUpgrade();
            return;
        }
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            Storage.StorageDirectory sd = this.getStorageDir(idx);
            if (!sd.getPreviousDir().exists()) continue;
            throw new InconsistentFSStateException(sd.root, "previous fs state should not exist during upgrade. Finalize or rollback first.");
        }
        this.loadFSImage();
        long oldCTime = this.getCTime();
        this.cTime = FSNamesystem.now();
        int oldLV = this.getLayoutVersion();
        this.layoutVersion = -16;
        this.checkpointTime = FSNamesystem.now();
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            Storage.StorageDirectory sd = this.getStorageDir(idx);
            LOG.info((Object)("Upgrading image directory " + sd.root + ".\n   old LV = " + oldLV + "; old CTime = " + oldCTime + ".\n   new LV = " + this.getLayoutVersion() + "; new CTime = " + this.getCTime()));
            File curDir = sd.getCurrentDir();
            File prevDir = sd.getPreviousDir();
            File tmpDir = sd.getPreviousTmp();
            assert (curDir.exists()) : "Current directory must exist.";
            assert (!prevDir.exists()) : "prvious directory must not exist.";
            assert (!tmpDir.exists()) : "prvious.tmp directory must not exist.";
            FSImage.rename(curDir, tmpDir);
            if (!curDir.mkdir()) {
                throw new IOException("Cannot create directory " + curDir);
            }
            this.saveFSImage(FSImage.getImageFile(sd, NameNodeFile.IMAGE));
            this.editLog.createEditLogFile(FSImage.getImageFile(sd, NameNodeFile.EDITS));
            sd.write();
            FSImage.rename(tmpDir, prevDir);
            this.isUpgradeFinalized = false;
            LOG.info((Object)("Upgrade of " + sd.root + " is complete."));
        }
        this.initializeDistributedUpgrade();
        this.editLog.open();
    }

    private void doRollback() throws IOException {
        File prevDir;
        Storage.StorageDirectory sd;
        int idx;
        boolean canRollback = false;
        FSImage prevState = new FSImage();
        prevState.layoutVersion = -16;
        for (idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            sd = this.getStorageDir(idx);
            prevDir = sd.getPreviousDir();
            if (!prevDir.exists()) {
                LOG.info((Object)("Storage directory " + sd.root + " does not contain previous fs state."));
                sd.read();
                continue;
            }
            FSImage fSImage = prevState;
            fSImage.getClass();
            Storage.StorageDirectory sdPrev = new Storage.StorageDirectory(fSImage, sd.root);
            sdPrev.read(sdPrev.getPreviousVersionFile());
            canRollback = true;
        }
        if (!canRollback) {
            throw new IOException("Cannot rollback. None of the storage directories contain previous fs state.");
        }
        for (idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            sd = this.getStorageDir(idx);
            prevDir = sd.getPreviousDir();
            if (!prevDir.exists()) continue;
            LOG.info((Object)("Rolling back storage directory " + sd.root + ".\n   new LV = " + prevState.getLayoutVersion() + "; new CTime = " + prevState.getCTime()));
            File tmpDir = sd.getRemovedTmp();
            assert (!tmpDir.exists()) : "removed.tmp directory must not exist.";
            File curDir = sd.getCurrentDir();
            assert (curDir.exists()) : "Current directory must exist.";
            FSImage.rename(curDir, tmpDir);
            FSImage.rename(prevDir, curDir);
            FSImage.deleteDir(tmpDir);
            LOG.info((Object)("Rollback of " + sd.root + " is complete."));
        }
        this.isUpgradeFinalized = true;
        this.verifyDistributedUpgradeProgress(FSConstants.StartupOption.REGULAR);
    }

    private void doFinalize(Storage.StorageDirectory sd) throws IOException {
        File prevDir = sd.getPreviousDir();
        if (!prevDir.exists()) {
            LOG.info((Object)("Directory " + prevDir + " does not exist."));
            LOG.info((Object)("Finalize upgrade for " + sd.root + " is not required."));
            return;
        }
        LOG.info((Object)("Finalizing upgrade for storage directory " + sd.root + "." + (this.getLayoutVersion() == 0 ? "" : "\n   cur LV = " + this.getLayoutVersion() + "; cur CTime = " + this.getCTime())));
        assert (sd.getCurrentDir().exists()) : "Current directory must exist.";
        File tmpDir = sd.getFinalizedTmp();
        FSImage.rename(prevDir, tmpDir);
        FSImage.deleteDir(tmpDir);
        this.isUpgradeFinalized = true;
        LOG.info((Object)("Finalize upgrade for " + sd.root + " is complete."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doImportCheckpoint() throws IOException {
        FSImage ckptImage = new FSImage();
        FSNamesystem fsNamesys = FSNamesystem.getFSNamesystem();
        FSImage realImage = fsNamesys.getFSImage();
        assert (realImage == this);
        fsNamesys.dir.fsImage = ckptImage;
        try {
            ckptImage.recoverTransitionRead(this.checkpointDirs, FSConstants.StartupOption.REGULAR);
        }
        finally {
            ckptImage.close();
        }
        realImage.setStorageInfo(ckptImage);
        fsNamesys.dir.fsImage = realImage;
        this.saveFSImage();
    }

    void finalizeUpgrade() throws IOException {
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            this.doFinalize(this.getStorageDir(idx));
        }
    }

    boolean isUpgradeFinalized() {
        return this.isUpgradeFinalized;
    }

    @Override
    protected void getFields(Properties props, Storage.StorageDirectory sd) throws IOException {
        super.getFields(props, sd);
        if (this.layoutVersion == 0) {
            throw new IOException("NameNode directory " + sd.root + " is not formatted.");
        }
        String sDUS = props.getProperty("distributedUpgradeState");
        String sDUV = props.getProperty("distributedUpgradeVersion");
        this.setDistributedUpgradeState(sDUS == null ? false : Boolean.parseBoolean(sDUS), sDUV == null ? this.getLayoutVersion() : Integer.parseInt(sDUV));
        this.checkpointTime = this.readCheckpointTime(sd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long readCheckpointTime(Storage.StorageDirectory sd) throws IOException {
        File timeFile = FSImage.getImageFile(sd, NameNodeFile.TIME);
        long timeStamp = 0L;
        if (timeFile.exists() && timeFile.canRead()) {
            DataInputStream in = new DataInputStream(new FileInputStream(timeFile));
            try {
                timeStamp = in.readLong();
            }
            finally {
                in.close();
            }
        }
        return timeStamp;
    }

    @Override
    protected void setFields(Properties props, Storage.StorageDirectory sd) throws IOException {
        super.setFields(props, sd);
        boolean uState = this.getDistributedUpgradeState();
        int uVersion = this.getDistributedUpgradeVersion();
        if (uState && uVersion != this.getLayoutVersion()) {
            props.setProperty("distributedUpgradeState", Boolean.toString(uState));
            props.setProperty("distributedUpgradeVersion", Integer.toString(uVersion));
        }
        this.writeCheckpointTime(sd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeCheckpointTime(Storage.StorageDirectory sd) throws IOException {
        if (this.checkpointTime < 0L) {
            return;
        }
        File timeFile = FSImage.getImageFile(sd, NameNodeFile.TIME);
        if (timeFile.exists()) {
            timeFile.delete();
        }
        DataOutputStream out = new DataOutputStream(new FileOutputStream(timeFile));
        try {
            out.writeLong(this.checkpointTime);
        }
        finally {
            out.close();
        }
    }

    int incrementCheckpointTime() {
        ++this.checkpointTime;
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            try {
                Storage.StorageDirectory sd = this.getStorageDir(idx);
                this.writeCheckpointTime(sd);
                continue;
            }
            catch (IOException e) {
                return idx;
            }
        }
        return -1;
    }

    void processIOError(int index) {
        assert (index >= 0 && index < this.getNumStorageDirs());
        this.storageDirs.remove(index);
    }

    FSEditLog getEditLog() {
        return this.editLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isConversionNeeded(Storage.StorageDirectory sd) throws IOException {
        File oldImageDir = new File(sd.root, "image");
        if (!oldImageDir.exists()) {
            throw new InconsistentFSStateException(sd.root, oldImageDir + " does not exist.");
        }
        File oldF = new File(oldImageDir, "fsimage");
        RandomAccessFile oldFile = new RandomAccessFile(oldF, "rws");
        try {
            oldFile.seek(0L);
            int odlVersion = oldFile.readInt();
            if (odlVersion < -3) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            oldFile.close();
        }
        return true;
    }

    void recoverInterruptedCheckpoint(Storage.StorageDirectory sd) throws IOException {
        File curFile = FSImage.getImageFile(sd, NameNodeFile.IMAGE);
        File ckptFile = FSImage.getImageFile(sd, NameNodeFile.IMAGE_NEW);
        if (ckptFile.exists()) {
            if (FSImage.getImageFile(sd, NameNodeFile.EDITS_NEW).exists()) {
                if (!ckptFile.delete()) {
                    throw new IOException("Unable to delete " + ckptFile);
                }
            } else if (!ckptFile.renameTo(curFile)) {
                curFile.delete();
                if (!ckptFile.renameTo(curFile)) {
                    throw new IOException("Unable to rename " + ckptFile + " to " + curFile);
                }
            }
        }
    }

    boolean loadFSImage() throws IOException {
        long latestCheckpointTime = Long.MIN_VALUE;
        Storage.StorageDirectory latestSD = null;
        boolean needToSave = false;
        this.isUpgradeFinalized = true;
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            Storage.StorageDirectory sd = this.getStorageDir(idx);
            this.recoverInterruptedCheckpoint(sd);
            if (!sd.getVersionFile().exists()) {
                needToSave |= true;
                continue;
            }
            assert (FSImage.getImageFile(sd, NameNodeFile.IMAGE).exists()) : "Image file must exist.";
            this.checkpointTime = this.readCheckpointTime(sd);
            if (latestCheckpointTime < this.checkpointTime) {
                latestCheckpointTime = this.checkpointTime;
                latestSD = sd;
            }
            if (this.checkpointTime <= 0L) {
                needToSave |= true;
            }
            this.isUpgradeFinalized = this.isUpgradeFinalized && !sd.getPreviousDir().exists();
        }
        assert (latestSD != null) : "Latest storage directory was not determined.";
        long startTime = FSNamesystem.now();
        long imageSize = FSImage.getImageFile(latestSD, NameNodeFile.IMAGE).length();
        latestSD.read();
        needToSave |= this.loadFSImage(FSImage.getImageFile(latestSD, NameNodeFile.IMAGE));
        LOG.info((Object)("Image file of size " + imageSize + " loaded in " + (FSNamesystem.now() - startTime) / 1000L + " seconds."));
        return needToSave |= this.loadFSEdits(latestSD) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean loadFSImage(File curFile) throws IOException {
        assert (this.getLayoutVersion() < 0) : "Negative layout version is expected.";
        assert (curFile != null) : "curFile is null";
        FSNamesystem fsNamesys = FSNamesystem.getFSNamesystem();
        FSDirectory fsDir = fsNamesys.dir;
        boolean needToSave = true;
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(curFile)));
        try {
            int imgVersion = in.readInt();
            this.namespaceID = in.readInt();
            long numFiles = imgVersion <= -16 ? in.readLong() : (long)in.readInt();
            this.layoutVersion = imgVersion;
            if (imgVersion <= -12) {
                long genstamp = in.readLong();
                fsNamesys.setGenerationStamp(genstamp);
            }
            needToSave = imgVersion != -16;
            short replication = FSNamesystem.getFSNamesystem().getDefaultReplication();
            LOG.info((Object)("Number of files = " + numFiles));
            String parentPath = "";
            INodeDirectory parentINode = fsDir.rootDir;
            for (long i = 0L; i < numFiles; ++i) {
                long modificationTime = 0L;
                long blockSize = 0L;
                String path = FSImage.readString(in);
                replication = in.readShort();
                replication = FSEditLog.adjustReplication(replication);
                modificationTime = in.readLong();
                if (imgVersion <= -8) {
                    blockSize = in.readLong();
                }
                int numBlocks = in.readInt();
                Block[] blocks = null;
                if (-9 <= imgVersion && numBlocks > 0 || imgVersion < -9 && numBlocks >= 0) {
                    blocks = new Block[numBlocks];
                    for (int j = 0; j < numBlocks; ++j) {
                        blocks[j] = new Block();
                        if (-14 < imgVersion) {
                            blocks[j].set(in.readLong(), in.readLong(), 0L);
                            continue;
                        }
                        blocks[j].readFields(in);
                    }
                }
                if (-8 <= imgVersion && blockSize == 0L) {
                    if (numBlocks > 1) {
                        blockSize = blocks[0].getNumBytes();
                    } else {
                        long first = numBlocks == 1 ? blocks[0].getNumBytes() : 0L;
                        blockSize = Math.max(fsNamesys.getDefaultBlockSize(), first);
                    }
                }
                long quota = -1L;
                if (imgVersion <= -16 && blocks == null) {
                    quota = in.readLong();
                }
                PermissionStatus permissions = fsNamesys.getUpgradePermission();
                if (imgVersion <= -11) {
                    permissions = PermissionStatus.read(in);
                }
                if (path.length() == 0) {
                    if (quota != -1L) {
                        fsDir.rootDir.setQuota(quota);
                    }
                    fsDir.rootDir.setModificationTime(modificationTime);
                    fsDir.rootDir.setPermissionStatus(permissions);
                    continue;
                }
                if (!this.isParent(path, parentPath)) {
                    parentINode = null;
                    parentPath = this.getParent(path);
                }
                parentINode = fsDir.addToParent(path, parentINode, permissions, blocks, replication, modificationTime, quota, blockSize);
            }
            this.loadDatanodes(imgVersion, in);
            this.loadFilesUnderConstruction(imgVersion, in, fsNamesys);
            fsDir.updateCountForINodeWithQuota();
        }
        finally {
            in.close();
        }
        return needToSave;
    }

    String getParent(String path) {
        return path.substring(0, path.lastIndexOf("/"));
    }

    private boolean isParent(String path, String parent) {
        return parent != null && path != null && path.indexOf(parent) == 0 && path.lastIndexOf("/") == parent.length();
    }

    int loadFSEdits(Storage.StorageDirectory sd) throws IOException {
        int numEdits = 0;
        numEdits = this.editLog.loadFSEdits(FSImage.getImageFile(sd, NameNodeFile.EDITS));
        File editsNew = FSImage.getImageFile(sd, NameNodeFile.EDITS_NEW);
        if (editsNew.exists()) {
            numEdits += this.editLog.loadFSEdits(editsNew);
        }
        return numEdits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveFSImage(File newFile) throws IOException {
        FSNamesystem fsNamesys = FSNamesystem.getFSNamesystem();
        FSDirectory fsDir = fsNamesys.dir;
        long startTime = FSNamesystem.now();
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(newFile)));
        try {
            out.writeInt(-16);
            out.writeInt(this.namespaceID);
            out.writeLong(fsDir.rootDir.numItemsInTree());
            out.writeLong(fsNamesys.getGenerationStamp());
            byte[] byteStore = new byte[32000];
            ByteBuffer strbuf = ByteBuffer.wrap(byteStore);
            FSImage.saveINode2Image(strbuf, fsDir.rootDir, out);
            FSImage.saveImage(strbuf, 0, fsDir.rootDir, out);
            fsNamesys.saveFilesUnderConstruction(out);
            strbuf = null;
        }
        finally {
            out.close();
        }
        LOG.info((Object)("Image file of size " + newFile.length() + " saved in " + (FSNamesystem.now() - startTime) / 1000L + " seconds."));
    }

    void saveFSImage() throws IOException {
        this.editLog.createNewIfMissing();
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            Storage.StorageDirectory sd = this.getStorageDir(idx);
            this.saveFSImage(FSImage.getImageFile(sd, NameNodeFile.IMAGE_NEW));
            this.editLog.createEditLogFile(FSImage.getImageFile(sd, NameNodeFile.EDITS));
            File editsNew = FSImage.getImageFile(sd, NameNodeFile.EDITS_NEW);
            if (!editsNew.exists()) continue;
            this.editLog.createEditLogFile(editsNew);
        }
        this.ckptState = FSConstants.CheckpointStates.UPLOAD_DONE;
        this.rollFSImage();
    }

    private int newNamespaceID() {
        Random r = new Random();
        r.setSeed(FSNamesystem.now());
        int newID = 0;
        while (newID == 0) {
            newID = r.nextInt(Integer.MAX_VALUE);
        }
        return newID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void format(Storage.StorageDirectory sd) throws IOException {
        sd.clearDirectory();
        sd.lock();
        try {
            this.saveFSImage(FSImage.getImageFile(sd, NameNodeFile.IMAGE));
            this.editLog.createEditLogFile(FSImage.getImageFile(sd, NameNodeFile.EDITS));
            sd.write();
        }
        finally {
            sd.unlock();
        }
        LOG.info((Object)("Storage directory " + sd.root + " has been successfully formatted."));
    }

    public void format() throws IOException {
        this.layoutVersion = -16;
        this.namespaceID = this.newNamespaceID();
        this.cTime = 0L;
        this.checkpointTime = FSNamesystem.now();
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            Storage.StorageDirectory sd = this.getStorageDir(idx);
            this.format(sd);
        }
    }

    private static void saveINode2Image(ByteBuffer name, INode node, DataOutputStream out) throws IOException {
        int nameLen = name.position();
        out.writeShort(nameLen);
        out.write(name.array(), name.arrayOffset(), nameLen);
        if (!node.isDirectory()) {
            INodeFile fileINode = (INodeFile)node;
            out.writeShort(fileINode.getReplication());
            out.writeLong(fileINode.getModificationTime());
            out.writeLong(fileINode.getPreferredBlockSize());
            BlocksMap.BlockInfo[] blocks = fileINode.getBlocks();
            out.writeInt(blocks.length);
            for (BlocksMap.BlockInfo blk : blocks) {
                blk.write(out);
            }
            FILE_PERM.fromShort(fileINode.getFsPermissionShort());
            PermissionStatus.write(out, fileINode.getUserName(), fileINode.getGroupName(), FILE_PERM);
        } else {
            out.writeShort(0);
            out.writeLong(node.getModificationTime());
            out.writeLong(0L);
            out.writeInt(-1);
            out.writeLong(node.getQuota());
            FILE_PERM.fromShort(node.getFsPermissionShort());
            PermissionStatus.write(out, node.getUserName(), node.getGroupName(), FILE_PERM);
        }
    }

    private static void saveImage(ByteBuffer parentPrefix, int prefixLength, INodeDirectory current, DataOutputStream out) throws IOException {
        int newPrefixLength = prefixLength;
        if (current.getChildrenRaw() == null) {
            return;
        }
        for (INode child : current.getChildren()) {
            parentPrefix.position(prefixLength);
            parentPrefix.put(PATH_SEPARATOR).put(child.getLocalNameBytes());
            FSImage.saveINode2Image(parentPrefix, child, out);
        }
        for (INode child : current.getChildren()) {
            if (!child.isDirectory()) continue;
            parentPrefix.position(prefixLength);
            parentPrefix.put(PATH_SEPARATOR).put(child.getLocalNameBytes());
            newPrefixLength = parentPrefix.position();
            FSImage.saveImage(parentPrefix, newPrefixLength, (INodeDirectory)child, out);
        }
        parentPrefix.position(prefixLength);
    }

    void loadDatanodes(int version, DataInputStream in) throws IOException {
        if (version > -3) {
            return;
        }
        if (version <= -12) {
            return;
        }
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            DatanodeImage nodeImage = new DatanodeImage();
            nodeImage.readFields(in);
        }
    }

    private void loadFilesUnderConstruction(int version, DataInputStream in, FSNamesystem fs) throws IOException {
        FSDirectory fsDir = fs.dir;
        if (version > -13) {
            return;
        }
        int size = in.readInt();
        LOG.info((Object)("Number of files under construction = " + size));
        for (int i = 0; i < size; ++i) {
            INodeFileUnderConstruction cons = FSImage.readINodeUnderConstruction(in);
            String path = cons.getLocalName();
            INodeFile old = fsDir.getFileINode(path);
            if (old == null) {
                throw new IOException("Found lease for non-existent file " + path);
            }
            if (((INode)old).isDirectory()) {
                throw new IOException("Found lease for directory " + path);
            }
            INodeFile oldnode = old;
            fsDir.replaceNode(path, oldnode, cons);
            fs.leaseManager.addLease(cons.clientName, path);
        }
    }

    static INodeFileUnderConstruction readINodeUnderConstruction(DataInputStream in) throws IOException {
        byte[] name = FSImage.readBytes(in);
        short blockReplication = in.readShort();
        long modificationTime = in.readLong();
        long preferredBlockSize = in.readLong();
        int numBlocks = in.readInt();
        BlocksMap.BlockInfo[] blocks = new BlocksMap.BlockInfo[numBlocks];
        Block blk = new Block();
        for (int i = 0; i < numBlocks; ++i) {
            blk.readFields(in);
            blocks[i] = new BlocksMap.BlockInfo(blk, blockReplication);
        }
        PermissionStatus perm = PermissionStatus.read(in);
        String clientName = FSImage.readString(in);
        String clientMachine = FSImage.readString(in);
        int numLocs = in.readInt();
        DatanodeDescriptor[] locations = new DatanodeDescriptor[numLocs];
        for (int i = 0; i < numLocs; ++i) {
            locations[i] = new DatanodeDescriptor();
            locations[i].readFields(in);
        }
        return new INodeFileUnderConstruction(name, blockReplication, modificationTime, preferredBlockSize, blocks, perm, clientName, clientMachine, null);
    }

    static void writeINodeUnderConstruction(DataOutputStream out, INodeFileUnderConstruction cons, String path) throws IOException {
        FSImage.writeString(path, out);
        out.writeShort(cons.getReplication());
        out.writeLong(cons.getModificationTime());
        out.writeLong(cons.getPreferredBlockSize());
        int nrBlocks = cons.getBlocks().length;
        out.writeInt(nrBlocks);
        for (int i = 0; i < nrBlocks; ++i) {
            cons.getBlocks()[i].write(out);
        }
        cons.getPermissionStatus().write(out);
        FSImage.writeString(cons.getClientName(), out);
        FSImage.writeString(cons.getClientMachine(), out);
        out.writeInt(0);
    }

    void rollFSImage() throws IOException {
        File ckpt;
        Storage.StorageDirectory sd;
        int idx;
        if (this.ckptState != FSConstants.CheckpointStates.UPLOAD_DONE) {
            throw new IOException("Cannot roll fsImage before rolling edits log.");
        }
        if (!this.editLog.existsNew()) {
            throw new IOException("New Edits file does not exist");
        }
        for (idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            sd = this.getStorageDir(idx);
            ckpt = FSImage.getImageFile(sd, NameNodeFile.IMAGE_NEW);
            if (ckpt.exists()) continue;
            throw new IOException("Checkpoint file " + ckpt + " does not exist");
        }
        this.editLog.purgeEditLog();
        for (idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            File curFile;
            sd = this.getStorageDir(idx);
            ckpt = FSImage.getImageFile(sd, NameNodeFile.IMAGE_NEW);
            if (ckpt.renameTo(curFile = FSImage.getImageFile(sd, NameNodeFile.IMAGE))) continue;
            curFile.delete();
            if (ckpt.renameTo(curFile)) continue;
            this.editLog.processIOError(idx);
            --idx;
        }
        this.layoutVersion = -16;
        this.checkpointTime = FSNamesystem.now();
        for (idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            sd = this.getStorageDir(idx);
            try {
                sd.write();
                continue;
            }
            catch (IOException e) {
                LOG.error((Object)("Cannot write file " + sd.root), (Throwable)e);
                this.editLog.processIOError(idx);
                --idx;
            }
        }
        this.ckptState = FSConstants.CheckpointStates.START;
    }

    CheckpointSignature rollEditLog() throws IOException {
        this.getEditLog().rollEditLog();
        this.ckptState = FSConstants.CheckpointStates.ROLLED_EDITS;
        return new CheckpointSignature(this);
    }

    void validateCheckpointUpload(CheckpointSignature sig) throws IOException {
        if (this.ckptState != FSConstants.CheckpointStates.ROLLED_EDITS) {
            throw new IOException("Namenode is not expecting an new image " + (Object)((Object)this.ckptState));
        }
        long modtime = this.getEditLog().getFsEditTime();
        if (sig.editsTime != modtime) {
            throw new IOException("Namenode has an edit log with timestamp of " + DATE_FORM.format(new Date(modtime)) + " but new checkpoint was created using editlog " + " with timestamp " + DATE_FORM.format(new Date(sig.editsTime)) + ". Checkpoint Aborted.");
        }
        sig.validateStorageInfo(this);
        this.ckptState = FSConstants.CheckpointStates.UPLOAD_START;
    }

    synchronized void checkpointUploadDone() {
        this.ckptState = FSConstants.CheckpointStates.UPLOAD_DONE;
    }

    void close() throws IOException {
        this.getEditLog().close();
        this.unlockAll();
    }

    File getFsImageName() {
        return this.getImageFile(0, NameNodeFile.IMAGE);
    }

    File getFsEditName() throws IOException {
        return this.getEditLog().getFsEditName();
    }

    File getFsTimeName() {
        return this.getImageFile(0, NameNodeFile.TIME);
    }

    File[] getFsImageNameCheckpoint() {
        File[] list = new File[this.getNumStorageDirs()];
        for (int i = 0; i < this.getNumStorageDirs(); ++i) {
            list[i] = FSImage.getImageFile(this.getStorageDir(i), NameNodeFile.IMAGE_NEW);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void corruptPreUpgradeStorage(File rootDir) throws IOException {
        File oldImageDir = new File(rootDir, "image");
        if (!oldImageDir.exists() && !oldImageDir.mkdir()) {
            throw new IOException("Cannot create directory " + oldImageDir);
        }
        File oldImage = new File(oldImageDir, "fsimage");
        if (!oldImage.exists() && !oldImage.createNewFile()) {
            throw new IOException("Cannot create file " + oldImage);
        }
        RandomAccessFile oldFile = new RandomAccessFile(oldImage, "rws");
        try {
            this.writeCorruptedData(oldFile);
        }
        finally {
            oldFile.close();
        }
    }

    private boolean getDistributedUpgradeState() {
        return FSNamesystem.getFSNamesystem().getDistributedUpgradeState();
    }

    private int getDistributedUpgradeVersion() {
        return FSNamesystem.getFSNamesystem().getDistributedUpgradeVersion();
    }

    private void setDistributedUpgradeState(boolean uState, int uVersion) {
        FSNamesystem.getFSNamesystem().upgradeManager.setUpgradeState(uState, uVersion);
    }

    private void verifyDistributedUpgradeProgress(FSConstants.StartupOption startOpt) throws IOException {
        if (startOpt == FSConstants.StartupOption.ROLLBACK || startOpt == FSConstants.StartupOption.IMPORT) {
            return;
        }
        UpgradeManagerNamenode um = FSNamesystem.getFSNamesystem().upgradeManager;
        assert (um != null) : "FSNameSystem.upgradeManager is null.";
        if (startOpt != FSConstants.StartupOption.UPGRADE) {
            if (um.getUpgradeState()) {
                throw new IOException("\n   Previous distributed upgrade was not completed. \n   Please restart NameNode with -upgrade option.");
            }
            if (um.getDistributedUpgrades() != null) {
                throw new IOException("\n   Distributed upgrade for NameNode version " + um.getUpgradeVersion() + " to current LV " + -16 + " is required.\n   Please restart NameNode with -upgrade option.");
            }
        }
    }

    private void initializeDistributedUpgrade() throws IOException {
        UpgradeManagerNamenode um = FSNamesystem.getFSNamesystem().upgradeManager;
        if (!um.initializeUpgrade()) {
            return;
        }
        FSNamesystem.getFSNamesystem().getFSImage().writeAll();
        NameNode.LOG.info((Object)("\n   Distributed upgrade for NameNode version " + um.getUpgradeVersion() + " to current LV " + -16 + " is initialized."));
    }

    static Collection<File> getCheckpointDirs(Configuration conf, String defaultName) {
        Collection<String> dirNames = conf.getStringCollection("fs.checkpoint.dir");
        if (dirNames.size() == 0 && defaultName != null) {
            dirNames.add(defaultName);
        }
        ArrayList<File> dirs = new ArrayList<File>(dirNames.size());
        for (String name : dirNames) {
            dirs.add(new File(name));
        }
        return dirs;
    }

    static String readString(DataInputStream in) throws IOException {
        U_STR.readFields(in);
        return U_STR.toString();
    }

    static byte[] readBytes(DataInputStream in) throws IOException {
        U_STR.readFields(in);
        int len = U_STR.getLength();
        byte[] bytes = new byte[len];
        System.arraycopy(U_STR.getBytes(), 0, bytes, 0, len);
        return bytes;
    }

    static void writeString(String str, DataOutputStream out) throws IOException {
        U_STR.set(str);
        U_STR.write(out);
    }

    static class DatanodeImage
    implements WritableComparable {
        DatanodeDescriptor node;

        DatanodeImage() {
            this.node = new DatanodeDescriptor();
        }

        DatanodeImage(DatanodeDescriptor from) {
            this.node = from;
        }

        DatanodeDescriptor getDatanodeDescriptor() {
            return this.node;
        }

        public int compareTo(Object o) {
            return this.node.compareTo(o);
        }

        public boolean equals(Object o) {
            return this.node.equals(o);
        }

        public int hashCode() {
            return this.node.hashCode();
        }

        public void write(DataOutput out) throws IOException {
            new DatanodeID(this.node).write(out);
            out.writeLong(this.node.getCapacity());
            out.writeLong(this.node.getRemaining());
            out.writeLong(this.node.getLastUpdate());
            out.writeInt(this.node.getXceiverCount());
        }

        public void readFields(DataInput in) throws IOException {
            DatanodeID id = new DatanodeID();
            id.readFields(in);
            long capacity = in.readLong();
            long remaining = in.readLong();
            long lastUpdate = in.readLong();
            int xceiverCount = in.readInt();
            this.node.updateRegInfo(id);
            this.node.setStorageID(id.getStorageID());
            this.node.setCapacity(capacity);
            this.node.setRemaining(remaining);
            this.node.setLastUpdate(lastUpdate);
            this.node.setXceiverCount(xceiverCount);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NameNodeFile {
        IMAGE("fsimage"),
        TIME("fstime"),
        EDITS("edits"),
        IMAGE_NEW("fsimage.ckpt"),
        EDITS_NEW("edits.new");

        private String fileName = null;

        private NameNodeFile(String name) {
            this.fileName = name;
        }

        String getName() {
            return this.fileName;
        }
    }
}

