/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.AlreadyBeingCreatedException;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.BlockListAsLongs;
import org.apache.hadoop.dfs.BlocksMap;
import org.apache.hadoop.dfs.BlocksWithLocations;
import org.apache.hadoop.dfs.CheckpointSignature;
import org.apache.hadoop.dfs.CorruptReplicasMap;
import org.apache.hadoop.dfs.DFSFileInfo;
import org.apache.hadoop.dfs.DatanodeCommand;
import org.apache.hadoop.dfs.DatanodeDescriptor;
import org.apache.hadoop.dfs.DatanodeID;
import org.apache.hadoop.dfs.DatanodeInfo;
import org.apache.hadoop.dfs.DatanodeRegistration;
import org.apache.hadoop.dfs.DisallowedDatanodeException;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.FSDirectory;
import org.apache.hadoop.dfs.FSEditLog;
import org.apache.hadoop.dfs.FSImage;
import org.apache.hadoop.dfs.FSNamesystemMetrics;
import org.apache.hadoop.dfs.FileDataServlet;
import org.apache.hadoop.dfs.FsckServlet;
import org.apache.hadoop.dfs.GenerationStamp;
import org.apache.hadoop.dfs.GetImageServlet;
import org.apache.hadoop.dfs.Host2NodesMap;
import org.apache.hadoop.dfs.INode;
import org.apache.hadoop.dfs.INodeFile;
import org.apache.hadoop.dfs.INodeFileUnderConstruction;
import org.apache.hadoop.dfs.LeaseExpiredException;
import org.apache.hadoop.dfs.LeaseManager;
import org.apache.hadoop.dfs.ListPathsServlet;
import org.apache.hadoop.dfs.LocatedBlock;
import org.apache.hadoop.dfs.LocatedBlocks;
import org.apache.hadoop.dfs.NameNode;
import org.apache.hadoop.dfs.NamespaceInfo;
import org.apache.hadoop.dfs.NotReplicatedYetException;
import org.apache.hadoop.dfs.PendingReplicationBlocks;
import org.apache.hadoop.dfs.PermissionChecker;
import org.apache.hadoop.dfs.ReplicationTargetChooser;
import org.apache.hadoop.dfs.SafeModeException;
import org.apache.hadoop.dfs.Storage;
import org.apache.hadoop.dfs.StringBytesWritable;
import org.apache.hadoop.dfs.UnderReplicatedBlocks;
import org.apache.hadoop.dfs.UnregisteredDatanodeException;
import org.apache.hadoop.dfs.UpgradeCommand;
import org.apache.hadoop.dfs.UpgradeManagerNamenode;
import org.apache.hadoop.dfs.UpgradeStatusReport;
import org.apache.hadoop.dfs.namenode.metrics.FSNamesystemMBean;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AccessControlException;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapred.StatusHttpServer;
import org.apache.hadoop.metrics.util.MBeanUtil;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.ScriptBasedMapping;
import org.apache.hadoop.security.UnixUserGroupInformation;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.HostsFileReader;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FSNamesystem
implements FSConstants,
FSNamesystemMBean {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.fs.FSNamesystem");
    public static final String AUDIT_FORMAT = "ugi=%s\tip=%s\tcmd=%s\tpath=%s\tperm=%s";
    public static final Log auditLog = LogFactory.getLog((String)"org.apache.hadoop.fs.FSNamesystem.audit");
    private boolean isPermissionEnabled;
    private UserGroupInformation fsOwner;
    private String supergroup;
    private PermissionStatus defaultPermission;
    private FSNamesystemMetrics myFSMetrics;
    private long capacityTotal = 0L;
    private long capacityUsed = 0L;
    private long capacityRemaining = 0L;
    private int totalLoad = 0;
    private long pendingReplicationBlocksCount = 0L;
    private long underReplicatedBlocksCount = 0L;
    private long scheduledReplicationBlocksCount = 0L;
    FSDirectory dir;
    BlocksMap blocksMap = new BlocksMap();
    CorruptReplicasMap corruptReplicas = new CorruptReplicasMap();
    Map<String, DatanodeDescriptor> datanodeMap = new TreeMap<String, DatanodeDescriptor>();
    private Map<String, Collection<Block>> recentInvalidateSets = new TreeMap<String, Collection<Block>>();
    private Map<String, Collection<Block>> excessReplicateMap = new TreeMap<String, Collection<Block>>();
    StatusHttpServer infoServer;
    int infoPort;
    Date startTime;
    Random r = new Random();
    ArrayList<DatanodeDescriptor> heartbeats = new ArrayList();
    private UnderReplicatedBlocks neededReplications = new UnderReplicatedBlocks();
    private PendingReplicationBlocks pendingReplications;
    LeaseManager leaseManager = new LeaseManager(this);
    Daemon hbthread = null;
    Daemon lmthread = null;
    Daemon smmthread = null;
    Daemon replthread = null;
    Daemon resthread = null;
    volatile boolean fsRunning = true;
    long systemStart = 0L;
    private int maxReplication;
    private int maxReplicationStreams;
    private int minReplication;
    private int defaultReplication;
    private long heartbeatRecheckInterval;
    private long heartbeatExpireInterval;
    private long replicationRecheckInterval;
    private long decommissionRecheckInterval;
    private long defaultBlockSize = 0L;
    private int replIndex = 0;
    public static FSNamesystem fsNamesystemObject;
    private String localMachine;
    private int port;
    private SafeModeInfo safeMode;
    private Host2NodesMap host2DataNodeMap = new Host2NodesMap();
    NetworkTopology clusterMap = new NetworkTopology();
    private DNSToSwitchMapping dnsToSwitchMapping;
    private LinkedBlockingQueue<DatanodeDescriptor> resolutionQueue = new LinkedBlockingQueue();
    ReplicationTargetChooser replicator;
    private HostsFileReader hostsReader;
    private Daemon dnthread = null;
    private long maxFsObjects = 0L;
    private final GenerationStamp generationStamp = new GenerationStamp();
    private int blockInvalidateLimit = 100;
    static Random randBlockId;
    UpgradeManagerNamenode upgradeManager = new UpgradeManagerNamenode();
    private ObjectName mbeanName;

    FSNamesystem(NameNode nn, Configuration conf) throws IOException {
        try {
            this.initialize(nn, conf);
        }
        catch (IOException e) {
            LOG.error((Object)(this.getClass().getSimpleName() + " initialization failed."), (Throwable)e);
            this.close();
            throw e;
        }
    }

    private void initialize(NameNode nn, Configuration conf) throws IOException {
        this.systemStart = FSNamesystem.now();
        this.startTime = new Date(this.systemStart);
        this.setConfigurationParameters(conf);
        this.localMachine = nn.getNameNodeAddress().getHostName();
        this.port = nn.getNameNodeAddress().getPort();
        this.registerMBean(conf);
        this.dir = new FSDirectory(this, conf);
        FSConstants.StartupOption startOpt = NameNode.getStartupOption(conf);
        this.dir.loadFSImage(FSNamesystem.getNamespaceDirs(conf), startOpt);
        long timeTakenToLoadFSImage = FSNamesystem.now() - this.systemStart;
        LOG.info((Object)("Finished loading FSImage in " + timeTakenToLoadFSImage + " msecs"));
        NameNode.getNameNodeMetrics().fsImageLoadTime.set((int)timeTakenToLoadFSImage);
        this.safeMode = new SafeModeInfo(conf);
        this.setBlockTotal();
        this.pendingReplications = new PendingReplicationBlocks((long)conf.getInt("dfs.replication.pending.timeout.sec", -1) * 1000L);
        this.hbthread = new Daemon(new HeartbeatMonitor());
        this.lmthread = new Daemon(this.leaseManager.createMonitor());
        this.replthread = new Daemon(new ReplicationMonitor());
        this.resthread = new Daemon(new ResolutionMonitor());
        this.hbthread.start();
        this.lmthread.start();
        this.replthread.start();
        this.resthread.start();
        this.hostsReader = new HostsFileReader(conf.get("dfs.hosts", ""), conf.get("dfs.hosts.exclude", ""));
        this.dnthread = new Daemon(new DecommissionedMonitor());
        this.dnthread.start();
        this.dnsToSwitchMapping = (DNSToSwitchMapping)ReflectionUtils.newInstance(conf.getClass("topology.node.switch.mapping.impl", ScriptBasedMapping.class, DNSToSwitchMapping.class), conf);
        String infoAddr = NetUtils.getServerAddress(conf, "dfs.info.bindAddress", "dfs.info.port", "dfs.http.address");
        InetSocketAddress infoSocAddr = NetUtils.createSocketAddr(infoAddr);
        String infoHost = infoSocAddr.getHostName();
        int tmpInfoPort = infoSocAddr.getPort();
        this.infoServer = new StatusHttpServer("dfs", infoHost, tmpInfoPort, tmpInfoPort == 0);
        InetSocketAddress secInfoSocAddr = NetUtils.createSocketAddr(conf.get("dfs.https.address", infoHost + ":" + 0));
        Configuration sslConf = new Configuration(conf);
        sslConf.addResource(conf.get("https.keystore.info.rsrc", "sslinfo.xml"));
        String keyloc = sslConf.get("https.keystore.location");
        if (null != keyloc) {
            this.infoServer.addSslListener(secInfoSocAddr, keyloc, sslConf.get("https.keystore.password", ""), sslConf.get("https.keystore.keypassword", ""));
        }
        InetSocketAddress datanodeSslPort = NetUtils.createSocketAddr(conf.get("dfs.datanode.https.address", infoHost + ":" + 50475));
        this.infoServer.setAttribute("datanode.https.port", datanodeSslPort.getPort());
        this.infoServer.setAttribute("name.node", nn);
        this.infoServer.setAttribute("name.system.image", this.getFSImage());
        this.infoServer.setAttribute("name.conf", conf);
        this.infoServer.addServlet("fsck", "/fsck", FsckServlet.class);
        this.infoServer.addServlet("getimage", "/getimage", GetImageServlet.class);
        this.infoServer.addServlet("listPaths", "/listPaths/*", ListPathsServlet.class);
        this.infoServer.addServlet("data", "/data/*", FileDataServlet.class);
        this.infoServer.start();
        this.infoPort = this.infoServer.getPort();
        conf.set("dfs.http.address", infoHost + ":" + this.infoPort);
        LOG.info((Object)("Web-server up at: " + infoHost + ":" + this.infoPort));
    }

    static Collection<File> getNamespaceDirs(Configuration conf) {
        Collection<String> dirNames = conf.getStringCollection("dfs.name.dir");
        if (dirNames.isEmpty()) {
            dirNames.add("/tmp/hadoop/dfs/name");
        }
        ArrayList<File> dirs = new ArrayList<File>(dirNames.size());
        for (String name : dirNames) {
            dirs.add(new File(name));
        }
        return dirs;
    }

    FSNamesystem(FSImage fsImage, Configuration conf) throws IOException {
        this.setConfigurationParameters(conf);
        this.registerMBean(conf);
        this.dir = new FSDirectory(fsImage, this, conf);
    }

    private void setConfigurationParameters(Configuration conf) throws IOException {
        fsNamesystemObject = this;
        try {
            this.fsOwner = UnixUserGroupInformation.login(conf);
        }
        catch (LoginException e) {
            throw new IOException(StringUtils.stringifyException(e));
        }
        LOG.info((Object)("fsOwner=" + this.fsOwner));
        this.supergroup = conf.get("dfs.permissions.supergroup", "supergroup");
        this.isPermissionEnabled = conf.getBoolean("dfs.permissions", true);
        LOG.info((Object)("supergroup=" + this.supergroup));
        LOG.info((Object)("isPermissionEnabled=" + this.isPermissionEnabled));
        short filePermission = (short)conf.getInt("dfs.upgrade.permission", 511);
        this.defaultPermission = PermissionStatus.createImmutable(this.fsOwner.getUserName(), this.supergroup, new FsPermission(filePermission));
        this.replicator = new ReplicationTargetChooser(conf.getBoolean("dfs.replication.considerLoad", true), this, this.clusterMap);
        this.defaultReplication = conf.getInt("dfs.replication", 3);
        this.maxReplication = conf.getInt("dfs.replication.max", 512);
        this.minReplication = conf.getInt("dfs.replication.min", 1);
        if (this.minReplication <= 0) {
            throw new IOException("Unexpected configuration parameters: dfs.replication.min = " + this.minReplication + " must be greater than 0");
        }
        if (this.maxReplication >= Short.MAX_VALUE) {
            throw new IOException("Unexpected configuration parameters: dfs.replication.max = " + this.maxReplication + " must be less than " + Short.MAX_VALUE);
        }
        if (this.maxReplication < this.minReplication) {
            throw new IOException("Unexpected configuration parameters: dfs.replication.min = " + this.minReplication + " must be less than dfs.replication.max = " + this.maxReplication);
        }
        this.maxReplicationStreams = conf.getInt("dfs.max-repl-streams", 2);
        long heartbeatInterval = conf.getLong("dfs.heartbeat.interval", 3L) * 1000L;
        this.heartbeatRecheckInterval = conf.getInt("heartbeat.recheck.interval", 300000);
        this.heartbeatExpireInterval = 2L * this.heartbeatRecheckInterval + 10L * heartbeatInterval;
        this.replicationRecheckInterval = (long)conf.getInt("dfs.replication.interval", 3) * 1000L;
        this.decommissionRecheckInterval = (long)conf.getInt("dfs.namenode.decommission.interval", 300) * 1000L;
        this.defaultBlockSize = conf.getLong("dfs.block.size", 0x4000000L);
        this.maxFsObjects = conf.getLong("dfs.max.objects", 0L);
        this.blockInvalidateLimit = Math.max(this.blockInvalidateLimit, 20 * (int)(heartbeatInterval / 1000L));
    }

    protected PermissionStatus getUpgradePermission() {
        return this.defaultPermission;
    }

    public static FSNamesystem getFSNamesystem() {
        return fsNamesystemObject;
    }

    NamespaceInfo getNamespaceInfo() {
        return new NamespaceInfo(this.dir.fsImage.getNamespaceID(), this.dir.fsImage.getCTime(), this.getDistributedUpgradeVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void close() {
        block24: {
            block23: {
                block22: {
                    this.fsRunning = false;
                    if (this.pendingReplications != null) {
                        this.pendingReplications.stop();
                    }
                    if (this.infoServer != null) {
                        this.infoServer.stop();
                    }
                    if (this.hbthread != null) {
                        this.hbthread.interrupt();
                    }
                    if (this.replthread != null) {
                        this.replthread.interrupt();
                    }
                    if (this.resthread != null) {
                        this.resthread.interrupt();
                    }
                    if (this.dnthread != null) {
                        this.dnthread.interrupt();
                    }
                    if (this.smmthread == null) break block22;
                    this.smmthread.interrupt();
                }
                try {
                    if (this.lmthread == null) break block23;
                    this.lmthread.interrupt();
                    this.lmthread.join(3000L);
                }
                catch (InterruptedException ie) {
                    IOUtils.close(LOG, this.dir);
                    break block24;
                    catch (Throwable throwable) {
                        IOUtils.close(LOG, this.dir);
                        throw throwable;
                    }
                }
            }
            IOUtils.close(LOG, this.dir);
            break block24;
            catch (InterruptedException ie) {
                block25: {
                    try {
                        if (this.lmthread == null) break block25;
                        this.lmthread.interrupt();
                        this.lmthread.join(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        IOUtils.close(LOG, this.dir);
                        break block24;
                        catch (Throwable throwable) {
                            IOUtils.close(LOG, this.dir);
                            throw throwable;
                        }
                    }
                }
                IOUtils.close(LOG, this.dir);
                catch (Throwable throwable) {
                    block27: {
                        block26: {
                            try {
                                if (this.lmthread == null) break block26;
                                this.lmthread.interrupt();
                                this.lmthread.join(3000L);
                            }
                            catch (InterruptedException ie2) {
                                IOUtils.close(LOG, this.dir);
                                break block27;
                                catch (Throwable throwable2) {
                                    IOUtils.close(LOG, this.dir);
                                    throw throwable2;
                                }
                            }
                        }
                        IOUtils.close(LOG, this.dir);
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void metaSave(String filename) throws IOException {
        this.checkSuperuserPrivilege();
        File file = new File(System.getProperty("hadoop.log.dir"), filename);
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file, true)));
        UnderReplicatedBlocks underReplicatedBlocks = this.neededReplications;
        synchronized (underReplicatedBlocks) {
            out.println("Metasave: Blocks waiting for replication: " + this.neededReplications.size());
            for (Block block : this.neededReplications) {
                out.print(block);
                Iterator<DatanodeDescriptor> jt = this.blocksMap.nodeIterator(block);
                while (jt.hasNext()) {
                    DatanodeDescriptor node = jt.next();
                    out.print(" " + node + " : ");
                }
                out.println("");
            }
        }
        this.pendingReplications.metaSave(out);
        this.dumpRecentInvalidateSets(out);
        this.datanodeDump(out);
        out.flush();
        out.close();
    }

    long getDefaultBlockSize() {
        return this.defaultBlockSize;
    }

    private int getReplication(Block block) {
        INodeFile fileINode = this.blocksMap.getINode(block);
        if (fileINode == null) {
            return 0;
        }
        assert (!fileINode.isDirectory()) : "Block cannot belong to a directory.";
        return fileINode.getReplication();
    }

    synchronized void updateNeededReplications(Block block, int curReplicasDelta, int expectedReplicasDelta) {
        NumberReplicas repl = this.countNodes(block);
        int curExpectedReplicas = this.getReplication(block);
        this.neededReplications.update(block, repl.liveReplicas(), repl.decommissionedReplicas(), curExpectedReplicas, curReplicasDelta, expectedReplicasDelta);
    }

    synchronized BlocksWithLocations getBlocks(DatanodeID datanode, long size) throws IOException {
        long totalSize;
        this.checkSuperuserPrivilege();
        DatanodeDescriptor node = this.getDatanode(datanode);
        if (node == null) {
            NameNode.stateChangeLog.warn((Object)("BLOCK* NameSystem.getBlocks: Asking for blocks from an unrecorded node " + datanode.getName()));
            throw new IllegalArgumentException("Unexpected exception.  Got getBlocks message for datanode " + datanode.getName() + ", but there is no info for it");
        }
        int numBlocks = node.numBlocks();
        if (numBlocks == 0) {
            return new BlocksWithLocations(new BlocksWithLocations.BlockWithLocations[0]);
        }
        Iterator<Block> iter = node.getBlockIterator();
        int startBlock = this.r.nextInt(numBlocks);
        for (int i = 0; i < startBlock; ++i) {
            iter.next();
        }
        ArrayList<BlocksWithLocations.BlockWithLocations> results = new ArrayList<BlocksWithLocations.BlockWithLocations>();
        for (totalSize = 0L; totalSize < size && iter.hasNext(); totalSize += this.addBlock(iter.next(), results)) {
        }
        if (totalSize < size) {
            iter = node.getBlockIterator();
            for (int i = 0; i < startBlock && totalSize < size; totalSize += this.addBlock(iter.next(), results), ++i) {
            }
        }
        return new BlocksWithLocations(results.toArray(new BlocksWithLocations.BlockWithLocations[results.size()]));
    }

    private long addBlock(Block block, List<BlocksWithLocations.BlockWithLocations> results) {
        ArrayList<String> machineSet = new ArrayList<String>(this.blocksMap.numNodes(block));
        Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(block);
        while (it.hasNext()) {
            String storageID = it.next().getStorageID();
            Collection<Block> blocks = this.recentInvalidateSets.get(storageID);
            if (blocks != null && blocks.contains(block)) continue;
            machineSet.add(storageID);
        }
        if (machineSet.size() == 0) {
            return 0L;
        }
        results.add(new BlocksWithLocations.BlockWithLocations(block, machineSet.toArray(new String[machineSet.size()])));
        return block.getNumBytes();
    }

    public synchronized void setPermission(String src, FsPermission permission) throws IOException {
        this.checkOwner(src);
        this.dir.setPermission(src, permission);
        this.getEditLog().logSync();
        if (auditLog.isInfoEnabled()) {
            DFSFileInfo stat = this.dir.getFileInfo(src);
            auditLog.info((Object)String.format(AUDIT_FORMAT, UserGroupInformation.getCurrentUGI(), Server.getRemoteIp(), "setPermission", src, stat.getOwner() + ':' + stat.getGroup() + ':' + stat.getPermission()));
        }
    }

    public synchronized void setOwner(String src, String username, String group) throws IOException {
        PermissionChecker pc = this.checkOwner(src);
        if (!pc.isSuper) {
            if (username != null && !pc.user.equals(username)) {
                throw new AccessControlException("Non-super user cannot change owner.");
            }
            if (group != null && !pc.containsGroup(group)) {
                throw new AccessControlException("User does not belong to " + group + " .");
            }
        }
        this.dir.setOwner(src, username, group);
        this.getEditLog().logSync();
        if (auditLog.isInfoEnabled()) {
            DFSFileInfo stat = this.dir.getFileInfo(src);
            auditLog.info((Object)String.format(AUDIT_FORMAT, UserGroupInformation.getCurrentUGI(), Server.getRemoteIp(), "setOwner", src, stat.getOwner() + ':' + stat.getGroup() + ':' + stat.getPermission()));
        }
    }

    LocatedBlocks getBlockLocations(String clientMachine, String src, long offset, long length) throws IOException {
        LocatedBlocks blocks;
        if (this.isPermissionEnabled) {
            this.checkPathAccess(src, FsAction.READ);
        }
        if ((blocks = this.getBlockLocations(src, offset, length)) != null) {
            DatanodeDescriptor client = this.host2DataNodeMap.getDatanodeByHost(clientMachine);
            for (LocatedBlock b : blocks.getLocatedBlocks()) {
                this.clusterMap.pseudoSortByDistance(client, b.getLocations());
            }
        }
        return blocks;
    }

    LocatedBlocks getBlockLocations(String src, long offset, long length) throws IOException {
        if (offset < 0L) {
            throw new IOException("Negative offset is not supported. File: " + src);
        }
        if (length < 0L) {
            throw new IOException("Negative length is not supported. File: " + src);
        }
        LocatedBlocks ret = this.getBlockLocationsInternal(this.dir.getFileINode(src), offset, length, Integer.MAX_VALUE);
        if (auditLog.isInfoEnabled()) {
            auditLog.info((Object)String.format(AUDIT_FORMAT, UserGroupInformation.getCurrentUGI(), Server.getRemoteIp(), "open", src, null));
        }
        return ret;
    }

    private synchronized LocatedBlocks getBlockLocationsInternal(INodeFile inode, long offset, long length, int nrBlocksToReturn) {
        if (inode == null) {
            return null;
        }
        BlocksMap.BlockInfo[] blocks = inode.getBlocks();
        if (blocks == null) {
            return null;
        }
        if (blocks.length == 0) {
            return new LocatedBlocks(inode, new ArrayList<LocatedBlock>(blocks.length));
        }
        ArrayList<LocatedBlock> results = new ArrayList<LocatedBlock>(blocks.length);
        int curBlk = 0;
        long curPos = 0L;
        long blkSize = 0L;
        int nrBlocks = blocks[0].getNumBytes() == 0L ? 0 : blocks.length;
        for (curBlk = 0; curBlk < nrBlocks; ++curBlk) {
            blkSize = blocks[curBlk].getNumBytes();
            assert (blkSize > 0L) : "Block of size 0";
            if (curPos + blkSize > offset) break;
            curPos += blkSize;
        }
        if (nrBlocks > 0 && curBlk == nrBlocks) {
            return null;
        }
        long endOff = offset + length;
        do {
            int numNodes = this.blocksMap.numNodes(blocks[curBlk]);
            Collection<DatanodeDescriptor> nodesCorrupt = this.corruptReplicas.getNodes(blocks[curBlk]);
            int numCorruptNodes = nodesCorrupt == null ? 0 : nodesCorrupt.size();
            boolean blockCorrupt = numCorruptNodes == numNodes;
            int numMachineSet = blockCorrupt ? numNodes : numNodes - numCorruptNodes;
            DatanodeInfo[] machineSet = new DatanodeDescriptor[numMachineSet];
            if (numMachineSet > 0) {
                numNodes = 0;
                Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(blocks[curBlk]);
                while (it.hasNext()) {
                    boolean replicaCorrupt;
                    DatanodeDescriptor dn = it.next();
                    boolean bl = replicaCorrupt = nodesCorrupt != null && nodesCorrupt.contains(dn);
                    if (!blockCorrupt && (blockCorrupt || replicaCorrupt)) continue;
                    machineSet[numNodes++] = dn;
                }
            }
            results.add(new LocatedBlock(blocks[curBlk], machineSet, curPos, blockCorrupt));
        } while ((curPos += blocks[++curBlk].getNumBytes()) < endOff && curBlk < blocks.length && results.size() < nrBlocksToReturn);
        return new LocatedBlocks(inode, results);
    }

    public boolean setReplication(String src, short replication) throws IOException {
        boolean status = this.setReplicationInternal(src, replication);
        this.getEditLog().logSync();
        if (auditLog.isInfoEnabled()) {
            auditLog.info((Object)String.format(AUDIT_FORMAT, UserGroupInformation.getCurrentUGI(), Server.getRemoteIp(), "setReplication", src, null));
        }
        return status;
    }

    private synchronized boolean setReplicationInternal(String src, short replication) throws IOException {
        int idx;
        int[] oldReplication;
        Block[] fileBlocks;
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot set replication for " + src, this.safeMode);
        }
        this.verifyReplication(src, replication, null);
        if (this.isPermissionEnabled) {
            this.checkPathAccess(src, FsAction.WRITE);
        }
        if ((fileBlocks = this.dir.setReplication(src, replication, oldReplication = new int[1])) == null) {
            return false;
        }
        int oldRepl = oldReplication[0];
        if (oldRepl == replication) {
            return true;
        }
        LOG.info((Object)("Increasing replication for file " + src + ". New replication is " + replication));
        for (idx = 0; idx < fileBlocks.length; ++idx) {
            this.updateNeededReplications(fileBlocks[idx], 0, replication - oldRepl);
        }
        if (oldRepl > replication) {
            LOG.info((Object)("Reducing replication for file " + src + ". New replication is " + replication));
            for (idx = 0; idx < fileBlocks.length; ++idx) {
                this.proccessOverReplicatedBlock(fileBlocks[idx], replication, null, null);
            }
        }
        return true;
    }

    long getPreferredBlockSize(String filename) throws IOException {
        if (this.isPermissionEnabled) {
            this.checkTraverse(filename);
        }
        return this.dir.getPreferredBlockSize(filename);
    }

    private void verifyReplication(String src, short replication, String clientName) throws IOException {
        String text = "file " + src + (clientName != null ? " on client " + clientName : "") + ".\n" + "Requested replication " + replication;
        if (replication > this.maxReplication) {
            throw new IOException(text + " exceeds maximum " + this.maxReplication);
        }
        if (replication < this.minReplication) {
            throw new IOException(text + " is less than the required minimum " + this.minReplication);
        }
    }

    void startFile(String src, PermissionStatus permissions, String holder, String clientMachine, boolean overwrite, short replication, long blockSize) throws IOException {
        this.startFileInternal(src, permissions, holder, clientMachine, overwrite, replication, blockSize);
        this.getEditLog().logSync();
        if (auditLog.isInfoEnabled()) {
            DFSFileInfo stat = this.dir.getFileInfo(src);
            auditLog.info((Object)String.format(AUDIT_FORMAT, UserGroupInformation.getCurrentUGI(), Server.getRemoteIp(), "create", src, stat.getOwner() + ':' + stat.getGroup() + ':' + stat.getPermission()));
        }
    }

    private synchronized void startFileInternal(String src, PermissionStatus permissions, String holder, String clientMachine, boolean overwrite, short replication, long blockSize) throws IOException {
        NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.startFile: file " + src + " for " + holder + " at " + clientMachine));
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot create file" + src, this.safeMode);
        }
        if (!FSNamesystem.isValidName(src)) {
            throw new IOException("Invalid file name: " + src);
        }
        if (this.isPermissionEnabled) {
            if (overwrite && this.dir.exists(src)) {
                this.checkPathAccess(src, FsAction.WRITE);
            } else {
                this.checkAncestorAccess(src, FsAction.WRITE);
            }
        }
        try {
            INodeFile myFile = this.dir.getFileINode(src);
            if (myFile != null && myFile.isUnderConstruction()) {
                INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)myFile;
                LeaseManager.Lease lease = this.leaseManager.getLease(new StringBytesWritable(holder));
                if (lease != null) {
                    throw new AlreadyBeingCreatedException("failed to create file " + src + " for " + holder + " on client " + clientMachine + " because current leaseholder is trying to recreate file.");
                }
                lease = this.leaseManager.getLease(pendingFile.clientName);
                if (lease == null) {
                    throw new AlreadyBeingCreatedException("failed to create file " + src + " for " + holder + " on client " + clientMachine + " because pendingCreates is non-null but no leases found.");
                }
                if (lease.expiredSoftLimit()) {
                    LOG.info((Object)("startFile: recover lease " + lease + ", src=" + src));
                    this.internalReleaseLease(lease, src);
                }
                throw new AlreadyBeingCreatedException("failed to create file " + src + " for " + holder + " on client " + clientMachine + ", because this file is already being created by " + pendingFile.getClientName() + " on " + pendingFile.getClientMachine());
            }
            try {
                this.verifyReplication(src, replication, clientMachine);
            }
            catch (IOException e) {
                throw new IOException("failed to create " + e.getMessage());
            }
            if (!this.dir.isValidToCreate(src)) {
                if (overwrite) {
                    this.delete(src);
                } else {
                    throw new IOException("failed to create file " + src + " on client " + clientMachine + " either because the filename is invalid or the file exists");
                }
            }
            DatanodeDescriptor clientNode = this.host2DataNodeMap.getDatanodeByHost(clientMachine);
            this.checkFsObjectLimit();
            long genstamp = this.nextGenerationStamp();
            INodeFileUnderConstruction newNode = this.dir.addFile(src, permissions, replication, blockSize, holder, clientMachine, clientNode, genstamp);
            if (newNode == null) {
                throw new IOException("DIR* NameSystem.startFile: Unable to add file to namespace.");
            }
            this.leaseManager.addLease(newNode.clientName, src);
        }
        catch (IOException ie) {
            NameNode.stateChangeLog.warn((Object)("DIR* NameSystem.startFile: " + ie.getMessage()));
            throw ie;
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.startFile: add " + src + " to namespace for " + holder));
        }
    }

    void appendFileInternal(String src, String holder, String clientMachine) throws IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.appendFile: file " + src + " for " + holder + " at " + clientMachine));
        }
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot append file" + src, this.safeMode);
        }
        if (!FSNamesystem.isValidName(src)) {
            throw new IOException("Invalid file name: " + src);
        }
        if (this.isPermissionEnabled) {
            this.checkPathAccess(src, FsAction.WRITE);
        }
        try {
            INodeFile f = this.dir.getFileINode(src);
            DatanodeDescriptor clientNode = this.host2DataNodeMap.getDatanodeByHost(clientMachine);
            INodeFileUnderConstruction newnode = f.toINodeFileUnderConstruction(holder, clientMachine, clientNode);
            this.dir.replaceNode(src, f, newnode);
            this.leaseManager.addLease(newnode.clientName, src);
        }
        catch (IOException ie) {
            NameNode.stateChangeLog.warn((Object)"DIR* NameSystem.appendFile: ", (Throwable)ie);
            throw ie;
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.appendFile: add " + src + " to namespace for " + holder));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocatedBlock getAdditionalBlock(String src, String clientName) throws IOException {
        short replication;
        long blockSize;
        long fileLength;
        DatanodeDescriptor clientNode = null;
        Block newBlock = null;
        NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.getAdditionalBlock: file " + src + " for " + clientName));
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot add block to " + src, this.safeMode);
            }
            this.checkFsObjectLimit();
            INodeFileUnderConstruction pendingFile = this.checkLease(src, clientName);
            if (!this.checkFileProgress(pendingFile, false)) {
                throw new NotReplicatedYetException("Not replicated yet:" + src);
            }
            fileLength = pendingFile.computeContentSummary().getLength();
            blockSize = pendingFile.getPreferredBlockSize();
            clientNode = pendingFile.getClientNode();
            replication = pendingFile.getReplication();
        }
        DatanodeInfo[] targets = this.replicator.chooseTarget(replication, clientNode, null, blockSize);
        if (targets.length < this.minReplication) {
            throw new IOException("File " + src + " could only be replicated to " + targets.length + " nodes, instead of " + this.minReplication);
        }
        FSNamesystem fSNamesystem2 = this;
        synchronized (fSNamesystem2) {
            INodeFileUnderConstruction pendingFile = this.checkLease(src, clientName);
            if (!this.checkFileProgress(pendingFile, false)) {
                throw new NotReplicatedYetException("Not replicated yet:" + src);
            }
            newBlock = this.allocateBlock(src, pendingFile);
            pendingFile.setTargets((DatanodeDescriptor[])targets);
        }
        return new LocatedBlock(newBlock, targets, fileLength);
    }

    public synchronized boolean abandonBlock(Block b, String src, String holder) throws IOException {
        NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.abandonBlock: " + b + "of file " + src));
        INodeFileUnderConstruction file = this.checkLease(src, holder);
        this.dir.removeBlock(src, file, b);
        NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.abandonBlock: " + b + " is removed from pendingCreates"));
        return true;
    }

    private INodeFileUnderConstruction checkLease(String src, String holder) throws IOException {
        INodeFile file = this.dir.getFileINode(src);
        if (file == null) {
            LeaseManager.Lease lease = this.leaseManager.getLease(new StringBytesWritable(holder));
            throw new LeaseExpiredException("No lease on " + src + " File does not exist. " + (lease != null ? lease.toString() : "Holder " + holder + " does not have any open files."));
        }
        if (!file.isUnderConstruction()) {
            LeaseManager.Lease lease = this.leaseManager.getLease(new StringBytesWritable(holder));
            throw new LeaseExpiredException("No lease on " + src + " File is not open for writing. " + (lease != null ? lease.toString() : "Holder " + holder + " does not have any open files."));
        }
        INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)file;
        if (holder != null && !pendingFile.getClientName().equals(holder)) {
            throw new LeaseExpiredException("Lease mismatch on " + src + " owned by " + pendingFile.getClientName() + " but is accessed by " + holder);
        }
        return pendingFile;
    }

    public int completeFile(String src, String holder) throws IOException {
        int status = this.completeFileInternal(src, holder);
        this.getEditLog().logSync();
        return status;
    }

    private synchronized int completeFileInternal(String src, String holder) throws IOException {
        NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.completeFile: " + src + " for " + holder));
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot complete file " + src, this.safeMode);
        }
        INodeFile iFile = this.dir.getFileINode(src);
        INodeFileUnderConstruction pendingFile = null;
        Block[] fileBlocks = null;
        if (iFile != null && iFile.isUnderConstruction()) {
            pendingFile = (INodeFileUnderConstruction)iFile;
            fileBlocks = this.dir.getFileBlocks(src);
        }
        if (fileBlocks == null) {
            NameNode.stateChangeLog.warn((Object)("DIR* NameSystem.completeFile: failed to complete " + src + " because dir.getFileBlocks() is null " + " and pendingFile is " + (pendingFile == null ? "null" : "from " + pendingFile.getClientMachine())));
            return 0;
        }
        if (!this.checkFileProgress(pendingFile, true)) {
            return 1;
        }
        this.finalizeINodeFileUnderConstruction(src, pendingFile);
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.completeFile: " + src + " blocklist persisted"));
        }
        return 2;
    }

    private void checkReplicationFactor(INodeFile file) {
        short numExpectedReplicas = file.getReplication();
        BlocksMap.BlockInfo[] pendingBlocks = file.getBlocks();
        int nrBlocks = pendingBlocks.length;
        for (int i = 0; i < nrBlocks; ++i) {
            NumberReplicas number = this.countNodes(pendingBlocks[i]);
            if (number.liveReplicas() >= numExpectedReplicas) continue;
            this.neededReplications.add(pendingBlocks[i], number.liveReplicas(), number.decommissionedReplicas, numExpectedReplicas);
        }
    }

    private Block allocateBlock(String src, INode file) throws IOException {
        Block b = null;
        while (this.isValidBlock(b = new Block(randBlockId.nextLong(), 0L, this.getGenerationStamp()))) {
        }
        b = this.dir.addBlock(src, file, b);
        NameNode.stateChangeLog.info((Object)("BLOCK* NameSystem.allocateBlock: " + src + ". " + b));
        return b;
    }

    synchronized boolean checkFileProgress(INodeFile v, boolean checkall) {
        if (checkall) {
            for (BlocksMap.BlockInfo block : v.getBlocks()) {
                if (this.blocksMap.numNodes(block) >= this.minReplication) continue;
                return false;
            }
        } else {
            Block b = v.getPenultimateBlock();
            if (b != null && this.blocksMap.numNodes(b) < this.minReplication) {
                return false;
            }
        }
        return true;
    }

    private void addToInvalidates(Block b, DatanodeInfo n) {
        Collection<Block> invalidateSet = this.recentInvalidateSets.get(n.getStorageID());
        if (invalidateSet == null) {
            invalidateSet = new HashSet<Block>();
            this.recentInvalidateSets.put(n.getStorageID(), invalidateSet);
        }
        invalidateSet.add(b);
        NameNode.stateChangeLog.info((Object)("BLOCK* NameSystem.delete: " + b.getBlockName() + " is added to invalidSet of " + n.getName()));
    }

    private void addToInvalidates(Block b) {
        Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(b);
        while (it.hasNext()) {
            DatanodeDescriptor node = it.next();
            this.addToInvalidates(b, node);
        }
    }

    private synchronized void dumpRecentInvalidateSets(PrintWriter out) {
        int size = this.recentInvalidateSets.values().size();
        out.println("Metasave: Blocks waiting deletion from " + size + " datanodes.");
        if (size == 0) {
            return;
        }
        for (Map.Entry<String, Collection<Block>> entry : this.recentInvalidateSets.entrySet()) {
            Collection<Block> blocks = entry.getValue();
            if (blocks.size() <= 0) continue;
            out.println(this.datanodeMap.get(entry.getKey()).getName() + blocks);
        }
    }

    public synchronized void markBlockAsCorrupt(Block blk, DatanodeInfo dn) throws IOException {
        DatanodeDescriptor node = this.getDatanode(dn);
        if (node == null) {
            throw new IOException("Cannot mark block" + blk.getBlockName() + " as corrupt because datanode " + dn.getName() + " does not exist. ");
        }
        if (this.blocksMap.getINode(blk) == null) {
            NameNode.stateChangeLog.info((Object)("BLOCK NameSystem.markBlockAsCorrupt: block " + blk + " could not be marked " + "as corrupt as it does not exists in " + "blocksMap"));
        } else {
            this.corruptReplicas.addToCorruptReplicasMap(blk, node);
        }
    }

    public synchronized void invalidateBlock(Block blk, DatanodeInfo dn) throws IOException {
        NameNode.stateChangeLog.info((Object)("DIR* NameSystem.invalidateBlock: " + blk + " on " + dn.getName()));
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot invalidate block " + blk, this.safeMode);
        }
        DatanodeDescriptor node = this.getDatanode(dn);
        if (node == null) {
            throw new IOException("Cannot invalidate block " + blk + " because datanode " + dn.getName() + " does not exist.");
        }
        int count = this.countNodes(blk).liveReplicas();
        if (count > 1) {
            this.addToInvalidates(blk, dn);
            this.removeStoredBlock(blk, node);
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.invalidateBlocks: " + blk + " on " + dn.getName() + " listed for deletion."));
        } else {
            NameNode.stateChangeLog.info((Object)("BLOCK* NameSystem.invalidateBlocks: " + blk + " on " + dn.getName() + " is the only copy and was not deleted."));
        }
    }

    public boolean renameTo(String src, String dst) throws IOException {
        boolean status = this.renameToInternal(src, dst);
        this.getEditLog().logSync();
        return status;
    }

    private synchronized boolean renameToInternal(String src, String dst) throws IOException {
        NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.renameTo: " + src + " to " + dst));
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot rename " + src, this.safeMode);
        }
        if (!FSNamesystem.isValidName(dst)) {
            throw new IOException("Invalid name: " + dst);
        }
        if (this.isPermissionEnabled) {
            String actualdst = this.dir.isDir(dst) ? dst + "/" + new Path(src).getName() : dst;
            this.checkParentAccess(src, FsAction.WRITE);
            this.checkAncestorAccess(actualdst, FsAction.WRITE);
        }
        if (this.dir.renameTo(src, dst)) {
            this.changeLease(src, dst);
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean delete(String src) throws IOException {
        return this.delete(src, true);
    }

    public boolean delete(String src, boolean recursive) throws IOException {
        if (!recursive && !this.dir.isDirEmpty(src)) {
            throw new IOException(src + " is non empty");
        }
        boolean status = this.deleteInternal(src, true, true);
        this.getEditLog().logSync();
        if (auditLog.isInfoEnabled()) {
            auditLog.info((Object)String.format(AUDIT_FORMAT, UserGroupInformation.getCurrentUGI(), Server.getRemoteIp(), "delete", src, null));
        }
        return status;
    }

    boolean deleteInSafeMode(String src) throws IOException {
        boolean status = this.deleteInternal(src, false, false);
        this.getEditLog().logSync();
        return status;
    }

    synchronized boolean deleteInternal(String src, boolean enforceSafeMode, boolean enforcePermission) throws IOException {
        ArrayList<Block> deletedBlocks;
        INode old;
        NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.delete: " + src));
        if (enforceSafeMode && this.isInSafeMode()) {
            throw new SafeModeException("Cannot delete " + src, this.safeMode);
        }
        if (enforcePermission && this.isPermissionEnabled) {
            this.checkPermission(src, false, null, FsAction.WRITE, null, FsAction.ALL);
        }
        if ((old = this.dir.delete(src, deletedBlocks = new ArrayList<Block>())) == null) {
            return false;
        }
        for (Block b : deletedBlocks) {
            this.addToInvalidates(b);
        }
        if (old.isUnderConstruction()) {
            INodeFileUnderConstruction cons = (INodeFileUnderConstruction)old;
            this.leaseManager.removeLease(cons.clientName, src);
        }
        return true;
    }

    DFSFileInfo getFileInfo(String src) throws IOException {
        if (this.isPermissionEnabled) {
            this.checkTraverse(src);
        }
        return this.dir.getFileInfo(src);
    }

    static boolean isValidName(String src) {
        if (!src.startsWith("/")) {
            return false;
        }
        StringTokenizer tokens = new StringTokenizer(src, "/");
        while (tokens.hasMoreTokens()) {
            String element = tokens.nextToken();
            if (!element.equals("..") && !element.equals(".") && element.indexOf(":") < 0 && element.indexOf("/") < 0) continue;
            return false;
        }
        return true;
    }

    public boolean mkdirs(String src, PermissionStatus permissions) throws IOException {
        boolean status = this.mkdirsInternal(src, permissions);
        this.getEditLog().logSync();
        if (auditLog.isInfoEnabled()) {
            DFSFileInfo stat = this.dir.getFileInfo(src);
            auditLog.info((Object)String.format(AUDIT_FORMAT, UserGroupInformation.getCurrentUGI(), Server.getRemoteIp(), "mkdirs", src, stat.getOwner() + ':' + stat.getGroup() + ':' + stat.getPermission()));
        }
        return status;
    }

    private synchronized boolean mkdirsInternal(String src, PermissionStatus permissions) throws IOException {
        NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.mkdirs: " + src));
        if (this.isPermissionEnabled) {
            this.checkTraverse(src);
        }
        if (this.dir.isDir(src)) {
            return true;
        }
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot create directory " + src, this.safeMode);
        }
        if (!FSNamesystem.isValidName(src)) {
            throw new IOException("Invalid directory name: " + src);
        }
        if (this.isPermissionEnabled) {
            this.checkAncestorAccess(src, FsAction.WRITE);
        }
        this.checkFsObjectLimit();
        if (!this.dir.mkdirs(src, permissions, false, FSNamesystem.now())) {
            throw new IOException("Invalid directory name: " + src);
        }
        return true;
    }

    ContentSummary getContentSummary(String src) throws IOException {
        if (this.isPermissionEnabled) {
            this.checkPermission(src, false, null, null, null, FsAction.READ_EXECUTE);
        }
        return this.dir.getContentSummary(src);
    }

    void setQuota(String path, long quota) throws IOException {
        if (this.isPermissionEnabled) {
            this.checkSuperuserPrivilege();
        }
        this.dir.setQuota(path, quota);
        this.getEditLog().logSync();
    }

    void clearQuota(String path) throws IOException {
        if (this.isPermissionEnabled) {
            this.checkSuperuserPrivilege();
        }
        this.dir.clearQuota(path);
        this.getEditLog().logSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fsync(String src, String clientName) throws IOException {
        NameNode.stateChangeLog.info((Object)("BLOCK* NameSystem.fsync: file " + src + " for " + clientName));
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot fsync file " + src, this.safeMode);
            }
            INodeFileUnderConstruction pendingFile = this.checkLease(src, clientName);
            this.dir.persistBlocks(src, pendingFile);
        }
    }

    void internalReleaseLease(LeaseManager.Lease lease, String src) throws IOException {
        INodeFileUnderConstruction pendingFile;
        LOG.info((Object)("Recovering lease=" + lease + ", src=" + src));
        INodeFile iFile = this.dir.getFileINode(src);
        if (iFile == null) {
            NameNode.stateChangeLog.warn((Object)("DIR* NameSystem.internalReleaseCreate: attempt to release a create lock on " + src + " file does not exist."));
            return;
        }
        if (!iFile.isUnderConstruction()) {
            NameNode.stateChangeLog.warn((Object)("DIR* NameSystem.internalReleaseCreate: attempt to release a create lock on " + src + " but file is already closed."));
            return;
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.internalReleaseCreate: " + src + " does not being written in " + lease));
        }
        if ((pendingFile = (INodeFileUnderConstruction)iFile).getTargets() == null || pendingFile.getTargets().length == 0) {
            if (pendingFile.getBlocks().length == 0) {
                this.finalizeINodeFileUnderConstruction(src, pendingFile);
                NameNode.stateChangeLog.warn((Object)"BLOCK* internalReleaseLease: No blocks found, lease removed.");
                return;
            }
            BlocksMap.BlockInfo[] blocks = pendingFile.getBlocks();
            BlocksMap.BlockInfo last = blocks[blocks.length - 1];
            DatanodeDescriptor[] targets = new DatanodeDescriptor[this.blocksMap.numNodes(last)];
            Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(last);
            int i = 0;
            while (it != null && it.hasNext()) {
                targets[i] = it.next();
                ++i;
            }
            pendingFile.setTargets(targets);
        }
        pendingFile.assignPrimaryDatanode();
        this.leaseManager.renewLease(lease);
    }

    private void finalizeINodeFileUnderConstruction(String src, INodeFileUnderConstruction pendingFile) throws IOException {
        this.leaseManager.removeLease(pendingFile.clientName, src);
        INodeFile newFile = pendingFile.convertToInodeFile();
        this.dir.replaceNode(src, pendingFile, newFile);
        this.dir.closeFile(src, newFile);
        this.checkReplicationFactor(newFile);
    }

    synchronized void commitBlockSynchronization(Block lastblock, long newgenerationstamp, long newlength, boolean closeFile, boolean deleteblock, DatanodeID[] newtargets) throws IOException {
        LOG.info((Object)("commitBlockSynchronization(lastblock=" + lastblock + ", newgenerationstamp=" + newgenerationstamp + ", newlength=" + newlength + ", newtargets=" + Arrays.asList(newtargets) + ")"));
        BlocksMap.BlockInfo oldblockinfo = this.blocksMap.getStoredBlock(lastblock);
        if (oldblockinfo == null) {
            throw new IOException("Block (=" + lastblock + ") not found");
        }
        INodeFile iFile = oldblockinfo.getINode();
        if (!iFile.isUnderConstruction()) {
            throw new IOException("Unexpected block (=" + lastblock + ") since the file (=" + iFile.getLocalName() + ") is not under construction");
        }
        INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)iFile;
        this.blocksMap.remove(lastblock);
        if (deleteblock) {
            pendingFile.removeBlock(lastblock);
        } else {
            lastblock.set(lastblock.blkid, newlength, newgenerationstamp);
            BlocksMap.BlockInfo newblockinfo = this.blocksMap.addINode(lastblock, pendingFile);
            DatanodeDescriptor[] descriptors = null;
            if (newtargets.length > 0) {
                descriptors = new DatanodeDescriptor[newtargets.length];
                for (int i = 0; i < newtargets.length; ++i) {
                    descriptors[i] = this.getDatanode(newtargets[i]);
                    descriptors[i].addBlock(newblockinfo);
                }
            }
            pendingFile.setLastBlock(newblockinfo, descriptors);
        }
        String src = this.leaseManager.findPath(pendingFile);
        if (!closeFile) {
            this.dir.persistBlocks(src, pendingFile);
            this.getEditLog().logSync();
            LOG.info((Object)("commitBlockSynchronization(lastblock=" + lastblock + ", newgenerationstamp=" + newgenerationstamp + ", newlength=" + newlength + ", newtargets=" + Arrays.asList(newtargets) + ") successful"));
            return;
        }
        this.finalizeINodeFileUnderConstruction(src, pendingFile);
        this.getEditLog().logSync();
        LOG.info((Object)("commitBlockSynchronization(newblock=" + lastblock + ", newgenerationstamp=" + newgenerationstamp + ", newlength=" + newlength + ", newtargets=" + Arrays.asList(newtargets) + ") successful"));
    }

    void renewLease(String holder) throws IOException {
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot renew lease for " + holder, this.safeMode);
        }
        this.leaseManager.renewLease(holder);
    }

    public DFSFileInfo[] getListing(String src) throws IOException {
        if (this.isPermissionEnabled) {
            if (this.dir.isDir(src)) {
                this.checkPathAccess(src, FsAction.READ_EXECUTE);
            } else {
                this.checkTraverse(src);
            }
        }
        if (auditLog.isInfoEnabled()) {
            auditLog.info((Object)String.format(AUDIT_FORMAT, UserGroupInformation.getCurrentUGI(), Server.getRemoteIp(), "listStatus", src, null));
        }
        return this.dir.getListing(src);
    }

    public void addToResolutionQueue(DatanodeDescriptor d) {
        while (!this.resolutionQueue.add(d)) {
            LOG.warn((Object)"Couldn't add to the Resolution queue now. Will try again");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    synchronized boolean blockReportProcessed(DatanodeRegistration nodeReg) throws IOException {
        return this.getDatanode(nodeReg).getBlockReportProcessed();
    }

    synchronized boolean isResolved(DatanodeRegistration dnReg) {
        try {
            return !this.getDatanode(dnReg).getNetworkLocation().equals("");
        }
        catch (IOException ie) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerDatanode(DatanodeRegistration nodeReg) throws IOException {
        if (!this.verifyNodeRegistration(nodeReg)) {
            throw new DisallowedDatanodeException(nodeReg);
        }
        String dnAddress = Server.getRemoteAddress();
        if (dnAddress == null) {
            dnAddress = nodeReg.getHost();
        }
        String hostName = nodeReg.getHost();
        DatanodeID dnReg = new DatanodeID(dnAddress + ":" + nodeReg.getPort(), nodeReg.getStorageID(), nodeReg.getInfoPort(), nodeReg.getIpcPort());
        nodeReg.updateRegInfo(dnReg);
        NameNode.stateChangeLog.info((Object)("BLOCK* NameSystem.registerDatanode: node registration from " + nodeReg.getName() + " storage " + nodeReg.getStorageID()));
        DatanodeDescriptor nodeS = this.datanodeMap.get(nodeReg.getStorageID());
        DatanodeDescriptor nodeN = this.host2DataNodeMap.getDatanodeByName(nodeReg.getName());
        if (nodeN != null && nodeN != nodeS) {
            NameNode.LOG.info((Object)("BLOCK* NameSystem.registerDatanode: node from name: " + nodeN.getName()));
            this.removeDatanode(nodeN);
            this.wipeDatanode(nodeN);
            nodeN = null;
        }
        if (nodeS != null) {
            if (nodeN == nodeS) {
                NameNode.stateChangeLog.debug((Object)"BLOCK* NameSystem.registerDatanode: node restarted.");
            } else {
                NameNode.stateChangeLog.info((Object)("BLOCK* NameSystem.registerDatanode: node " + nodeS.getName() + " is replaced by " + nodeReg.getName() + " with the same storageID " + nodeReg.getStorageID()));
            }
            this.clusterMap.remove(nodeS);
            nodeS.updateRegInfo(nodeReg);
            nodeS.setHostName(hostName);
            nodeS.setNetworkLocation("");
            nodeS.setBlockReportProcessed(false);
            this.addToResolutionQueue(nodeS);
            ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
            synchronized (arrayList) {
                if (!this.heartbeats.contains(nodeS)) {
                    this.heartbeats.add(nodeS);
                    nodeS.updateHeartbeat(0L, 0L, 0L, 0);
                    nodeS.isAlive = true;
                }
            }
            return;
        }
        if (nodeReg.getStorageID().equals("")) {
            nodeReg.storageID = this.newStorageID();
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.registerDatanode: new storageID " + nodeReg.getStorageID() + " assigned."));
        }
        DatanodeDescriptor nodeDescr = new DatanodeDescriptor(nodeReg, "", hostName);
        this.unprotectedAddDatanode(nodeDescr);
        this.addToResolutionQueue(nodeDescr);
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            this.heartbeats.add(nodeDescr);
            nodeDescr.isAlive = true;
        }
    }

    public String getRegistrationID() {
        return Storage.getRegistrationID(this.dir.fsImage);
    }

    private String newStorageID() {
        String newID = null;
        while (newID == null) {
            newID = "DS" + Integer.toString(this.r.nextInt());
            if (this.datanodeMap.get(newID) == null) continue;
            newID = null;
        }
        return newID;
    }

    private boolean isDatanodeDead(DatanodeDescriptor node) {
        return node.getLastUpdate() < FSNamesystem.now() - this.heartbeatExpireInterval;
    }

    private void setDatanodeDead(DatanodeDescriptor node) throws IOException {
        node.setLastUpdate(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatanodeCommand handleHeartbeat(DatanodeRegistration nodeReg, long capacity, long dfsUsed, long remaining, int xceiverCount, int xmitsInProgress) throws IOException {
        DatanodeCommand cmd = null;
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            Map<String, DatanodeDescriptor> map = this.datanodeMap;
            synchronized (map) {
                DatanodeDescriptor nodeinfo = null;
                try {
                    nodeinfo = this.getDatanode(nodeReg);
                }
                catch (UnregisteredDatanodeException e) {
                    return DatanodeCommand.REGISTER;
                }
                if (nodeinfo != null && this.shouldNodeShutdown(nodeinfo)) {
                    this.setDatanodeDead(nodeinfo);
                    throw new DisallowedDatanodeException(nodeinfo);
                }
                if (nodeinfo == null || !nodeinfo.isAlive) {
                    return DatanodeCommand.REGISTER;
                }
                this.updateStats(nodeinfo, false);
                nodeinfo.updateHeartbeat(capacity, dfsUsed, remaining, xceiverCount);
                this.updateStats(nodeinfo, true);
                if (cmd == null) {
                    cmd = nodeinfo.getLeaseRecoveryCommand(Integer.MAX_VALUE);
                }
                if (cmd == null) {
                    cmd = nodeinfo.getReplicationCommand(this.maxReplicationStreams - xmitsInProgress);
                }
                if (cmd == null) {
                    cmd = nodeinfo.getInvalidateBlocks(this.blockInvalidateLimit);
                }
            }
        }
        if (!this.blockReportProcessed(nodeReg)) {
            assert (cmd == null);
            if (this.isResolved(nodeReg)) {
                return DatanodeCommand.BLOCKREPORT;
            }
        }
        if (cmd == null) {
            cmd = this.getDistributedUpgradeCommand();
        }
        return cmd;
    }

    private void updateStats(DatanodeDescriptor node, boolean isAdded) {
        assert (Thread.holdsLock(this.heartbeats));
        if (isAdded) {
            this.capacityTotal += node.getCapacity();
            this.capacityUsed += node.getDfsUsed();
            this.capacityRemaining += node.getRemaining();
            this.totalLoad += node.getXceiverCount();
        } else {
            this.capacityTotal -= node.getCapacity();
            this.capacityUsed -= node.getDfsUsed();
            this.capacityRemaining -= node.getRemaining();
            this.totalLoad -= node.getXceiverCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int computeDatanodeWork() throws IOException {
        int workFound = 0;
        int blocksToProcess = 0;
        int nodesToProcess = 0;
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            blocksToProcess = (int)((float)this.heartbeats.size() * 2.0f);
            nodesToProcess = (int)Math.ceil((double)this.heartbeats.size() * 32.0 / 100.0);
        }
        workFound = this.computeReplicationWork(blocksToProcess);
        this.pendingReplicationBlocksCount = this.pendingReplications.size();
        this.underReplicatedBlocksCount = this.neededReplications.size();
        this.scheduledReplicationBlocksCount = workFound;
        if (workFound == 0) {
            workFound = this.computeInvalidateWork(nodesToProcess);
        }
        return workFound;
    }

    private int computeInvalidateWork(int nodesToProcess) {
        int work;
        int blockCnt = 0;
        for (int nodeCnt = 0; nodeCnt < nodesToProcess && (work = this.invalidateWorkForOneNode()) != 0; ++nodeCnt) {
            blockCnt += work;
        }
        return blockCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int computeReplicationWork(int blocksToProcess) throws IOException {
        int scheduledReplicationCount = 0;
        if (this.isInSafeMode()) {
            return scheduledReplicationCount;
        }
        UnderReplicatedBlocks underReplicatedBlocks = this.neededReplications;
        synchronized (underReplicatedBlocks) {
            blocksToProcess = Math.min(blocksToProcess, this.neededReplications.size());
            if (blocksToProcess == 0) {
                return scheduledReplicationCount;
            }
            Iterator<Block> neededReplicationsIterator = this.neededReplications.iterator();
            for (int i = 0; i < this.replIndex && neededReplicationsIterator.hasNext(); ++i) {
                neededReplicationsIterator.next();
            }
            int blkCnt = 0;
            while (blkCnt < blocksToProcess) {
                Block block;
                INodeFile fileINode;
                if (!neededReplicationsIterator.hasNext()) {
                    this.replIndex = 0;
                    if (blkCnt >= (blocksToProcess = Math.min(blocksToProcess, this.neededReplications.size()))) break;
                    neededReplicationsIterator = this.neededReplications.iterator();
                    assert (neededReplicationsIterator.hasNext()) : "neededReplications should not be empty.";
                }
                if ((fileINode = this.blocksMap.getINode(block = neededReplicationsIterator.next())) == null) {
                    neededReplicationsIterator.remove();
                    --this.replIndex;
                } else {
                    short requiredReplication = fileINode.getReplication();
                    ArrayList<DatanodeDescriptor> containingNodes = new ArrayList<DatanodeDescriptor>();
                    NumberReplicas numReplicas = new NumberReplicas();
                    DatanodeDescriptor srcNode = this.chooseSourceDatanode(block, containingNodes, numReplicas);
                    if (srcNode != null) {
                        int numEffectiveReplicas = numReplicas.liveReplicas() + this.pendingReplications.getNumReplicas(block);
                        if (numEffectiveReplicas >= requiredReplication) {
                            neededReplicationsIterator.remove();
                            --this.replIndex;
                            NameNode.stateChangeLog.info((Object)("BLOCK* Removing block " + block + " from neededReplications as it does not belong to any file."));
                        } else {
                            int maxTargets = this.maxReplicationStreams - srcNode.getNumberOfBlocksToBeReplicated();
                            assert (maxTargets > 0) : "Datanode " + srcNode.getName() + " should have not been selected as a source for replication.";
                            DatanodeDescriptor[] targets = this.replicator.chooseTarget(Math.min(requiredReplication - numEffectiveReplicas, maxTargets), srcNode, containingNodes, null, block.getNumBytes());
                            if (targets.length != 0) {
                                srcNode.addBlockToBeReplicated(block, targets);
                                ++scheduledReplicationCount;
                                if (numEffectiveReplicas + targets.length >= requiredReplication) {
                                    neededReplicationsIterator.remove();
                                    --this.replIndex;
                                    this.pendingReplications.add(block, targets.length);
                                    NameNode.stateChangeLog.debug((Object)("BLOCK* block " + block + " is moved from neededReplications to pendingReplications"));
                                }
                                if (NameNode.stateChangeLog.isInfoEnabled()) {
                                    StringBuffer targetList = new StringBuffer("datanode(s)");
                                    for (int k = 0; k < targets.length; ++k) {
                                        targetList.append(' ');
                                        targetList.append(targets[k].getName());
                                    }
                                    NameNode.stateChangeLog.info((Object)("BLOCK* ask " + srcNode.getName() + " to replicate " + block + " to " + targetList));
                                    NameNode.stateChangeLog.debug((Object)("BLOCK* neededReplications = " + this.neededReplications.size() + " pendingReplications = " + this.pendingReplications.size()));
                                }
                            }
                        }
                    }
                }
                ++blkCnt;
                ++this.replIndex;
            }
        }
        return scheduledReplicationCount;
    }

    private DatanodeDescriptor chooseSourceDatanode(Block block, List<DatanodeDescriptor> containingNodes, NumberReplicas numReplicas) {
        containingNodes.clear();
        DatanodeDescriptor srcNode = null;
        int live = 0;
        int decommissioned = 0;
        int corrupt = 0;
        Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(block);
        while (it.hasNext()) {
            Collection<Block> excessBlocks;
            DatanodeDescriptor node = it.next();
            Collection<DatanodeDescriptor> nodes = this.corruptReplicas.getNodes(block);
            if (nodes != null && nodes.contains(node)) {
                ++corrupt;
            } else if (!node.isDecommissionInProgress() && !node.isDecommissioned()) {
                ++live;
            } else {
                ++decommissioned;
            }
            containingNodes.add(node);
            if (nodes != null && nodes.contains(node) || node.getNumberOfBlocksToBeReplicated() >= this.maxReplicationStreams || (excessBlocks = this.excessReplicateMap.get(node.getStorageID())) != null && excessBlocks.contains(block) || node.isDecommissioned()) continue;
            if (node.isDecommissionInProgress() || srcNode == null) {
                srcNode = node;
                continue;
            }
            if (srcNode.isDecommissionInProgress() || !this.r.nextBoolean()) continue;
            srcNode = node;
        }
        if (numReplicas != null) {
            numReplicas.initialize(live, decommissioned, corrupt);
        }
        return srcNode;
    }

    private synchronized int invalidateWorkForOneNode() {
        if (this.isInSafeMode()) {
            return 0;
        }
        if (this.recentInvalidateSets.isEmpty()) {
            return 0;
        }
        String firstNodeId = this.recentInvalidateSets.keySet().iterator().next();
        assert (firstNodeId != null);
        DatanodeDescriptor dn = this.datanodeMap.get(firstNodeId);
        Collection<Block> invalidateSet = this.recentInvalidateSets.remove(firstNodeId);
        if (invalidateSet == null || dn == null) {
            return 0;
        }
        ArrayList<Block> blocksToInvalidate = new ArrayList<Block>(this.blockInvalidateLimit);
        Iterator<Block> it = invalidateSet.iterator();
        for (int blkCount = 0; blkCount < this.blockInvalidateLimit && it.hasNext(); ++blkCount) {
            blocksToInvalidate.add(it.next());
            it.remove();
        }
        if (it.hasNext()) {
            this.recentInvalidateSets.put(firstNodeId, invalidateSet);
        }
        dn.addBlocksToBeInvalidated(blocksToInvalidate);
        if (NameNode.stateChangeLog.isInfoEnabled()) {
            StringBuffer blockList = new StringBuffer();
            for (Block blk : blocksToInvalidate) {
                blockList.append(' ');
                blockList.append(blk);
            }
            NameNode.stateChangeLog.info((Object)("BLOCK* ask " + dn.getName() + " to delete " + blockList));
        }
        return blocksToInvalidate.size();
    }

    void setNodeReplicationLimit(int limit) {
        this.maxReplicationStreams = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processPendingReplications() {
        Block[] timedOutItems = this.pendingReplications.getTimedOutBlocks();
        if (timedOutItems != null) {
            FSNamesystem fSNamesystem = this;
            synchronized (fSNamesystem) {
                for (int i = 0; i < timedOutItems.length; ++i) {
                    NumberReplicas num = this.countNodes(timedOutItems[i]);
                    this.neededReplications.add(timedOutItems[i], num.liveReplicas(), num.decommissionedReplicas(), this.getReplication(timedOutItems[i]));
                }
            }
        }
    }

    public synchronized void removeDatanode(DatanodeID nodeID) throws IOException {
        DatanodeDescriptor nodeInfo = this.getDatanode(nodeID);
        if (nodeInfo != null) {
            this.removeDatanode(nodeInfo);
        } else {
            NameNode.stateChangeLog.warn((Object)("BLOCK* NameSystem.removeDatanode: " + nodeID.getName() + " does not exist"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDatanode(DatanodeDescriptor nodeInfo) {
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            if (nodeInfo.isAlive) {
                this.updateStats(nodeInfo, false);
                this.heartbeats.remove(nodeInfo);
                nodeInfo.isAlive = false;
            }
        }
        Iterator<Block> it = nodeInfo.getBlockIterator();
        while (it.hasNext()) {
            this.removeStoredBlock(it.next(), nodeInfo);
        }
        this.unprotectedRemoveDatanode(nodeInfo);
        this.clusterMap.remove(nodeInfo);
    }

    void unprotectedRemoveDatanode(DatanodeDescriptor nodeDescr) {
        nodeDescr.resetBlocks();
        NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.unprotectedRemoveDatanode: " + nodeDescr.getName() + " is out of service now."));
    }

    void unprotectedAddDatanode(DatanodeDescriptor nodeDescr) {
        this.host2DataNodeMap.remove(this.datanodeMap.put(nodeDescr.getStorageID(), nodeDescr));
        this.host2DataNodeMap.add(nodeDescr);
        NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.unprotectedAddDatanode: node " + nodeDescr.getName() + " is added to datanodeMap."));
    }

    void wipeDatanode(DatanodeID nodeID) throws IOException {
        String key = nodeID.getStorageID();
        this.host2DataNodeMap.remove(this.datanodeMap.remove(key));
        NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.wipeDatanode: " + nodeID.getName() + " storage " + key + " is removed from datanodeMap."));
    }

    FSImage getFSImage() {
        return this.dir.fsImage;
    }

    FSEditLog getEditLog() {
        return this.getFSImage().getEditLog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void heartbeatCheck() {
        boolean allAlive = false;
        while (!allAlive) {
            boolean foundDead = false;
            DatanodeDescriptor nodeID = null;
            Object object = this.heartbeats;
            synchronized (object) {
                for (DatanodeDescriptor nodeInfo : this.heartbeats) {
                    if (!this.isDatanodeDead(nodeInfo)) continue;
                    foundDead = true;
                    nodeID = nodeInfo;
                    break;
                }
            }
            if (foundDead) {
                object = this;
                synchronized (object) {
                    ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
                    synchronized (arrayList) {
                        Map<String, DatanodeDescriptor> map = this.datanodeMap;
                        synchronized (map) {
                            DatanodeDescriptor nodeInfo = null;
                            try {
                                nodeInfo = this.getDatanode(nodeID);
                            }
                            catch (IOException e) {
                                nodeInfo = null;
                            }
                            if (nodeInfo != null && this.isDatanodeDead(nodeInfo)) {
                                NameNode.stateChangeLog.info((Object)("BLOCK* NameSystem.heartbeatCheck: lost heartbeat from " + nodeInfo.getName()));
                                this.removeDatanode(nodeInfo);
                            }
                        }
                    }
                }
            }
            allAlive = !foundDead;
        }
    }

    public synchronized Block[] processReport(DatanodeID nodeID, BlockListAsLongs newReport) throws IOException {
        DatanodeDescriptor node;
        long startTime = FSNamesystem.now();
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.processReport: from " + nodeID.getName() + " " + newReport.getNumberOfBlocks() + " blocks"));
        }
        if ((node = this.getDatanode(nodeID)) == null) {
            throw new IOException("ProcessReport from unregisterted node: " + nodeID.getName());
        }
        if (this.shouldNodeShutdown(node)) {
            this.setDatanodeDead(node);
            throw new DisallowedDatanodeException(node);
        }
        if (node.getNetworkLocation().equals("")) {
            LOG.info((Object)("Ignoring block report from " + nodeID.getName() + " because rack location for this datanode is still to be resolved."));
            return null;
        }
        node.setBlockReportProcessed(true);
        LinkedList<Block> toAdd = new LinkedList<Block>();
        LinkedList<Block> toRemove = new LinkedList<Block>();
        node.reportDiff(this.blocksMap, newReport, toAdd, toRemove);
        for (Block b : toRemove) {
            this.removeStoredBlock(b, node);
        }
        for (Block b : toAdd) {
            this.addStoredBlock(b, node, null);
        }
        ArrayList<Block> obsolete = new ArrayList<Block>();
        Iterator<Block> it = node.getBlockIterator();
        while (it.hasNext()) {
            Block b = it.next();
            if (this.isValidBlock(b)) continue;
            if (obsolete.size() > this.blockInvalidateLimit) {
                this.addToInvalidates(b, node);
            } else {
                obsolete.add(b);
            }
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.processReport: ask " + nodeID.getName() + " to delete " + b));
        }
        NameNode.getNameNodeMetrics().blockReport.inc((int)(FSNamesystem.now() - startTime));
        return obsolete.toArray(new Block[obsolete.size()]);
    }

    synchronized Block addStoredBlock(Block block, DatanodeDescriptor node, DatanodeDescriptor delNodeHint) {
        int corruptReplicasCount;
        BlocksMap.BlockInfo storedBlock = this.blocksMap.getStoredBlock(block);
        INodeFile fileINode = null;
        boolean added = false;
        if (storedBlock == null) {
            added = this.blocksMap.addNode(block, node, this.defaultReplication);
            storedBlock = this.blocksMap.getStoredBlock(block);
        } else {
            added = node.addBlock(storedBlock);
        }
        assert (storedBlock != null) : "Block must be stored by now";
        fileINode = storedBlock.getINode();
        if (block != storedBlock) {
            if (block.getNumBytes() > 0L) {
                long cursize = storedBlock.getNumBytes();
                if (cursize == 0L) {
                    storedBlock.setNumBytes(block.getNumBytes());
                } else if (cursize != block.getNumBytes()) {
                    LOG.warn((Object)("Inconsistent size for block " + block + " reported from " + node.getName() + " current size is " + cursize + " reported size is " + block.getNumBytes()));
                    try {
                        if (cursize > block.getNumBytes()) {
                            LOG.warn((Object)("Deleting block " + block + " from " + node.getName()));
                            this.invalidateBlock(block, node);
                        } else {
                            int numNodes = this.blocksMap.numNodes(block);
                            int count = 0;
                            DatanodeDescriptor[] nodes = new DatanodeDescriptor[numNodes];
                            Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(block);
                            while (it != null && it.hasNext()) {
                                DatanodeDescriptor dd = it.next();
                                if (dd.equals(node)) continue;
                                nodes[count++] = dd;
                            }
                            for (int j = 0; j < count; ++j) {
                                LOG.warn((Object)("Deleting block " + block + " from " + nodes[j].getName()));
                                this.invalidateBlock(block, nodes[j]);
                            }
                            storedBlock = this.blocksMap.getStoredBlock(block);
                            if (storedBlock == null) {
                                LOG.warn((Object)("Block " + block + " reported from " + node.getName() + " does not exist in blockMap. Surprise! Surprise!"));
                            } else {
                                storedBlock.setNumBytes(block.getNumBytes());
                            }
                        }
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Error in deleting bad block " + block + e));
                    }
                }
            }
            block = storedBlock;
        }
        assert (storedBlock == block) : "Block must be stored by now";
        int curReplicaDelta = 0;
        if (added) {
            curReplicaDelta = 1;
            if (!this.isInSafeMode()) {
                NameNode.stateChangeLog.info((Object)("BLOCK* NameSystem.addStoredBlock: blockMap updated: " + node.getName() + " is added to " + block + " size " + block.getNumBytes()));
            }
        } else {
            NameNode.stateChangeLog.warn((Object)("BLOCK* NameSystem.addStoredBlock: Redundant addStoredBlock request received for " + block + " on " + node.getName() + " size " + block.getNumBytes()));
        }
        if (fileINode == null) {
            NameNode.stateChangeLog.info((Object)("BLOCK* NameSystem.addStoredBlock: addStoredBlock request received for " + block + " on " + node.getName() + " size " + block.getNumBytes() + " But it does not belong to any file."));
            return block;
        }
        NumberReplicas num = this.countNodes(storedBlock);
        int numCurrentReplica = num.liveReplicas() + this.pendingReplications.getNumReplicas(block);
        this.incrementSafeBlockCount(numCurrentReplica);
        if (fileINode.isUnderConstruction()) {
            return block;
        }
        if (this.isInSafeMode()) {
            return block;
        }
        short fileReplication = fileINode.getReplication();
        if (numCurrentReplica >= fileReplication) {
            this.neededReplications.remove(block, numCurrentReplica, num.decommissionedReplicas, fileReplication);
        } else {
            this.updateNeededReplications(block, curReplicaDelta, 0);
        }
        if (numCurrentReplica > fileReplication) {
            this.proccessOverReplicatedBlock(block, fileReplication, node, delNodeHint);
        }
        if ((corruptReplicasCount = num.corruptReplicas()) > 0 && numCurrentReplica == fileReplication) {
            this.corruptReplicas.invalidateCorruptReplicas(block);
        }
        return block;
    }

    private synchronized void processMisReplicatedBlocks() {
        long nrInvalid = 0L;
        long nrOverReplicated = 0L;
        long nrUnderReplicated = 0L;
        this.neededReplications.clear();
        this.excessReplicateMap.clear();
        for (BlocksMap.BlockInfo block : this.blocksMap.getBlocks()) {
            INodeFile fileINode = block.getINode();
            if (fileINode == null) {
                ++nrInvalid;
                this.addToInvalidates(block);
                continue;
            }
            short expectedReplication = fileINode.getReplication();
            NumberReplicas num = this.countNodes(block);
            int numCurrentReplica = num.liveReplicas();
            if (this.neededReplications.add(block, numCurrentReplica, num.decommissionedReplicas(), expectedReplication)) {
                ++nrUnderReplicated;
            }
            if (numCurrentReplica <= expectedReplication) continue;
            ++nrOverReplicated;
            this.proccessOverReplicatedBlock(block, expectedReplication, null, null);
        }
        LOG.info((Object)("Total number of blocks = " + this.blocksMap.size()));
        LOG.info((Object)("Number of invalid blocks = " + nrInvalid));
        LOG.info((Object)("Number of under-replicated blocks = " + nrUnderReplicated));
        LOG.info((Object)("Number of  over-replicated blocks = " + nrOverReplicated));
    }

    private void proccessOverReplicatedBlock(Block block, short replication, DatanodeDescriptor addedNode, DatanodeDescriptor delNodeHint) {
        if (addedNode == delNodeHint) {
            delNodeHint = null;
        }
        ArrayList<DatanodeDescriptor> nonExcess = new ArrayList<DatanodeDescriptor>();
        Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(block);
        while (it.hasNext()) {
            DatanodeDescriptor cur = it.next();
            Collection<Block> excessBlocks = this.excessReplicateMap.get(cur.getStorageID());
            if (excessBlocks != null && excessBlocks.contains(block) || cur.isDecommissionInProgress() || cur.isDecommissioned()) continue;
            nonExcess.add(cur);
        }
        this.chooseExcessReplicates(nonExcess, block, replication, addedNode, delNodeHint);
    }

    void chooseExcessReplicates(Collection<DatanodeDescriptor> nonExcess, Block b, short replication, DatanodeDescriptor addedNode, DatanodeDescriptor delNodeHint) {
        HashMap<String, ArrayList<DatanodeDescriptor>> rackMap = new HashMap<String, ArrayList<DatanodeDescriptor>>();
        for (DatanodeDescriptor node : nonExcess) {
            String rackName = node.getNetworkLocation();
            ArrayList<DatanodeDescriptor> datanodeList = (ArrayList<DatanodeDescriptor>)rackMap.get(rackName);
            if (datanodeList == null) {
                datanodeList = new ArrayList<DatanodeDescriptor>();
            }
            datanodeList.add(node);
            rackMap.put(rackName, datanodeList);
        }
        ArrayList priSet = new ArrayList();
        ArrayList remains = new ArrayList();
        for (Map.Entry rackEntry : rackMap.entrySet()) {
            ArrayList datanodeList = (ArrayList)rackEntry.getValue();
            if (datanodeList.size() == 1) {
                remains.add(datanodeList.get(0));
                continue;
            }
            priSet.addAll(datanodeList);
        }
        boolean firstOne = true;
        while (nonExcess.size() - replication > 0) {
            DatanodeDescriptor cur = null;
            long minSpace = Long.MAX_VALUE;
            if (firstOne && delNodeHint != null && nonExcess.contains(delNodeHint) && (priSet.contains(delNodeHint) || addedNode != null && !priSet.contains(addedNode))) {
                cur = delNodeHint;
            } else {
                Iterator iter;
                Iterator iterator = iter = priSet.isEmpty() ? remains.iterator() : priSet.iterator();
                while (iter.hasNext()) {
                    DatanodeDescriptor node = (DatanodeDescriptor)iter.next();
                    long free = node.getRemaining();
                    if (minSpace <= free) continue;
                    minSpace = free;
                    cur = node;
                }
            }
            firstOne = false;
            String rack = cur.getNetworkLocation();
            ArrayList datanodes = (ArrayList)rackMap.get(rack);
            datanodes.remove(cur);
            if (datanodes.isEmpty()) {
                rackMap.remove(rack);
            }
            if (priSet.remove(cur)) {
                if (datanodes.size() == 1) {
                    priSet.remove(datanodes.get(0));
                    remains.add(datanodes.get(0));
                }
            } else {
                remains.remove(cur);
            }
            nonExcess.remove(cur);
            Collection<Block> excessBlocks = this.excessReplicateMap.get(cur.getStorageID());
            if (excessBlocks == null) {
                excessBlocks = new TreeSet<Block>();
                this.excessReplicateMap.put(cur.getStorageID(), excessBlocks);
            }
            excessBlocks.add(b);
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.chooseExcessReplicates: (" + cur.getName() + ", " + b + ") is added to excessReplicateMap"));
            Collection<Block> invalidateSet = this.recentInvalidateSets.get(cur.getStorageID());
            if (invalidateSet == null) {
                invalidateSet = new ArrayList<Block>();
                this.recentInvalidateSets.put(cur.getStorageID(), invalidateSet);
            }
            invalidateSet.add(b);
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.chooseExcessReplicates: (" + cur.getName() + ", " + b + ") is added to recentInvalidateSets"));
        }
    }

    synchronized void removeStoredBlock(Block block, DatanodeDescriptor node) {
        Collection<Block> excessBlocks;
        NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.removeStoredBlock: " + block + " from " + node.getName()));
        if (!this.blocksMap.removeNode(block, node)) {
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.removeStoredBlock: " + block + " has already been removed from node " + node));
            return;
        }
        INodeFile fileINode = this.blocksMap.getINode(block);
        if (fileINode != null) {
            this.decrementSafeBlockCount(block);
            this.updateNeededReplications(block, -1, 0);
        }
        if ((excessBlocks = this.excessReplicateMap.get(node.getStorageID())) != null) {
            excessBlocks.remove(block);
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.removeStoredBlock: " + block + " is removed from excessBlocks"));
            if (excessBlocks.size() == 0) {
                this.excessReplicateMap.remove(node.getStorageID());
            }
        }
        this.corruptReplicas.removeFromCorruptReplicasMap(block);
    }

    public synchronized void blockReceived(DatanodeID nodeID, Block block, String delHint) throws IOException {
        DatanodeDescriptor node = this.getDatanode(nodeID);
        if (node == null) {
            NameNode.stateChangeLog.warn((Object)("BLOCK* NameSystem.blockReceived: " + block + " is received from an unrecorded node " + nodeID.getName()));
            throw new IllegalArgumentException("Unexpected exception.  Got blockReceived message from node " + block + ", but there is no info for it");
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("BLOCK* NameSystem.blockReceived: " + block + " is received from " + nodeID.getName()));
        }
        if (this.shouldNodeShutdown(node)) {
            this.setDatanodeDead(node);
            throw new DisallowedDatanodeException(node);
        }
        DatanodeDescriptor delHintNode = null;
        if (delHint != null && delHint.length() != 0 && (delHintNode = this.datanodeMap.get(delHint)) == null) {
            NameNode.stateChangeLog.warn((Object)("BLOCK* NameSystem.blockReceived: " + block + " is expected to be removed from an unrecorded node " + delHint));
        }
        this.addStoredBlock(block, node, delHintNode);
        this.pendingReplications.remove(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long[] getStats() throws IOException {
        this.checkSuperuserPrivilege();
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            return new long[]{this.getCapacityTotal(), this.getCapacityUsed(), this.getCapacityRemaining()};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCapacityTotal() {
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            return this.capacityTotal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCapacityUsed() {
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            return this.capacityUsed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCapacityRemaining() {
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            return this.capacityRemaining;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalLoad() {
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            return this.totalLoad;
        }
    }

    int getNumberOfDatanodes(FSConstants.DatanodeReportType type) {
        return this.getDatanodeListForReport(type).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ArrayList<DatanodeDescriptor> getDatanodeListForReport(FSConstants.DatanodeReportType type) {
        boolean listLiveNodes = type == FSConstants.DatanodeReportType.ALL || type == FSConstants.DatanodeReportType.LIVE;
        boolean listDeadNodes = type == FSConstants.DatanodeReportType.ALL || type == FSConstants.DatanodeReportType.DEAD;
        HashMap<String, String> mustList = new HashMap<String, String>();
        if (listDeadNodes) {
            Iterator<String> it = this.hostsReader.getHosts().iterator();
            while (it.hasNext()) {
                mustList.put(it.next(), "");
            }
            it = this.hostsReader.getExcludedHosts().iterator();
            while (it.hasNext()) {
                mustList.put(it.next(), "");
            }
        }
        ArrayList<DatanodeDescriptor> nodes = null;
        Map<String, DatanodeDescriptor> map = this.datanodeMap;
        synchronized (map) {
            nodes = new ArrayList<DatanodeDescriptor>(this.datanodeMap.size() + mustList.size());
            for (DatanodeDescriptor dn : this.datanodeMap.values()) {
                boolean isDead = this.isDatanodeDead(dn);
                if (isDead && listDeadNodes || !isDead && listLiveNodes) {
                    nodes.add(dn);
                }
                mustList.remove(dn.getName());
                mustList.remove(dn.getHost());
                mustList.remove(dn.getHostName());
            }
        }
        if (listDeadNodes) {
            Iterator it = mustList.keySet().iterator();
            while (it.hasNext()) {
                DatanodeDescriptor dn = new DatanodeDescriptor(new DatanodeID((String)it.next()));
                dn.setLastUpdate(0L);
                nodes.add(dn);
            }
        }
        return nodes;
    }

    public synchronized DatanodeInfo[] datanodeReport(FSConstants.DatanodeReportType type) throws AccessControlException {
        this.checkSuperuserPrivilege();
        ArrayList<DatanodeDescriptor> results = this.getDatanodeListForReport(type);
        DatanodeInfo[] arr = new DatanodeInfo[results.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = new DatanodeInfo(results.get(i));
        }
        return arr;
    }

    public synchronized void DFSNodesStatus(ArrayList<DatanodeDescriptor> live, ArrayList<DatanodeDescriptor> dead) {
        ArrayList<DatanodeDescriptor> results = this.getDatanodeListForReport(FSConstants.DatanodeReportType.ALL);
        for (DatanodeDescriptor node : results) {
            if (this.isDatanodeDead(node)) {
                dead.add(node);
                continue;
            }
            live.add(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void datanodeDump(PrintWriter out) {
        Map<String, DatanodeDescriptor> map = this.datanodeMap;
        synchronized (map) {
            out.println("Metasave: Number of datanodes: " + this.datanodeMap.size());
            for (DatanodeDescriptor node : this.datanodeMap.values()) {
                out.println(node.dumpDatanode());
            }
        }
    }

    private void startDecommission(DatanodeDescriptor node) throws IOException {
        if (!node.isDecommissionInProgress() && !node.isDecommissioned()) {
            LOG.info((Object)("Start Decommissioning node " + node.name));
            node.startDecommission();
            Iterator<Block> decommissionBlocks = node.getBlockIterator();
            while (decommissionBlocks.hasNext()) {
                Block block = decommissionBlocks.next();
                this.updateNeededReplications(block, -1, 0);
            }
        }
    }

    public void stopDecommission(DatanodeDescriptor node) throws IOException {
        LOG.info((Object)("Stop Decommissioning node " + node.name));
        node.stopDecommission();
    }

    public DatanodeInfo getDataNodeInfo(String name) {
        return this.datanodeMap.get(name);
    }

    public String getDFSNameNodeMachine() {
        return this.localMachine;
    }

    public int getDFSNameNodePort() {
        return this.port;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    short getMaxReplication() {
        return (short)this.maxReplication;
    }

    short getMinReplication() {
        return (short)this.minReplication;
    }

    short getDefaultReplication() {
        return (short)this.defaultReplication;
    }

    private NumberReplicas countNodes(Block b, Iterator<DatanodeDescriptor> nodeIter) {
        int count = 0;
        int live = 0;
        int corrupt = 0;
        Collection<DatanodeDescriptor> nodesCorrupt = this.corruptReplicas.getNodes(b);
        while (nodeIter.hasNext()) {
            DatanodeDescriptor node = nodeIter.next();
            if (nodesCorrupt != null && nodesCorrupt.contains(node)) {
                ++corrupt;
                continue;
            }
            if (node.isDecommissionInProgress() || node.isDecommissioned()) {
                ++count;
                continue;
            }
            ++live;
        }
        return new NumberReplicas(live, count, corrupt);
    }

    private NumberReplicas countNodes(Block b) {
        return this.countNodes(b, this.blocksMap.nodeIterator(b));
    }

    private boolean isReplicationInProgress(DatanodeDescriptor srcNode) {
        boolean status = false;
        Iterator<Block> decommissionBlocks = srcNode.getBlockIterator();
        while (decommissionBlocks.hasNext()) {
            Block block = decommissionBlocks.next();
            INodeFile fileINode = this.blocksMap.getINode(block);
            if (fileINode == null) continue;
            NumberReplicas num = this.countNodes(block);
            int curReplicas = num.liveReplicas();
            int curExpectedReplicas = this.getReplication(block);
            if (curExpectedReplicas <= curReplicas) continue;
            status = true;
            if (this.neededReplications.contains(block) || this.pendingReplications.getNumReplicas(block) != 0) continue;
            this.neededReplications.update(block, curReplicas, num.decommissionedReplicas(), curExpectedReplicas, -1, 0);
        }
        return status;
    }

    private boolean checkDecommissionStateInternal(DatanodeDescriptor node) {
        if (node.isDecommissionInProgress() && !this.isReplicationInProgress(node)) {
            node.setDecommissioned();
            LOG.info((Object)("Decommission complete for node " + node.name));
        }
        return node.isDecommissioned();
    }

    private boolean inHostsList(DatanodeID node) {
        Set<String> hostsList = this.hostsReader.getHosts();
        return hostsList.isEmpty() || hostsList.contains(node.getName()) || hostsList.contains(node.getHost()) || node instanceof DatanodeInfo && hostsList.contains(((DatanodeInfo)node).getHostName());
    }

    private boolean inExcludedHostsList(DatanodeID node) {
        Set<String> excludeList = this.hostsReader.getExcludedHosts();
        return excludeList.contains(node.getName()) || excludeList.contains(node.getHost()) || node instanceof DatanodeInfo && excludeList.contains(((DatanodeInfo)node).getHostName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshNodes() throws IOException {
        this.checkSuperuserPrivilege();
        this.hostsReader.refresh();
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            for (DatanodeDescriptor node : this.datanodeMap.values()) {
                if (!this.inHostsList(node)) {
                    node.setDecommissioned();
                    continue;
                }
                if (this.inExcludedHostsList(node)) {
                    if (node.isDecommissionInProgress() || node.isDecommissioned()) continue;
                    this.startDecommission(node);
                    continue;
                }
                if (!node.isDecommissionInProgress() && !node.isDecommissioned()) continue;
                this.stopDecommission(node);
            }
        }
    }

    void finalizeUpgrade() throws IOException {
        this.checkSuperuserPrivilege();
        this.getFSImage().finalizeUpgrade();
    }

    public synchronized boolean verifyNodeRegistration(DatanodeRegistration nodeReg) throws IOException {
        if (!this.inHostsList(nodeReg)) {
            return false;
        }
        if (this.inExcludedHostsList(nodeReg)) {
            DatanodeDescriptor node = this.getDatanode(nodeReg);
            if (node == null) {
                throw new IOException("verifyNodeRegistration: unknown datanode " + nodeReg.getName());
            }
            if (!this.checkDecommissionStateInternal(node)) {
                this.startDecommission(node);
            }
        }
        return true;
    }

    private boolean shouldNodeShutdown(DatanodeDescriptor node) {
        return node.isDecommissioned();
    }

    public synchronized void decommissionedDatanodeCheck() {
        for (DatanodeDescriptor node : this.datanodeMap.values()) {
            this.checkDecommissionStateInternal(node);
        }
    }

    public DatanodeDescriptor getDatanode(DatanodeID nodeID) throws IOException {
        UnregisteredDatanodeException e = null;
        DatanodeDescriptor node = this.datanodeMap.get(nodeID.getStorageID());
        if (node == null) {
            return null;
        }
        if (!node.getName().equals(nodeID.getName())) {
            e = new UnregisteredDatanodeException(nodeID, node);
            NameNode.stateChangeLog.fatal((Object)("BLOCK* NameSystem.getDatanode: " + e.getLocalizedMessage()));
            throw e;
        }
        return node;
    }

    @Deprecated
    private DatanodeDescriptor getDatanodeByIndex(int index) {
        int i = 0;
        for (DatanodeDescriptor node : this.datanodeMap.values()) {
            if (i == index) {
                return node;
            }
            ++i;
        }
        return null;
    }

    @Deprecated
    public String randomDataNode() {
        int size = this.datanodeMap.size();
        int index = 0;
        if (size != 0) {
            index = this.r.nextInt(size);
            for (int i = 0; i < size; ++i) {
                DatanodeDescriptor d = this.getDatanodeByIndex(index);
                if (!(d == null || d.isDecommissioned() || this.isDatanodeDead(d) || d.isDecommissionInProgress())) {
                    return d.getHost() + ":" + d.getInfoPort();
                }
                index = (index + 1) % size;
            }
        }
        return null;
    }

    public DatanodeDescriptor getRandomDatanode() {
        return this.replicator.chooseTarget(1, null, null, 0L)[0];
    }

    public int getNameNodeInfoPort() {
        return this.infoPort;
    }

    static long now() {
        return System.currentTimeMillis();
    }

    boolean setSafeMode(FSConstants.SafeModeAction action) throws IOException {
        if (action != FSConstants.SafeModeAction.SAFEMODE_GET) {
            this.checkSuperuserPrivilege();
            switch (action) {
                case SAFEMODE_LEAVE: {
                    this.leaveSafeMode(false, false);
                    break;
                }
                case SAFEMODE_ENTER: {
                    this.enterSafeMode();
                }
            }
        }
        return this.isInSafeMode();
    }

    boolean isInSafeMode() {
        if (this.safeMode == null) {
            return false;
        }
        return this.safeMode.isOn();
    }

    void incrementSafeBlockCount(int replication) {
        if (this.safeMode == null) {
            return;
        }
        this.safeMode.incrementSafeBlockCount((short)replication);
    }

    void decrementSafeBlockCount(Block b) {
        if (this.safeMode == null) {
            return;
        }
        this.safeMode.decrementSafeBlockCount((short)this.countNodes(b).liveReplicas());
    }

    void setBlockTotal() {
        if (this.safeMode == null) {
            return;
        }
        this.safeMode.setBlockTotal(this.blocksMap.size());
    }

    @Override
    public long getBlocksTotal() {
        return this.blocksMap.size();
    }

    synchronized void enterSafeMode() throws IOException {
        if (this.isInSafeMode()) {
            NameNode.stateChangeLog.info((Object)"STATE* Safe mode is already ON.");
            return;
        }
        this.safeMode = new SafeModeInfo();
    }

    synchronized void leaveSafeMode(boolean checkForUpgrades, boolean checkBlockReplication) throws IOException {
        if (!this.isInSafeMode()) {
            NameNode.stateChangeLog.info((Object)"STATE* Safe mode is already OFF.");
            return;
        }
        if (this.getDistributedUpgradeState()) {
            throw new SafeModeException("Distributed upgrade is in progress", this.safeMode);
        }
        this.safeMode.leave(checkForUpgrades, checkBlockReplication);
    }

    String getSafeModeTip() {
        if (!this.isInSafeMode()) {
            return "";
        }
        return this.safeMode.getTurnOffTip();
    }

    long getEditLogSize() throws IOException {
        return this.getEditLog().getEditLogSize();
    }

    synchronized CheckpointSignature rollEditLog() throws IOException {
        if (this.isInSafeMode()) {
            throw new SafeModeException("Checkpoint not created", this.safeMode);
        }
        LOG.info((Object)("Roll Edit Log from " + Server.getRemoteAddress()));
        return this.getFSImage().rollEditLog();
    }

    synchronized void rollFSImage() throws IOException {
        if (this.isInSafeMode()) {
            throw new SafeModeException("Checkpoint not created", this.safeMode);
        }
        LOG.info((Object)("Roll FSImage from " + Server.getRemoteAddress()));
        this.getFSImage().rollFSImage();
    }

    private boolean isValidBlock(Block b) {
        return this.blocksMap.getINode(b) != null;
    }

    UpgradeStatusReport distributedUpgradeProgress(FSConstants.UpgradeAction action) throws IOException {
        return this.upgradeManager.distributedUpgradeProgress(action);
    }

    UpgradeCommand processDistributedUpgradeCommand(UpgradeCommand comm) throws IOException {
        return this.upgradeManager.processUpgradeCommand(comm);
    }

    int getDistributedUpgradeVersion() {
        return this.upgradeManager.getUpgradeVersion();
    }

    UpgradeCommand getDistributedUpgradeCommand() throws IOException {
        return this.upgradeManager.getBroadcastCommand();
    }

    boolean getDistributedUpgradeState() {
        return this.upgradeManager.getUpgradeState();
    }

    short getDistributedUpgradeStatus() {
        return this.upgradeManager.getUpgradeStatus();
    }

    boolean startDistributedUpgradeIfNeeded() throws IOException {
        return this.upgradeManager.startUpgrade();
    }

    PermissionStatus createFsOwnerPermissions(FsPermission permission) {
        return new PermissionStatus(this.fsOwner.getUserName(), this.supergroup, permission);
    }

    private PermissionChecker checkOwner(String path) throws AccessControlException {
        return this.checkPermission(path, true, null, null, null, null);
    }

    private PermissionChecker checkPathAccess(String path, FsAction access) throws AccessControlException {
        return this.checkPermission(path, false, null, null, access, null);
    }

    private PermissionChecker checkParentAccess(String path, FsAction access) throws AccessControlException {
        return this.checkPermission(path, false, null, access, null, null);
    }

    private PermissionChecker checkAncestorAccess(String path, FsAction access) throws AccessControlException {
        return this.checkPermission(path, false, access, null, null, null);
    }

    private PermissionChecker checkTraverse(String path) throws AccessControlException {
        return this.checkPermission(path, false, null, null, null, null);
    }

    private void checkSuperuserPrivilege() throws AccessControlException {
        if (this.isPermissionEnabled) {
            PermissionChecker pc = new PermissionChecker(this.fsOwner.getUserName(), this.supergroup);
            if (!pc.isSuper) {
                throw new AccessControlException("Superuser privilege is required");
            }
        }
    }

    private PermissionChecker checkPermission(String path, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess) throws AccessControlException {
        PermissionChecker pc = new PermissionChecker(this.fsOwner.getUserName(), this.supergroup);
        if (!pc.isSuper) {
            this.dir.waitForReady();
            pc.checkPermission(path, this.dir.rootDir, doCheckOwner, ancestorAccess, parentAccess, access, subAccess);
        }
        return pc;
    }

    void checkFsObjectLimit() throws IOException {
        if (this.maxFsObjects != 0L && this.maxFsObjects <= this.dir.totalInodes() + this.getBlocksTotal()) {
            throw new IOException("Exceeded the configured number of objects " + this.maxFsObjects + " in the filesystem.");
        }
    }

    long getMaxObjects() {
        return this.maxFsObjects;
    }

    @Override
    public long getFilesTotal() {
        return this.dir.totalInodes();
    }

    @Override
    public long getPendingReplicationBlocks() {
        return this.pendingReplicationBlocksCount;
    }

    @Override
    public long getUnderReplicatedBlocks() {
        return this.underReplicatedBlocksCount;
    }

    @Override
    public long getScheduledReplicationBlocks() {
        return this.scheduledReplicationBlocksCount;
    }

    @Override
    public String getFSState() {
        return this.isInSafeMode() ? "safeMode" : "Operational";
    }

    void registerMBean(Configuration conf) {
        try {
            this.myFSMetrics = new FSNamesystemMetrics(conf, this);
            StandardMBean bean = new StandardMBean(this, FSNamesystemMBean.class);
            this.mbeanName = MBeanUtil.registerMBean("NameNode", "FSNamesystemStatus", bean);
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
        }
        LOG.info((Object)"Registered FSNamesystemStatusMBean");
    }

    public FSNamesystemMetrics getFSNamesystemMetrics() {
        return this.myFSMetrics;
    }

    public void shutdown() {
        if (this.mbeanName != null) {
            MBeanUtil.unregisterMBean(this.mbeanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int numLiveDataNodes() {
        int numLive = 0;
        Map<String, DatanodeDescriptor> map = this.datanodeMap;
        synchronized (map) {
            for (DatanodeDescriptor dn : this.datanodeMap.values()) {
                if (this.isDatanodeDead(dn)) continue;
                ++numLive;
            }
        }
        return numLive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int numDeadDataNodes() {
        int numDead = 0;
        Map<String, DatanodeDescriptor> map = this.datanodeMap;
        synchronized (map) {
            for (DatanodeDescriptor dn : this.datanodeMap.values()) {
                if (!this.isDatanodeDead(dn)) continue;
                ++numDead;
            }
        }
        return numDead;
    }

    void setGenerationStamp(long stamp) {
        this.generationStamp.setStamp(stamp);
    }

    long getGenerationStamp() {
        return this.generationStamp.getStamp();
    }

    long nextGenerationStamp() {
        long gs = this.generationStamp.nextStamp();
        this.getEditLog().logGenerationStamp(gs);
        return gs;
    }

    synchronized long nextGenerationStampForBlock(Block block) throws IOException {
        String msg = "Block " + block + " is already commited.";
        BlocksMap.BlockInfo storedBlock = this.blocksMap.getStoredBlock(block);
        if (storedBlock == null) {
            LOG.info((Object)msg);
            throw new IOException(msg);
        }
        INodeFile fileINode = storedBlock.getINode();
        if (!fileINode.isUnderConstruction()) {
            LOG.info((Object)msg);
            throw new IOException(msg);
        }
        return this.nextGenerationStamp();
    }

    void changeLease(String src, String dst) throws IOException {
        String replaceBy;
        String overwrite;
        DFSFileInfo dinfo = this.dir.getFileInfo(dst);
        if (dinfo.isDir()) {
            Path spath = new Path(src);
            overwrite = spath.getParent().toString() + "/";
            replaceBy = dst + "/";
        } else {
            overwrite = src;
            replaceBy = dst;
        }
        this.leaseManager.changeLease(src, dst, overwrite, replaceBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveFilesUnderConstruction(DataOutputStream out) throws IOException {
        LeaseManager leaseManager = this.leaseManager;
        synchronized (leaseManager) {
            out.writeInt(this.leaseManager.countPath());
            for (LeaseManager.Lease lease : this.leaseManager.getSortedLeases()) {
                Collection<StringBytesWritable> files = lease.getPaths();
                Iterator<StringBytesWritable> i = files.iterator();
                while (i.hasNext()) {
                    String path = i.next().getString();
                    INodeFile node = this.dir.getFileINode(path);
                    if (node == null) {
                        throw new IOException("saveLeases found path " + path + " but no matching entry in namespace.");
                    }
                    if (!node.isUnderConstruction()) {
                        throw new IOException("saveLeases found path " + path + " but is not under construction.");
                    }
                    INodeFileUnderConstruction cons = (INodeFileUnderConstruction)node;
                    FSImage.writeINodeUnderConstruction(out, cons, path);
                }
            }
        }
    }

    static {
        randBlockId = new Random();
    }

    class SafeModeMonitor
    implements Runnable {
        private static final long recheckInterval = 1000L;

        SafeModeMonitor() {
        }

        public void run() {
            while (FSNamesystem.this.fsRunning && FSNamesystem.this.safeMode != null && !FSNamesystem.this.safeMode.canLeave()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (FSNamesystem.this.safeMode != null) {
                FSNamesystem.this.safeMode.leave(true, true);
            }
            FSNamesystem.this.smmthread = null;
        }
    }

    class SafeModeInfo {
        private double threshold;
        private int extension;
        private int safeReplication;
        private long reached = -1L;
        int blockTotal;
        private int blockSafe;
        private long lastStatusReport = 0L;

        SafeModeInfo(Configuration conf) {
            this.threshold = conf.getFloat("dfs.safemode.threshold.pct", 0.95f);
            this.extension = conf.getInt("dfs.safemode.extension", 0);
            this.safeReplication = conf.getInt("dfs.replication.min", 1);
            this.blockTotal = 0;
            this.blockSafe = 0;
        }

        private SafeModeInfo() {
            this.threshold = 1.5;
            this.extension = 0;
            this.safeReplication = 32768;
            this.blockTotal = -1;
            this.blockSafe = -1;
            this.reached = -1L;
            this.enter();
            this.reportStatus("STATE* Safe mode is ON.", true);
        }

        synchronized boolean isOn() {
            try {
                assert (this.isConsistent()) : " SafeMode: Inconsistent filesystem state: Total num of blocks, active blocks, or total safe blocks don't match.";
            }
            catch (IOException e) {
                System.err.print(StringUtils.stringifyException(e));
            }
            return this.reached >= 0L;
        }

        void enter() {
            this.reached = 0L;
        }

        synchronized void leave(boolean checkForUpgrades, boolean checkBlockReplication) {
            if (checkForUpgrades) {
                boolean needUpgrade = false;
                try {
                    needUpgrade = FSNamesystem.this.startDistributedUpgradeIfNeeded();
                }
                catch (IOException e) {
                    LOG.error((Object)StringUtils.stringifyException(e));
                }
                if (needUpgrade) {
                    FSNamesystem.this.safeMode = new SafeModeInfo();
                    return;
                }
            }
            if (checkBlockReplication) {
                FSNamesystem.this.processMisReplicatedBlocks();
            }
            long timeInSafemode = FSNamesystem.now() - FSNamesystem.this.systemStart;
            NameNode.stateChangeLog.info((Object)("STATE* Leaving safe mode after " + timeInSafemode / 1000L + " secs."));
            NameNode.getNameNodeMetrics().safeModeTime.set((int)timeInSafemode);
            if (this.reached >= 0L) {
                NameNode.stateChangeLog.info((Object)"STATE* Safe mode is OFF.");
            }
            this.reached = -1L;
            FSNamesystem.this.safeMode = null;
            NameNode.stateChangeLog.info((Object)("STATE* Network topology has " + FSNamesystem.this.clusterMap.getNumOfRacks() + " racks and " + FSNamesystem.this.clusterMap.getNumOfLeaves() + " datanodes"));
            NameNode.stateChangeLog.info((Object)("STATE* UnderReplicatedBlocks has " + FSNamesystem.this.neededReplications.size() + " blocks"));
        }

        synchronized boolean canLeave() {
            if (this.reached == 0L) {
                return false;
            }
            if (FSNamesystem.now() - this.reached < (long)this.extension) {
                this.reportStatus("STATE* Safe mode ON.", false);
                return false;
            }
            return !this.needEnter();
        }

        boolean needEnter() {
            return (double)this.getSafeBlockRatio() < this.threshold;
        }

        private float getSafeBlockRatio() {
            return this.blockTotal == 0 ? 1.0f : (float)this.blockSafe / (float)this.blockTotal;
        }

        private void checkMode() {
            if (this.needEnter()) {
                this.enter();
                this.reportStatus("STATE* Safe mode ON.", false);
                return;
            }
            if (!this.isOn() || this.extension <= 0 || this.threshold <= 0.0) {
                this.leave(true, false);
                return;
            }
            if (this.reached > 0L) {
                this.reportStatus("STATE* Safe mode ON.", false);
                return;
            }
            this.reached = FSNamesystem.now();
            FSNamesystem.this.smmthread = new Daemon(new SafeModeMonitor());
            FSNamesystem.this.smmthread.start();
            this.reportStatus("STATE* Safe mode extension entered.", true);
        }

        synchronized void setBlockTotal(int total) {
            this.blockTotal = total;
            this.checkMode();
        }

        synchronized void incrementSafeBlockCount(short replication) {
            if (replication == this.safeReplication) {
                ++this.blockSafe;
            }
            this.checkMode();
        }

        synchronized void decrementSafeBlockCount(short replication) {
            if (replication == this.safeReplication - 1) {
                --this.blockSafe;
            }
            this.checkMode();
        }

        boolean isManual() {
            return this.blockTotal == -1;
        }

        String getTurnOffTip() {
            String autoOffMsg = "Safe mode will be turned off automatically";
            if (this.reached < 0L) {
                return "Safe mode is OFF.";
            }
            if (this.isManual()) {
                if (FSNamesystem.this.getDistributedUpgradeState()) {
                    return "Safe mode will be turned off automatically upon completion of the distributed upgrade: upgrade progress = " + FSNamesystem.this.getDistributedUpgradeStatus() + "%";
                }
                return "Use \"hadoop dfs -safemode leave\" to turn safe mode off.";
            }
            String safeBlockRatioMsg = String.format("The ratio of reported blocks %.4f has " + (this.reached == 0L ? "not " : "") + "reached the threshold %.4f. ", Float.valueOf(this.getSafeBlockRatio()), this.threshold) + "Safe mode will be turned off automatically";
            if (this.reached == 0L) {
                return safeBlockRatioMsg + ".";
            }
            return safeBlockRatioMsg + " in " + Math.abs(this.reached + (long)this.extension - FSNamesystem.now()) / 1000L + " seconds.";
        }

        private void reportStatus(String msg, boolean rightNow) {
            long curTime = FSNamesystem.now();
            if (!rightNow && curTime - this.lastStatusReport < 20000L) {
                return;
            }
            NameNode.stateChangeLog.info((Object)(msg + " \n" + this.getTurnOffTip()));
            this.lastStatusReport = curTime;
        }

        public String toString() {
            String resText = "Current safe block ratio = " + this.getSafeBlockRatio() + ". Target threshold = " + this.threshold + ". Minimal replication = " + this.safeReplication + ".";
            if (this.reached > 0L) {
                resText = resText + " Threshold was reached " + new Date(this.reached) + ".";
            }
            return resText;
        }

        boolean isConsistent() throws IOException {
            if (this.blockTotal == -1 && this.blockSafe == -1) {
                return true;
            }
            int activeBlocks = FSNamesystem.this.blocksMap.size();
            Iterator it = FSNamesystem.this.recentInvalidateSets.values().iterator();
            while (it.hasNext()) {
                activeBlocks -= ((Collection)it.next()).size();
            }
            return this.blockTotal == activeBlocks || this.blockSafe >= 0 && this.blockSafe <= this.blockTotal;
        }
    }

    class DecommissionedMonitor
    implements Runnable {
        DecommissionedMonitor() {
        }

        public void run() {
            while (FSNamesystem.this.fsRunning) {
                try {
                    FSNamesystem.this.decommissionedDatanodeCheck();
                }
                catch (Exception e) {
                    LOG.info((Object)StringUtils.stringifyException(e));
                }
                try {
                    Thread.sleep(FSNamesystem.this.decommissionRecheckInterval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static class NumberReplicas {
        private int liveReplicas;
        private int decommissionedReplicas;
        private int corruptReplicas;

        NumberReplicas() {
            this.initialize(0, 0, 0);
        }

        NumberReplicas(int live, int decommissioned, int corrupt) {
            this.initialize(live, decommissioned, corrupt);
        }

        void initialize(int live, int decommissioned, int corrupt) {
            this.liveReplicas = live;
            this.decommissionedReplicas = decommissioned;
            this.corruptReplicas = corrupt;
        }

        int liveReplicas() {
            return this.liveReplicas;
        }

        int decommissionedReplicas() {
            return this.decommissionedReplicas;
        }

        int corruptReplicas() {
            return this.corruptReplicas;
        }
    }

    class ReplicationMonitor
    implements Runnable {
        static final int INVALIDATE_WORK_PCT_PER_ITERATION = 32;
        static final float REPLICATION_WORK_MULTIPLIER_PER_ITERATION = 2.0f;

        ReplicationMonitor() {
        }

        public void run() {
            while (FSNamesystem.this.fsRunning) {
                try {
                    FSNamesystem.this.computeDatanodeWork();
                    FSNamesystem.this.processPendingReplications();
                    Thread.sleep(FSNamesystem.this.replicationRecheckInterval);
                }
                catch (InterruptedException ie) {
                    LOG.warn((Object)("ReplicationMonitor thread received InterruptedException." + ie));
                    break;
                }
                catch (IOException ie) {
                    LOG.warn((Object)("ReplicationMonitor thread received exception. " + ie));
                }
                catch (Throwable t) {
                    LOG.warn((Object)("ReplicationMonitor thread received Runtime exception. " + t));
                    Runtime.getRuntime().exit(-1);
                }
            }
        }
    }

    class HeartbeatMonitor
    implements Runnable {
        HeartbeatMonitor() {
        }

        public void run() {
            while (FSNamesystem.this.fsRunning) {
                try {
                    FSNamesystem.this.heartbeatCheck();
                }
                catch (Exception e) {
                    LOG.error((Object)StringUtils.stringifyException(e));
                }
                try {
                    Thread.sleep(FSNamesystem.this.heartbeatRecheckInterval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class ResolutionMonitor
    implements Runnable {
        private ResolutionMonitor() {
        }

        public void run() {
            try {
                while (FSNamesystem.this.fsRunning) {
                    try {
                        ArrayList datanodes = new ArrayList(FSNamesystem.this.resolutionQueue.size());
                        datanodes.add(FSNamesystem.this.resolutionQueue.take());
                        FSNamesystem.this.resolutionQueue.drainTo(datanodes);
                        ArrayList<String> dnHosts = new ArrayList<String>(datanodes.size());
                        for (DatanodeDescriptor d : datanodes) {
                            dnHosts.add(d.getName());
                        }
                        List<String> rName = FSNamesystem.this.dnsToSwitchMapping.resolve(dnHosts);
                        if (rName == null) {
                            LOG.error((Object)"The resolve call returned null! Using /default-rack for some hosts");
                            rName = new ArrayList<String>(dnHosts.size());
                            for (int i = 0; i < dnHosts.size(); ++i) {
                                rName.add("/default-rack");
                            }
                        }
                        int i = 0;
                        for (String m : rName) {
                            DatanodeDescriptor d = (DatanodeDescriptor)datanodes.get(i++);
                            d.setNetworkLocation(m);
                            FSNamesystem.this.clusterMap.add(d);
                        }
                    }
                    catch (InterruptedException e) {
                        LOG.debug((Object)("ResolutionMonitor thread received InterruptException. " + e));
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)StringUtils.stringifyException(e));
            }
        }
    }
}

