/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.FSNamesystem;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.util.MetricsIntValue;

public class FSNamesystemMetrics
implements Updater {
    private static Log log = LogFactory.getLog(FSNamesystemMetrics.class);
    private final MetricsRecord metricsRecord;
    private FSNamesystem fsNameSystem;
    public MetricsIntValue filesTotal = new MetricsIntValue("FilesTotal");
    public MetricsIntValue blocksTotal = new MetricsIntValue("BlocksTotal");
    public MetricsIntValue capacityTotalGB = new MetricsIntValue("CapacityTotalGB");
    public MetricsIntValue capacityUsedGB = new MetricsIntValue("CapacityUsedGB");
    public MetricsIntValue capacityRemainingGB = new MetricsIntValue("CapacityRemainingGB");
    public MetricsIntValue totalLoad = new MetricsIntValue("TotalLoad");
    public MetricsIntValue pendingReplicationBlocks = new MetricsIntValue("PendingReplicationBlocks");
    public MetricsIntValue underReplicatedBlocks = new MetricsIntValue("UnderReplicatedBlocks");
    public MetricsIntValue scheduledReplicationBlocks = new MetricsIntValue("ScheduledReplicationBlocks");

    FSNamesystemMetrics(Configuration conf, FSNamesystem fsNameSystem) {
        String sessionId = conf.get("session.id");
        this.fsNameSystem = fsNameSystem;
        MetricsContext metricsContext = MetricsUtil.getContext("dfs");
        this.metricsRecord = MetricsUtil.createRecord(metricsContext, "FSNamesystem");
        this.metricsRecord.setTag("sessionId", sessionId);
        metricsContext.registerUpdater(this);
        log.info((Object)("Initializing FSNamesystemMeterics using context object:" + metricsContext.getClass().getName()));
    }

    public void shutdown() {
        if (this.fsNameSystem != null) {
            this.fsNameSystem.shutdown();
        }
    }

    private int roundBytesToGBytes(long bytes) {
        return Math.round((float)bytes / 1.0737418E9f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdates(MetricsContext unused) {
        FSNamesystemMetrics fSNamesystemMetrics = this;
        synchronized (fSNamesystemMetrics) {
            this.filesTotal.set((int)this.fsNameSystem.getFilesTotal());
            this.filesTotal.pushMetric(this.metricsRecord);
            this.blocksTotal.set((int)this.fsNameSystem.getBlocksTotal());
            this.blocksTotal.pushMetric(this.metricsRecord);
            this.capacityTotalGB.set(this.roundBytesToGBytes(this.fsNameSystem.getCapacityTotal()));
            this.capacityTotalGB.pushMetric(this.metricsRecord);
            this.capacityUsedGB.set(this.roundBytesToGBytes(this.fsNameSystem.getCapacityUsed()));
            this.capacityUsedGB.pushMetric(this.metricsRecord);
            this.capacityRemainingGB.set(this.roundBytesToGBytes(this.fsNameSystem.getCapacityRemaining()));
            this.capacityRemainingGB.pushMetric(this.metricsRecord);
            this.totalLoad.set(this.fsNameSystem.getTotalLoad());
            this.totalLoad.pushMetric(this.metricsRecord);
            this.pendingReplicationBlocks.set((int)this.fsNameSystem.getPendingReplicationBlocks());
            this.pendingReplicationBlocks.pushMetric(this.metricsRecord);
            this.underReplicatedBlocks.set((int)this.fsNameSystem.getUnderReplicatedBlocks());
            this.underReplicatedBlocks.pushMetric(this.metricsRecord);
            this.scheduledReplicationBlocks.set((int)this.fsNameSystem.getScheduledReplicationBlocks());
            this.scheduledReplicationBlocks.pushMetric(this.metricsRecord);
        }
        this.metricsRecord.update();
    }
}

