/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.DatanodeProtocol;
import org.apache.hadoop.dfs.DatanodeStatsCommand;
import org.apache.hadoop.dfs.FSDataset;
import org.apache.hadoop.dfs.NamespaceInfo;
import org.apache.hadoop.dfs.UpgradeCommand;
import org.apache.hadoop.dfs.UpgradeObjectDatanode;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.util.StringUtils;

class GenerationStampUpgradeDatanode
extends UpgradeObjectDatanode {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.dfs.GenerationStampUpgrade");
    DatanodeProtocol namenode;
    InetSocketAddress namenodeAddr;
    private AtomicInteger blocksPreviouslyUpgraded = new AtomicInteger(0);
    private AtomicInteger blocksToUpgrade = new AtomicInteger(0);
    private AtomicInteger blocksUpgraded = new AtomicInteger(0);
    private AtomicInteger errors = new AtomicInteger(0);
    private static final int poolSize = 4;
    private static final int LONG_TIMEOUT_MILLISEC = 60000;
    static UpgradeCommand noUpgradeOnNamenode = new UpgradeCommand();
    private List<UpgradeExecutor> completedList = new LinkedList<UpgradeExecutor>();
    private AtomicBoolean offlineUpgrade = new AtomicBoolean(false);
    private AtomicBoolean upgradeCompleted = new AtomicBoolean(false);

    public int getVersion() {
        return -13;
    }

    public synchronized UpgradeCommand startUpgrade() throws IOException {
        if (this.offlineUpgrade.get()) {
            this.doUpgrade();
        }
        return null;
    }

    public String getDescription() {
        return "Block Generation Stamp Upgrade at Datanode";
    }

    public short getUpgradeStatus() {
        return this.blocksToUpgrade.get() == this.blocksUpgraded.get() ? (short)100 : (short)Math.floor((double)this.blocksUpgraded.get() * 100.0 / (double)this.blocksToUpgrade.get());
    }

    public UpgradeCommand completeUpgrade() throws IOException {
        assert (this.getUpgradeStatus() == 100);
        return new DatanodeStatsCommand(this.getUpgradeStatus(), this.getDatanode().dnRegistration, this.blocksPreviouslyUpgraded.get() + this.blocksUpgraded.get(), this.blocksToUpgrade.get() - this.blocksUpgraded.get(), this.errors.get(), -13);
    }

    boolean preUpgradeAction(NamespaceInfo nsInfo) throws IOException {
        int nsUpgradeVersion = nsInfo.getDistributedUpgradeVersion();
        if (nsUpgradeVersion >= this.getVersion()) {
            return false;
        }
        LOG.info((Object)"\n  This Datanode has missed a cluster wide Block generation Stamp Upgrade.\n  Will perform an 'offline' upgrade of the blocks.\n  During this time, Datanode does not heartbeat.");
        try {
            this.getDatanode().namenode.errorReport(this.getDatanode().dnRegistration, 0, "Performing an offline generation stamp upgrade. Will be back online once the ugprade completes. Please see datanode logs.");
        }
        catch (IOException ignored) {
            LOG.info((Object)"\n  This Datanode was unable to send error report to namenode.");
        }
        this.offlineUpgrade.set(true);
        return true;
    }

    public GenerationStampUpgradeDatanode() {
        this.blocksPreviouslyUpgraded.set(0);
        this.blocksToUpgrade.set(0);
        this.blocksUpgraded.set(0);
        this.errors.set(0);
    }

    static File getPreGenerationMetaFile(File f) {
        return new File(f.getAbsolutePath() + ".meta");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doUpgrade() throws IOException {
        Block[] blockArr;
        if (this.upgradeCompleted.get()) {
            assert (this.offlineUpgrade.get()) : "Multiple calls to doUpgrade is expected only during offline upgrade";
            return;
        }
        FSDataset dataset = (FSDataset)this.getDatanode().data;
        Configuration conf = new Configuration();
        conf.set("ipc.client.timeout", "60000");
        RetryPolicy timeoutPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep(60, 1L, TimeUnit.MILLISECONDS);
        HashMap<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap = new HashMap<Class<? extends Exception>, RetryPolicy>();
        exceptionToPolicyMap.put(SocketTimeoutException.class, timeoutPolicy);
        RetryPolicy methodPolicy = RetryPolicies.retryByException(RetryPolicies.TRY_ONCE_THEN_FAIL, exceptionToPolicyMap);
        HashMap<String, RetryPolicy> methodNameToPolicyMap = new HashMap<String, RetryPolicy>();
        methodNameToPolicyMap.put("processUpgradeCommand", methodPolicy);
        LOG.info((Object)("Starting Block Generation Stamp Upgrade on datanode " + this.getDatanode()));
        while (true) {
            try {
                this.namenodeAddr = this.getDatanode().getNameNodeAddr();
                this.namenode = (DatanodeProtocol)RetryProxy.create(DatanodeProtocol.class, (Object)RPC.waitForProxy(DatanodeProtocol.class, 15L, this.namenodeAddr, conf), methodNameToPolicyMap);
                break;
            }
            catch (IOException e) {
                LOG.warn((Object)("Generation Stamp Upgrade Exception while trying to connect to NameNode at " + this.getDatanode().getNameNodeAddr().toString() + " : " + StringUtils.stringifyException(e)));
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e1) {
                    throw new IOException("Interrupted Sleep while creating RPC proxy." + e1);
                }
            }
        }
        LOG.info((Object)("Block Generation Stamp Upgrade Datanode connected to namenode at " + this.namenodeAddr));
        LinkedList<UpgradeExecutor> blockList = new LinkedList<UpgradeExecutor>();
        for (Block b : blockArr = dataset.getBlockReport()) {
            File blockFile = null;
            try {
                blockFile = dataset.getBlockFile(b);
            }
            catch (IOException e) {
                LOG.warn((Object)("Could not find file location for " + b + ". It might already be deleted. Exception : " + StringUtils.stringifyException(e)));
                this.errors.getAndIncrement();
                continue;
            }
            if (!blockFile.exists()) {
                this.errors.getAndIncrement();
                LOG.error((Object)("could not find block file " + blockFile));
                continue;
            }
            File metaFile = dataset.getMetaFile(b);
            File oldMetaFile = GenerationStampUpgradeDatanode.getPreGenerationMetaFile(blockFile);
            if (metaFile.exists()) {
                this.blocksPreviouslyUpgraded.getAndIncrement();
                continue;
            }
            this.blocksToUpgrade.getAndIncrement();
            blockList.add(new UpgradeExecutor(b));
        }
        blockArr = null;
        int nLeft = blockList.size();
        LOG.info((Object)("Starting upgrade of " + this.blocksToUpgrade.get() + " blocks out of " + (this.blocksToUpgrade.get() + this.blocksPreviouslyUpgraded.get())));
        ExecutorService pool = Executors.newFixedThreadPool(4);
        Iterator it = blockList.iterator();
        while (it.hasNext()) {
            pool.submit((Runnable)it.next());
        }
        this.sendStatus();
        long now = System.currentTimeMillis();
        long statusReportIntervalMilliSec = 30000L;
        long lastStatusReportTime = now;
        long lastUpdateTime = now;
        long lastWarnTime = now;
        while (nLeft > 0) {
            List<UpgradeExecutor> list = this.completedList;
            synchronized (list) {
                if (this.completedList.size() <= 0) {
                    try {
                        this.completedList.wait(1000L);
                    }
                    catch (InterruptedException ignored) {
                        // empty catch block
                    }
                }
                now = System.currentTimeMillis();
                if (this.completedList.size() > 0) {
                    UpgradeExecutor exe = this.completedList.remove(0);
                    --nLeft;
                    if (exe.throwable != null) {
                        this.errors.getAndIncrement();
                        LOG.error((Object)("Got an exception during generation stamp upgrade of " + exe.block + ": " + StringUtils.stringifyException(exe.throwable)));
                    }
                    this.blocksUpgraded.getAndIncrement();
                    lastUpdateTime = now;
                } else if (now - lastUpdateTime >= 60000L && now - lastWarnTime >= 60000L) {
                    lastWarnTime = now;
                    LOG.warn((Object)"No block was updated in last 1 minutes! will keep waiting... ");
                }
            }
            if (now - lastStatusReportTime <= statusReportIntervalMilliSec) continue;
            this.sendStatus();
            lastStatusReportTime = System.currentTimeMillis();
        }
        pool.shutdown();
        this.upgradeCompleted.set(true);
        LOG.info((Object)("Completed Block Generation Stamp Upgrade. Total of " + (this.blocksPreviouslyUpgraded.get() + this.blocksToUpgrade.get()) + " blocks : " + this.blocksPreviouslyUpgraded.get() + " blocks previously " + "upgraded, " + this.blocksUpgraded.get() + " blocks upgraded this time " + "with " + this.errors.get() + " errors."));
        while (!this.sendStatus()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendStatus() {
        LOG.info((Object)((this.offlineUpgrade.get() ? "Offline " : "") + "Block Generation Stamp Upgrade : " + this.getUpgradeStatus() + "% completed."));
        if (this.offlineUpgrade.get()) {
            return true;
        }
        DatanodeStatsCommand cmd = null;
        GenerationStampUpgradeDatanode generationStampUpgradeDatanode = this;
        synchronized (generationStampUpgradeDatanode) {
            cmd = new DatanodeStatsCommand(this.getUpgradeStatus(), this.getDatanode().dnRegistration, this.blocksPreviouslyUpgraded.get() + this.blocksUpgraded.get(), this.blocksToUpgrade.get() - this.blocksUpgraded.get(), this.errors.get(), -13);
        }
        UpgradeCommand reply = GenerationStampUpgradeDatanode.sendCommand(this.namenodeAddr, this.namenode, cmd, 0);
        if (reply == null) {
            LOG.warn((Object)"Could not send status to Namenode. Namenode might be over loaded or down.");
        }
        return reply != null;
    }

    static UpgradeCommand sendCommand(InetSocketAddress namenodeAddr, DatanodeProtocol namenode, UpgradeCommand cmd, int retries) {
        for (int i = 0; i <= retries || retries < 0; ++i) {
            try {
                UpgradeCommand reply = namenode.processUpgradeCommand(cmd);
                if (reply == null) {
                    return noUpgradeOnNamenode;
                }
                return reply;
            }
            catch (IOException e) {
                LOG.warn((Object)("Exception to " + namenodeAddr + " while sending command " + cmd.getAction() + ": " + e + (retries < 0 || i >= retries ? "... will retry ..." : ": " + StringUtils.stringifyException(e))));
                continue;
            }
        }
        return null;
    }

    class UpgradeExecutor
    implements Runnable {
        Block block;
        Throwable throwable;

        UpgradeExecutor(Block b) {
            this.block = b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                FSDataset dataset = (FSDataset)GenerationStampUpgradeDatanode.this.getDatanode().data;
                this.upgradeToCurVersion(dataset, this.block);
            }
            catch (Throwable t) {
                this.throwable = t;
            }
            List list = GenerationStampUpgradeDatanode.this.completedList;
            synchronized (list) {
                GenerationStampUpgradeDatanode.this.completedList.add(this);
                GenerationStampUpgradeDatanode.this.completedList.notify();
            }
        }

        void upgradeToCurVersion(FSDataset dataset, Block block) throws IOException {
            File blockFile = dataset.getBlockFile(block);
            if (blockFile == null) {
                throw new IOException("Could find file for " + block);
            }
            File metadataFile = dataset.getMetaFile(block);
            File oldmetadataFile = GenerationStampUpgradeDatanode.getPreGenerationMetaFile(blockFile);
            if (metadataFile.exists() && oldmetadataFile.exists()) {
                if (metadataFile.length() == oldmetadataFile.length() && !oldmetadataFile.delete()) {
                    LOG.info((Object)("Unable to delete old metadata file " + oldmetadataFile));
                }
            } else {
                if (metadataFile.exists()) {
                    return;
                }
                if (oldmetadataFile.exists()) {
                    if (!oldmetadataFile.renameTo(metadataFile)) {
                        throw new IOException("Could find rename " + oldmetadataFile + " to " + metadataFile);
                    }
                } else {
                    throw new IOException("Could find any metadata file for " + block);
                }
            }
        }
    }
}

