/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.dfs.DFSFileInfo;
import org.apache.hadoop.dfs.DatanodeID;
import org.apache.hadoop.dfs.DatanodeInfo;
import org.apache.hadoop.dfs.DatanodeStatsCommand;
import org.apache.hadoop.dfs.GenerationStampUpgradeStatusReport;
import org.apache.hadoop.dfs.LocatedBlock;
import org.apache.hadoop.dfs.LocatedBlocks;
import org.apache.hadoop.dfs.UpgradeCommand;
import org.apache.hadoop.dfs.UpgradeObjectNamenode;
import org.apache.hadoop.dfs.UpgradeStatusReport;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.StringUtils;

class GenerationStampUpgradeNamenode
extends UpgradeObjectNamenode {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.dfs.GenerationStampUpgradeNamenode");
    static final long inactivityExtension = 10000L;
    AtomicLong lastNodeCompletionTime = new AtomicLong(0L);
    static final int PRE_GENERATIONSTAMP_LAYOUT_VERSION = -13;
    static final int DN_CMD_STATS = 300;
    UpgradeStatus upgradeStatus = UpgradeStatus.INITIALIZED;
    HashMap<DatanodeID, DnInfo> dnMap = new HashMap();
    HashMap<DatanodeID, DnInfo> unfinishedDnMap = new HashMap();
    Daemon monitorThread;
    double avgDatanodeCompletionPct = 0.0;
    boolean forceDnCompletion = false;
    private BlockLevelStats latestBlockLevelStats = new BlockLevelStats();

    public int getVersion() {
        return -13;
    }

    public UpgradeCommand completeUpgrade() throws IOException {
        return null;
    }

    public String getDescription() {
        return "Block Generation Stamp Upgrade at Namenode";
    }

    public synchronized short getUpgradeStatus() {
        if (this.upgradeStatus == UpgradeStatus.COMPLETED) {
            return 100;
        }
        return (short)this.avgDatanodeCompletionPct;
    }

    public UpgradeCommand startUpgrade() throws IOException {
        assert (this.monitorThread == null);
        this.lastNodeCompletionTime.set(System.currentTimeMillis());
        this.monitorThread = new Daemon(new UpgradeMonitor());
        this.monitorThread.start();
        return super.startUpgrade();
    }

    public synchronized void forceProceed() throws IOException {
        if (this.forceDnCompletion) {
            LOG.warn((Object)"forceProceed is already set for this upgrade. It can take a short while to take affect. Please wait.");
            return;
        }
        LOG.info((Object)"got forceProceed request for this upgrade. Datanodes upgrade will be considered done. It can take a few seconds to take effect.");
        this.forceDnCompletion = true;
    }

    UpgradeCommand processUpgradeCommand(UpgradeCommand command) throws IOException {
        switch (command.getAction()) {
            case 300: {
                return this.handleStatsCmd(command);
            }
        }
        throw new IOException("Unknown Command for Generation Stamp Upgrade : " + command.getAction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeStatusReport getUpgradeStatusReport(boolean details) throws IOException {
        String replyString = "";
        short status = 0;
        GenerationStampUpgradeNamenode generationStampUpgradeNamenode = this;
        synchronized (generationStampUpgradeNamenode) {
            status = this.getUpgradeStatus();
            replyString = String.format((this.monitorThread == null ? "\tUpgrade has not been started yet.\n" : "") + (this.forceDnCompletion ? "\tForce Proceed is ON\n" : "") + "\tLast Block Level Stats updated at : %tc\n" + "\tLast Block Level Stats : %s\n" + "\tBrief Datanode Status  : %s\n" + "%s", this.latestBlockLevelStats.updatedAt, this.latestBlockLevelStats.statusString("\n\t                         "), this.printStatus("\n\t                         "), status < 100 && this.upgradeStatus == UpgradeStatus.DATANODES_DONE ? "\tNOTE: Upgrade at the Datanodes has finished. Deleteing \".crc\" files\n\tcan take longer than status implies.\n" : "");
            if (details) {
                StringBuilder str = null;
                Iterator<DatanodeID> keys = this.dnMap.keySet().iterator();
                Iterator<DnInfo> values = this.dnMap.values().iterator();
                while (keys.hasNext() && values.hasNext()) {
                    DatanodeID dn = keys.next();
                    DnInfo info = values.next();
                    String dnStr = "\t\t" + dn.getName() + "\t : " + info.percentCompleted + " % \t" + info.blocksUpgraded + " u \t" + info.blocksRemaining + " r \t" + info.errors + " e\n";
                    if (str == null) {
                        str = new StringBuilder(dnStr.length() * (this.dnMap.size() + (this.dnMap.size() + 7) / 8));
                    }
                    str.append(dnStr);
                }
                replyString = replyString + "\n\tDatanode Stats (total: " + this.dnMap.size() + "): " + "pct Completion(%) blocks upgraded (u) " + "blocks remaining (r) errors (e)\n\n" + (str == null ? "\t\tThere are no known Datanodes\n" : str);
            }
        }
        return new GenerationStampUpgradeStatusReport(-13, status, replyString);
    }

    private synchronized UpgradeCommand handleStatsCmd(UpgradeCommand cmd) {
        boolean alreadyCompleted;
        DatanodeStatsCommand stats = (DatanodeStatsCommand)cmd;
        DatanodeID dn = stats.datanodeId;
        DnInfo dnInfo = this.dnMap.get(dn);
        boolean bl = alreadyCompleted = dnInfo != null && dnInfo.isDone();
        if (dnInfo == null) {
            dnInfo = new DnInfo();
            this.dnMap.put(dn, dnInfo);
            LOG.info((Object)("Upgrade started/resumed at datanode " + dn.getName()));
        }
        dnInfo.setStats(stats);
        if (!dnInfo.isDone()) {
            this.unfinishedDnMap.put(dn, dnInfo);
        }
        if (dnInfo.isDone() && !alreadyCompleted) {
            LOG.info((Object)("upgrade completed on datanode " + dn.getName()));
            this.unfinishedDnMap.remove(dn);
            if (this.unfinishedDnMap.size() == 0) {
                this.lastNodeCompletionTime.set(System.currentTimeMillis());
            }
        }
        return new UpgradeCommand();
    }

    synchronized boolean isUpgradeDone() {
        return this.upgradeStatus == UpgradeStatus.COMPLETED;
    }

    synchronized String printStatus(String spacing) {
        long errors = 0L;
        long totalCompletion = 0L;
        for (DnInfo dnInfo : this.dnMap.values()) {
            totalCompletion += (long)dnInfo.percentCompleted;
            errors += dnInfo.errors;
        }
        this.avgDatanodeCompletionPct = (double)totalCompletion / ((double)this.dnMap.size() + 1.0E-20);
        String msg = "Avg completion of all Datanodes: " + String.format("%.2f%%", this.avgDatanodeCompletionPct) + " with " + errors + " errors. " + (this.unfinishedDnMap.size() > 0 ? spacing + this.unfinishedDnMap.size() + " out of " + this.dnMap.size() + " nodes are not done." : "");
        LOG.info((Object)("Generation Stamp Upgrade is " + (this.isUpgradeDone() ? "complete. " : "still running. ") + spacing + msg));
        return msg;
    }

    private synchronized void setStatus(UpgradeStatus status) {
        this.upgradeStatus = status;
    }

    private synchronized UpgradeStatus checkOverallCompletion() {
        if (this.upgradeStatus == UpgradeStatus.COMPLETED || this.upgradeStatus == UpgradeStatus.DATANODES_DONE) {
            return this.upgradeStatus;
        }
        if (this.upgradeStatus != UpgradeStatus.DATANODES_DONE) {
            boolean datanodesDone;
            boolean bl = datanodesDone = this.dnMap.size() > 0 && this.unfinishedDnMap.size() == 0 && System.currentTimeMillis() - this.lastNodeCompletionTime.get() > 10000L || this.forceDnCompletion;
            if (datanodesDone) {
                LOG.info((Object)("Upgrade of DataNode blocks is complete. " + (this.forceDnCompletion ? "(ForceDnCompletion is on.)" : "")));
                this.upgradeStatus = UpgradeStatus.DATANODES_DONE;
            }
        }
        if (this.upgradeStatus != UpgradeStatus.DATANODES_DONE && this.latestBlockLevelStats.updatedAt > 0L && this.latestBlockLevelStats.minimallyReplicatedBlocks == 0L && this.latestBlockLevelStats.underReplicatedBlocks == 0L) {
            LOG.info((Object)("Marking datanode upgrade complete since all the blocks are upgraded (even though some datanodes may not have reported completion. Block level stats :\n\t" + this.latestBlockLevelStats.statusString("\n\t")));
            this.upgradeStatus = UpgradeStatus.DATANODES_DONE;
        }
        return this.upgradeStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateBlockLevelStats(String path, BlockLevelStats stats) {
        DFSFileInfo[] fileArr;
        for (DFSFileInfo file : fileArr = this.getFSNamesystem().dir.getListing(path)) {
            if (file.isDir()) {
                this.updateBlockLevelStats(file.getPath().toString(), stats);
                continue;
            }
            LocatedBlocks blockLoc = null;
            try {
                blockLoc = this.getFSNamesystem().getBlockLocations(file.getPath().toString(), 0L, file.getLen());
                int numBlocks = blockLoc.locatedBlockCount();
                for (int i = 0; i < numBlocks; ++i) {
                    LocatedBlock loc = blockLoc.get(i);
                    DatanodeInfo[] dnArr = loc.getLocations();
                    int numUpgraded = 0;
                    GenerationStampUpgradeNamenode generationStampUpgradeNamenode = this;
                    synchronized (generationStampUpgradeNamenode) {
                        for (DatanodeInfo dn : dnArr) {
                            DnInfo dnInfo = this.dnMap.get(dn);
                            if (dnInfo == null || !dnInfo.isDone()) continue;
                            ++numUpgraded;
                        }
                    }
                    if (numUpgraded >= file.getReplication()) {
                        ++stats.fullyReplicatedBlocks;
                    } else if (numUpgraded >= this.getFSNamesystem().getMinReplication()) {
                        ++stats.minimallyReplicatedBlocks;
                    } else {
                        ++stats.underReplicatedBlocks;
                    }
                    if (numUpgraded != 0) continue;
                    ++stats.unReplicatedBlocks;
                }
            }
            catch (IOException e) {
                LOG.error((Object)("BlockGenerationStampUpgrade: could not get block locations for " + file.getPath().toString() + " : " + StringUtils.stringifyException(e)));
                ++stats.errors;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateBlockLevelStats() {
        LOG.info((Object)"Starting update of block level stats. This could take a few minutes");
        BlockLevelStats stats = new BlockLevelStats();
        this.updateBlockLevelStats("/", stats);
        stats.updatedAt = System.currentTimeMillis();
        LOG.info((Object)("Block level stats:\n\t" + stats.statusString("\n\t")));
        GenerationStampUpgradeNamenode generationStampUpgradeNamenode = this;
        synchronized (generationStampUpgradeNamenode) {
            this.latestBlockLevelStats = stats;
        }
    }

    private static class BlockLevelStats {
        long fullyReplicatedBlocks = 0L;
        long minimallyReplicatedBlocks = 0L;
        long underReplicatedBlocks = 0L;
        long unReplicatedBlocks = 0L;
        long errors;
        long updatedAt;

        private BlockLevelStats() {
        }

        String statusString(String spacing) {
            long totalBlocks = this.fullyReplicatedBlocks + this.minimallyReplicatedBlocks + this.underReplicatedBlocks;
            double multiplier = 100.0 / ((double)totalBlocks + 1.0E-20);
            if (spacing.equals("")) {
                spacing = ", ";
            }
            return String.format("Total Blocks : %d%sFully Upgragraded : %.2f%%%sMinimally Upgraded : %.2f%%%sUnder Upgraded : %.2f%% (includes Un-upgraded blocks)%sUn-upgraded : %.2f%%%sErrors : %d", totalBlocks, spacing, (double)this.fullyReplicatedBlocks * multiplier, spacing, (double)this.minimallyReplicatedBlocks * multiplier, spacing, (double)this.underReplicatedBlocks * multiplier, spacing, (double)this.unReplicatedBlocks * multiplier, spacing, this.errors);
        }
    }

    class UpgradeMonitor
    implements Runnable {
        static final long statusReportIntervalMillis = 60000L;
        static final long blockReportIntervalMillis = 300000L;
        static final int sleepTimeSec = 5;

        UpgradeMonitor() {
        }

        public void run() {
            long lastReportTime;
            long lastBlockReportTime = lastReportTime = System.currentTimeMillis();
            while (!GenerationStampUpgradeNamenode.this.isUpgradeDone()) {
                long now;
                UpgradeStatus status = GenerationStampUpgradeNamenode.this.checkOverallCompletion();
                if (status == UpgradeStatus.DATANODES_DONE) {
                    GenerationStampUpgradeNamenode.this.setStatus(UpgradeStatus.COMPLETED);
                }
                if ((now = System.currentTimeMillis()) - lastBlockReportTime >= 300000L) {
                    GenerationStampUpgradeNamenode.this.updateBlockLevelStats();
                    lastBlockReportTime = now;
                }
                if (now - lastReportTime >= 60000L || GenerationStampUpgradeNamenode.this.isUpgradeDone()) {
                    GenerationStampUpgradeNamenode.this.printStatus("\n\t");
                    lastReportTime = now;
                }
                if (GenerationStampUpgradeNamenode.this.isUpgradeDone()) break;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            LOG.info((Object)"Leaving the Generation Stamp Upgrade Namenode monitor thread");
        }
    }

    class DnInfo {
        short percentCompleted = 0;
        long blocksUpgraded = 0L;
        long blocksRemaining = 0L;
        long errors = 0L;

        DnInfo(short pcCompleted) {
            this.percentCompleted = GenerationStampUpgradeNamenode.this.status;
        }

        DnInfo() {
        }

        void setStats(DatanodeStatsCommand cmd) {
            this.percentCompleted = cmd.getCurrentStatus();
            this.blocksUpgraded = cmd.blocksUpgraded;
            this.blocksRemaining = cmd.blocksRemaining;
            this.errors = cmd.errors;
        }

        boolean isDone() {
            return this.percentCompleted >= 100;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum UpgradeStatus {
        INITIALIZED,
        STARTED,
        DATANODES_DONE,
        COMPLETED;

    }
}

