/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.ListPathsServlet;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UnixUserGroupInformation;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class HftpFileSystem
extends FileSystem {
    protected InetSocketAddress nnAddr;
    protected UserGroupInformation ugi;
    protected static final SimpleDateFormat df;

    public void initialize(URI name, Configuration conf) throws IOException {
        this.setConf(conf);
        try {
            this.ugi = UnixUserGroupInformation.login(conf, true);
        }
        catch (LoginException le) {
            throw new IOException(StringUtils.stringifyException(le));
        }
        this.nnAddr = NetUtils.createSocketAddr(name.toString());
    }

    public URI getUri() {
        try {
            return new URI("hftp", null, this.nnAddr.getHostName(), this.nnAddr.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    protected HttpURLConnection openConnection(String path, String query) throws IOException {
        try {
            URL url = new URI("http", null, this.nnAddr.getHostName(), this.nnAddr.getPort(), path, query, null).toURL();
            return (HttpURLConnection)url.openConnection();
        }
        catch (URISyntaxException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public FSDataInputStream open(Path f, int buffersize) throws IOException {
        HttpURLConnection connection = null;
        connection = this.openConnection("/data" + f.toUri().getPath(), "ugi=" + this.ugi);
        connection.setRequestMethod("GET");
        connection.connect();
        final InputStream in = connection.getInputStream();
        return new FSDataInputStream(new FSInputStream(){

            public int read() throws IOException {
                return in.read();
            }

            public int read(byte[] b, int off, int len) throws IOException {
                return in.read(b, off, len);
            }

            public void close() throws IOException {
                in.close();
            }

            public void seek(long pos) throws IOException {
                throw new IOException("Can't seek!");
            }

            public long getPos() throws IOException {
                throw new IOException("Position unknown!");
            }

            public boolean seekToNewSource(long targetPos) throws IOException {
                return false;
            }
        });
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        LsParser lsparser = new LsParser();
        return lsparser.listStatus(f);
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        LsParser lsparser = new LsParser();
        return lsparser.getFileStatus(f);
    }

    public Path getWorkingDirectory() {
        return new Path("/").makeQualified(this);
    }

    public void setWorkingDirectory(Path f) {
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        throw new IOException("Not supported");
    }

    @Deprecated
    public boolean delete(Path f) throws IOException {
        throw new IOException("Not supported");
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        throw new IOException("Not supported");
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        throw new IOException("Not supported");
    }

    static {
        HttpURLConnection.setFollowRedirects(true);
        df = ListPathsServlet.df;
    }

    class LsParser
    extends DefaultHandler {
        ArrayList<FileStatus> fslist = new ArrayList();

        LsParser() {
        }

        public void startElement(String ns, String localname, String qname, Attributes attrs) throws SAXException {
            long modif;
            if ("listing".equals(qname)) {
                return;
            }
            if (!"file".equals(qname) && !"directory".equals(qname)) {
                throw new SAXException("Unrecognized entry: " + qname);
            }
            try {
                modif = df.parse(attrs.getValue("modified")).getTime();
            }
            catch (ParseException e) {
                throw new SAXException(e);
            }
            FileStatus fs = "file".equals(qname) ? new FileStatus(Long.valueOf(attrs.getValue("size")), false, Short.valueOf(attrs.getValue("replication")).shortValue(), Long.valueOf(attrs.getValue("blocksize")), modif, FsPermission.valueOf(attrs.getValue("permission")), attrs.getValue("owner"), attrs.getValue("group"), new Path(HftpFileSystem.this.getUri().toString(), attrs.getValue("path")).makeQualified(HftpFileSystem.this)) : new FileStatus(0L, true, 0, 0L, modif, FsPermission.valueOf(attrs.getValue("permission")), attrs.getValue("owner"), attrs.getValue("group"), new Path(HftpFileSystem.this.getUri().toString(), attrs.getValue("path")).makeQualified(HftpFileSystem.this));
            this.fslist.add(fs);
        }

        private void fetchList(String path, boolean recur) throws IOException {
            try {
                XMLReader xr = XMLReaderFactory.createXMLReader();
                xr.setContentHandler(this);
                HttpURLConnection connection = HftpFileSystem.this.openConnection("/listPaths" + path, "ugi=" + HftpFileSystem.this.ugi + (recur ? "&recursive=yes" : ""));
                connection.setRequestMethod("GET");
                connection.connect();
                InputStream resp = connection.getInputStream();
                xr.parse(new InputSource(resp));
            }
            catch (SAXException e) {
                IOException ie = new IOException("invalid xml directory content");
                ie.initCause(e);
                throw ie;
            }
        }

        public FileStatus getFileStatus(Path f) throws IOException {
            this.fetchList(f.toUri().getPath(), false);
            if (this.fslist.size() == 0) {
                throw new FileNotFoundException("File does not exist: " + f);
            }
            return this.fslist.get(0);
        }

        public FileStatus[] listStatus(Path f, boolean recur) throws IOException {
            this.fetchList(f.toUri().getPath(), recur);
            if (this.fslist.size() > 0 && (this.fslist.size() != 1 || this.fslist.get(0).isDir())) {
                this.fslist.remove(0);
            }
            return this.fslist.toArray(new FileStatus[0]);
        }

        public FileStatus[] listStatus(Path f) throws IOException {
            return this.listStatus(f, false);
        }
    }
}

