/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import org.apache.hadoop.dfs.INodeDirectory;
import org.apache.hadoop.dfs.QuotaExceededException;
import org.apache.hadoop.fs.permission.PermissionStatus;

class INodeDirectoryWithQuota
extends INodeDirectory {
    private long quota;
    private long count;

    INodeDirectoryWithQuota(long quota, INodeDirectory other) throws QuotaExceededException {
        super(other);
        this.count = other.numItemsInTree();
        this.setQuota(quota);
    }

    INodeDirectoryWithQuota(PermissionStatus permissions, long modificationTime, long quota) {
        super(permissions, modificationTime);
        this.quota = quota;
    }

    INodeDirectoryWithQuota(String name, PermissionStatus permissions, long quota) {
        super(name, permissions);
        this.quota = quota;
    }

    long getQuota() {
        return this.quota;
    }

    void setQuota(long quota) throws QuotaExceededException {
        INodeDirectoryWithQuota.verifyQuota(quota, this.count);
        this.quota = quota;
    }

    long numItemsInTree() {
        return this.count;
    }

    void updateNumItemsInTree(long delta) throws QuotaExceededException {
        long newCount = this.count + delta;
        if (delta > 0L) {
            INodeDirectoryWithQuota.verifyQuota(this.quota, newCount);
        }
        this.count = newCount;
    }

    void setCount(long count) throws QuotaExceededException {
        INodeDirectoryWithQuota.verifyQuota(this.quota, count);
        this.count = count;
    }

    private static void verifyQuota(long quota, long count) throws QuotaExceededException {
        if (quota < count) {
            throw new QuotaExceededException(quota, count);
        }
    }
}

