/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.BlocksMap;
import org.apache.hadoop.dfs.DatanodeDescriptor;
import org.apache.hadoop.dfs.INode;
import org.apache.hadoop.dfs.INodeFileUnderConstruction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class INodeFile
extends INode {
    static final FsPermission UMASK = FsPermission.createImmutable((short)73);
    protected BlocksMap.BlockInfo[] blocks = null;
    protected short blockReplication;
    protected long preferredBlockSize;

    INodeFile(PermissionStatus permissions, int nrBlocks, short replication, long modificationTime, long preferredBlockSize) {
        this(permissions, new BlocksMap.BlockInfo[nrBlocks], replication, modificationTime, preferredBlockSize);
    }

    protected INodeFile() {
        this.blocks = null;
        this.blockReplication = 0;
        this.preferredBlockSize = 0L;
    }

    protected INodeFile(PermissionStatus permissions, BlocksMap.BlockInfo[] blklist, short replication, long modificationTime, long preferredBlockSize) {
        super(permissions, modificationTime);
        this.blockReplication = replication;
        this.preferredBlockSize = preferredBlockSize;
        this.blocks = blklist;
    }

    @Override
    protected void setPermission(FsPermission permission) {
        super.setPermission(permission.applyUMask(UMASK));
    }

    @Override
    boolean isDirectory() {
        return false;
    }

    short getReplication() {
        return this.blockReplication;
    }

    void setReplication(short replication) {
        this.blockReplication = replication;
    }

    BlocksMap.BlockInfo[] getBlocks() {
        return this.blocks;
    }

    void addBlock(BlocksMap.BlockInfo newblock) {
        if (this.blocks == null) {
            this.blocks = new BlocksMap.BlockInfo[1];
            this.blocks[0] = newblock;
        } else {
            int size = this.blocks.length;
            BlocksMap.BlockInfo[] newlist = new BlocksMap.BlockInfo[size + 1];
            for (int i = 0; i < size; ++i) {
                newlist[i] = this.blocks[i];
            }
            newlist[size] = newblock;
            this.blocks = newlist;
        }
    }

    void setBlock(int idx, BlocksMap.BlockInfo blk) {
        this.blocks[idx] = blk;
    }

    @Override
    int collectSubtreeBlocksAndClear(List<Block> v) {
        this.parent = null;
        for (BlocksMap.BlockInfo blk : this.blocks) {
            v.add(blk);
        }
        this.blocks = null;
        return 1;
    }

    @Override
    long[] computeContentSummary(long[] summary) {
        long bytes = 0L;
        for (BlocksMap.BlockInfo blk : this.blocks) {
            bytes += blk.getNumBytes();
        }
        summary[0] = summary[0] + bytes;
        summary[1] = summary[1] + 1L;
        return summary;
    }

    long getPreferredBlockSize() {
        return this.preferredBlockSize;
    }

    Block getPenultimateBlock() {
        if (this.blocks == null || this.blocks.length <= 1) {
            return null;
        }
        return this.blocks[this.blocks.length - 2];
    }

    INodeFileUnderConstruction toINodeFileUnderConstruction(String clientName, String clientMachine, DatanodeDescriptor clientNode) throws IOException {
        if (this.isUnderConstruction()) {
            return (INodeFileUnderConstruction)this;
        }
        return new INodeFileUnderConstruction(this.name, this.blockReplication, this.modificationTime, this.preferredBlockSize, this.blocks, this.getPermissionStatus(), clientName, clientMachine, clientNode);
    }
}

