/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.IOException;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.BlocksMap;
import org.apache.hadoop.dfs.DatanodeDescriptor;
import org.apache.hadoop.dfs.INodeFile;
import org.apache.hadoop.dfs.NameNode;
import org.apache.hadoop.dfs.StringBytesWritable;
import org.apache.hadoop.fs.permission.PermissionStatus;

class INodeFileUnderConstruction
extends INodeFile {
    StringBytesWritable clientName = null;
    StringBytesWritable clientMachine = null;
    DatanodeDescriptor clientNode = null;
    private int primaryNodeIndex = -1;
    private DatanodeDescriptor[] targets = null;

    INodeFileUnderConstruction() {
    }

    INodeFileUnderConstruction(PermissionStatus permissions, short replication, long preferredBlockSize, long modTime, String clientName, String clientMachine, DatanodeDescriptor clientNode) throws IOException {
        super(permissions.applyUMask(UMASK), 0, replication, modTime, preferredBlockSize);
        this.clientName = new StringBytesWritable(clientName);
        this.clientMachine = new StringBytesWritable(clientMachine);
        this.clientNode = clientNode;
    }

    INodeFileUnderConstruction(byte[] name, short blockReplication, long modificationTime, long preferredBlockSize, BlocksMap.BlockInfo[] blocks, PermissionStatus perm, String clientName, String clientMachine, DatanodeDescriptor clientNode) throws IOException {
        super(perm, blocks, blockReplication, modificationTime, preferredBlockSize);
        this.setLocalName(name);
        this.clientName = new StringBytesWritable(clientName);
        this.clientMachine = new StringBytesWritable(clientMachine);
        this.clientNode = clientNode;
    }

    String getClientName() throws IOException {
        return this.clientName.getString();
    }

    String getClientMachine() throws IOException {
        return this.clientMachine.getString();
    }

    DatanodeDescriptor getClientNode() {
        return this.clientNode;
    }

    boolean isUnderConstruction() {
        return true;
    }

    DatanodeDescriptor[] getTargets() {
        return this.targets;
    }

    void setTargets(DatanodeDescriptor[] targets) {
        this.targets = targets;
        this.primaryNodeIndex = -1;
    }

    INodeFile convertToInodeFile() {
        INodeFile obj = new INodeFile(this.getPermissionStatus(), this.getBlocks(), this.getReplication(), this.getModificationTime(), this.getPreferredBlockSize());
        return obj;
    }

    void removeBlock(Block oldblock) throws IOException {
        if (this.blocks == null) {
            throw new IOException("Trying to delete non-existant block " + oldblock);
        }
        int size_1 = this.blocks.length - 1;
        if (!this.blocks[size_1].equals(oldblock)) {
            throw new IOException("Trying to delete non-last block " + oldblock);
        }
        BlocksMap.BlockInfo[] newlist = new BlocksMap.BlockInfo[size_1];
        System.arraycopy(this.blocks, 0, newlist, 0, size_1);
        this.blocks = newlist;
        this.targets = null;
    }

    void setLastBlock(BlocksMap.BlockInfo newblock, DatanodeDescriptor[] newtargets) throws IOException {
        if (this.blocks == null) {
            throw new IOException("Trying to update non-existant block (newblock=" + newblock + ")");
        }
        this.blocks[this.blocks.length - 1] = newblock;
        this.setTargets(newtargets);
    }

    void assignPrimaryDatanode() {
        if (this.targets.length == 0) {
            NameNode.stateChangeLog.warn((Object)"BLOCK* INodeFileUnderConstruction.initLeaseRecovery: No blocks found, lease removed.");
        }
        int previous = this.primaryNodeIndex;
        for (int i = 1; i <= this.targets.length; ++i) {
            int j = (previous + i) % this.targets.length;
            if (!this.targets[j].isAlive) continue;
            this.primaryNodeIndex = j;
            DatanodeDescriptor primary = this.targets[this.primaryNodeIndex];
            primary.addBlockToBeRecovered(this.blocks[this.blocks.length - 1], this.targets);
            NameNode.stateChangeLog.info((Object)("BLOCK* " + this.blocks[this.blocks.length - 1] + " recovery started."));
        }
    }
}

