/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.Block;
import org.apache.hadoop.dfs.BlockCommand;
import org.apache.hadoop.dfs.BlockListAsLongs;
import org.apache.hadoop.dfs.BlocksWithLocations;
import org.apache.hadoop.dfs.CheckpointSignature;
import org.apache.hadoop.dfs.ClientProtocol;
import org.apache.hadoop.dfs.DFSFileInfo;
import org.apache.hadoop.dfs.DatanodeCommand;
import org.apache.hadoop.dfs.DatanodeID;
import org.apache.hadoop.dfs.DatanodeInfo;
import org.apache.hadoop.dfs.DatanodeProtocol;
import org.apache.hadoop.dfs.DatanodeRegistration;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.FSImage;
import org.apache.hadoop.dfs.FSNamesystem;
import org.apache.hadoop.dfs.IncorrectVersionException;
import org.apache.hadoop.dfs.LocatedBlock;
import org.apache.hadoop.dfs.LocatedBlocks;
import org.apache.hadoop.dfs.NameNodeMetrics;
import org.apache.hadoop.dfs.NamenodeProtocol;
import org.apache.hadoop.dfs.NamespaceInfo;
import org.apache.hadoop.dfs.UnregisteredDatanodeException;
import org.apache.hadoop.dfs.UpgradeCommand;
import org.apache.hadoop.dfs.UpgradeStatusReport;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;

public class NameNode
implements ClientProtocol,
DatanodeProtocol,
NamenodeProtocol,
FSConstants {
    public static final int DEFAULT_PORT = 8020;
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.dfs.NameNode");
    public static final Log stateChangeLog = LogFactory.getLog((String)"org.apache.hadoop.dfs.StateChange");
    FSNamesystem namesystem;
    private Server server;
    private Thread emptier;
    private int handlerCount = 2;
    private InetSocketAddress nameNodeAddress = null;
    private boolean stopRequested = false;
    static NameNodeMetrics myMetrics;

    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (protocol.equals(ClientProtocol.class.getName())) {
            return 35L;
        }
        if (protocol.equals(DatanodeProtocol.class.getName())) {
            return 15L;
        }
        if (protocol.equals(NamenodeProtocol.class.getName())) {
            return 1L;
        }
        throw new IOException("Unknown protocol to name node: " + protocol);
    }

    public static void format(Configuration conf) throws IOException {
        NameNode.format(conf, false);
    }

    public static NameNodeMetrics getNameNodeMetrics() {
        return myMetrics;
    }

    static InetSocketAddress getAddress(String address) {
        return NetUtils.createSocketAddr(address, 8020);
    }

    static InetSocketAddress getAddress(Configuration conf) {
        return NameNode.getAddress(FileSystem.getDefaultUri(conf).getAuthority());
    }

    static URI getUri(InetSocketAddress namenode) {
        int port = namenode.getPort();
        String portString = port == 8020 ? "" : ":" + port;
        return URI.create("hdfs://" + namenode.getHostName() + portString);
    }

    private void initialize(String address, Configuration conf) throws IOException {
        InetSocketAddress socAddr = NameNode.getAddress(address);
        this.handlerCount = conf.getInt("dfs.namenode.handler.count", 10);
        this.server = RPC.getServer(this, socAddr.getHostName(), socAddr.getPort(), this.handlerCount, false, conf);
        this.nameNodeAddress = this.server.getListenerAddress();
        FileSystem.setDefaultUri(conf, NameNode.getUri(this.nameNodeAddress));
        LOG.info((Object)("Namenode up at: " + this.nameNodeAddress));
        myMetrics = new NameNodeMetrics(conf, this);
        this.namesystem = new FSNamesystem(this, conf);
        this.server.start();
        this.emptier = new Thread(new Trash(conf).getEmptier(), "Trash Emptier");
        this.emptier.setDaemon(true);
        this.emptier.start();
    }

    public NameNode(Configuration conf) throws IOException {
        this(FileSystem.getDefaultUri(conf).getAuthority(), conf);
    }

    public NameNode(String bindAddress, Configuration conf) throws IOException {
        try {
            this.initialize(bindAddress, conf);
        }
        catch (IOException e) {
            this.stop();
            throw e;
        }
    }

    public void join() {
        try {
            this.server.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stop() {
        if (this.stopRequested) {
            return;
        }
        this.stopRequested = true;
        if (this.namesystem != null) {
            this.namesystem.close();
        }
        if (this.emptier != null) {
            this.emptier.interrupt();
        }
        if (this.server != null) {
            this.server.stop();
        }
        if (myMetrics != null) {
            myMetrics.shutdown();
        }
        if (this.namesystem != null) {
            this.namesystem.shutdown();
        }
    }

    public BlocksWithLocations getBlocks(DatanodeInfo datanode, long size) throws IOException {
        if (size <= 0L) {
            throw new IllegalArgumentException("Unexpected not positive size: " + size);
        }
        return this.namesystem.getBlocks(datanode, size);
    }

    public LocatedBlocks getBlockLocations(String src, long offset, long length) throws IOException {
        NameNode.myMetrics.numGetBlockLocations.inc();
        return this.namesystem.getBlockLocations(NameNode.getClientMachine(), src, offset, length);
    }

    private static String getClientMachine() {
        String clientMachine = Server.getRemoteAddress();
        if (clientMachine == null) {
            clientMachine = "";
        }
        return clientMachine;
    }

    public void create(String src, FsPermission masked, String clientName, boolean overwrite, short replication, long blockSize) throws IOException {
        String clientMachine = NameNode.getClientMachine();
        stateChangeLog.debug((Object)("*DIR* NameNode.create: file " + src + " for " + clientName + " at " + clientMachine));
        if (!this.checkPathLength(src)) {
            throw new IOException("create: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        this.namesystem.startFile(src, new PermissionStatus(UserGroupInformation.getCurrentUGI().getUserName(), null, masked), clientName, clientMachine, overwrite, replication, blockSize);
        NameNode.myMetrics.numFilesCreated.inc();
    }

    void append(String src, String clientName) throws IOException {
        String clientMachine = NameNode.getClientMachine();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug((Object)("*DIR* NameNode.append: file " + src + " for " + clientName + " at " + clientMachine));
        }
        this.namesystem.appendFileInternal(src, clientName, clientMachine);
    }

    public boolean setReplication(String src, short replication) throws IOException {
        return this.namesystem.setReplication(src, replication);
    }

    public void setPermission(String src, FsPermission permissions) throws IOException {
        this.namesystem.setPermission(src, permissions);
    }

    public void setOwner(String src, String username, String groupname) throws IOException {
        this.namesystem.setOwner(src, username, groupname);
    }

    public LocatedBlock addBlock(String src, String clientName) throws IOException {
        stateChangeLog.debug((Object)("*BLOCK* NameNode.addBlock: file " + src + " for " + clientName));
        return this.namesystem.getAdditionalBlock(src, clientName);
    }

    public void abandonBlock(Block b, String src, String holder) throws IOException {
        stateChangeLog.debug((Object)("*BLOCK* NameNode.abandonBlock: " + b + " of file " + src));
        if (!this.namesystem.abandonBlock(b, src, holder)) {
            throw new IOException("Cannot abandon block during write to " + src);
        }
    }

    public boolean complete(String src, String clientName) throws IOException {
        stateChangeLog.debug((Object)("*DIR* NameNode.complete: " + src + " for " + clientName));
        int returnCode = this.namesystem.completeFile(src, clientName);
        if (returnCode == 1) {
            return false;
        }
        if (returnCode == 2) {
            return true;
        }
        throw new IOException("Could not complete write to file " + src + " by " + clientName);
    }

    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        stateChangeLog.info((Object)"*DIR* NameNode.reportBadBlocks");
        for (int i = 0; i < blocks.length; ++i) {
            Block blk = blocks[i].getBlock();
            DatanodeInfo[] nodes = blocks[i].getLocations();
            for (int j = 0; j < nodes.length; ++j) {
                DatanodeInfo dn = nodes[j];
                this.namesystem.markBlockAsCorrupt(blk, dn);
            }
        }
    }

    public long nextGenerationStamp(Block block) throws IOException {
        return this.namesystem.nextGenerationStampForBlock(block);
    }

    public void commitBlockSynchronization(Block block, long newgenerationstamp, long newlength, boolean closeFile, boolean deleteblock, DatanodeID[] newtargets) throws IOException {
        this.namesystem.commitBlockSynchronization(block, newgenerationstamp, newlength, closeFile, deleteblock, newtargets);
    }

    public long getPreferredBlockSize(String filename) throws IOException {
        return this.namesystem.getPreferredBlockSize(filename);
    }

    public boolean rename(String src, String dst) throws IOException {
        stateChangeLog.debug((Object)("*DIR* NameNode.rename: " + src + " to " + dst));
        if (!this.checkPathLength(dst)) {
            throw new IOException("rename: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        boolean ret = this.namesystem.renameTo(src, dst);
        if (ret) {
            NameNode.myMetrics.numFilesRenamed.inc();
        }
        return ret;
    }

    @Deprecated
    public boolean delete(String src) throws IOException {
        stateChangeLog.debug((Object)("*DIR* NameNode.delete: " + src));
        return this.namesystem.delete(src);
    }

    public boolean delete(String src, boolean recursive) throws IOException {
        stateChangeLog.debug((Object)("*DIR* Namenode.delete:  " + src));
        return this.namesystem.delete(src, recursive);
    }

    private boolean checkPathLength(String src) {
        Path srcPath = new Path(src);
        return src.length() <= 8000 && srcPath.depth() <= 1000;
    }

    public boolean mkdirs(String src, FsPermission masked) throws IOException {
        stateChangeLog.debug((Object)("*DIR* NameNode.mkdirs: " + src));
        if (!this.checkPathLength(src)) {
            throw new IOException("mkdirs: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        return this.namesystem.mkdirs(src, new PermissionStatus(UserGroupInformation.getCurrentUGI().getUserName(), null, masked));
    }

    public void renewLease(String clientName) throws IOException {
        this.namesystem.renewLease(clientName);
    }

    public DFSFileInfo[] getListing(String src) throws IOException {
        DFSFileInfo[] files = this.namesystem.getListing(src);
        if (files != null) {
            NameNode.myMetrics.numFilesListed.inc(files.length);
        }
        return files;
    }

    public DFSFileInfo getFileInfo(String src) throws IOException {
        return this.namesystem.getFileInfo(src);
    }

    public long[] getStats() throws IOException {
        return this.namesystem.getStats();
    }

    public DatanodeInfo[] getDatanodeReport(FSConstants.DatanodeReportType type) throws IOException {
        DatanodeInfo[] results = this.namesystem.datanodeReport(type);
        if (results == null) {
            throw new IOException("Cannot find datanode report");
        }
        return results;
    }

    public boolean setSafeMode(FSConstants.SafeModeAction action) throws IOException {
        return this.namesystem.setSafeMode(action);
    }

    public boolean isInSafeMode() {
        return this.namesystem.isInSafeMode();
    }

    public void refreshNodes() throws IOException {
        this.namesystem.refreshNodes();
    }

    public long getEditLogSize() throws IOException {
        return this.namesystem.getEditLogSize();
    }

    public CheckpointSignature rollEditLog() throws IOException {
        return this.namesystem.rollEditLog();
    }

    public void rollFsImage() throws IOException {
        this.namesystem.rollFSImage();
    }

    public void finalizeUpgrade() throws IOException {
        this.namesystem.finalizeUpgrade();
    }

    public UpgradeStatusReport distributedUpgradeProgress(FSConstants.UpgradeAction action) throws IOException {
        return this.namesystem.distributedUpgradeProgress(action);
    }

    public void metaSave(String filename) throws IOException {
        this.namesystem.metaSave(filename);
    }

    public ContentSummary getContentSummary(String path) throws IOException {
        return this.namesystem.getContentSummary(path);
    }

    public void setQuota(String path, long quota) throws IOException {
        this.namesystem.setQuota(path, quota);
    }

    public void clearQuota(String path) throws IOException {
        this.namesystem.clearQuota(path);
    }

    public void fsync(String src, String clientName) throws IOException {
        this.namesystem.fsync(src, clientName);
    }

    public DatanodeRegistration register(DatanodeRegistration nodeReg) throws IOException {
        this.verifyVersion(nodeReg.getVersion());
        this.namesystem.registerDatanode(nodeReg);
        return nodeReg;
    }

    public DatanodeCommand sendHeartbeat(DatanodeRegistration nodeReg, long capacity, long dfsUsed, long remaining, int xmitsInProgress, int xceiverCount) throws IOException {
        this.verifyRequest(nodeReg);
        return this.namesystem.handleHeartbeat(nodeReg, capacity, dfsUsed, remaining, xceiverCount, xmitsInProgress);
    }

    public DatanodeCommand blockReport(DatanodeRegistration nodeReg, long[] blocks) throws IOException {
        this.verifyRequest(nodeReg);
        BlockListAsLongs blist = new BlockListAsLongs(blocks);
        stateChangeLog.debug((Object)("*BLOCK* NameNode.blockReport: from " + nodeReg.getName() + " " + blist.getNumberOfBlocks() + " blocks"));
        Block[] blocksToDelete = this.namesystem.processReport(nodeReg, blist);
        if (blocksToDelete != null && blocksToDelete.length > 0) {
            return new BlockCommand(2, blocksToDelete);
        }
        if (this.getFSImage().isUpgradeFinalized()) {
            return DatanodeCommand.FINALIZE;
        }
        return null;
    }

    public void blockReceived(DatanodeRegistration nodeReg, Block[] blocks, String[] delHints) throws IOException {
        this.verifyRequest(nodeReg);
        stateChangeLog.debug((Object)("*BLOCK* NameNode.blockReceived: from " + nodeReg.getName() + " " + blocks.length + " blocks."));
        for (int i = 0; i < blocks.length; ++i) {
            this.namesystem.blockReceived(nodeReg, blocks[i], delHints[i]);
        }
    }

    public void errorReport(DatanodeRegistration nodeReg, int errorCode, String msg) throws IOException {
        String dnName = nodeReg == null ? "unknown DataNode" : nodeReg.getName();
        LOG.info((Object)("Error report from " + dnName + ": " + msg));
        if (errorCode == 0) {
            return;
        }
        this.verifyRequest(nodeReg);
        if (errorCode == 1) {
            this.namesystem.removeDatanode(nodeReg);
        }
    }

    public NamespaceInfo versionRequest() throws IOException {
        return this.namesystem.getNamespaceInfo();
    }

    public UpgradeCommand processUpgradeCommand(UpgradeCommand comm) throws IOException {
        return this.namesystem.processDistributedUpgradeCommand(comm);
    }

    public void verifyRequest(DatanodeRegistration nodeReg) throws IOException {
        this.verifyVersion(nodeReg.getVersion());
        if (!this.namesystem.getRegistrationID().equals(nodeReg.getRegistrationID())) {
            throw new UnregisteredDatanodeException(nodeReg);
        }
    }

    public void verifyVersion(int version) throws IOException {
        if (version != -16) {
            throw new IncorrectVersionException(version, "data node");
        }
    }

    public File getFsImageName() throws IOException {
        return this.getFSImage().getFsImageName();
    }

    FSImage getFSImage() {
        return this.namesystem.dir.fsImage;
    }

    public File[] getFsImageNameCheckpoint() throws IOException {
        return this.getFSImage().getFsImageNameCheckpoint();
    }

    public InetSocketAddress getNameNodeAddress() {
        return this.nameNodeAddress;
    }

    NetworkTopology getNetworkTopology() {
        return this.namesystem.clusterMap;
    }

    private static boolean format(Configuration conf, boolean isConfirmationNeeded) throws IOException {
        Collection<File> dirsToFormat = FSNamesystem.getNamespaceDirs(conf);
        for (File curDir : dirsToFormat) {
            if (!curDir.exists() || !isConfirmationNeeded) continue;
            System.err.print("Re-format filesystem in " + curDir + " ? (Y or N) ");
            if (System.in.read() != 89) {
                System.err.println("Format aborted in " + curDir);
                return true;
            }
            while (System.in.read() != 10) {
            }
        }
        FSNamesystem nsys = new FSNamesystem(new FSImage(dirsToFormat), conf);
        nsys.dir.fsImage.format();
        return false;
    }

    private static boolean finalize(Configuration conf, boolean isConfirmationNeeded) throws IOException {
        Collection<File> dirsToFormat = FSNamesystem.getNamespaceDirs(conf);
        FSNamesystem nsys = new FSNamesystem(new FSImage(dirsToFormat), conf);
        System.err.print("\"finalize\" will remove the previous state of the files system.\nRecent upgrade will become permanent.\nRollback option will not be available anymore.\n");
        if (isConfirmationNeeded) {
            System.err.print("Finalize filesystem state ? (Y or N) ");
            if (System.in.read() != 89) {
                System.err.println("Finalize aborted.");
                return true;
            }
            while (System.in.read() != 10) {
            }
        }
        nsys.dir.fsImage.finalizeUpgrade();
        return false;
    }

    private static void printUsage() {
        System.err.println("Usage: java NameNode [" + FSConstants.StartupOption.FORMAT.getName() + "] | [" + FSConstants.StartupOption.UPGRADE.getName() + "] | [" + FSConstants.StartupOption.ROLLBACK.getName() + "] | [" + FSConstants.StartupOption.FINALIZE.getName() + "] | [" + FSConstants.StartupOption.IMPORT.getName() + "]");
    }

    private static FSConstants.StartupOption parseArguments(String[] args, Configuration conf) {
        int argsLen = args == null ? 0 : args.length;
        FSConstants.StartupOption startOpt = FSConstants.StartupOption.REGULAR;
        for (int i = 0; i < argsLen; ++i) {
            String cmd = args[i];
            if (FSConstants.StartupOption.FORMAT.getName().equalsIgnoreCase(cmd)) {
                startOpt = FSConstants.StartupOption.FORMAT;
                continue;
            }
            if (FSConstants.StartupOption.REGULAR.getName().equalsIgnoreCase(cmd)) {
                startOpt = FSConstants.StartupOption.REGULAR;
                continue;
            }
            if (FSConstants.StartupOption.UPGRADE.getName().equalsIgnoreCase(cmd)) {
                startOpt = FSConstants.StartupOption.UPGRADE;
                continue;
            }
            if (FSConstants.StartupOption.ROLLBACK.getName().equalsIgnoreCase(cmd)) {
                startOpt = FSConstants.StartupOption.ROLLBACK;
                continue;
            }
            if (FSConstants.StartupOption.FINALIZE.getName().equalsIgnoreCase(cmd)) {
                startOpt = FSConstants.StartupOption.FINALIZE;
                continue;
            }
            if (FSConstants.StartupOption.IMPORT.getName().equalsIgnoreCase(cmd)) {
                startOpt = FSConstants.StartupOption.IMPORT;
                continue;
            }
            return null;
        }
        NameNode.setStartupOption(conf, startOpt);
        return startOpt;
    }

    private static void setStartupOption(Configuration conf, FSConstants.StartupOption opt) {
        conf.set("dfs.namenode.startup", opt.toString());
    }

    static FSConstants.StartupOption getStartupOption(Configuration conf) {
        return FSConstants.StartupOption.valueOf(conf.get("dfs.namenode.startup", FSConstants.StartupOption.REGULAR.toString()));
    }

    static NameNode createNameNode(String[] argv, Configuration conf) throws IOException {
        FSConstants.StartupOption startOpt;
        if (conf == null) {
            conf = new Configuration();
        }
        if ((startOpt = NameNode.parseArguments(argv, conf)) == null) {
            NameNode.printUsage();
            return null;
        }
        switch (startOpt) {
            case FORMAT: {
                boolean aborted = NameNode.format(conf, true);
                System.exit(aborted ? 1 : 0);
            }
            case FINALIZE: {
                boolean aborted = NameNode.finalize(conf, true);
                System.exit(aborted ? 1 : 0);
            }
        }
        NameNode namenode = new NameNode(conf);
        return namenode;
    }

    public static void main(String[] argv) throws Exception {
        try {
            StringUtils.startupShutdownMessage(NameNode.class, argv, LOG);
            NameNode namenode = NameNode.createNameNode(argv, null);
            if (namenode != null) {
                namenode.join();
            }
        }
        catch (Throwable e) {
            LOG.error((Object)StringUtils.stringifyException(e));
            System.exit(-1);
        }
    }
}

