/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.IOException;

public final class QuotaExceededException
extends IOException {
    private static final long serialVersionUID = 1L;
    private String pathName;
    private long quota;
    private long count;

    public QuotaExceededException(String msg) {
        super(msg);
    }

    public QuotaExceededException(long quota, long count) {
        this.quota = quota;
        this.count = count;
    }

    public void setPathName(String path) {
        this.pathName = path;
    }

    public String getMessage() {
        String msg = super.getMessage();
        if (msg == null) {
            return "The quota" + (this.pathName == null ? "" : " of " + this.pathName) + " is exceeded: quota=" + this.quota + " count=" + this.count;
        }
        return msg;
    }
}

