/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.CheckpointSignature;
import org.apache.hadoop.dfs.ClientProtocol;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.FSImage;
import org.apache.hadoop.dfs.FSNamesystem;
import org.apache.hadoop.dfs.GetImageServlet;
import org.apache.hadoop.dfs.InconsistentFSStateException;
import org.apache.hadoop.dfs.NameNode;
import org.apache.hadoop.dfs.Storage;
import org.apache.hadoop.dfs.TransferFsImage;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.mapred.StatusHttpServer;
import org.apache.hadoop.metrics.jvm.JvmMetrics;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.StringUtils;

public class SecondaryNameNode
implements FSConstants,
Runnable {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.dfs.NameNode.Secondary");
    private String fsName;
    private CheckpointStorage checkpointImage;
    private ClientProtocol namenode;
    private Configuration conf;
    private InetSocketAddress nameNodeAddr;
    private boolean shouldRun;
    private StatusHttpServer infoServer;
    private int infoPort;
    private String infoBindAddress;
    private Collection<File> checkpointDirs;
    private long checkpointPeriod;
    private long checkpointSize;

    FSImage getFSImage() {
        return this.checkpointImage;
    }

    SecondaryNameNode(Configuration conf) throws IOException {
        try {
            this.initialize(conf);
        }
        catch (IOException e) {
            this.shutdown();
            throw e;
        }
    }

    private void initialize(Configuration conf) throws IOException {
        JvmMetrics.init("SecondaryNameNode", conf.get("session.id"));
        this.shouldRun = true;
        this.nameNodeAddr = NameNode.getAddress(conf);
        this.conf = conf;
        this.namenode = (ClientProtocol)RPC.waitForProxy(ClientProtocol.class, 35L, this.nameNodeAddr, conf);
        this.fsName = this.getInfoServer();
        this.checkpointDirs = FSImage.getCheckpointDirs(conf, "/tmp/hadoop/dfs/namesecondary");
        this.checkpointImage = new CheckpointStorage();
        this.checkpointImage.recoverCreate(this.checkpointDirs);
        this.checkpointPeriod = conf.getLong("fs.checkpoint.period", 3600L);
        this.checkpointSize = conf.getLong("fs.checkpoint.size", 0x400000L);
        String infoAddr = NetUtils.getServerAddress(conf, "dfs.secondary.info.bindAddress", "dfs.secondary.info.port", "dfs.secondary.http.address");
        InetSocketAddress infoSocAddr = NetUtils.createSocketAddr(infoAddr);
        this.infoBindAddress = infoSocAddr.getHostName();
        int tmpInfoPort = infoSocAddr.getPort();
        this.infoServer = new StatusHttpServer("secondary", this.infoBindAddress, tmpInfoPort, tmpInfoPort == 0);
        this.infoServer.setAttribute("name.system.image", this.checkpointImage);
        this.infoServer.setAttribute("name.conf", conf);
        this.infoServer.addServlet("getimage", "/getimage", GetImageServlet.class);
        this.infoServer.start();
        this.infoPort = this.infoServer.getPort();
        conf.set("dfs.secondary.http.address", this.infoBindAddress + ":" + this.infoPort);
        LOG.info((Object)("Secondary Web-server up at: " + this.infoBindAddress + ":" + this.infoPort));
        LOG.warn((Object)("Checkpoint Period   :" + this.checkpointPeriod + " secs " + "(" + this.checkpointPeriod / 60L + " min)"));
        LOG.warn((Object)("Log Size Trigger    :" + this.checkpointSize + " bytes " + "(" + this.checkpointSize / 1024L + " KB)"));
    }

    public void shutdown() {
        this.shouldRun = false;
        try {
            if (this.infoServer != null) {
                this.infoServer.stop();
            }
        }
        catch (InterruptedException ie) {
            LOG.warn((Object)StringUtils.stringifyException(ie));
        }
        try {
            if (this.checkpointImage != null) {
                this.checkpointImage.close();
            }
        }
        catch (IOException e) {
            LOG.warn((Object)StringUtils.stringifyException(e));
        }
    }

    public void run() {
        long period = 300L;
        long lastCheckpointTime = 0L;
        if (this.checkpointPeriod < period) {
            period = this.checkpointPeriod;
        }
        while (this.shouldRun) {
            try {
                Thread.sleep(1000L * period);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (!this.shouldRun) break;
            try {
                long now = System.currentTimeMillis();
                long size = this.namenode.getEditLogSize();
                if (size < this.checkpointSize && now < lastCheckpointTime + 1000L * this.checkpointPeriod) continue;
                this.doCheckpoint();
                lastCheckpointTime = now;
            }
            catch (IOException e) {
                LOG.error((Object)"Exception in doCheckpoint: ");
                LOG.error((Object)StringUtils.stringifyException(e));
                e.printStackTrace();
            }
            catch (Throwable e) {
                LOG.error((Object)"Throwable Exception in doCheckpoint: ");
                LOG.error((Object)StringUtils.stringifyException(e));
                e.printStackTrace();
                Runtime.getRuntime().exit(-1);
            }
        }
    }

    private void downloadCheckpointFiles(CheckpointSignature sig) throws IOException {
        this.checkpointImage.cTime = sig.cTime;
        this.checkpointImage.checkpointTime = sig.checkpointTime;
        String fileid = "getimage=1";
        File[] srcNames = this.checkpointImage.getImageFiles();
        assert (srcNames.length > 0) : "No checkpoint targets.";
        TransferFsImage.getFileClient(this.fsName, fileid, srcNames);
        LOG.info((Object)("Downloaded file " + srcNames[0].getName() + " size " + srcNames[0].length() + " bytes."));
        fileid = "getedit=1";
        srcNames = this.checkpointImage.getEditsFiles();
        assert (srcNames.length > 0) : "No checkpoint targets.";
        TransferFsImage.getFileClient(this.fsName, fileid, srcNames);
        LOG.info((Object)("Downloaded file " + srcNames[0].getName() + " size " + srcNames[0].length() + " bytes."));
        this.checkpointImage.checkpointUploadDone();
    }

    private void putFSImage(CheckpointSignature sig) throws IOException {
        String fileid = "putimage=1&port=" + this.infoPort + "&machine=" + InetAddress.getLocalHost().getHostAddress() + "&token=" + sig.toString();
        LOG.info((Object)("Posted URL " + this.fsName + fileid));
        TransferFsImage.getFileClient(this.fsName, fileid, null);
    }

    private String getInfoServer() throws IOException {
        URI fsName = FileSystem.getDefaultUri(this.conf);
        if (!"hdfs".equals(fsName.getScheme())) {
            throw new IOException("This is not a DFS");
        }
        return NetUtils.getServerAddress(this.conf, "dfs.info.bindAddress", "dfs.info.port", "dfs.http.address");
    }

    void doCheckpoint() throws IOException {
        this.startCheckpoint();
        CheckpointSignature sig = this.namenode.rollEditLog();
        if (ErrorSimulator.getErrorSimulation(0)) {
            throw new IOException("Simulating error0 after creating edits.new");
        }
        this.downloadCheckpointFiles(sig);
        this.doMerge(sig);
        this.putFSImage(sig);
        if (ErrorSimulator.getErrorSimulation(1)) {
            throw new IOException("Simulating error1 after uploading new image to NameNode");
        }
        this.namenode.rollFsImage();
        this.checkpointImage.endCheckpoint();
        LOG.warn((Object)("Checkpoint done. New Image Size: " + this.checkpointImage.getFsImageName().length()));
    }

    private void startCheckpoint() throws IOException {
        this.checkpointImage.unlockAll();
        this.checkpointImage.getEditLog().close();
        this.checkpointImage.recoverCreate(this.checkpointDirs);
        this.checkpointImage.startCheckpoint();
    }

    private void doMerge(CheckpointSignature sig) throws IOException {
        FSNamesystem namesystem = new FSNamesystem(this.checkpointImage, this.conf);
        assert (namesystem.dir.fsImage == this.checkpointImage);
        this.checkpointImage.doMerge(sig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processArgs(String[] argv) throws Exception {
        int exitCode;
        block18: {
            String cmd;
            if (argv.length < 1) {
                this.printUsage("");
                return -1;
            }
            exitCode = -1;
            int i = 0;
            if ("-geteditsize".equals(cmd = argv[i++])) {
                if (argv.length != 1) {
                    this.printUsage(cmd);
                    return exitCode;
                }
            } else if ("-checkpoint".equals(cmd)) {
                if (argv.length != 1 && argv.length != 2) {
                    this.printUsage(cmd);
                    return exitCode;
                }
                if (argv.length == 2 && !"force".equals(argv[i])) {
                    this.printUsage(cmd);
                    return exitCode;
                }
            }
            exitCode = 0;
            try {
                if ("-checkpoint".equals(cmd)) {
                    long size = this.namenode.getEditLogSize();
                    if (size >= this.checkpointSize || argv.length == 2 && "force".equals(argv[i])) {
                        this.doCheckpoint();
                    } else {
                        System.err.println("EditLog size " + size + " bytes is " + "smaller than configured checkpoint " + "size " + this.checkpointSize + " bytes.");
                        System.err.println("Skipping checkpoint.");
                    }
                    break block18;
                }
                if ("-geteditsize".equals(cmd)) {
                    long size = this.namenode.getEditLogSize();
                    System.out.println("EditLog size is " + size + " bytes");
                    break block18;
                }
                exitCode = -1;
                LOG.error((Object)(cmd.substring(1) + ": Unknown command"));
                this.printUsage("");
            }
            catch (RemoteException e) {
                exitCode = -1;
                try {
                    String[] content = e.getLocalizedMessage().split("\n");
                    LOG.error((Object)(cmd.substring(1) + ": " + content[0]));
                }
                catch (Exception ex) {
                    LOG.error((Object)(cmd.substring(1) + ": " + ex.getLocalizedMessage()));
                }
            }
            catch (IOException e) {
                exitCode = -1;
                LOG.error((Object)(cmd.substring(1) + ": " + e.getLocalizedMessage()));
            }
        }
        return exitCode;
    }

    private void printUsage(String cmd) {
        if ("-geteditsize".equals(cmd)) {
            System.err.println("Usage: java SecondaryNameNode [-geteditsize]");
        } else if ("-checkpoint".equals(cmd)) {
            System.err.println("Usage: java SecondaryNameNode [-checkpoint [force]]");
        } else {
            System.err.println("Usage: java SecondaryNameNode [-checkpoint [force]] [-geteditsize] ");
        }
    }

    public static void main(String[] argv) throws Exception {
        StringUtils.startupShutdownMessage(SecondaryNameNode.class, argv, LOG);
        Configuration tconf = new Configuration();
        if (argv.length >= 1) {
            SecondaryNameNode secondary = new SecondaryNameNode(tconf);
            int ret = secondary.processArgs(argv);
            System.exit(ret);
        }
        Daemon checkpointThread = new Daemon(new SecondaryNameNode(tconf));
        checkpointThread.start();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CheckpointStorage
    extends FSImage {
        CheckpointStorage() throws IOException {
        }

        @Override
        boolean isConversionNeeded(Storage.StorageDirectory sd) {
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void recoverCreate(Collection<File> dataDirs) throws IOException {
            this.storageDirs = new ArrayList(dataDirs.size());
            Iterator<File> i$ = dataDirs.iterator();
            while (i$.hasNext()) {
                File dataDir = i$.next();
                boolean isAccessible = true;
                try {
                    if (dataDir.mkdirs()) {
                        // empty if block
                    }
                }
                catch (SecurityException se) {
                    isAccessible = false;
                }
                if (!isAccessible) {
                    throw new InconsistentFSStateException(dataDir, "cannot access checkpoint directory.");
                }
                Storage.StorageDirectory sd = new Storage.StorageDirectory(this, dataDir);
                try {
                    Storage.StorageState curState = sd.analyzeStorage(FSConstants.StartupOption.REGULAR);
                    switch (curState) {
                        case NON_EXISTENT: {
                            throw new InconsistentFSStateException(sd.root, "checkpoint directory does not exist or is not accessible.");
                        }
                        case NOT_FORMATTED: {
                            break;
                        }
                        case NORMAL: {
                            break;
                        }
                        default: {
                            sd.doRecover(curState);
                            break;
                        }
                    }
                }
                catch (IOException ioe) {
                    sd.unlock();
                    throw ioe;
                }
                this.addStorageDir(sd);
                LOG.warn((Object)("Checkpoint directory " + sd.root + " is added."));
            }
            return;
        }

        void startCheckpoint() throws IOException {
            for (Storage.StorageDirectory sd : this.storageDirs) {
                File curDir = sd.getCurrentDir();
                File tmpCkptDir = sd.getLastCheckpointTmp();
                assert (!tmpCkptDir.exists()) : tmpCkptDir.getName() + " directory must not exist.";
                if (curDir.exists()) {
                    CheckpointStorage.rename(curDir, tmpCkptDir);
                }
                if (curDir.mkdir()) continue;
                throw new IOException("Cannot create directory " + curDir);
            }
        }

        void endCheckpoint() throws IOException {
            for (Storage.StorageDirectory sd : this.storageDirs) {
                File tmpCkptDir = sd.getLastCheckpointTmp();
                File prevCkptDir = sd.getPreviousCheckpoint();
                if (prevCkptDir.exists()) {
                    CheckpointStorage.deleteDir(prevCkptDir);
                }
                if (!tmpCkptDir.exists()) continue;
                CheckpointStorage.rename(tmpCkptDir, prevCkptDir);
            }
        }

        private void doMerge(CheckpointSignature sig) throws IOException {
            this.getEditLog().open();
            Storage.StorageDirectory sd = this.getStorageDir(0);
            this.loadFSImage(FSImage.getImageFile(sd, FSImage.NameNodeFile.IMAGE));
            this.loadFSEdits(sd);
            sig.validateStorageInfo(this);
            this.saveFSImage();
        }
    }

    static class ErrorSimulator {
        private static boolean[] simulation = null;

        ErrorSimulator() {
        }

        static void initializeErrorSimulationEvent(int numberOfEvents) {
            simulation = new boolean[numberOfEvents];
            for (int i = 0; i < numberOfEvents; ++i) {
                ErrorSimulator.simulation[i] = false;
            }
        }

        static boolean getErrorSimulation(int index) {
            if (simulation == null) {
                return false;
            }
            assert (index < simulation.length);
            return simulation[index];
        }

        static void setErrorSimulation(int index) {
            assert (index < simulation.length);
            ErrorSimulator.simulation[index] = true;
        }

        static void clearErrorSimulation(int index) {
            assert (index < simulation.length);
            ErrorSimulator.simulation[index] = false;
        }
    }
}

