/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.IOException;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.WritableComparator;

class StringBytesWritable
extends BytesWritable {
    StringBytesWritable() {
    }

    StringBytesWritable(String str) throws IOException {
        super(str.getBytes("UTF8"));
    }

    String getString() throws IOException {
        return new String(this.get(), "UTF8");
    }

    public String toString() {
        try {
            return this.getString();
        }
        catch (IOException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
    }

    boolean equals(String str) throws IOException {
        return WritableComparator.compareBytes(this.get(), 0, this.getSize(), str.getBytes("UTF8"), 0, str.length()) == 0;
    }
}

