/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.IOException;
import java.util.SortedSet;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.UpgradeCommand;
import org.apache.hadoop.dfs.UpgradeObjectCollection;
import org.apache.hadoop.dfs.Upgradeable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class UpgradeManager {
    protected SortedSet<Upgradeable> currentUpgrades = null;
    protected boolean upgradeState = false;
    protected int upgradeVersion = 0;
    protected UpgradeCommand broadcastCommand = null;

    UpgradeManager() {
    }

    synchronized UpgradeCommand getBroadcastCommand() {
        return this.broadcastCommand;
    }

    boolean getUpgradeState() {
        return this.upgradeState;
    }

    int getUpgradeVersion() {
        return this.upgradeVersion;
    }

    void setUpgradeState(boolean uState, int uVersion) {
        this.upgradeState = uState;
        this.upgradeVersion = uVersion;
    }

    SortedSet<Upgradeable> getDistributedUpgrades() throws IOException {
        return UpgradeObjectCollection.getDistributedUpgrades(this.getUpgradeVersion(), this.getType());
    }

    short getUpgradeStatus() {
        if (this.currentUpgrades == null) {
            return 100;
        }
        return this.currentUpgrades.first().getUpgradeStatus();
    }

    boolean initializeUpgrade() throws IOException {
        this.currentUpgrades = this.getDistributedUpgrades();
        if (this.currentUpgrades == null) {
            this.setUpgradeState(false, -16);
            return false;
        }
        Upgradeable curUO = this.currentUpgrades.first();
        this.setUpgradeState(true, curUO.getVersion());
        return true;
    }

    boolean isUpgradeCompleted() {
        return this.currentUpgrades == null;
    }

    abstract FSConstants.NodeType getType();

    abstract boolean startUpgrade() throws IOException;

    abstract void completeUpgrade() throws IOException;
}

