/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.IOException;
import org.apache.hadoop.dfs.DataNode;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.NamespaceInfo;
import org.apache.hadoop.dfs.UpgradeCommand;
import org.apache.hadoop.dfs.UpgradeManager;
import org.apache.hadoop.dfs.UpgradeObjectDatanode;
import org.apache.hadoop.util.Daemon;

class UpgradeManagerDatanode
extends UpgradeManager {
    DataNode dataNode = null;
    Daemon upgradeDaemon = null;

    UpgradeManagerDatanode(DataNode dataNode) {
        this.dataNode = dataNode;
    }

    public FSConstants.NodeType getType() {
        return FSConstants.NodeType.DATA_NODE;
    }

    void initializeUpgrade(NamespaceInfo nsInfo) throws IOException {
        if (!super.initializeUpgrade()) {
            return;
        }
        DataNode.LOG.info((Object)("\n   Distributed upgrade for DataNode " + this.dataNode.dnRegistration.getName() + " version " + this.getUpgradeVersion() + " to current LV " + -16 + " is initialized."));
        UpgradeObjectDatanode curUO = (UpgradeObjectDatanode)this.currentUpgrades.first();
        curUO.setDatanode(this.dataNode);
        this.upgradeState = curUO.preUpgradeAction(nsInfo);
    }

    synchronized boolean startUpgrade() throws IOException {
        if (this.upgradeState) {
            assert (this.currentUpgrades != null) : "UpgradeManagerDatanode.currentUpgrades is null.";
            UpgradeObjectDatanode curUO = (UpgradeObjectDatanode)this.currentUpgrades.first();
            curUO.startUpgrade();
            return true;
        }
        if (this.broadcastCommand != null) {
            if (this.broadcastCommand.getVersion() > this.getUpgradeVersion()) {
                this.broadcastCommand = null;
            } else {
                assert (this.currentUpgrades == null) : "UpgradeManagerDatanode.currentUpgrades is not null.";
                assert (this.upgradeDaemon == null) : "UpgradeManagerDatanode.upgradeDaemon is not null.";
                this.dataNode.namenode.processUpgradeCommand(this.broadcastCommand);
                return true;
            }
        }
        if (this.currentUpgrades == null) {
            this.currentUpgrades = this.getDistributedUpgrades();
        }
        if (this.currentUpgrades == null) {
            DataNode.LOG.info((Object)("\n   Distributed upgrade for DataNode version " + this.getUpgradeVersion() + " to current LV " + -16 + " cannot be started. " + "The upgrade object is not defined."));
            return false;
        }
        this.upgradeState = true;
        UpgradeObjectDatanode curUO = (UpgradeObjectDatanode)this.currentUpgrades.first();
        curUO.setDatanode(this.dataNode);
        curUO.startUpgrade();
        this.upgradeDaemon = new Daemon(curUO);
        this.upgradeDaemon.start();
        DataNode.LOG.info((Object)("\n   Distributed upgrade for DataNode " + this.dataNode.dnRegistration.getName() + " version " + this.getUpgradeVersion() + " to current LV " + -16 + " is started."));
        return true;
    }

    synchronized void processUpgradeCommand(UpgradeCommand command) throws IOException {
        assert (command.getAction() == 101) : "Only start upgrade action can be processed at this time.";
        this.upgradeVersion = command.getVersion();
        if (this.startUpgrade()) {
            return;
        }
        throw new IOException("Distributed upgrade for DataNode " + this.dataNode.dnRegistration.getName() + " version " + this.getUpgradeVersion() + " to current LV " + -16 + " cannot be started. " + "The upgrade object is not defined.");
    }

    synchronized void completeUpgrade() throws IOException {
        assert (this.currentUpgrades != null) : "UpgradeManagerDatanode.currentUpgrades is null.";
        UpgradeObjectDatanode curUO = (UpgradeObjectDatanode)this.currentUpgrades.first();
        this.broadcastCommand = curUO.completeUpgrade();
        this.upgradeState = false;
        this.currentUpgrades = null;
        this.upgradeDaemon = null;
        DataNode.LOG.info((Object)("\n   Distributed upgrade for DataNode " + this.dataNode.dnRegistration.getName() + " version " + this.getUpgradeVersion() + " to current LV " + -16 + " is complete."));
    }

    synchronized void shutdownUpgrade() {
        if (this.upgradeDaemon != null) {
            this.upgradeDaemon.interrupt();
        }
    }
}

