/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.IOException;
import java.util.SortedSet;
import org.apache.hadoop.dfs.FSConstants;
import org.apache.hadoop.dfs.FSImage;
import org.apache.hadoop.dfs.FSNamesystem;
import org.apache.hadoop.dfs.IncorrectVersionException;
import org.apache.hadoop.dfs.NameNode;
import org.apache.hadoop.dfs.UpgradeCommand;
import org.apache.hadoop.dfs.UpgradeManager;
import org.apache.hadoop.dfs.UpgradeObjectCollection;
import org.apache.hadoop.dfs.UpgradeObjectNamenode;
import org.apache.hadoop.dfs.UpgradeStatusReport;
import org.apache.hadoop.dfs.Upgradeable;

class UpgradeManagerNamenode
extends UpgradeManager {
    UpgradeManagerNamenode() {
    }

    public FSConstants.NodeType getType() {
        return FSConstants.NodeType.NAME_NODE;
    }

    synchronized boolean startUpgrade() throws IOException {
        if (!this.upgradeState) {
            this.initializeUpgrade();
            if (!this.upgradeState) {
                return false;
            }
            FSNamesystem.getFSNamesystem().getFSImage().writeAll();
        }
        assert (this.currentUpgrades != null) : "currentUpgrades is null";
        this.broadcastCommand = ((Upgradeable)this.currentUpgrades.first()).startUpgrade();
        NameNode.LOG.info((Object)("\n   Distributed upgrade for NameNode version " + this.getUpgradeVersion() + " to current LV " + -16 + " is started."));
        return true;
    }

    synchronized UpgradeCommand processUpgradeCommand(UpgradeCommand command) throws IOException {
        NameNode.LOG.debug((Object)("\n   Distributed upgrade for NameNode version " + this.getUpgradeVersion() + " to current LV " + -16 + " is processing upgrade command: " + command.getAction() + " status = " + this.getUpgradeStatus() + "%"));
        if (this.currentUpgrades == null) {
            NameNode.LOG.info((Object)("Ignoring upgrade command: " + command.getAction() + " version " + command.getVersion() + ". No distributed upgrades are currently running on the NameNode"));
            return null;
        }
        UpgradeObjectNamenode curUO = (UpgradeObjectNamenode)this.currentUpgrades.first();
        if (command.getVersion() != curUO.getVersion()) {
            throw new IncorrectVersionException(command.getVersion(), "UpgradeCommand", curUO.getVersion());
        }
        UpgradeCommand reply = curUO.processUpgradeCommand(command);
        if (curUO.getUpgradeStatus() < 100) {
            return reply;
        }
        curUO.completeUpgrade();
        NameNode.LOG.info((Object)("\n   Distributed upgrade for NameNode version " + curUO.getVersion() + " to current LV " + -16 + " is complete."));
        this.currentUpgrades.remove(curUO);
        if (this.currentUpgrades.isEmpty()) {
            this.completeUpgrade();
        } else {
            curUO = (UpgradeObjectNamenode)this.currentUpgrades.first();
            this.broadcastCommand = curUO.startUpgrade();
        }
        return reply;
    }

    synchronized void completeUpgrade() throws IOException {
        this.setUpgradeState(false, -16);
        FSNamesystem.getFSNamesystem().getFSImage().writeAll();
        this.currentUpgrades = null;
        this.broadcastCommand = null;
        FSNamesystem.getFSNamesystem().leaveSafeMode(false, true);
    }

    UpgradeStatusReport distributedUpgradeProgress(FSConstants.UpgradeAction action) throws IOException {
        boolean isFinalized = false;
        if (this.currentUpgrades == null) {
            FSImage fsimage = FSNamesystem.getFSNamesystem().getFSImage();
            isFinalized = fsimage.isUpgradeFinalized();
            if (isFinalized) {
                return null;
            }
            return new UpgradeStatusReport(fsimage.getLayoutVersion(), 101, isFinalized);
        }
        UpgradeObjectNamenode curUO = (UpgradeObjectNamenode)this.currentUpgrades.first();
        boolean details = false;
        switch (action) {
            case GET_STATUS: {
                break;
            }
            case DETAILED_STATUS: {
                details = true;
                break;
            }
            case FORCE_PROCEED: {
                curUO.forceProceed();
            }
        }
        return curUO.getUpgradeStatusReport(details);
    }

    public static void main(String[] args) throws IOException {
        UpgradeManagerNamenode um = new UpgradeManagerNamenode();
        SortedSet<Upgradeable> uos = UpgradeObjectCollection.getDistributedUpgrades(-4, FSConstants.NodeType.NAME_NODE);
        System.out.println(uos.size());
        um.startUpgrade();
    }
}

