/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.dfs;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.dfs.DatanodeDescriptor;
import org.apache.hadoop.dfs.FSNamesystem;
import org.apache.hadoop.dfs.JspHelper;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.util.ServletUtil;
import org.apache.hadoop.util.VersionInfo;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;

public final class dfshealth_jsp
extends HttpJspBase
implements JspSourceDependent {
    FSNamesystem fsn = FSNamesystem.getFSNamesystem();
    String namenodeLabel = this.fsn.getDFSNameNodeMachine() + ":" + this.fsn.getDFSNameNodePort();
    JspHelper jspHelper = new JspHelper();
    int rowNum = 0;
    int colNum = 0;
    long diskBytes = 0x40000000L;
    String diskByteStr = "GB";
    String sorterField = null;
    String sorterOrder = null;
    private static Vector _jspx_dependants;

    String rowTxt() {
        this.colNum = 0;
        return "<tr class=\"" + (this.rowNum++ % 2 == 0 ? "rowNormal" : "rowAlt") + "\"> ";
    }

    String colTxt() {
        return "<td id=\"col" + ++this.colNum + "\"> ";
    }

    void counterReset() {
        this.colNum = 0;
        this.rowNum = 0;
    }

    String NodeHeaderStr(String name) {
        String ret = "class=header";
        String order = "ASC";
        if (name.equals(this.sorterField)) {
            ret = ret + this.sorterOrder;
            if (this.sorterOrder.equals("ASC")) {
                order = "DSC";
            }
        }
        ret = ret + " onClick=\"window.document.location='/dfshealth.jsp?sorter/field=" + name + "&sorter/order=" + order + "'\" title=\"sort on this column\"";
        return ret;
    }

    public void generateNodeData(JspWriter out, DatanodeDescriptor d, String suffix, boolean alive) throws IOException {
        String url = "http://" + d.getHostName() + ":" + d.getInfoPort() + "/browseDirectory.jsp?namenodeInfoPort=" + this.fsn.getNameNodeInfoPort() + "&dir=" + URLEncoder.encode("/", "UTF-8");
        String name = d.getHostName() + ":" + d.getPort();
        if (!name.matches("\\d+\\.\\d+.\\d+\\.\\d+.*")) {
            name = name.replaceAll("\\.[^.:]*", "");
        }
        int idx = suffix != null && name.endsWith(suffix) ? name.indexOf(suffix) : -1;
        out.print(this.rowTxt() + "<td class=\"name\"><a title=\"" + d.getHost() + ":" + d.getPort() + "\" href=\"" + url + "\">" + (idx > 0 ? name.substring(0, idx) : name) + "</a>" + (alive ? "" : "\n"));
        if (!alive) {
            return;
        }
        long c = d.getCapacity();
        long u = d.getDfsUsed();
        String percentUsed = c > 0L ? FsShell.limitDecimalTo2(1.0 * (double)u / (double)c * 100.0) : "100";
        String adminState = d.isDecommissioned() ? "Decommissioned" : (d.isDecommissionInProgress() ? "Decommission In Progress" : "In Service");
        long timestamp = d.getLastUpdate();
        long currentTime = System.currentTimeMillis();
        out.print("<td class=\"lastcontact\"> " + (currentTime - timestamp) / 1000L + "<td class=\"adminstate\">" + adminState + "<td class=\"size\">" + FsShell.limitDecimalTo2((double)c * 1.0 / (double)this.diskBytes) + "<td class=\"pcused\">" + percentUsed + "<td class=\"pcused\">" + JspHelper.percentageGraph((int)Double.parseDouble(percentUsed), 100) + "<td class=\"size\">" + FsShell.limitDecimalTo2((double)d.getRemaining() * 1.0 / (double)this.diskBytes) + "<td class=\"blocks\">" + d.numBlocks() + "\n");
    }

    public void generateDFSHealthReport(JspWriter out, HttpServletRequest request) throws IOException {
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
        this.jspHelper.DFSNodesStatus(live, dead);
        this.sorterField = request.getParameter("sorter/field");
        this.sorterOrder = request.getParameter("sorter/order");
        if (this.sorterField == null) {
            this.sorterField = "name";
        }
        if (this.sorterOrder == null) {
            this.sorterOrder = "ASC";
        }
        this.jspHelper.sortNodeList(live, this.sorterField, this.sorterOrder);
        this.jspHelper.sortNodeList(dead, "name", "ASC");
        String port_suffix = null;
        if (live.size() > 0) {
            String name = live.get(0).getName();
            int idx = name.indexOf(58);
            if (idx > 0) {
                port_suffix = name.substring(idx);
            }
            for (int i = 1; port_suffix != null && i < live.size(); ++i) {
                if (live.get(i).getName().endsWith(port_suffix)) continue;
                port_suffix = null;
                break;
            }
        }
        this.counterReset();
        out.print("<div id=\"dfstable\"> <table>\n" + this.rowTxt() + this.colTxt() + "Capacity" + this.colTxt() + ":" + this.colTxt() + FsShell.byteDesc(this.fsn.getCapacityTotal()) + this.rowTxt() + this.colTxt() + "DFS Remaining" + this.colTxt() + ":" + this.colTxt() + FsShell.byteDesc(this.fsn.getCapacityRemaining()) + this.rowTxt() + this.colTxt() + "DFS Used" + this.colTxt() + ":" + this.colTxt() + FsShell.byteDesc(this.fsn.getCapacityUsed()) + this.rowTxt() + this.colTxt() + "DFS Used%" + this.colTxt() + ":" + this.colTxt() + FsShell.limitDecimalTo2((double)this.fsn.getCapacityUsed() * 100.0 / ((double)this.fsn.getCapacityTotal() + 1.0E-10)) + " %" + this.rowTxt() + this.colTxt() + "<a href=\"#LiveNodes\">Live Nodes</a> " + this.colTxt() + ":" + this.colTxt() + live.size() + this.rowTxt() + this.colTxt() + "<a href=\"#DeadNodes\">Dead Nodes</a> " + this.colTxt() + ":" + this.colTxt() + dead.size() + "</table></div><br><hr>\n");
        if (live.isEmpty() && dead.isEmpty()) {
            out.print("There are no datanodes in the cluster");
        } else {
            out.print("<div id=\"dfsnodetable\"> <a name=\"LiveNodes\" id=\"title\">Live Datanodes : " + live.size() + "</a>" + "<br><br>\n<table border=1 cellspacing=0>\n");
            this.counterReset();
            if (live.size() > 0) {
                if (live.get(0).getCapacity() > 1024L * this.diskBytes) {
                    this.diskBytes *= 1024L;
                    this.diskByteStr = "TB";
                }
                out.print("<tr class=\"headerRow\"> <th name> Node <th " + this.NodeHeaderStr("lastcontact") + "> Last Contact <th " + this.NodeHeaderStr("adminstate") + "> Admin State <th " + this.NodeHeaderStr("size") + "> Size (" + this.diskByteStr + ") <th " + this.NodeHeaderStr("pcused") + "> Used (%) <th " + this.NodeHeaderStr("pcused") + "> Used (%) <th " + this.NodeHeaderStr("remaining") + "> Remaining (" + this.diskByteStr + ") <th " + this.NodeHeaderStr("blocks") + "> Blocks\n");
                for (int i = 0; i < live.size(); ++i) {
                    this.generateNodeData(out, live.get(i), port_suffix, true);
                }
            }
            out.print("</table>\n");
            this.counterReset();
            out.print("<br> <a name=\"DeadNodes\" id=\"title\">  Dead Datanodes : " + dead.size() + "</a><br><br>\n");
            if (dead.size() > 0) {
                out.print("<table border=1 cellspacing=0> <tr id=\"row1\"> <td> Node \n");
                for (int i = 0; i < dead.size(); ++i) {
                    this.generateNodeData(out, dead.get(i), port_suffix, false);
                }
                out.print("</table>\n");
            }
            out.print("</div>");
        }
    }

    public List getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        JspFactory _jspxFactory = null;
        PageContext pageContext = null;
        HttpSession session = null;
        ServletContext application = null;
        ServletConfig config = null;
        JspWriter out = null;
        dfshealth_jsp page = this;
        JspWriter _jspx_out = null;
        PageContext _jspx_page_context = null;
        try {
            _jspxFactory = JspFactory.getDefaultFactory();
            response.setContentType("text/html; charset=UTF-8");
            _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
            application = pageContext.getServletContext();
            config = pageContext.getServletConfig();
            session = pageContext.getSession();
            _jspx_out = out = pageContext.getOut();
            out.write(10);
            out.write("\n\n<html>\n\n<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/hadoop.css\">\n<title>Hadoop NameNode ");
            out.print(this.namenodeLabel);
            out.write("</title>\n    \n<body>\n<h1>NameNode '");
            out.print(this.namenodeLabel);
            out.write("'</h1>\n\n\n<div id=\"dfstable\"> <table>\t  \n<tr> <td id=\"col1\"> Started: <td> ");
            out.print((Object)this.fsn.getStartTime());
            out.write("\n<tr> <td id=\"col1\"> Version: <td> ");
            out.print(VersionInfo.getVersion());
            out.write(44);
            out.write(32);
            out.write(114);
            out.print(VersionInfo.getRevision());
            out.write("\n<tr> <td id=\"col1\"> Compiled: <td> ");
            out.print(VersionInfo.getDate());
            out.write(" by ");
            out.print(VersionInfo.getUser());
            out.write("\n<tr> <td id=\"col1\"> Upgrades: <td> ");
            out.print(this.jspHelper.getUpgradeStatusText());
            out.write("\n</table></div><br>\t\t\t\t      \n\n<b><a href=\"/nn_browsedfscontent.jsp\">Browse the filesystem</a></b>\n<hr>\n<h3>Cluster Summary</h3>\n<b> ");
            out.print(this.jspHelper.getSafeModeText());
            out.write(" </b>\n<b> ");
            out.print(this.jspHelper.getInodeLimitText());
            out.write(" </b>\n\n");
            this.generateDFSHealthReport(out, request);
            out.write("\n<hr>\n\n<h3>Local logs</h3>\n<a href=\"/logs/\">Log</a> directory\n\n");
            out.println(ServletUtil.htmlFooter());
            out.write(10);
            if (_jspxFactory == null) return;
        }
        catch (Throwable t) {
            try {
                if (t instanceof SkipPageException) return;
                out = _jspx_out;
                if (out != null && out.getBufferSize() != 0) {
                    out.clearBuffer();
                }
                if (_jspx_page_context == null) return;
                _jspx_page_context.handlePageException(t);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (_jspxFactory != null) {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
        }
        _jspxFactory.releasePageContext(_jspx_page_context);
        return;
    }
}

