/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class ContentSummary
implements Writable {
    private long length;
    private long fileCount;
    private long directoryCount;
    private long quota;
    private static final String STRING_FORMAT = "%12d %12d %18d ";
    private static final String QUOTA_STRING_FORMAT = "%12d %15d %12d %12d %18d ";
    private static final String NON_QUOTA_STRING_FORMAT = "%12s %15s %12d %12d %18d ";
    private static final String HEADER = String.format("%12d %12d %18d ".replace('d', 's'), "directories", "files", "bytes");
    private static final String QUOTA_HEADER = String.format("%12d %15d %12d %12d %18d ".replace('d', 's'), "quota", "remaining quota", "directories", "files", "bytes");

    public ContentSummary() {
    }

    public ContentSummary(long length, long fileCount, long directoryCount) {
        this.length = length;
        this.fileCount = fileCount;
        this.directoryCount = directoryCount;
        this.quota = -1L;
    }

    public ContentSummary(long length, long fileCount, long directoryCount, long quota) {
        this.length = length;
        this.fileCount = fileCount;
        this.directoryCount = directoryCount;
        this.quota = quota;
    }

    public long getLength() {
        return this.length;
    }

    public long getDirectoryCount() {
        return this.directoryCount;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public long getQuota() {
        return this.quota;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.length);
        out.writeLong(this.fileCount);
        out.writeLong(this.directoryCount);
        out.writeLong(this.quota);
    }

    public void readFields(DataInput in) throws IOException {
        this.length = in.readLong();
        this.fileCount = in.readLong();
        this.directoryCount = in.readLong();
        this.quota = in.readLong();
    }

    public static String getHeader(boolean qOption) {
        return qOption ? QUOTA_HEADER : HEADER;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean qOption) {
        if (qOption) {
            if (this.quota > 0L) {
                long remainingQuota = this.quota - (this.directoryCount + this.fileCount);
                return String.format(QUOTA_STRING_FORMAT, this.quota, remainingQuota, this.directoryCount, this.fileCount, this.length);
            }
            return String.format(NON_QUOTA_STRING_FORMAT, "none", "inf", this.directoryCount, this.fileCount, this.length);
        }
        return String.format(STRING_FORMAT, this.directoryCount, this.fileCount, this.length);
    }
}

