/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.StringUtils;

public class Trash
extends Configured {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.fs.Trash");
    private static final Path CURRENT = new Path("Current");
    private static final Path TRASH = new Path(".Trash/");
    private static final Path HOMES = new Path("/user/");
    private static final FsPermission PERMISSION = new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE);
    private static final DateFormat CHECKPOINT = new SimpleDateFormat("yyMMddHHmm");
    private static final int MSECS_PER_MINUTE = 60000;
    private FileSystem fs;
    private Path trash;
    private Path current;
    private long interval;

    public Trash(Configuration conf) throws IOException {
        this(FileSystem.get(conf).getHomeDirectory(), conf);
    }

    private Trash(Path home, Configuration conf) throws IOException {
        super(conf);
        this.fs = home.getFileSystem(conf);
        this.trash = new Path(home, TRASH);
        this.current = new Path(this.trash, CURRENT);
        this.interval = conf.getLong("fs.trash.interval", 60L) * 60000L;
    }

    public boolean moveToTrash(Path path) throws IOException {
        if (this.interval == 0L) {
            return false;
        }
        if (!path.isAbsolute()) {
            path = new Path(this.fs.getWorkingDirectory(), path);
        }
        if (!this.fs.exists(path)) {
            throw new FileNotFoundException(path.toString());
        }
        if (path.makeQualified(this.fs).toString().startsWith(this.trash.toString())) {
            return false;
        }
        Path trashPath = new Path(this.current, path.getName());
        IOException cause = null;
        for (int i = 0; i < 2; ++i) {
            try {
                if (!this.fs.mkdirs(this.current, PERMISSION)) {
                    LOG.warn((Object)("Can't create trash directory: " + this.current));
                    return false;
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("Can't create trash directory: " + this.current));
                return false;
            }
            try {
                String orig = trashPath.toString();
                int j = 1;
                while (this.fs.exists(trashPath)) {
                    trashPath = new Path(orig + "." + j);
                    ++j;
                }
                if (!this.fs.rename(path, trashPath)) continue;
                return true;
            }
            catch (IOException e) {
                cause = e;
            }
        }
        throw (IOException)new IOException("Failed to move to trash: " + path).initCause(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint() throws IOException {
        Path checkpoint;
        if (!this.fs.exists(this.current)) {
            return;
        }
        DateFormat dateFormat = CHECKPOINT;
        synchronized (dateFormat) {
            checkpoint = new Path(this.trash, CHECKPOINT.format(new Date()));
        }
        if (!this.fs.rename(this.current, checkpoint)) {
            throw new IOException("Failed to checkpoint trash: " + checkpoint);
        }
        LOG.info((Object)("Created trash checkpoint: " + checkpoint.toUri().getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expunge() throws IOException {
        FileStatus[] dirs = this.fs.listStatus(this.trash);
        if (dirs == null) {
            return;
        }
        long now = System.currentTimeMillis();
        for (int i = 0; i < dirs.length; ++i) {
            long time;
            Path path = dirs[i].getPath();
            String dir = path.toUri().getPath();
            String name = path.getName();
            if (name.equals(CURRENT.getName())) continue;
            try {
                DateFormat dateFormat = CHECKPOINT;
                synchronized (dateFormat) {
                    time = CHECKPOINT.parse(name).getTime();
                }
            }
            catch (ParseException e) {
                LOG.warn((Object)("Unexpected item in trash: " + dir + ". Ignoring."));
                continue;
            }
            if (now - this.interval <= time) continue;
            if (this.fs.delete(path, true)) {
                LOG.info((Object)("Deleted trash checkpoint: " + dir));
                continue;
            }
            LOG.warn((Object)("Couldn't delete checkpoint: " + dir + " Ignoring."));
        }
    }

    Path getCurrentTrashDir() {
        return this.current;
    }

    public Runnable getEmptier() throws IOException {
        return new Emptier(this.getConf());
    }

    public static void main(String[] args) throws Exception {
        new Trash(new Configuration()).getEmptier().run();
    }

    private static class Emptier
    implements Runnable {
        private Configuration conf;
        private FileSystem fs;
        private long interval;

        public Emptier(Configuration conf) throws IOException {
            this.conf = conf;
            this.interval = conf.getLong("fs.trash.interval", 60L) * 60000L;
            this.fs = FileSystem.get(conf);
        }

        public void run() {
            if (this.interval == 0L) {
                return;
            }
            long now = System.currentTimeMillis();
            block8: while (true) {
                long end = this.ceiling(now, this.interval);
                try {
                    Thread.sleep(end - now);
                }
                catch (InterruptedException e) {
                    return;
                }
                try {
                    now = System.currentTimeMillis();
                    if (now < end) continue;
                    FileStatus[] homes = null;
                    try {
                        homes = this.fs.listStatus(HOMES);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Trash can't list homes: " + e + " Sleeping."));
                        continue;
                    }
                    if (homes == null) continue;
                    FileStatus[] arr$ = homes;
                    int len$ = arr$.length;
                    int i$ = 0;
                    while (true) {
                        if (i$ >= len$) continue block8;
                        FileStatus home = arr$[i$];
                        if (home.isDir()) {
                            try {
                                Trash trash = new Trash(home.getPath(), this.conf);
                                trash.expunge();
                                trash.checkpoint();
                            }
                            catch (IOException e) {
                                LOG.warn((Object)("Trash caught: " + e + ". Skipping " + home.getPath() + "."));
                            }
                        }
                        ++i$;
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)("RuntimeException during Trash.Emptier.run() " + StringUtils.stringifyException(e)));
                    continue;
                }
                break;
            }
        }

        private long ceiling(long time, long interval) {
            return this.floor(time, interval) + interval;
        }

        private long floor(long time, long interval) {
            return time / interval * interval;
        }
    }
}

