/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.permission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FsAction {
    NONE(0, "---"),
    EXECUTE(1, "--x"),
    WRITE(2, "-w-"),
    WRITE_EXECUTE(3, "-wx"),
    READ(4, "r--"),
    READ_EXECUTE(5, "r-x"),
    READ_WRITE(6, "rw-"),
    ALL(7, "rwx");

    public final int INDEX;
    public final String SYMBOL;

    private FsAction(int v, String s) {
        this.INDEX = v;
        this.SYMBOL = s;
    }

    public boolean implies(FsAction that) {
        if (that != null) {
            return (this.INDEX & that.INDEX) == that.INDEX;
        }
        return false;
    }

    public FsAction and(FsAction that) {
        return FsAction.values()[this.INDEX & that.INDEX];
    }

    public FsAction or(FsAction that) {
        return FsAction.values()[this.INDEX | that.INDEX];
    }

    public FsAction not() {
        return FsAction.values()[7 - this.INDEX];
    }
}

