/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3native;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3.S3Credentials;
import org.apache.hadoop.fs.s3.S3Exception;
import org.apache.hadoop.fs.s3native.FileMetadata;
import org.apache.hadoop.fs.s3native.NativeFileSystemStore;
import org.apache.hadoop.fs.s3native.PartialListing;
import org.jets3t.service.S3ObjectsChunk;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.AWSCredentials;

class Jets3tNativeFileSystemStore
implements NativeFileSystemStore {
    private S3Service s3Service;
    private S3Bucket bucket;

    Jets3tNativeFileSystemStore() {
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        S3Credentials s3Credentials = new S3Credentials();
        s3Credentials.initialize(uri, conf);
        try {
            AWSCredentials awsCredentials = new AWSCredentials(s3Credentials.getAccessKey(), s3Credentials.getSecretAccessKey());
            this.s3Service = new RestS3Service(awsCredentials);
        }
        catch (S3ServiceException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new S3Exception(e);
        }
        this.bucket = new S3Bucket(uri.getHost());
        this.createBucket(this.bucket.getName());
    }

    private void createBucket(String bucketName) throws IOException {
        try {
            this.s3Service.createBucket(bucketName);
        }
        catch (S3ServiceException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new S3Exception(e);
        }
    }

    public void storeFile(String key, File file, byte[] md5Hash) throws IOException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            S3Object object = new S3Object(key);
            object.setDataInputStream((InputStream)in);
            object.setContentType("binary/octet-stream");
            object.setContentLength(file.length());
            if (md5Hash != null) {
                object.setMd5Hash(md5Hash);
            }
            this.s3Service.putObject(this.bucket, object);
        }
        catch (S3ServiceException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new S3Exception(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void storeEmptyFile(String key) throws IOException {
        try {
            S3Object object = new S3Object(key);
            object.setDataInputStream((InputStream)new ByteArrayInputStream(new byte[0]));
            object.setContentType("binary/octet-stream");
            object.setContentLength(0L);
            this.s3Service.putObject(this.bucket, object);
        }
        catch (S3ServiceException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new S3Exception(e);
        }
    }

    public FileMetadata retrieveMetadata(String key) throws IOException {
        try {
            S3Object object = this.s3Service.getObjectDetails(this.bucket, key);
            return new FileMetadata(key, object.getContentLength(), object.getLastModifiedDate().getTime());
        }
        catch (S3ServiceException e) {
            if (e.getMessage().contains("ResponseCode=404")) {
                return null;
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new S3Exception(e);
        }
    }

    public InputStream retrieve(String key) throws IOException {
        try {
            S3Object object = this.s3Service.getObject(this.bucket, key);
            return object.getDataInputStream();
        }
        catch (S3ServiceException e) {
            if (e.getS3ErrorCode().equals("NoSuchKey")) {
                return null;
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new S3Exception(e);
        }
    }

    public InputStream retrieve(String key, long byteRangeStart) throws IOException {
        try {
            S3Object object = this.s3Service.getObject(this.bucket, key, null, null, null, null, Long.valueOf(byteRangeStart), null);
            return object.getDataInputStream();
        }
        catch (S3ServiceException e) {
            if (e.getS3ErrorCode().equals("NoSuchKey")) {
                return null;
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new S3Exception(e);
        }
    }

    public PartialListing list(String prefix, int maxListingLength) throws IOException {
        return this.list(prefix, maxListingLength, null);
    }

    public PartialListing list(String prefix, int maxListingLength, String priorLastKey) throws IOException {
        try {
            if (prefix.length() > 0 && !prefix.endsWith("/")) {
                prefix = prefix + "/";
            }
            S3ObjectsChunk chunk = this.s3Service.listObjectsChunked(this.bucket.getName(), prefix, "/", (long)maxListingLength, priorLastKey);
            FileMetadata[] fileMetadata = new FileMetadata[chunk.getObjects().length];
            for (int i = 0; i < fileMetadata.length; ++i) {
                S3Object object = chunk.getObjects()[i];
                fileMetadata[i] = new FileMetadata(object.getKey(), object.getContentLength(), object.getLastModifiedDate().getTime());
            }
            return new PartialListing(chunk.getPriorLastKey(), fileMetadata, chunk.getCommonPrefixes());
        }
        catch (S3ServiceException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new S3Exception(e);
        }
    }

    public void delete(String key) throws IOException {
        try {
            this.s3Service.deleteObject(this.bucket, key);
        }
        catch (S3ServiceException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new S3Exception(e);
        }
    }

    public void purge(String prefix) throws IOException {
        try {
            S3Object[] objects = this.s3Service.listObjects(this.bucket, prefix, null);
            for (int i = 0; i < objects.length; ++i) {
                this.s3Service.deleteObject(this.bucket, objects[i].getKey());
            }
        }
        catch (S3ServiceException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new S3Exception(e);
        }
    }

    public void dump() throws IOException {
        StringBuilder sb = new StringBuilder("S3 Native Filesystem, ");
        sb.append(this.bucket.getName()).append("\n");
        try {
            S3Object[] objects = this.s3Service.listObjects(this.bucket);
            for (int i = 0; i < objects.length; ++i) {
                sb.append(objects[i].getKey()).append("\n");
            }
        }
        catch (S3ServiceException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new S3Exception(e);
        }
        System.out.println(sb);
    }
}

