/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandFormat {
    final String name;
    final int minPar;
    final int maxPar;
    final Map<String, Boolean> options = new HashMap<String, Boolean>();

    public CommandFormat(String n, int min, int max, String ... possibleOpt) {
        this.name = n;
        this.minPar = min;
        this.maxPar = max;
        for (String opt : possibleOpt) {
            this.options.put(opt, Boolean.FALSE);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> parse(String[] args, int pos) {
        ArrayList<String> parameters = new ArrayList<String>();
        while (pos < args.length) {
            if (args[pos].charAt(0) == '-' && args[pos].length() > 1) {
                String opt = args[pos].substring(1);
                if (!this.options.containsKey(opt)) throw new IllegalArgumentException("Illegal option " + args[pos]);
                this.options.put(opt, Boolean.TRUE);
            } else {
                parameters.add(args[pos]);
            }
            ++pos;
        }
        int psize = parameters.size();
        if (psize >= this.minPar && psize <= this.maxPar) return parameters;
        throw new IllegalArgumentException("Illegal number of arguments");
    }

    public boolean getOpt(String option) {
        return this.options.get(option);
    }
}

