/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.BlockCompressorStream;
import org.apache.hadoop.io.compress.BlockDecompressorStream;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.lzo.LzoCompressor;
import org.apache.hadoop.io.compress.lzo.LzoDecompressor;
import org.apache.hadoop.util.NativeCodeLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LzoCodec
implements Configurable,
CompressionCodec {
    private static final Log LOG = LogFactory.getLog((String)LzoCodec.class.getName());
    private Configuration conf;
    private static boolean nativeLzoLoaded = false;

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    public static boolean isNativeLzoLoaded(Configuration conf) {
        return nativeLzoLoaded && conf.getBoolean("hadoop.native.lib", true);
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return this.createOutputStream(out, this.createCompressor());
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        if (!LzoCodec.isNativeLzoLoaded(this.conf)) {
            throw new RuntimeException("native-lzo library not available");
        }
        LzoCompressor.CompressionStrategy strategy = LzoCompressor.CompressionStrategy.valueOf(this.conf.get("io.compression.codec.lzo.compressor", LzoCompressor.CompressionStrategy.LZO1X_1.name()));
        int bufferSize = this.conf.getInt("io.compression.codec.lzo.buffersize", 65536);
        int compressionOverhead = strategy.name().contains("LZO1") ? (bufferSize >> 4) + 64 + 3 : (bufferSize >> 3) + 128 + 3;
        return new BlockCompressorStream(out, compressor, bufferSize, compressionOverhead);
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        if (!LzoCodec.isNativeLzoLoaded(this.conf)) {
            throw new RuntimeException("native-lzo library not available");
        }
        return LzoCompressor.class;
    }

    @Override
    public Compressor createCompressor() {
        if (!LzoCodec.isNativeLzoLoaded(this.conf)) {
            throw new RuntimeException("native-lzo library not available");
        }
        LzoCompressor.CompressionStrategy strategy = LzoCompressor.CompressionStrategy.valueOf(this.conf.get("io.compression.codec.lzo.compressor", LzoCompressor.CompressionStrategy.LZO1X_1.name()));
        int bufferSize = this.conf.getInt("io.compression.codec.lzo.buffersize", 65536);
        return new LzoCompressor(strategy, bufferSize);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return this.createInputStream(in, this.createDecompressor());
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        if (!LzoCodec.isNativeLzoLoaded(this.conf)) {
            throw new RuntimeException("native-lzo library not available");
        }
        return new BlockDecompressorStream(in, decompressor, this.conf.getInt("io.compression.codec.lzo.buffersize", 65536));
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        if (!LzoCodec.isNativeLzoLoaded(this.conf)) {
            throw new RuntimeException("native-lzo library not available");
        }
        return LzoDecompressor.class;
    }

    @Override
    public Decompressor createDecompressor() {
        if (!LzoCodec.isNativeLzoLoaded(this.conf)) {
            throw new RuntimeException("native-lzo library not available");
        }
        LzoDecompressor.CompressionStrategy strategy = LzoDecompressor.CompressionStrategy.valueOf(this.conf.get("io.compression.codec.lzo.decompressor", LzoDecompressor.CompressionStrategy.LZO1X.name()));
        int bufferSize = this.conf.getInt("io.compression.codec.lzo.buffersize", 65536);
        return new LzoDecompressor(strategy, bufferSize);
    }

    @Override
    public String getDefaultExtension() {
        return ".lzo";
    }

    static {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            boolean bl = nativeLzoLoaded = LzoCompressor.isNativeLzoLoaded() && LzoDecompressor.isNativeLzoLoaded();
            if (nativeLzoLoaded) {
                LOG.info((Object)"Successfully loaded & initialized native-lzo library");
            } else {
                LOG.error((Object)"Failed to load/initialize native-lzo library");
            }
        } else {
            LOG.error((Object)"Cannot load native-lzo without native-hadoop");
        }
    }
}

