/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc.metrics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.metrics.RpcMgt;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingRate;

public class RpcMetrics
implements Updater {
    private MetricsRecord metricsRecord;
    private static Log LOG = LogFactory.getLog(RpcMetrics.class);
    RpcMgt rpcMgt;
    public MetricsTimeVaryingRate rpcQueueTime = new MetricsTimeVaryingRate("RpcQueueTime");
    public MetricsTimeVaryingRate rpcProcessingTime = new MetricsTimeVaryingRate("RpcProcessingTime");
    public Map<String, MetricsTimeVaryingRate> metricsList = Collections.synchronizedMap(new HashMap());

    public RpcMetrics(String hostName, String port, Server server) {
        MetricsContext context = MetricsUtil.getContext("rpc");
        this.metricsRecord = MetricsUtil.createRecord(context, "metrics");
        this.metricsRecord.setTag("port", port);
        LOG.info((Object)("Initializing RPC Metrics with hostName=" + hostName + ", port=" + port));
        context.registerUpdater(this);
        this.rpcMgt = new RpcMgt(hostName, port, this, server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdates(MetricsContext context) {
        this.rpcQueueTime.pushMetric(this.metricsRecord);
        this.rpcProcessingTime.pushMetric(this.metricsRecord);
        Map<String, MetricsTimeVaryingRate> map = this.metricsList;
        synchronized (map) {
            Set<String> keys = this.metricsList.keySet();
            for (String key : keys) {
                MetricsTimeVaryingRate value = this.metricsList.get(key);
                value.pushMetric(this.metricsRecord);
            }
        }
        this.metricsRecord.update();
    }

    public void shutdown() {
        if (this.rpcMgt != null) {
            this.rpcMgt.shutdown();
        }
    }
}

