/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc.metrics;

import javax.management.ObjectName;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.metrics.RpcMetrics;
import org.apache.hadoop.ipc.metrics.RpcMgtMBean;
import org.apache.hadoop.metrics.util.MBeanUtil;

class RpcMgt
implements RpcMgtMBean {
    private RpcMetrics myMetrics;
    private Server myServer;
    private ObjectName mbeanName;

    RpcMgt(String serviceName, String port, RpcMetrics metrics, Server server) {
        this.myMetrics = metrics;
        this.myServer = server;
        this.mbeanName = MBeanUtil.registerMBean(serviceName, "RpcStatisticsForPort" + port, this);
    }

    public void shutdown() {
        if (this.mbeanName != null) {
            MBeanUtil.unregisterMBean(this.mbeanName);
        }
    }

    public long getRpcOpsAvgProcessingTime() {
        return this.myMetrics.rpcProcessingTime.getPreviousIntervalAverageTime();
    }

    public long getRpcOpsAvgProcessingTimeMax() {
        return this.myMetrics.rpcProcessingTime.getMaxTime();
    }

    public long getRpcOpsAvgProcessingTimeMin() {
        return this.myMetrics.rpcProcessingTime.getMinTime();
    }

    public long getRpcOpsAvgQueueTime() {
        return this.myMetrics.rpcQueueTime.getPreviousIntervalAverageTime();
    }

    public long getRpcOpsAvgQueueTimeMax() {
        return this.myMetrics.rpcQueueTime.getMaxTime();
    }

    public long getRpcOpsAvgQueueTimeMin() {
        return this.myMetrics.rpcQueueTime.getMinTime();
    }

    public int getRpcOpsNumber() {
        return this.myMetrics.rpcProcessingTime.getPreviousIntervalNumOps();
    }

    public int getNumOpenConnections() {
        return this.myServer.getNumOpenConnections();
    }

    public int getCallQueueLen() {
        return this.myServer.getCallQueueLen();
    }

    public void resetAllMinMax() {
        this.myMetrics.rpcProcessingTime.resetMinMax();
        this.myMetrics.rpcQueueTime.resetMinMax();
    }
}

