/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Counters
implements Writable,
Iterable<Group> {
    private static final Log LOG = LogFactory.getLog(Counters.class);
    private Map<String, Group> counters = new HashMap<String, Group>();
    private Map<Enum, Counter> cache = new IdentityHashMap<Enum, Counter>();

    public synchronized Collection<String> getGroupNames() {
        return this.counters.keySet();
    }

    @Override
    public synchronized Iterator<Group> iterator() {
        return this.counters.values().iterator();
    }

    public synchronized Group getGroup(String groupName) {
        Group result = this.counters.get(groupName);
        if (result == null) {
            result = new Group(groupName);
            this.counters.put(groupName, result);
        }
        return result;
    }

    public synchronized Counter findCounter(Enum key) {
        Counter counter = this.cache.get(key);
        if (counter == null) {
            Group group = this.getGroup(key.getDeclaringClass().getName());
            counter = group.getCounterForName(key.toString());
            this.cache.put(key, counter);
        }
        return counter;
    }

    @Deprecated
    public synchronized Counter findCounter(String group, int id, String name) {
        return this.getGroup(group).getCounterForName(name);
    }

    public synchronized void incrCounter(Enum key, long amount) {
        this.findCounter(key).value += amount;
    }

    public synchronized void incrCounter(String group, String counter, long amount) {
        this.getGroup(group).getCounterForName(counter).value += amount;
    }

    public synchronized long getCounter(Enum key) {
        return this.findCounter(key).value;
    }

    public synchronized void incrAllCounters(Counters other) {
        for (Group otherGroup : other) {
            Group group = this.getGroup(otherGroup.getName());
            group.displayName = otherGroup.displayName;
            for (Counter otherCounter : otherGroup) {
                Counter counter = group.getCounterForName(otherCounter.getName());
                counter.displayName = otherCounter.displayName;
                counter.value += otherCounter.value;
            }
        }
    }

    public static Counters sum(Counters a, Counters b) {
        Counters counters = new Counters();
        counters.incrAllCounters(a);
        counters.incrAllCounters(b);
        return counters;
    }

    public synchronized int size() {
        int result = 0;
        for (Group group : this) {
            result += group.size();
        }
        return result;
    }

    @Override
    public synchronized void write(DataOutput out) throws IOException {
        out.writeInt(this.counters.size());
        for (Group group : this.counters.values()) {
            Text.writeString(out, group.getName());
            group.write(out);
        }
    }

    @Override
    public synchronized void readFields(DataInput in) throws IOException {
        int numClasses = in.readInt();
        this.counters.clear();
        while (numClasses-- > 0) {
            String groupName = Text.readString(in);
            Group group = new Group(groupName);
            group.readFields(in);
            this.counters.put(groupName, group);
        }
    }

    public void log(Log log) {
        log.info((Object)("Counters: " + this.size()));
        for (Group group : this) {
            log.info((Object)("  " + group.getDisplayName()));
            for (Counter counter : group) {
                log.info((Object)("    " + counter.getDisplayName() + "=" + counter.getCounter()));
            }
        }
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("Counters: " + this.size());
        for (Group group : this) {
            sb.append("\n\t" + group.getDisplayName());
            for (Counter counter : group) {
                sb.append("\n\t\t" + counter.getDisplayName() + "=" + counter.getCounter());
            }
        }
        return sb.toString();
    }

    public synchronized String makeCompactString() {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (Group group : this) {
            for (Counter counter : group) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(',');
                }
                buffer.append(group.getDisplayName());
                buffer.append('.');
                buffer.append(counter.getDisplayName());
                buffer.append(':');
                buffer.append(counter.getCounter());
            }
        }
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Group
    implements Writable,
    Iterable<Counter> {
        private String groupName;
        private String displayName;
        private Map<String, Counter> subcounters = new HashMap<String, Counter>();
        private ResourceBundle bundle = null;

        Group(String groupName) {
            try {
                this.bundle = Group.getResourceBundle(groupName);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            this.groupName = groupName;
            this.displayName = this.localize("CounterGroupName", groupName);
            LOG.debug((Object)("Creating group " + groupName + " with " + (this.bundle == null ? "nothing" : "bundle")));
        }

        private static ResourceBundle getResourceBundle(String enumClassName) {
            String bundleName = enumClassName.replace('$', '_');
            return ResourceBundle.getBundle(bundleName);
        }

        public String getName() {
            return this.groupName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public synchronized long getCounter(String counterName) {
            for (Counter counter : this.subcounters.values()) {
                if (counter == null || !counter.displayName.equals(counterName)) continue;
                return counter.value;
            }
            return 0L;
        }

        @Deprecated
        public synchronized Counter getCounter(int id, String name) {
            return this.getCounterForName(name);
        }

        public synchronized Counter getCounterForName(String name) {
            Counter result = this.subcounters.get(name);
            if (result == null) {
                LOG.debug((Object)("Adding " + name));
                result = new Counter(name, this.localize(name + ".name", name), 0L);
                this.subcounters.put(name, result);
            }
            return result;
        }

        public synchronized int size() {
            return this.subcounters.size();
        }

        private String localize(String key, String defaultValue) {
            String result = defaultValue;
            if (this.bundle != null) {
                try {
                    result = this.bundle.getString(key);
                }
                catch (MissingResourceException mre) {
                    // empty catch block
                }
            }
            return result;
        }

        @Override
        public synchronized void write(DataOutput out) throws IOException {
            Text.writeString(out, this.displayName);
            WritableUtils.writeVInt(out, this.subcounters.size());
            for (Counter counter : this.subcounters.values()) {
                counter.write(out);
            }
        }

        @Override
        public synchronized void readFields(DataInput in) throws IOException {
            this.displayName = Text.readString(in);
            this.subcounters.clear();
            int size = WritableUtils.readVInt(in);
            for (int i = 0; i < size; ++i) {
                Counter counter = new Counter();
                counter.readFields(in);
                this.subcounters.put(counter.getName(), counter);
            }
        }

        @Override
        public synchronized Iterator<Counter> iterator() {
            return new ArrayList<Counter>(this.subcounters.values()).iterator();
        }
    }

    public static class Counter
    implements Writable {
        private String name;
        private String displayName;
        private long value;

        Counter() {
            this.value = 0L;
        }

        Counter(String name, String displayName, long value) {
            this.name = name;
            this.displayName = displayName;
            this.value = value;
        }

        public synchronized void readFields(DataInput in) throws IOException {
            this.name = Text.readString(in);
            this.displayName = in.readBoolean() ? Text.readString(in) : this.name;
            this.value = WritableUtils.readVLong(in);
        }

        public synchronized void write(DataOutput out) throws IOException {
            Text.writeString(out, this.name);
            boolean distinctDisplayName = !this.name.equals(this.displayName);
            out.writeBoolean(distinctDisplayName);
            if (distinctDisplayName) {
                Text.writeString(out, this.displayName);
            }
            WritableUtils.writeVLong(out, this.value);
        }

        public synchronized String getName() {
            return this.name;
        }

        public synchronized String getDisplayName() {
            return this.displayName;
        }

        public synchronized long getCounter() {
            return this.value;
        }

        public synchronized void increment(long incr) {
            this.value += incr;
        }
    }
}

