/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ID
implements WritableComparable<ID> {
    protected int id;

    public ID(int id) {
        this.id = id;
    }

    protected ID() {
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return String.valueOf(this.id);
    }

    public int hashCode() {
        return Integer.valueOf(this.id).hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass().equals(ID.class)) {
            ID that = (ID)o;
            return this.id == that.id;
        }
        return false;
    }

    @Override
    public int compareTo(ID that) {
        return this.id - that.id;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.id = in.readInt();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.id);
    }

    public static ID read(DataInput in) throws IOException {
        ID id = new ID();
        id.readFields(in);
        return id;
    }

    public static ID forName(String str) throws IllegalArgumentException {
        if (str == null) {
            return null;
        }
        try {
            int id = Integer.parseInt(str);
            return new ID(id);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Id string : " + str + " is not propoerly formed");
        }
    }
}

