/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapred.RamManager;

class IFile {
    private static int EOF_MARKER = -1;

    IFile() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InMemoryReader<K, V>
    extends Reader<K, V> {
        RamManager ramManager;

        public InMemoryReader(RamManager ramManager, byte[] data, int start, int length) {
            this.ramManager = ramManager;
            this.buffer = data;
            this.bufferSize = length - start;
            this.fileLength = this.bufferSize;
            this.dataIn.reset(this.buffer, start, length);
        }

        @Override
        public boolean next(DataInputBuffer key, DataInputBuffer value) throws IOException {
            if (this.eof) {
                throw new EOFException("Completed reading " + this.bytesRead);
            }
            int oldPos = this.dataIn.getPosition();
            int keyLength = WritableUtils.readVInt(this.dataIn);
            int valueLength = WritableUtils.readVInt(this.dataIn);
            int pos = this.dataIn.getPosition();
            this.bytesRead += (long)(pos - oldPos);
            if (keyLength == EOF_MARKER && valueLength == EOF_MARKER) {
                this.eof = true;
                return false;
            }
            int recordLength = keyLength + valueLength;
            pos = this.dataIn.getPosition();
            byte[] data = this.dataIn.getData();
            key.reset(data, pos, keyLength);
            value.reset(data, pos + keyLength, valueLength);
            long skipped = this.dataIn.skip(recordLength);
            if (skipped != (long)recordLength) {
                throw new IOException("Failed to skip past record of length: " + recordLength);
            }
            this.bytesRead += (long)recordLength;
            return true;
        }

        @Override
        public void close() {
            this.dataIn = null;
            this.buffer = null;
            this.ramManager.unreserve(this.bufferSize);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Reader<K, V> {
        private static final int DEFAULT_BUFFER_SIZE = 131072;
        private static final int MAX_VINT_SIZE = 5;
        InputStream in;
        Decompressor decompressor;
        long bytesRead = 0L;
        long fileLength = 0L;
        boolean eof = false;
        byte[] buffer = null;
        int bufferSize = 131072;
        DataInputBuffer dataIn = new DataInputBuffer();

        public Reader(Configuration conf, FileSystem fs, Path file, CompressionCodec codec) throws IOException {
            this(conf, fs.open(file), fs.getFileStatus(file).getLen(), codec);
        }

        protected Reader() {
        }

        public Reader(Configuration conf, InputStream in, long length, CompressionCodec codec) throws IOException {
            if (codec != null) {
                this.decompressor = CodecPool.getDecompressor(codec);
                this.in = codec.createInputStream(in, this.decompressor);
            } else {
                this.in = in;
            }
            this.fileLength = length;
            this.bufferSize = conf.getInt("io.file.buffer.size", 131072);
        }

        public long getLength() {
            return this.fileLength;
        }

        private int readData(byte[] buf, int off, int len) throws IOException {
            int n;
            for (int bytesRead = 0; bytesRead < len; bytesRead += n) {
                n = this.in.read(buf, off + bytesRead, len - bytesRead);
                if (n >= 0) continue;
                return bytesRead;
            }
            return len;
        }

        void readNextBlock(int minSize) throws IOException {
            if (this.buffer == null) {
                this.buffer = new byte[this.bufferSize];
                this.dataIn.reset(this.buffer, 0, 0);
            }
            this.buffer = this.rejigData(this.buffer, this.bufferSize < minSize ? new byte[minSize << 1] : this.buffer);
            this.bufferSize = this.buffer.length;
        }

        private byte[] rejigData(byte[] source, byte[] destination) throws IOException {
            int bytesRemaining = this.dataIn.getLength() - this.dataIn.getPosition();
            if (bytesRemaining > 0) {
                System.arraycopy(source, this.dataIn.getPosition(), destination, 0, bytesRemaining);
            }
            int n = this.readData(destination, bytesRemaining, destination.length - bytesRemaining);
            this.dataIn.reset(destination, 0, bytesRemaining + n);
            return destination;
        }

        public boolean next(DataInputBuffer key, DataInputBuffer value) throws IOException {
            if (this.eof) {
                throw new EOFException("Completed reading " + this.bytesRead);
            }
            if (this.dataIn.getLength() - this.dataIn.getPosition() < 10) {
                this.readNextBlock(10);
            }
            int oldPos = this.dataIn.getPosition();
            int keyLength = WritableUtils.readVInt(this.dataIn);
            int valueLength = WritableUtils.readVInt(this.dataIn);
            int pos = this.dataIn.getPosition();
            this.bytesRead += (long)(pos - oldPos);
            if (keyLength == EOF_MARKER && valueLength == EOF_MARKER) {
                this.eof = true;
                return false;
            }
            int recordLength = keyLength + valueLength;
            if (this.dataIn.getLength() - pos < recordLength) {
                this.readNextBlock(recordLength);
                if (this.dataIn.getLength() - this.dataIn.getPosition() < recordLength) {
                    throw new EOFException("Could read the next record");
                }
            }
            pos = this.dataIn.getPosition();
            byte[] data = this.dataIn.getData();
            key.reset(data, pos, keyLength);
            value.reset(data, pos + keyLength, valueLength);
            this.dataIn.skip(recordLength);
            this.bytesRead += (long)recordLength;
            return true;
        }

        public void close() throws IOException {
            if (this.decompressor != null) {
                this.decompressor.reset();
                CodecPool.returnDecompressor(this.decompressor);
            }
            if (this.in != null) {
                this.in.close();
            }
            this.dataIn = null;
            this.buffer = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Writer<K, V> {
        FSDataOutputStream out;
        boolean ownOutputStream = false;
        long start = 0L;
        CompressionOutputStream compressedOut;
        Compressor compressor;
        boolean compressOutput = false;
        long decompressedBytesWritten = 0L;
        long compressedBytesWritten = 0L;
        Class<K> keyClass;
        Class<V> valueClass;
        Serializer<K> keySerializer;
        Serializer<V> valueSerializer;
        DataOutputBuffer buffer = new DataOutputBuffer();

        public Writer(Configuration conf, FileSystem fs, Path file, Class<K> keyClass, Class<V> valueClass, CompressionCodec codec) throws IOException {
            this(conf, fs.create(file), keyClass, valueClass, codec);
            this.ownOutputStream = true;
        }

        public Writer(Configuration conf, FSDataOutputStream out, Class<K> keyClass, Class<V> valueClass, CompressionCodec codec) throws IOException {
            if (codec != null) {
                this.compressor = CodecPool.getCompressor(codec);
                this.compressor.reset();
                this.compressedOut = codec.createOutputStream(out, this.compressor);
                this.out = new FSDataOutputStream(this.compressedOut, null);
                this.compressOutput = true;
            } else {
                this.out = out;
            }
            this.start = this.out.getPos();
            this.keyClass = keyClass;
            this.valueClass = valueClass;
            SerializationFactory serializationFactory = new SerializationFactory(conf);
            this.keySerializer = serializationFactory.getSerializer(keyClass);
            this.keySerializer.open(this.buffer);
            this.valueSerializer = serializationFactory.getSerializer(valueClass);
            this.valueSerializer.open(this.buffer);
        }

        public void close() throws IOException {
            WritableUtils.writeVInt(this.out, EOF_MARKER);
            WritableUtils.writeVInt(this.out, EOF_MARKER);
            this.decompressedBytesWritten += (long)(2 * WritableUtils.getVIntSize(EOF_MARKER));
            if (this.compressOutput) {
                this.compressedOut.finish();
                this.compressedOut.resetState();
                CodecPool.returnCompressor(this.compressor);
            }
            this.keySerializer.close();
            this.valueSerializer.close();
            if (this.out != null) {
                this.out.flush();
                this.compressedBytesWritten = this.out.getPos() - this.start;
                if (this.ownOutputStream) {
                    this.out.close();
                }
                this.out = null;
            }
        }

        public void append(K key, V value) throws IOException {
            if (key.getClass() != this.keyClass) {
                throw new IOException("wrong key class: " + key.getClass() + " is not " + this.keyClass);
            }
            if (value.getClass() != this.valueClass) {
                throw new IOException("wrong value class: " + value.getClass() + " is not " + this.valueClass);
            }
            this.keySerializer.serialize(key);
            int keyLength = this.buffer.getLength();
            if (keyLength == 0) {
                throw new IOException("zero length keys not allowed: " + key);
            }
            this.valueSerializer.serialize(value);
            int valueLength = this.buffer.getLength() - keyLength;
            WritableUtils.writeVInt(this.out, keyLength);
            WritableUtils.writeVInt(this.out, valueLength);
            this.out.write(this.buffer.getData(), 0, this.buffer.getLength());
            this.buffer.reset();
            this.decompressedBytesWritten += (long)(keyLength + valueLength + WritableUtils.getVIntSize(keyLength) + WritableUtils.getVIntSize(valueLength));
        }

        public void append(DataInputBuffer key, DataInputBuffer value) throws IOException {
            int keyLength = key.getLength() - key.getPosition();
            int valueLength = value.getLength() - value.getPosition();
            WritableUtils.writeVInt(this.out, keyLength);
            WritableUtils.writeVInt(this.out, valueLength);
            this.out.write(key.getData(), key.getPosition(), keyLength);
            this.out.write(value.getData(), value.getPosition(), valueLength);
            this.decompressedBytesWritten += (long)(keyLength + valueLength + WritableUtils.getVIntSize(keyLength) + WritableUtils.getVIntSize(valueLength));
        }

        public long getRawLength() {
            return this.decompressedBytesWritten;
        }

        public long getCompressedLength() {
            return this.compressedBytesWritten;
        }
    }
}

