/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.HistoryViewer;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobSubmissionProtocol;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.LocalJobRunner;
import org.apache.hadoop.mapred.MRConstants;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UnixUserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class JobClient
extends Configured
implements MRConstants,
Tool {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.JobClient");
    private TaskStatusFilter taskOutputFilter = TaskStatusFilter.FAILED;
    static long MAX_JOBPROFILE_AGE = 2000L;
    JobSubmissionProtocol jobSubmitClient;
    Path sysDir = null;
    FileSystem fs = null;
    static Random r = new Random();
    private static final FsPermission JOB_FILE_PERMISSION = FsPermission.createImmutable((short)420);
    static final FsPermission JOB_DIR_PERMISSION = FsPermission.createImmutable((short)511);
    private static final int CURRENT_SPLIT_FILE_VERSION = 0;
    private static final byte[] SPLIT_FILE_HEADER = "SPL".getBytes();

    public JobClient() {
    }

    public JobClient(JobConf conf) throws IOException {
        this.setConf(conf);
        this.init(conf);
    }

    public void init(JobConf conf) throws IOException {
        String tracker = conf.get("mapred.job.tracker", "local");
        this.jobSubmitClient = "local".equals(tracker) ? new LocalJobRunner(conf) : this.createRPCProxy(JobTracker.getAddress(conf), conf);
    }

    private JobSubmissionProtocol createRPCProxy(InetSocketAddress addr, Configuration conf) throws IOException {
        return (JobSubmissionProtocol)RPC.getProxy(JobSubmissionProtocol.class, 10L, addr, conf, NetUtils.getSocketFactory(conf, JobSubmissionProtocol.class));
    }

    public JobClient(InetSocketAddress jobTrackAddr, Configuration conf) throws IOException {
        this.jobSubmitClient = this.createRPCProxy(jobTrackAddr, conf);
    }

    public synchronized void close() throws IOException {
        if (!(this.jobSubmitClient instanceof LocalJobRunner)) {
            RPC.stopProxy(this.jobSubmitClient);
        }
    }

    public synchronized FileSystem getFs() throws IOException {
        if (this.fs == null) {
            Path sysDir = this.getSystemDir();
            this.fs = sysDir.getFileSystem(this.getConf());
        }
        return this.fs;
    }

    private boolean compareFs(FileSystem srcFs, FileSystem destFs) {
        URI srcUri = srcFs.getUri();
        URI dstUri = destFs.getUri();
        if (srcUri.getScheme() == null) {
            return false;
        }
        if (!srcUri.getScheme().equals(dstUri.getScheme())) {
            return false;
        }
        String srcHost = srcUri.getHost();
        String dstHost = dstUri.getHost();
        if (srcHost != null && dstHost != null) {
            try {
                srcHost = InetAddress.getByName(srcHost).getCanonicalHostName();
                dstHost = InetAddress.getByName(dstHost).getCanonicalHostName();
            }
            catch (UnknownHostException ue) {
                return false;
            }
            if (!srcHost.equals(dstHost)) {
                return false;
            }
        } else {
            if (srcHost == null && dstHost != null) {
                return false;
            }
            if (srcHost != null && dstHost == null) {
                return false;
            }
        }
        return srcUri.getPort() == dstUri.getPort();
    }

    private Path copyRemoteFiles(FileSystem jtFs, Path parentDir, Path originalPath, JobConf job, short replication) throws IOException {
        FileSystem remoteFs = null;
        remoteFs = originalPath.getFileSystem(job);
        if (this.compareFs(remoteFs, jtFs)) {
            return originalPath;
        }
        Path newPath = new Path(parentDir, originalPath.getName());
        FileUtil.copy(remoteFs, originalPath, jtFs, newPath, false, job);
        jtFs.setReplication(newPath, replication);
        return newPath;
    }

    private void configureCommandLineOptions(JobConf job, Path submitJobDir, Path submitJarFile) throws IOException {
        String originalJarPath;
        URI[] tfiles;
        URI[] tarchives;
        URI pathURI;
        Path newPath;
        Path tmp;
        String files = null;
        String libjars = null;
        String archives = null;
        files = job.get("tmpfiles");
        libjars = job.get("tmpjars");
        archives = job.get("tmparchives");
        UnixUserGroupInformation ugi = null;
        try {
            ugi = UnixUserGroupInformation.login(job, true);
        }
        catch (LoginException e) {
            throw (IOException)new IOException("Failed to get the current user's information.").initCause(e);
        }
        FileSystem fs = this.getFs();
        LOG.debug((Object)("default FileSystem: " + fs.getUri()));
        fs.delete(submitJobDir, true);
        submitJobDir = fs.makeQualified(submitJobDir);
        submitJobDir = new Path(submitJobDir.toUri().getPath());
        FsPermission mapredSysPerms = new FsPermission(JOB_DIR_PERMISSION);
        FileSystem.mkdirs(fs, submitJobDir, mapredSysPerms);
        Path filesDir = new Path(submitJobDir, "files");
        Path archivesDir = new Path(submitJobDir, "archives");
        Path libjarsDir = new Path(submitJobDir, "libjars");
        short replication = (short)job.getInt("mapred.submit.replication", 10);
        if (files != null) {
            String[] fileArr;
            FileSystem.mkdirs(fs, filesDir, mapredSysPerms);
            for (String tmpFile : fileArr = files.split(",")) {
                tmp = new Path(tmpFile);
                newPath = this.copyRemoteFiles(fs, filesDir, tmp, job, replication);
                try {
                    pathURI = new URI(newPath.toUri().toString() + "#" + newPath.getName());
                    DistributedCache.addCacheFile(pathURI, job);
                }
                catch (URISyntaxException ue) {
                    throw new IOException("Failed to create uri for " + tmpFile);
                }
                DistributedCache.createSymlink(job);
            }
        }
        if (libjars != null) {
            String[] libjarsArr;
            FileSystem.mkdirs(fs, libjarsDir, mapredSysPerms);
            for (String tmpjars : libjarsArr = libjars.split(",")) {
                tmp = new Path(tmpjars);
                newPath = this.copyRemoteFiles(fs, libjarsDir, tmp, job, replication);
                DistributedCache.addArchiveToClassPath(newPath, job);
            }
        }
        if (archives != null) {
            String[] archivesArr;
            FileSystem.mkdirs(fs, archivesDir, mapredSysPerms);
            for (String tmpArchives : archivesArr = archives.split(",")) {
                tmp = new Path(tmpArchives);
                newPath = this.copyRemoteFiles(fs, archivesDir, tmp, job, replication);
                try {
                    pathURI = new URI(newPath.toUri().toString() + "#" + newPath.getName());
                    DistributedCache.addCacheArchive(pathURI, job);
                }
                catch (URISyntaxException ue) {
                    throw new IOException("Failed to create uri for " + tmpArchives);
                }
                DistributedCache.createSymlink(job);
            }
        }
        if ((tarchives = DistributedCache.getCacheArchives(job)) != null) {
            StringBuffer archiveTimestamps = new StringBuffer(String.valueOf(DistributedCache.getTimestamp(job, tarchives[0])));
            for (int i = 1; i < tarchives.length; ++i) {
                archiveTimestamps.append(",");
                archiveTimestamps.append(String.valueOf(DistributedCache.getTimestamp(job, tarchives[i])));
            }
            DistributedCache.setArchiveTimestamps(job, archiveTimestamps.toString());
        }
        if ((tfiles = DistributedCache.getCacheFiles(job)) != null) {
            StringBuffer fileTimestamps = new StringBuffer(String.valueOf(DistributedCache.getTimestamp(job, tfiles[0])));
            for (int i = 1; i < tfiles.length; ++i) {
                fileTimestamps.append(",");
                fileTimestamps.append(String.valueOf(DistributedCache.getTimestamp(job, tfiles[i])));
            }
            DistributedCache.setFileTimestamps(job, fileTimestamps.toString());
        }
        if ((originalJarPath = job.getJar()) != null) {
            if ("".equals(job.getJobName())) {
                job.setJobName(new Path(originalJarPath).getName());
            }
            job.setJar(submitJarFile.toString());
            fs.copyFromLocalFile(new Path(originalJarPath), submitJarFile);
            fs.setReplication(submitJarFile, replication);
            fs.setPermission(submitJarFile, new FsPermission(JOB_FILE_PERMISSION));
        } else {
            LOG.warn((Object)"No job jar file set.  User classes may not be found. See JobConf(Class) or JobConf#setJar(String).");
        }
        job.setUser(ugi.getUserName());
        if (job.getWorkingDirectory() == null) {
            job.setWorkingDirectory(fs.getWorkingDirectory());
        }
    }

    public RunningJob submitJob(String jobFile) throws FileNotFoundException, InvalidJobConfException, IOException {
        JobConf job = new JobConf(jobFile);
        return this.submitJob(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunningJob submitJob(JobConf job) throws FileNotFoundException, InvalidJobConfException, IOException {
        JobID jobId = this.jobSubmitClient.getNewJobId();
        Path submitJobDir = new Path(this.getSystemDir(), jobId.toString());
        Path submitJarFile = new Path(submitJobDir, "job.jar");
        Path submitSplitFile = new Path(submitJobDir, "job.split");
        this.configureCommandLineOptions(job, submitJobDir, submitJarFile);
        Path submitJobFile = new Path(submitJobDir, "job.xml");
        InputFormat inFormat = job.getInputFormat();
        inFormat.validateInput(job);
        job.getOutputFormat().checkOutputSpecs(this.fs, job);
        LOG.debug((Object)("Creating splits at " + this.fs.makeQualified(submitSplitFile)));
        InputSplit[] splits = inFormat.getSplits(job, job.getNumMapTasks());
        Arrays.sort(splits, new Comparator<InputSplit>(){

            @Override
            public int compare(InputSplit a, InputSplit b) {
                try {
                    long left = a.getLength();
                    long right = b.getLength();
                    if (left == right) {
                        return 0;
                    }
                    if (left < right) {
                        return 1;
                    }
                    return -1;
                }
                catch (IOException ie) {
                    throw new RuntimeException("Problem getting input split size", ie);
                }
            }
        });
        FSDataOutputStream out = FileSystem.create(this.fs, submitSplitFile, new FsPermission(JOB_FILE_PERMISSION));
        try {
            this.writeSplitsFile(splits, out);
        }
        finally {
            out.close();
        }
        job.set("mapred.job.split.file", submitSplitFile.toString());
        job.setNumMapTasks(splits.length);
        out = FileSystem.create(this.fs, submitJobFile, new FsPermission(JOB_FILE_PERMISSION));
        try {
            job.write(out);
        }
        finally {
            out.close();
        }
        JobStatus status = this.jobSubmitClient.submitJob(jobId);
        if (status != null) {
            return new NetworkedJob(status);
        }
        throw new IOException("Could not launch job");
    }

    private void writeSplitsFile(InputSplit[] splits, FSDataOutputStream out) throws IOException {
        out.write(SPLIT_FILE_HEADER);
        WritableUtils.writeVInt(out, 0);
        WritableUtils.writeVInt(out, splits.length);
        DataOutputBuffer buffer = new DataOutputBuffer();
        RawSplit rawSplit = new RawSplit();
        for (InputSplit split : splits) {
            rawSplit.setClassName(split.getClass().getName());
            buffer.reset();
            split.write(buffer);
            rawSplit.setBytes(buffer.getData(), 0, buffer.getLength());
            rawSplit.setLocations(split.getLocations());
            rawSplit.write(out);
        }
    }

    static RawSplit[] readSplitFile(DataInput in) throws IOException {
        byte[] header = new byte[SPLIT_FILE_HEADER.length];
        in.readFully(header);
        if (!Arrays.equals(SPLIT_FILE_HEADER, header)) {
            throw new IOException("Invalid header on split file");
        }
        int vers = WritableUtils.readVInt(in);
        if (vers != 0) {
            throw new IOException("Unsupported split version " + vers);
        }
        int len = WritableUtils.readVInt(in);
        RawSplit[] result = new RawSplit[len];
        for (int i = 0; i < len; ++i) {
            result[i] = new RawSplit();
            result[i].readFields(in);
        }
        return result;
    }

    public RunningJob getJob(JobID jobid) throws IOException {
        JobStatus status = this.jobSubmitClient.getJobStatus(jobid);
        if (status != null) {
            return new NetworkedJob(status);
        }
        return null;
    }

    @Deprecated
    public RunningJob getJob(String jobid) throws IOException {
        return this.getJob(JobID.forName(jobid));
    }

    public TaskReport[] getMapTaskReports(JobID jobId) throws IOException {
        return this.jobSubmitClient.getMapTaskReports(jobId);
    }

    @Deprecated
    public TaskReport[] getMapTaskReports(String jobId) throws IOException {
        return this.getMapTaskReports(JobID.forName(jobId));
    }

    public TaskReport[] getReduceTaskReports(JobID jobId) throws IOException {
        return this.jobSubmitClient.getReduceTaskReports(jobId);
    }

    @Deprecated
    public TaskReport[] getReduceTaskReports(String jobId) throws IOException {
        return this.getReduceTaskReports(JobID.forName(jobId));
    }

    public ClusterStatus getClusterStatus() throws IOException {
        return this.jobSubmitClient.getClusterStatus();
    }

    public JobStatus[] jobsToComplete() throws IOException {
        return this.jobSubmitClient.jobsToComplete();
    }

    private static void downloadProfile(TaskCompletionEvent e) throws IOException {
        URLConnection connection = new URL(JobClient.getTaskLogURL(e.getTaskAttemptId(), e.getTaskTrackerHttp()) + "&filter=profile").openConnection();
        InputStream in = connection.getInputStream();
        FileOutputStream out = new FileOutputStream(e.getTaskAttemptId() + ".profile");
        IOUtils.copyBytes(in, (OutputStream)out, 65536, true);
    }

    public JobStatus[] getAllJobs() throws IOException {
        return this.jobSubmitClient.getAllJobs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RunningJob runJob(JobConf job) throws IOException {
        TaskStatusFilter filter;
        JobClient jc = new JobClient(job);
        boolean error = true;
        RunningJob running = null;
        String lastReport = null;
        int MAX_RETRIES = 5;
        int retries = 5;
        try {
            filter = JobClient.getTaskOutputFilter(job);
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Object)("Invalid Output filter : " + e.getMessage() + " Valid values are : NONE, FAILED, SUCCEEDED, ALL"));
            throw e;
        }
        try {
            running = jc.submitJob(job);
            JobID jobId = running.getID();
            LOG.info((Object)("Running job: " + jobId));
            int eventCounter = 0;
            boolean profiling = job.getProfileEnabled();
            Configuration.IntegerRanges mapRanges = job.getProfileTaskRange(true);
            Configuration.IntegerRanges reduceRanges = job.getProfileTaskRange(false);
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    if (running.isComplete()) break;
                    running = jc.getJob(jobId);
                    String report = " map " + StringUtils.formatPercent(running.mapProgress(), 0) + " reduce " + StringUtils.formatPercent(running.reduceProgress(), 0);
                    if (!report.equals(lastReport)) {
                        LOG.info((Object)report);
                        lastReport = report;
                    }
                    TaskCompletionEvent[] events = running.getTaskCompletionEvents(eventCounter);
                    eventCounter += events.length;
                    block17: for (TaskCompletionEvent event : events) {
                        TaskCompletionEvent.Status status = event.getTaskStatus();
                        if (profiling && (status == TaskCompletionEvent.Status.SUCCEEDED || status == TaskCompletionEvent.Status.FAILED) && (event.isMap ? mapRanges : reduceRanges).isIncluded(event.idWithinJob())) {
                            JobClient.downloadProfile(event);
                        }
                        switch (filter) {
                            case NONE: {
                                continue block17;
                            }
                            case SUCCEEDED: {
                                if (event.getTaskStatus() != TaskCompletionEvent.Status.SUCCEEDED) continue block17;
                                LOG.info((Object)event.toString());
                                JobClient.displayTaskLogs(event.getTaskAttemptId(), event.getTaskTrackerHttp());
                                continue block17;
                            }
                            case FAILED: {
                                if (event.getTaskStatus() != TaskCompletionEvent.Status.FAILED) continue block17;
                                LOG.info((Object)event.toString());
                                TaskAttemptID taskId = event.getTaskAttemptId();
                                String[] taskDiagnostics = jc.jobSubmitClient.getTaskDiagnostics(taskId);
                                if (taskDiagnostics != null) {
                                    for (String diagnostics : taskDiagnostics) {
                                        System.err.println(diagnostics);
                                    }
                                }
                                JobClient.displayTaskLogs(event.getTaskAttemptId(), event.getTaskTrackerHttp());
                                continue block17;
                            }
                            case KILLED: {
                                if (event.getTaskStatus() != TaskCompletionEvent.Status.KILLED) continue block17;
                                LOG.info((Object)event.toString());
                                continue block17;
                            }
                            case ALL: {
                                LOG.info((Object)event.toString());
                                JobClient.displayTaskLogs(event.getTaskAttemptId(), event.getTaskTrackerHttp());
                            }
                        }
                    }
                    retries = 5;
                }
                catch (IOException ie) {
                    if (--retries == 0) {
                        LOG.warn((Object)"Final attempt failed, killing job.");
                        throw ie;
                    }
                    LOG.info((Object)("Communication problem with server: " + StringUtils.stringifyException(ie)));
                }
            }
            if (!running.isSuccessful()) {
                throw new IOException("Job failed!");
            }
            LOG.info((Object)("Job complete: " + jobId));
            running.getCounters().log(LOG);
            error = false;
        }
        finally {
            if (error && running != null) {
                running.killJob();
            }
            jc.close();
        }
        return running;
    }

    static String getTaskLogURL(TaskAttemptID taskId, String baseUrl) {
        return baseUrl + "/tasklog?plaintext=true&taskid=" + taskId;
    }

    private static void displayTaskLogs(TaskAttemptID taskId, String baseUrl) throws IOException {
        if (baseUrl != null) {
            String taskLogUrl = JobClient.getTaskLogURL(taskId, baseUrl);
            JobClient.getTaskLogs(taskId, new URL(taskLogUrl + "&filter=stdout"), System.out);
            JobClient.getTaskLogs(taskId, new URL(taskLogUrl + "&filter=stderr"), System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getTaskLogs(TaskAttemptID taskId, URL taskLogUrl, OutputStream out) {
        try {
            URLConnection connection = taskLogUrl.openConnection();
            BufferedReader input = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            BufferedWriter output = new BufferedWriter(new OutputStreamWriter(out));
            try {
                String logData = null;
                while ((logData = input.readLine()) != null) {
                    if (logData.length() <= 0) continue;
                    output.write(taskId + ": " + logData + "\n");
                    output.flush();
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Error reading task output" + ioe.getMessage()));
        }
    }

    static Configuration getConfiguration(String jobTrackerSpec) {
        Configuration conf = new Configuration();
        if (jobTrackerSpec != null) {
            if (jobTrackerSpec.indexOf(":") >= 0) {
                conf.set("mapred.job.tracker", jobTrackerSpec);
            } else {
                String classpathFile = "hadoop-" + jobTrackerSpec + ".xml";
                URL validate = conf.getResource(classpathFile);
                if (validate == null) {
                    throw new RuntimeException(classpathFile + " not found on CLASSPATH");
                }
                conf.addResource(classpathFile);
            }
        }
        return conf;
    }

    @Deprecated
    public void setTaskOutputFilter(TaskStatusFilter newValue) {
        this.taskOutputFilter = newValue;
    }

    public static TaskStatusFilter getTaskOutputFilter(JobConf job) {
        return TaskStatusFilter.valueOf(job.get("jobclient.output.filter", "FAILED"));
    }

    public static void setTaskOutputFilter(JobConf job, TaskStatusFilter newValue) {
        job.set("jobclient.output.filter", newValue.toString());
    }

    @Deprecated
    public TaskStatusFilter getTaskOutputFilter() {
        return this.taskOutputFilter;
    }

    private void displayUsage(String cmd) {
        String prefix = "Usage: JobClient ";
        if ("-submit".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + " <job-file>]");
        } else if ("-status".equals(cmd) || "-kill".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + " <job-id>]");
        } else if ("-counter".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + " <job-id> <group-name> <counter-name>]");
        } else if ("-events".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + " <job-id> <from-event-#> <#-of-events>]");
        } else if ("-history".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + " <jobOutputDir>]");
        } else if ("-list".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + " [all]]");
        } else if ("-kill-task".equals(cmd) || "-fail-task".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + " <task-id>]");
        } else {
            System.err.printf(prefix + "<command> <args>\n", new Object[0]);
            System.err.printf("\t[-submit <job-file>]\n", new Object[0]);
            System.err.printf("\t[-status <job-id>]\n", new Object[0]);
            System.err.printf("\t[-counter <job-id> <group-name> <counter-name>]\n", new Object[0]);
            System.err.printf("\t[-kill <job-id>]\n", new Object[0]);
            System.err.printf("\t[-events <job-id> <from-event-#> <#-of-events>]\n", new Object[0]);
            System.err.printf("\t[-history <jobOutputDir>]\n", new Object[0]);
            System.err.printf("\t[-list [all]]\n", new Object[0]);
            System.err.printf("\t[-kill-task <task-id>]\n", new Object[0]);
            System.err.printf("\t[-fail-task <task-id>]\n\n", new Object[0]);
            ToolRunner.printGenericCommandUsage(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] argv) throws Exception {
        int exitCode = -1;
        if (argv.length < 1) {
            this.displayUsage("");
            return exitCode;
        }
        String cmd = argv[0];
        String submitJobFile = null;
        String jobid = null;
        String taskid = null;
        String outputDir = null;
        String counterGroupName = null;
        String counterName = null;
        int fromEvent = 0;
        int nEvents = 0;
        boolean getStatus = false;
        boolean getCounter = false;
        boolean killJob = false;
        boolean listEvents = false;
        boolean viewHistory = false;
        boolean viewAllHistory = false;
        boolean listJobs = false;
        boolean listAllJobs = false;
        boolean killTask = false;
        boolean failTask = false;
        if ("-submit".equals(cmd)) {
            if (argv.length != 2) {
                this.displayUsage(cmd);
                return exitCode;
            }
            submitJobFile = argv[1];
        } else if ("-status".equals(cmd)) {
            if (argv.length != 2) {
                this.displayUsage(cmd);
                return exitCode;
            }
            jobid = argv[1];
            getStatus = true;
        } else if ("-counter".equals(cmd)) {
            if (argv.length != 4) {
                this.displayUsage(cmd);
                return exitCode;
            }
            getCounter = true;
            jobid = argv[1];
            counterGroupName = argv[2];
            counterName = argv[3];
        } else if ("-kill".equals(cmd)) {
            if (argv.length != 2) {
                this.displayUsage(cmd);
                return exitCode;
            }
            jobid = argv[1];
            killJob = true;
        } else if ("-events".equals(cmd)) {
            if (argv.length != 4) {
                this.displayUsage(cmd);
                return exitCode;
            }
            jobid = argv[1];
            fromEvent = Integer.parseInt(argv[2]);
            nEvents = Integer.parseInt(argv[3]);
            listEvents = true;
        } else if ("-history".equals(cmd)) {
            if (!(argv.length == 2 || argv.length == 3 && "all".equals(argv[1]))) {
                this.displayUsage(cmd);
                return exitCode;
            }
            viewHistory = true;
            if (argv.length == 3 && "all".equals(argv[1])) {
                viewAllHistory = true;
                outputDir = argv[2];
            } else {
                outputDir = argv[1];
            }
        } else if ("-list".equals(cmd)) {
            if (!(argv.length == 1 || argv.length == 2 && "all".equals(argv[1]))) {
                this.displayUsage(cmd);
                return exitCode;
            }
            if (argv.length == 2 && "all".equals(argv[1])) {
                listAllJobs = true;
            } else {
                listJobs = true;
            }
        } else if ("-kill-task".equals(cmd)) {
            if (argv.length != 2) {
                this.displayUsage(cmd);
                return exitCode;
            }
            killTask = true;
            taskid = argv[1];
        } else if ("-fail-task".equals(cmd)) {
            if (argv.length != 2) {
                this.displayUsage(cmd);
                return exitCode;
            }
            failTask = true;
            taskid = argv[1];
        } else {
            this.displayUsage(cmd);
            return exitCode;
        }
        JobConf conf = null;
        conf = submitJobFile != null ? new JobConf(submitJobFile) : new JobConf(this.getConf());
        this.init(conf);
        try {
            if (submitJobFile != null) {
                RunningJob job = this.submitJob(conf);
                System.out.println("Created job " + job.getID());
                exitCode = 0;
            } else if (getStatus) {
                RunningJob job = this.getJob(JobID.forName(jobid));
                if (job == null) {
                    System.out.println("Could not find job " + jobid);
                } else {
                    System.out.println();
                    System.out.println(job);
                    System.out.println(job.getCounters());
                    exitCode = 0;
                }
            } else if (getCounter) {
                RunningJob job = this.getJob(JobID.forName(jobid));
                if (job == null) {
                    System.out.println("Could not find job " + jobid);
                } else {
                    Counters counters = job.getCounters();
                    Counters.Group group = counters.getGroup(counterGroupName);
                    Counters.Counter counter = group.getCounterForName(counterName);
                    System.out.println(counter.getCounter());
                    exitCode = 0;
                }
            } else if (killJob) {
                RunningJob job = this.getJob(JobID.forName(jobid));
                if (job == null) {
                    System.out.println("Could not find job " + jobid);
                } else {
                    job.killJob();
                    System.out.println("Killed job " + jobid);
                    exitCode = 0;
                }
            } else if (viewHistory) {
                this.viewHistory(outputDir, viewAllHistory);
                exitCode = 0;
            } else if (listEvents) {
                this.listEvents(JobID.forName(jobid), fromEvent, nEvents);
                exitCode = 0;
            } else if (listJobs) {
                this.listJobs();
                exitCode = 0;
            } else if (listAllJobs) {
                this.listAllJobs();
                exitCode = 0;
            } else if (killTask) {
                if (this.jobSubmitClient.killTask(TaskAttemptID.forName(taskid), false)) {
                    System.out.println("Killed task " + taskid);
                    exitCode = 0;
                } else {
                    System.out.println("Could not kill task " + taskid);
                    exitCode = -1;
                }
            } else if (failTask) {
                if (this.jobSubmitClient.killTask(TaskAttemptID.forName(taskid), true)) {
                    System.out.println("Killed task " + taskid + " by failing it");
                    exitCode = 0;
                } else {
                    System.out.println("Could not fail task " + taskid);
                    exitCode = -1;
                }
            }
        }
        finally {
            this.close();
        }
        return exitCode;
    }

    private void viewHistory(String outputDir, boolean all) throws IOException {
        HistoryViewer historyViewer = new HistoryViewer(outputDir, this.getConf(), all);
        historyViewer.print();
    }

    private void listEvents(JobID jobId, int fromEventId, int numEvents) throws IOException {
        TaskCompletionEvent[] events = this.jobSubmitClient.getTaskCompletionEvents(jobId, fromEventId, numEvents);
        System.out.println("Task completion events for " + jobId);
        System.out.println("Number of events (from " + fromEventId + ") are: " + events.length);
        for (TaskCompletionEvent event : events) {
            System.out.println((Object)((Object)event.getTaskStatus()) + " " + event.getTaskAttemptId() + " " + JobClient.getTaskLogURL(event.getTaskAttemptId(), event.getTaskTrackerHttp()));
        }
    }

    private void listJobs() throws IOException {
        JobStatus[] jobs = this.jobsToComplete();
        if (jobs == null) {
            jobs = new JobStatus[]{};
        }
        System.out.printf("%d jobs currently running\n", jobs.length);
        System.out.printf("JobId\tState\tStartTime\tUserName\n", new Object[0]);
        for (JobStatus job : jobs) {
            System.out.printf("%s\t%d\t%d\t%s\n", job.getJobID(), job.getRunState(), job.getStartTime(), job.getUsername());
        }
    }

    private void listAllJobs() throws IOException {
        JobStatus[] jobs = this.getAllJobs();
        if (jobs == null) {
            jobs = new JobStatus[]{};
        }
        System.out.printf("%d jobs submitted\n", jobs.length);
        System.out.printf("States are:\n\tRunning : 1\tSucceded : 2\tFailed : 3\tPrep : 4\n", new Object[0]);
        System.out.printf("JobId\tState\tStartTime\tUserName\n", new Object[0]);
        for (JobStatus job : jobs) {
            System.out.printf("%s\t%d\t%d\t%s\n", job.getJobID(), job.getRunState(), job.getStartTime(), job.getUsername());
        }
    }

    public int getDefaultMaps() throws IOException {
        return this.getClusterStatus().getMaxMapTasks();
    }

    public int getDefaultReduces() throws IOException {
        return this.getClusterStatus().getMaxReduceTasks();
    }

    public Path getSystemDir() {
        if (this.sysDir == null) {
            this.sysDir = new Path(this.jobSubmitClient.getSystemDir());
        }
        return this.sysDir;
    }

    public static void main(String[] argv) throws Exception {
        int res = ToolRunner.run(new JobClient(), argv);
        System.exit(res);
    }

    static class RawSplit
    implements Writable {
        private String splitClass;
        private BytesWritable bytes = new BytesWritable();
        private String[] locations;

        RawSplit() {
        }

        public void setBytes(byte[] data, int offset, int length) {
            this.bytes.set(data, offset, length);
        }

        public void setClassName(String className) {
            this.splitClass = className;
        }

        public String getClassName() {
            return this.splitClass;
        }

        public BytesWritable getBytes() {
            return this.bytes;
        }

        public void setLocations(String[] locations) {
            this.locations = locations;
        }

        public String[] getLocations() {
            return this.locations;
        }

        public void readFields(DataInput in) throws IOException {
            this.splitClass = Text.readString(in);
            this.bytes.readFields(in);
            int len = WritableUtils.readVInt(in);
            this.locations = new String[len];
            for (int i = 0; i < len; ++i) {
                this.locations[i] = Text.readString(in);
            }
        }

        public void write(DataOutput out) throws IOException {
            Text.writeString(out, this.splitClass);
            this.bytes.write(out);
            WritableUtils.writeVInt(out, this.locations.length);
            for (int i = 0; i < this.locations.length; ++i) {
                Text.writeString(out, this.locations[i]);
            }
        }
    }

    class NetworkedJob
    implements RunningJob {
        JobProfile profile;
        JobStatus status;
        long statustime;

        public NetworkedJob(JobStatus job) throws IOException {
            this.status = job;
            this.profile = JobClient.this.jobSubmitClient.getJobProfile(job.getJobID());
            this.statustime = System.currentTimeMillis();
        }

        synchronized void ensureFreshStatus() throws IOException {
            if (System.currentTimeMillis() - this.statustime > MAX_JOBPROFILE_AGE) {
                this.updateStatus();
            }
        }

        synchronized void updateStatus() throws IOException {
            this.status = JobClient.this.jobSubmitClient.getJobStatus(this.profile.getJobID());
            this.statustime = System.currentTimeMillis();
        }

        public JobID getID() {
            return this.profile.getJobID();
        }

        @Deprecated
        public String getJobID() {
            return this.profile.getJobID().toString();
        }

        public String getJobName() {
            return this.profile.getJobName();
        }

        public String getJobFile() {
            return this.profile.getJobFile();
        }

        public String getTrackingURL() {
            return this.profile.getURL().toString();
        }

        public float mapProgress() throws IOException {
            this.ensureFreshStatus();
            return this.status.mapProgress();
        }

        public float reduceProgress() throws IOException {
            this.ensureFreshStatus();
            return this.status.reduceProgress();
        }

        public synchronized boolean isComplete() throws IOException {
            this.updateStatus();
            return this.status.getRunState() == 2 || this.status.getRunState() == 3;
        }

        public synchronized boolean isSuccessful() throws IOException {
            this.updateStatus();
            return this.status.getRunState() == 2;
        }

        public void waitForCompletion() throws IOException {
            while (!this.isComplete()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public synchronized void killJob() throws IOException {
            JobClient.this.jobSubmitClient.killJob(this.getID());
        }

        public synchronized void killTask(TaskAttemptID taskId, boolean shouldFail) throws IOException {
            JobClient.this.jobSubmitClient.killTask(taskId, shouldFail);
        }

        @Deprecated
        public synchronized void killTask(String taskId, boolean shouldFail) throws IOException {
            this.killTask(TaskAttemptID.forName(taskId), shouldFail);
        }

        public synchronized TaskCompletionEvent[] getTaskCompletionEvents(int startFrom) throws IOException {
            return JobClient.this.jobSubmitClient.getTaskCompletionEvents(this.getID(), startFrom, 10);
        }

        public String toString() {
            try {
                this.updateStatus();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return "Job: " + this.profile.getJobID() + "\n" + "file: " + this.profile.getJobFile() + "\n" + "tracking URL: " + this.profile.getURL() + "\n" + "map() completion: " + this.status.mapProgress() + "\n" + "reduce() completion: " + this.status.reduceProgress();
        }

        public Counters getCounters() throws IOException {
            return JobClient.this.jobSubmitClient.getJobCounters(this.getID());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TaskStatusFilter {
        NONE,
        KILLED,
        FAILED,
        SUCCEEDED,
        ALL;

    }
}

