/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.MapRunnable;
import org.apache.hadoop.mapred.MapRunner;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.HashPartitioner;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobConf
extends Configuration {
    private static final Log LOG = LogFactory.getLog(JobConf.class);

    public JobConf() {
    }

    public JobConf(Class exampleClass) {
        this.setJarByClass(exampleClass);
    }

    public JobConf(Configuration conf) {
        super(conf);
    }

    public JobConf(Configuration conf, Class exampleClass) {
        this(conf);
        this.setJarByClass(exampleClass);
    }

    public JobConf(String config) {
        this(new Path(config));
    }

    public JobConf(Path config) {
        this.addResource(config);
    }

    public String getJar() {
        return this.get("mapred.jar");
    }

    public void setJar(String jar) {
        this.set("mapred.jar", jar);
    }

    public void setJarByClass(Class cls) {
        String jar = JobConf.findContainingJar(cls);
        if (jar != null) {
            this.setJar(jar);
        }
    }

    @Deprecated
    public Path getSystemDir() {
        return new Path(this.get("mapred.system.dir", "/tmp/hadoop/mapred/system"));
    }

    public String[] getLocalDirs() throws IOException {
        return this.getStrings("mapred.local.dir");
    }

    public void deleteLocalFiles() throws IOException {
        String[] localDirs = this.getLocalDirs();
        for (int i = 0; i < localDirs.length; ++i) {
            FileSystem.getLocal(this).delete(new Path(localDirs[i]));
        }
    }

    public void deleteLocalFiles(String subdir) throws IOException {
        String[] localDirs = this.getLocalDirs();
        for (int i = 0; i < localDirs.length; ++i) {
            FileSystem.getLocal(this).delete(new Path(localDirs[i], subdir));
        }
    }

    public Path getLocalPath(String pathString) throws IOException {
        return this.getLocalPath("mapred.local.dir", pathString);
    }

    @Deprecated
    public void setInputPath(Path dir) {
        dir = new Path(this.getWorkingDirectory(), dir);
        this.set("mapred.input.dir", dir.toString());
    }

    @Deprecated
    public void addInputPath(Path dir) {
        dir = new Path(this.getWorkingDirectory(), dir);
        String dirs = this.get("mapred.input.dir");
        this.set("mapred.input.dir", dirs == null ? dir.toString() : dirs + "," + dir);
    }

    @Deprecated
    public Path[] getInputPaths() {
        String dirs = this.get("mapred.input.dir", "");
        ArrayList<Object> list = Collections.list(new StringTokenizer(dirs, ","));
        Path[] result = new Path[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = new Path((String)list.get(i));
        }
        return result;
    }

    public String getUser() {
        return this.get("user.name");
    }

    public void setUser(String user) {
        this.set("user.name", user);
    }

    public void setKeepFailedTaskFiles(boolean keep) {
        this.setBoolean("keep.failed.task.files", keep);
    }

    public boolean getKeepFailedTaskFiles() {
        return this.getBoolean("keep.failed.task.files", false);
    }

    public void setKeepTaskFilesPattern(String pattern) {
        this.set("keep.task.files.pattern", pattern);
    }

    public String getKeepTaskFilesPattern() {
        return this.get("keep.task.files.pattern");
    }

    public void setWorkingDirectory(Path dir) {
        dir = new Path(this.getWorkingDirectory(), dir);
        this.set("mapred.working.dir", dir.toString());
    }

    public Path getWorkingDirectory() {
        String name = this.get("mapred.working.dir");
        if (name != null) {
            return new Path(name);
        }
        try {
            Path dir = FileSystem.get(this).getWorkingDirectory();
            this.set("mapred.working.dir", dir.toString());
            return dir;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public Path getOutputPath() {
        Path workOutputDir = FileOutputFormat.getWorkOutputPath(this);
        if (workOutputDir != null) {
            return workOutputDir;
        }
        return FileOutputFormat.getOutputPath(this);
    }

    @Deprecated
    public void setOutputPath(Path dir) {
        FileOutputFormat.setOutputPath(this, dir);
    }

    public InputFormat getInputFormat() {
        return (InputFormat)ReflectionUtils.newInstance(this.getClass("mapred.input.format.class", TextInputFormat.class, InputFormat.class), this);
    }

    public void setInputFormat(Class<? extends InputFormat> theClass) {
        this.setClass("mapred.input.format.class", theClass, InputFormat.class);
    }

    public OutputFormat getOutputFormat() {
        return (OutputFormat)ReflectionUtils.newInstance(this.getClass("mapred.output.format.class", TextOutputFormat.class, OutputFormat.class), this);
    }

    public void setOutputFormat(Class<? extends OutputFormat> theClass) {
        this.setClass("mapred.output.format.class", theClass, OutputFormat.class);
    }

    public void setCompressMapOutput(boolean compress) {
        this.setBoolean("mapred.compress.map.output", compress);
    }

    public boolean getCompressMapOutput() {
        return this.getBoolean("mapred.compress.map.output", false);
    }

    @Deprecated
    public void setMapOutputCompressionType(SequenceFile.CompressionType style) {
        this.setCompressMapOutput(true);
        this.set("mapred.map.output.compression.type", style.toString());
        LOG.warn((Object)"SequenceFile compression is no longer valid for intermediate map-outputs!");
    }

    @Deprecated
    public SequenceFile.CompressionType getMapOutputCompressionType() {
        String val = this.get("mapred.map.output.compression.type", SequenceFile.CompressionType.RECORD.toString());
        LOG.warn((Object)"SequenceFile compression is no longer valid for intermediate map-outputs!");
        return SequenceFile.CompressionType.valueOf(val);
    }

    public void setMapOutputCompressorClass(Class<? extends CompressionCodec> codecClass) {
        this.setCompressMapOutput(true);
        this.setClass("mapred.map.output.compression.codec", codecClass, CompressionCodec.class);
    }

    public Class<? extends CompressionCodec> getMapOutputCompressorClass(Class<? extends CompressionCodec> defaultValue) {
        Class<? extends CompressionCodec> codecClass = defaultValue;
        String name = this.get("mapred.map.output.compression.codec");
        if (name != null) {
            try {
                codecClass = this.getClassByName(name).asSubclass(CompressionCodec.class);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Compression codec " + name + " was not found.", e);
            }
        }
        return codecClass;
    }

    public Class<?> getMapOutputKeyClass() {
        Class<Object> retv = this.getClass("mapred.mapoutput.key.class", null, Object.class);
        if (retv == null) {
            retv = this.getOutputKeyClass();
        }
        return retv;
    }

    public void setMapOutputKeyClass(Class<?> theClass) {
        this.setClass("mapred.mapoutput.key.class", theClass, Object.class);
    }

    public Class<?> getMapOutputValueClass() {
        Class<Object> retv = this.getClass("mapred.mapoutput.value.class", null, Object.class);
        if (retv == null) {
            retv = this.getOutputValueClass();
        }
        return retv;
    }

    public void setMapOutputValueClass(Class<?> theClass) {
        this.setClass("mapred.mapoutput.value.class", theClass, Object.class);
    }

    public Class<?> getOutputKeyClass() {
        return this.getClass("mapred.output.key.class", LongWritable.class, Object.class);
    }

    public void setOutputKeyClass(Class<?> theClass) {
        this.setClass("mapred.output.key.class", theClass, Object.class);
    }

    public RawComparator getOutputKeyComparator() {
        Class<RawComparator> theClass = this.getClass("mapred.output.key.comparator.class", null, RawComparator.class);
        if (theClass != null) {
            return (RawComparator)ReflectionUtils.newInstance(theClass, this);
        }
        return WritableComparator.get(this.getMapOutputKeyClass());
    }

    public void setOutputKeyComparatorClass(Class<? extends RawComparator> theClass) {
        this.setClass("mapred.output.key.comparator.class", theClass, RawComparator.class);
    }

    public RawComparator getOutputValueGroupingComparator() {
        Class<RawComparator> theClass = this.getClass("mapred.output.value.groupfn.class", null, RawComparator.class);
        if (theClass == null) {
            return this.getOutputKeyComparator();
        }
        return (RawComparator)ReflectionUtils.newInstance(theClass, this);
    }

    public void setOutputValueGroupingComparator(Class<? extends RawComparator> theClass) {
        this.setClass("mapred.output.value.groupfn.class", theClass, RawComparator.class);
    }

    public Class<?> getOutputValueClass() {
        return this.getClass("mapred.output.value.class", Text.class, Object.class);
    }

    public void setOutputValueClass(Class<?> theClass) {
        this.setClass("mapred.output.value.class", theClass, Object.class);
    }

    public Class<? extends Mapper> getMapperClass() {
        return this.getClass("mapred.mapper.class", IdentityMapper.class, Mapper.class);
    }

    public void setMapperClass(Class<? extends Mapper> theClass) {
        this.setClass("mapred.mapper.class", theClass, Mapper.class);
    }

    public Class<? extends MapRunnable> getMapRunnerClass() {
        return this.getClass("mapred.map.runner.class", MapRunner.class, MapRunnable.class);
    }

    public void setMapRunnerClass(Class<? extends MapRunnable> theClass) {
        this.setClass("mapred.map.runner.class", theClass, MapRunnable.class);
    }

    public Class<? extends Partitioner> getPartitionerClass() {
        return this.getClass("mapred.partitioner.class", HashPartitioner.class, Partitioner.class);
    }

    public void setPartitionerClass(Class<? extends Partitioner> theClass) {
        this.setClass("mapred.partitioner.class", theClass, Partitioner.class);
    }

    public Class<? extends Reducer> getReducerClass() {
        return this.getClass("mapred.reducer.class", IdentityReducer.class, Reducer.class);
    }

    public void setReducerClass(Class<? extends Reducer> theClass) {
        this.setClass("mapred.reducer.class", theClass, Reducer.class);
    }

    public Class<? extends Reducer> getCombinerClass() {
        return this.getClass("mapred.combiner.class", null, Reducer.class);
    }

    public void setCombinerClass(Class<? extends Reducer> theClass) {
        this.setClass("mapred.combiner.class", theClass, Reducer.class);
    }

    public boolean getSpeculativeExecution() {
        return this.getMapSpeculativeExecution() || this.getReduceSpeculativeExecution();
    }

    public void setSpeculativeExecution(boolean speculativeExecution) {
        this.setMapSpeculativeExecution(speculativeExecution);
        this.setReduceSpeculativeExecution(speculativeExecution);
    }

    public boolean getMapSpeculativeExecution() {
        return this.getBoolean("mapred.map.tasks.speculative.execution", true);
    }

    public void setMapSpeculativeExecution(boolean speculativeExecution) {
        this.setBoolean("mapred.map.tasks.speculative.execution", speculativeExecution);
    }

    public boolean getReduceSpeculativeExecution() {
        return this.getBoolean("mapred.reduce.tasks.speculative.execution", true);
    }

    public void setReduceSpeculativeExecution(boolean speculativeExecution) {
        this.setBoolean("mapred.reduce.tasks.speculative.execution", speculativeExecution);
    }

    public int getNumMapTasks() {
        return this.getInt("mapred.map.tasks", 1);
    }

    public void setNumMapTasks(int n) {
        this.setInt("mapred.map.tasks", n);
    }

    public int getNumReduceTasks() {
        return this.getInt("mapred.reduce.tasks", 1);
    }

    public void setNumReduceTasks(int n) {
        this.setInt("mapred.reduce.tasks", n);
    }

    public int getMaxMapAttempts() {
        return this.getInt("mapred.map.max.attempts", 4);
    }

    public void setMaxMapAttempts(int n) {
        this.setInt("mapred.map.max.attempts", n);
    }

    public int getMaxReduceAttempts() {
        return this.getInt("mapred.reduce.max.attempts", 4);
    }

    public void setMaxReduceAttempts(int n) {
        this.setInt("mapred.reduce.max.attempts", n);
    }

    public String getJobName() {
        return this.get("mapred.job.name", "");
    }

    public void setJobName(String name) {
        this.set("mapred.job.name", name);
    }

    public String getSessionId() {
        return this.get("session.id", "");
    }

    public void setSessionId(String sessionId) {
        this.set("session.id", sessionId);
    }

    public void setMaxTaskFailuresPerTracker(int noFailures) {
        this.setInt("mapred.max.tracker.failures", noFailures);
    }

    public int getMaxTaskFailuresPerTracker() {
        return this.getInt("mapred.max.tracker.failures", 4);
    }

    public int getMaxMapTaskFailuresPercent() {
        return this.getInt("mapred.max.map.failures.percent", 0);
    }

    public void setMaxMapTaskFailuresPercent(int percent) {
        this.setInt("mapred.max.map.failures.percent", percent);
    }

    public int getMaxReduceTaskFailuresPercent() {
        return this.getInt("mapred.max.reduce.failures.percent", 0);
    }

    public void setMaxReduceTaskFailuresPercent(int percent) {
        this.setInt("mapred.max.reduce.failures.percent", percent);
    }

    public void setJobPriority(JobPriority prio) {
        this.set("mapred.job.priority", prio.toString());
    }

    public JobPriority getJobPriority() {
        String prio = this.get("mapred.job.priority");
        if (prio == null) {
            return JobPriority.NORMAL;
        }
        return JobPriority.valueOf(prio);
    }

    public boolean getProfileEnabled() {
        return this.getBoolean("mapred.task.profile", false);
    }

    public void setProfileEnabled(boolean newValue) {
        this.setBoolean("mapred.task.profile", newValue);
    }

    public String getProfileParams() {
        return this.get("mapred.task.profile.params", "-agentlib:hprof=cpu=samples,heap=sites,force=n,thread=y,verbose=n,file=%s");
    }

    public void setProfileParams(String value) {
        this.set("mapred.task.profile.params", value);
    }

    public Configuration.IntegerRanges getProfileTaskRange(boolean isMap) {
        return this.getRange(isMap ? "mapred.task.profile.maps" : "mapred.task.profile.reduces", "0-2");
    }

    public void setProfileTaskRange(boolean isMap, String newValue) {
        new Configuration.IntegerRanges(newValue);
        this.set(isMap ? "mapred.task.profile.maps" : "mapred.task.profile.reduces", newValue);
    }

    public void setMapDebugScript(String mDbgScript) {
        this.set("mapred.map.task.debug.script", mDbgScript);
    }

    public String getMapDebugScript() {
        return this.get("mapred.map.task.debug.script");
    }

    public void setReduceDebugScript(String rDbgScript) {
        this.set("mapred.reduce.task.debug.script", rDbgScript);
    }

    public String getReduceDebugScript() {
        return this.get("mapred.reduce.task.debug.script");
    }

    public String getJobEndNotificationURI() {
        return this.get("job.end.notification.url");
    }

    public void setJobEndNotificationURI(String uri) {
        this.set("job.end.notification.url", uri);
    }

    public String getJobLocalDir() {
        return this.get("job.local.dir");
    }

    private static String findContainingJar(Class my_class) {
        ClassLoader loader = my_class.getClassLoader();
        String class_file = my_class.getName().replaceAll("\\.", "/") + ".class";
        try {
            Enumeration<URL> itr = loader.getResources(class_file);
            while (itr.hasMoreElements()) {
                URL url = itr.nextElement();
                if (!"jar".equals(url.getProtocol())) continue;
                String toReturn = url.getPath();
                if (toReturn.startsWith("file:")) {
                    toReturn = toReturn.substring("file:".length());
                }
                toReturn = URLDecoder.decode(toReturn, "UTF-8");
                return toReturn.replaceAll("!.*$", "");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

