/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.NumberFormat;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.ID;

public class JobID
extends ID {
    private static final String JOB = "job";
    private String jtIdentifier;
    private static char UNDERSCORE = (char)95;
    private static NumberFormat idFormat = NumberFormat.getInstance();

    public JobID(String jtIdentifier, int id) {
        super(id);
        this.jtIdentifier = jtIdentifier;
    }

    private JobID() {
    }

    public String getJtIdentifier() {
        return this.jtIdentifier;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass().equals(JobID.class)) {
            JobID that = (JobID)o;
            return this.id == that.id && this.jtIdentifier.equals(that.jtIdentifier);
        }
        return false;
    }

    public int compareTo(ID o) {
        JobID that = (JobID)o;
        int jtComp = this.jtIdentifier.compareTo(that.jtIdentifier);
        if (jtComp == 0) {
            return this.id - that.id;
        }
        return jtComp;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        return builder.append(JOB).append(UNDERSCORE).append((CharSequence)this.toStringWOPrefix()).toString();
    }

    StringBuilder toStringWOPrefix() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.jtIdentifier).append(UNDERSCORE).append(idFormat.format(this.id)).toString();
        return builder;
    }

    public int hashCode() {
        return this.toStringWOPrefix().toString().hashCode();
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.jtIdentifier = Text.readString(in);
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        Text.writeString(out, this.jtIdentifier);
    }

    public static JobID read(DataInput in) throws IOException {
        JobID jobId = new JobID();
        jobId.readFields(in);
        return jobId;
    }

    public static JobID forName(String str) throws IllegalArgumentException {
        if (str == null) {
            return null;
        }
        try {
            String[] parts = str.split("_");
            if (parts.length == 3 && parts[0].equals(JOB)) {
                return new JobID(parts[1], Integer.parseInt(parts[2]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException("JobId string : " + str + " is not properly formed");
    }

    public static String getJobIDsPattern(String jtIdentifier, Integer jobId) {
        StringBuilder builder = new StringBuilder(JOB).append(UNDERSCORE);
        builder.append((CharSequence)JobID.getJobIDsPatternWOPrefix(jtIdentifier, jobId));
        return builder.toString();
    }

    static StringBuilder getJobIDsPatternWOPrefix(String jtIdentifier, Integer jobId) {
        StringBuilder builder = new StringBuilder().append(jtIdentifier != null ? jtIdentifier : "[^_]*").append(UNDERSCORE).append(jobId != null ? idFormat.format(jobId) : "[0-9]*");
        return builder;
    }

    static {
        idFormat.setGroupingUsed(false);
        idFormat.setMinimumIntegerDigits(4);
    }
}

