/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobEndNotifier;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JobInProgress {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.JobInProgress");
    JobProfile profile;
    JobStatus status;
    Path localJobFile = null;
    Path localJarFile = null;
    TaskInProgress[] maps = new TaskInProgress[0];
    TaskInProgress[] reduces = new TaskInProgress[0];
    int numMapTasks = 0;
    int numReduceTasks = 0;
    int runningMapTasks = 0;
    int runningReduceTasks = 0;
    int finishedMapTasks = 0;
    int finishedReduceTasks = 0;
    int failedMapTasks = 0;
    int failedReduceTasks = 0;
    int mapFailuresPercent = 0;
    int reduceFailuresPercent = 0;
    int failedMapTIPs = 0;
    int failedReduceTIPs = 0;
    JobPriority priority = JobPriority.NORMAL;
    JobTracker jobtracker = null;
    Map<Node, List<TaskInProgress>> nonRunningMapCache;
    Map<Node, Set<TaskInProgress>> runningMapCache;
    List<TaskInProgress> nonLocalMaps;
    Set<TaskInProgress> nonLocalRunningMaps;
    List<TaskInProgress> nonRunningReduces;
    Set<TaskInProgress> runningReduces;
    private int maxLevel;
    private int taskCompletionEventTracker = 0;
    List<TaskCompletionEvent> taskCompletionEvents;
    private static final double CLUSTER_BLACKLIST_PERCENT = 0.25;
    private static final double MAX_ALLOWED_FETCH_FAILURES_PERCENT = 0.5;
    private volatile int clusterSize = 0;
    private volatile int flakyTaskTrackers = 0;
    private Map<String, Integer> trackerToFailuresMap = new TreeMap<String, Integer>();
    long startTime;
    long finishTime;
    private JobConf conf;
    boolean tasksInited = false;
    private LocalFileSystem localFs;
    private JobID jobId;
    private boolean hasSpeculativeMaps;
    private boolean hasSpeculativeReduces;
    private Counters jobCounters = new Counters();
    private MetricsRecord jobMetrics;
    private static final int MAX_FETCH_FAILURES_NOTIFICATIONS = 3;
    private Map<TaskAttemptID, Integer> mapTaskIdToFetchFailuresMap = new TreeMap<TaskAttemptID, Integer>();

    public JobInProgress(JobID jobid, JobTracker jobtracker, JobConf default_conf) throws IOException {
        this.jobId = jobid;
        String url = "http://" + jobtracker.getJobTrackerMachine() + ":" + jobtracker.getInfoPort() + "/jobdetails.jsp?jobid=" + jobid;
        this.jobtracker = jobtracker;
        this.status = new JobStatus(jobid, 0.0f, 0.0f, 4);
        this.startTime = System.currentTimeMillis();
        this.localFs = FileSystem.getLocal(default_conf);
        JobConf default_job_conf = new JobConf(default_conf);
        this.localJobFile = default_job_conf.getLocalPath("jobTracker/" + jobid + ".xml");
        this.localJarFile = default_job_conf.getLocalPath("jobTracker/" + jobid + ".jar");
        Path sysDir = new Path(this.jobtracker.getSystemDir());
        FileSystem fs = sysDir.getFileSystem(default_conf);
        Path jobFile = new Path(sysDir, jobid + "/job.xml");
        fs.copyToLocalFile(jobFile, this.localJobFile);
        this.conf = new JobConf(this.localJobFile);
        this.priority = this.conf.getJobPriority();
        this.profile = new JobProfile(this.conf.getUser(), jobid, jobFile.toString(), url, this.conf.getJobName());
        String jarFile = this.conf.getJar();
        if (jarFile != null) {
            fs.copyToLocalFile(new Path(jarFile), this.localJarFile);
            this.conf.setJar(this.localJarFile.toString());
        }
        this.numMapTasks = this.conf.getNumMapTasks();
        this.numReduceTasks = this.conf.getNumReduceTasks();
        this.taskCompletionEvents = new ArrayList<TaskCompletionEvent>(this.numMapTasks + this.numReduceTasks + 10);
        this.mapFailuresPercent = this.conf.getMaxMapTaskFailuresPercent();
        this.reduceFailuresPercent = this.conf.getMaxReduceTaskFailuresPercent();
        JobHistory.JobInfo.logSubmitted(jobid, this.conf, jobFile.toString(), System.currentTimeMillis());
        MetricsContext metricsContext = MetricsUtil.getContext("mapred");
        this.jobMetrics = MetricsUtil.createRecord(metricsContext, "job");
        this.jobMetrics.setTag("user", this.conf.getUser());
        this.jobMetrics.setTag("sessionId", this.conf.getSessionId());
        this.jobMetrics.setTag("jobName", this.conf.getJobName());
        this.jobMetrics.setTag("jobId", jobid.toString());
        this.hasSpeculativeMaps = this.conf.getMapSpeculativeExecution();
        this.hasSpeculativeReduces = this.conf.getReduceSpeculativeExecution();
        this.maxLevel = jobtracker.getNumTaskCacheLevels();
        this.nonLocalMaps = new LinkedList<TaskInProgress>();
        this.nonLocalRunningMaps = new LinkedHashSet<TaskInProgress>();
        this.runningMapCache = new IdentityHashMap<Node, Set<TaskInProgress>>();
        this.nonRunningReduces = new LinkedList<TaskInProgress>();
        this.runningReduces = new LinkedHashSet<TaskInProgress>();
    }

    public void updateMetrics() {
        Counters counters = this.getCounters();
        for (Counters.Group group : counters) {
            this.jobMetrics.setTag("group", group.getDisplayName());
            for (Counters.Counter counter : group) {
                this.jobMetrics.setTag("counter", counter.getDisplayName());
                this.jobMetrics.setMetric("value", counter.getCounter());
                this.jobMetrics.update();
            }
        }
    }

    public void cleanUpMetrics() {
        this.jobMetrics.removeTag("group");
        this.jobMetrics.removeTag("counter");
        this.jobMetrics.remove();
    }

    private void printCache(Map<Node, List<TaskInProgress>> cache) {
        LOG.info((Object)"The taskcache info:");
        for (Map.Entry<Node, List<TaskInProgress>> n : cache.entrySet()) {
            List<TaskInProgress> tips = n.getValue();
            LOG.info((Object)("Cached TIPs on node: " + n.getKey()));
            for (TaskInProgress tip : tips) {
                LOG.info((Object)("tip : " + tip.getTIPId()));
            }
        }
    }

    private Map<Node, List<TaskInProgress>> createCache(JobClient.RawSplit[] splits, int maxLevel) {
        IdentityHashMap<Node, List<TaskInProgress>> cache = new IdentityHashMap<Node, List<TaskInProgress>>(maxLevel);
        for (int i = 0; i < splits.length; ++i) {
            String[] splitLocations = splits[i].getLocations();
            if (splitLocations.length == 0) {
                this.nonLocalMaps.add(this.maps[i]);
                continue;
            }
            for (String host : splitLocations) {
                Node node = this.jobtracker.resolveAndAddToTopology(host);
                LOG.info((Object)("tip:" + this.maps[i].getTIPId() + " has split on node:" + node));
                for (int j = 0; j < maxLevel; ++j) {
                    ArrayList<TaskInProgress> hostMaps = (ArrayList<TaskInProgress>)cache.get(node);
                    if (hostMaps == null) {
                        hostMaps = new ArrayList<TaskInProgress>();
                        cache.put(node, hostMaps);
                        hostMaps.add(this.maps[i]);
                    }
                    if (hostMaps.get(hostMaps.size() - 1) != this.maps[i]) {
                        hostMaps.add(this.maps[i]);
                    }
                    node = node.getParent();
                }
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initTasks() throws IOException {
        Path tmpDir;
        FileSystem fileSys;
        int i;
        JobClient.RawSplit[] splits;
        if (this.tasksInited) {
            return;
        }
        String jobFile = this.profile.getJobFile();
        Path sysDir = new Path(this.jobtracker.getSystemDir());
        FileSystem fs = sysDir.getFileSystem(this.conf);
        FSDataInputStream splitFile = fs.open(new Path(this.conf.get("mapred.job.split.file")));
        try {
            splits = JobClient.readSplitFile(splitFile);
        }
        finally {
            splitFile.close();
        }
        this.numMapTasks = splits.length;
        this.maps = new TaskInProgress[this.numMapTasks];
        for (i = 0; i < this.numMapTasks; ++i) {
            this.maps[i] = new TaskInProgress(this.jobId, jobFile, splits[i], this.jobtracker, this.conf, this, i);
        }
        if (this.numMapTasks > 0) {
            LOG.info((Object)("Split info for job:" + this.jobId));
            this.nonRunningMapCache = this.createCache(splits, this.maxLevel);
        }
        if (this.numMapTasks == 0) {
            this.finishTime = System.currentTimeMillis();
            this.status.setMapProgress(1.0f);
            this.status.setReduceProgress(1.0f);
            this.status.setRunState(2);
            this.tasksInited = true;
            JobHistory.JobInfo.logStarted(this.profile.getJobID(), System.currentTimeMillis(), 0, 0);
            JobHistory.JobInfo.logFinished(this.profile.getJobID(), System.currentTimeMillis(), 0, 0, 0, 0, this.getCounters());
            JobEndNotifier.registerNotification(this.getJobConf(), this.getStatus());
            return;
        }
        this.reduces = new TaskInProgress[this.numReduceTasks];
        for (i = 0; i < this.numReduceTasks; ++i) {
            this.reduces[i] = new TaskInProgress(this.jobId, jobFile, this.numMapTasks, i, this.jobtracker, this.conf, this);
            this.nonRunningReduces.add(this.reduces[i]);
        }
        Path outputPath = FileOutputFormat.getOutputPath(this.conf);
        if (outputPath != null && !(fileSys = (tmpDir = new Path(outputPath, "_temporary")).getFileSystem(this.conf)).mkdirs(tmpDir)) {
            LOG.error((Object)("Mkdirs failed to create " + tmpDir.toString()));
        }
        this.status = new JobStatus(this.status.getJobID(), 0.0f, 0.0f, 1);
        this.tasksInited = true;
        JobHistory.JobInfo.logStarted(this.profile.getJobID(), System.currentTimeMillis(), this.numMapTasks, this.numReduceTasks);
    }

    public JobProfile getProfile() {
        return this.profile;
    }

    public JobStatus getStatus() {
        return this.status;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public int desiredMaps() {
        return this.numMapTasks;
    }

    public synchronized int finishedMaps() {
        return this.finishedMapTasks;
    }

    public int desiredReduces() {
        return this.numReduceTasks;
    }

    public synchronized int runningMaps() {
        return this.runningMapTasks;
    }

    public synchronized int runningReduces() {
        return this.runningReduceTasks;
    }

    public synchronized int finishedReduces() {
        return this.finishedReduceTasks;
    }

    public JobPriority getPriority() {
        return this.priority;
    }

    public void setPriority(JobPriority priority) {
        this.priority = priority == null ? JobPriority.NORMAL : priority;
    }

    TaskInProgress[] getMapTasks() {
        return this.maps;
    }

    TaskInProgress[] getReduceTasks() {
        return this.reduces;
    }

    JobConf getJobConf() {
        return this.conf;
    }

    public Vector<TaskInProgress> reportTasksInProgress(boolean shouldBeMap, boolean shouldBeComplete) {
        Vector<TaskInProgress> results = new Vector<TaskInProgress>();
        TaskInProgress[] tips = null;
        tips = shouldBeMap ? this.maps : this.reduces;
        for (int i = 0; i < tips.length; ++i) {
            if (tips[i].isComplete() != shouldBeComplete) continue;
            results.add(tips[i]);
        }
        return results;
    }

    public synchronized void updateTaskStatus(TaskInProgress tip, TaskStatus status, JobTracker.JobTrackerMetrics metrics) {
        boolean change;
        double oldProgress = tip.getProgress();
        boolean wasRunning = tip.isRunning();
        boolean wasComplete = tip.isComplete();
        if (wasComplete && status.getRunState() == TaskStatus.State.SUCCEEDED) {
            status.setRunState(TaskStatus.State.KILLED);
        }
        if (change = tip.updateStatus(status)) {
            TaskStatus.State state = status.getRunState();
            TaskTrackerStatus ttStatus = this.jobtracker.getTaskTracker(status.getTaskTracker());
            String httpTaskLogLocation = null;
            if (state == TaskStatus.State.COMMIT_PENDING) {
                JobWithTaskContext j = new JobWithTaskContext(this, tip, status.getTaskID(), metrics);
                this.jobtracker.addToCommitQueue(j);
            }
            if (null != ttStatus) {
                String host = NetUtils.getStaticResolution(ttStatus.getHost()) != null ? NetUtils.getStaticResolution(ttStatus.getHost()) : ttStatus.getHost();
                httpTaskLogLocation = "http://" + host + ":" + ttStatus.getHttpPort();
            }
            TaskCompletionEvent taskEvent = null;
            if (state == TaskStatus.State.SUCCEEDED) {
                taskEvent = new TaskCompletionEvent(this.taskCompletionEventTracker, status.getTaskID(), tip.idWithinJob(), status.getIsMap(), TaskCompletionEvent.Status.SUCCEEDED, httpTaskLogLocation);
                taskEvent.setTaskRunTime((int)(status.getFinishTime() - status.getStartTime()));
                tip.setSuccessEventNumber(this.taskCompletionEventTracker);
            } else {
                if (state == TaskStatus.State.COMMIT_PENDING) {
                    return;
                }
                if (state == TaskStatus.State.FAILED || state == TaskStatus.State.KILLED) {
                    TaskCompletionEvent.Status taskCompletionStatus;
                    TaskCompletionEvent t;
                    int eventNumber = tip.getSuccessEventNumber();
                    if (eventNumber != -1 && (t = this.taskCompletionEvents.get(eventNumber)).getTaskAttemptId().equals(status.getTaskID())) {
                        t.setTaskStatus(TaskCompletionEvent.Status.OBSOLETE);
                    }
                    this.failedTask(tip, status.getTaskID(), status, status.getTaskTracker(), wasRunning, wasComplete, metrics);
                    TaskCompletionEvent.Status status2 = taskCompletionStatus = state == TaskStatus.State.FAILED ? TaskCompletionEvent.Status.FAILED : TaskCompletionEvent.Status.KILLED;
                    if (tip.isFailed()) {
                        taskCompletionStatus = TaskCompletionEvent.Status.TIPFAILED;
                    }
                    taskEvent = new TaskCompletionEvent(this.taskCompletionEventTracker, status.getTaskID(), tip.idWithinJob(), status.getIsMap(), taskCompletionStatus, httpTaskLogLocation);
                }
            }
            if (taskEvent != null) {
                this.taskCompletionEvents.add(taskEvent);
                ++this.taskCompletionEventTracker;
                if (state == TaskStatus.State.SUCCEEDED) {
                    this.completedTask(tip, status, metrics);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Taking progress for " + tip.getTIPId() + " from " + oldProgress + " to " + tip.getProgress()));
        }
        double progressDelta = tip.getProgress() - oldProgress;
        if (tip.isMapTask()) {
            if (this.maps.length == 0) {
                this.status.setMapProgress(1.0f);
            } else {
                this.status.setMapProgress((float)((double)this.status.mapProgress() + progressDelta / (double)this.maps.length));
            }
        } else if (this.reduces.length == 0) {
            this.status.setReduceProgress(1.0f);
        } else {
            this.status.setReduceProgress((float)((double)this.status.reduceProgress() + progressDelta / (double)this.reduces.length));
        }
    }

    public synchronized Counters getJobCounters() {
        return this.jobCounters;
    }

    public synchronized Counters getMapCounters() {
        return this.incrementTaskCounters(new Counters(), this.maps);
    }

    public synchronized Counters getReduceCounters() {
        return this.incrementTaskCounters(new Counters(), this.reduces);
    }

    public Counters getCounters() {
        Counters result = new Counters();
        result.incrAllCounters(this.getJobCounters());
        this.incrementTaskCounters(result, this.maps);
        return this.incrementTaskCounters(result, this.reduces);
    }

    private Counters incrementTaskCounters(Counters counters, TaskInProgress[] tips) {
        for (TaskInProgress tip : tips) {
            counters.incrAllCounters(tip.getCounters());
        }
        return counters;
    }

    public synchronized Task obtainNewMapTask(TaskTrackerStatus tts, int clusterSize) throws IOException {
        if (!this.tasksInited) {
            LOG.info((Object)("Cannot create task split for " + this.profile.getJobID()));
            return null;
        }
        int target = this.findNewMapTask(tts, clusterSize, this.status.mapProgress());
        if (target == -1) {
            return null;
        }
        Task result = this.maps[target].getTaskToRun(tts.getTrackerName());
        if (result != null) {
            ++this.runningMapTasks;
            if (this.maps[target].isFirstAttempt(result.getTaskID())) {
                JobHistory.Task.logStarted(this.maps[target].getTIPId(), JobHistory.Values.MAP.name(), System.currentTimeMillis(), this.maps[target].getSplitNodes());
            }
            this.jobCounters.incrCounter(Counter.TOTAL_LAUNCHED_MAPS, 1L);
        }
        return result;
    }

    public synchronized Task obtainNewReduceTask(TaskTrackerStatus tts, int clusterSize) throws IOException {
        if (!this.tasksInited) {
            LOG.info((Object)("Cannot create task split for " + this.profile.getJobID()));
            return null;
        }
        int target = this.findNewReduceTask(tts, clusterSize, this.status.reduceProgress());
        if (target == -1) {
            return null;
        }
        Task result = this.reduces[target].getTaskToRun(tts.getTrackerName());
        if (result != null) {
            ++this.runningReduceTasks;
            if (this.reduces[target].isFirstAttempt(result.getTaskID())) {
                JobHistory.Task.logStarted(this.reduces[target].getTIPId(), JobHistory.Values.REDUCE.name(), System.currentTimeMillis(), "");
            }
            this.jobCounters.incrCounter(Counter.TOTAL_LAUNCHED_REDUCES, 1L);
        }
        return result;
    }

    private String convertTrackerNameToHostName(String trackerName) {
        int indexOfColon = trackerName.indexOf(":");
        String trackerHostName = indexOfColon == -1 ? trackerName : trackerName.substring(0, indexOfColon);
        return trackerHostName;
    }

    void addTrackerTaskFailure(String trackerName) {
        if ((double)this.flakyTaskTrackers < (double)this.clusterSize * 0.25) {
            String trackerHostName = this.convertTrackerNameToHostName(trackerName);
            Integer trackerFailures = this.trackerToFailuresMap.get(trackerHostName);
            if (trackerFailures == null) {
                trackerFailures = 0;
            }
            trackerFailures = trackerFailures + 1;
            this.trackerToFailuresMap.put(trackerHostName, trackerFailures);
            if (trackerFailures.intValue() == this.conf.getMaxTaskFailuresPerTracker()) {
                ++this.flakyTaskTrackers;
                LOG.info((Object)("TaskTracker at '" + trackerHostName + "' turned 'flaky'"));
            }
        }
    }

    private int getTrackerTaskFailures(String trackerName) {
        String trackerHostName = this.convertTrackerNameToHostName(trackerName);
        Integer failedTasks = this.trackerToFailuresMap.get(trackerHostName);
        return failedTasks != null ? failedTasks : 0;
    }

    int getNoOfBlackListedTrackers() {
        return this.flakyTaskTrackers;
    }

    synchronized Map<String, Integer> getTaskTrackerErrors() {
        TreeMap<String, Integer> trackerErrors = new TreeMap<String, Integer>(this.trackerToFailuresMap);
        return trackerErrors;
    }

    private synchronized void retireMap(TaskInProgress tip) {
        if (this.hasSpeculativeMaps) {
            if (this.runningMapCache == null) {
                LOG.warn((Object)"Running cache for maps missing!! Job details are missing.");
                return;
            }
            String[] splitLocations = tip.getSplitLocations();
            if (splitLocations.length == 0) {
                this.nonLocalRunningMaps.remove(tip);
                return;
            }
            for (String host : splitLocations) {
                Node node = this.jobtracker.getNode(host);
                for (int j = 0; j < this.maxLevel; ++j) {
                    Set<TaskInProgress> hostMaps = this.runningMapCache.get(node);
                    if (hostMaps != null) {
                        hostMaps.remove(tip);
                        if (hostMaps.size() == 0) {
                            this.runningMapCache.remove(node);
                        }
                    }
                    node = node.getParent();
                }
            }
        }
    }

    private synchronized void retireReduce(TaskInProgress tip) {
        if (this.hasSpeculativeReduces) {
            if (this.runningReduces == null) {
                LOG.warn((Object)"Running list for reducers missing!! Job details are missing.");
                return;
            }
            this.runningReduces.remove(tip);
        }
    }

    private synchronized void scheduleMap(TaskInProgress tip) {
        if (this.hasSpeculativeMaps) {
            if (this.runningMapCache == null) {
                LOG.warn((Object)"Running cache for maps is missing!! Job details are missing.");
                return;
            }
            String[] splitLocations = tip.getSplitLocations();
            if (splitLocations.length == 0) {
                this.nonLocalRunningMaps.add(tip);
                return;
            }
            for (String host : splitLocations) {
                Node node = this.jobtracker.getNode(host);
                for (int j = 0; j < this.maxLevel; ++j) {
                    Set<TaskInProgress> hostMaps = this.runningMapCache.get(node);
                    if (hostMaps == null) {
                        hostMaps = new LinkedHashSet<TaskInProgress>();
                        this.runningMapCache.put(node, hostMaps);
                    }
                    hostMaps.add(tip);
                    node = node.getParent();
                }
            }
        }
    }

    private synchronized void scheduleReduce(TaskInProgress tip) {
        if (this.hasSpeculativeReduces) {
            if (this.runningReduces == null) {
                LOG.warn((Object)"Running cache for reducers missing!! Job details are missing.");
                return;
            }
            this.runningReduces.add(tip);
        }
    }

    private synchronized void failMap(TaskInProgress tip) {
        if (this.nonRunningMapCache == null) {
            LOG.warn((Object)"Non-running cache for maps missing!! Job details are missing.");
            return;
        }
        String[] splitLocations = tip.getSplitLocations();
        if (splitLocations.length == 0) {
            this.nonLocalMaps.add(0, tip);
            return;
        }
        for (String host : splitLocations) {
            Node node = this.jobtracker.getNode(host);
            for (int j = 0; j < this.maxLevel; ++j) {
                List<TaskInProgress> hostMaps = this.nonRunningMapCache.get(node);
                if (hostMaps == null) {
                    hostMaps = new LinkedList<TaskInProgress>();
                    this.nonRunningMapCache.put(node, hostMaps);
                }
                hostMaps.add(0, tip);
                node = node.getParent();
            }
        }
    }

    private synchronized void failReduce(TaskInProgress tip) {
        if (this.nonRunningReduces == null) {
            LOG.warn((Object)"Failed cache for reducers missing!! Job details are missing.");
            return;
        }
        this.nonRunningReduces.add(0, tip);
    }

    private synchronized TaskInProgress findTaskFromList(Collection<TaskInProgress> tips, String taskTracker, boolean removeFailedTip) {
        Iterator<TaskInProgress> iter = tips.iterator();
        while (iter.hasNext()) {
            TaskInProgress tip = iter.next();
            if (tip.isRunnable() && !tip.isRunning()) {
                if (!tip.hasFailedOnMachine(taskTracker) || tip.getNumberOfFailedMachines() >= this.clusterSize) {
                    iter.remove();
                    return tip;
                }
                if (!removeFailedTip) continue;
                iter.remove();
                continue;
            }
            iter.remove();
        }
        return null;
    }

    private synchronized TaskInProgress findSpeculativeTask(Collection<TaskInProgress> list, String taskTracker, double avgProgress, long currentTime, boolean shouldRemove) {
        Iterator<TaskInProgress> iter = list.iterator();
        while (iter.hasNext()) {
            TaskInProgress tip = iter.next();
            if (!tip.isRunning()) {
                iter.remove();
                continue;
            }
            if (!tip.hasRunOnMachine(taskTracker)) {
                if (!tip.hasSpeculativeTask(currentTime, avgProgress)) continue;
                if (shouldRemove) {
                    iter.remove();
                }
                return tip;
            }
            if (!shouldRemove) continue;
            iter.remove();
        }
        return null;
    }

    private synchronized int findNewMapTask(TaskTrackerStatus tts, int clusterSize, double avgProgress) {
        String taskTracker = tts.getTrackerName();
        TaskInProgress tip = null;
        this.clusterSize = clusterSize;
        if (!this.shouldRunOnTaskTracker(taskTracker)) {
            return -1;
        }
        Node node = this.jobtracker.getNode(tts.getHost());
        if (node != null) {
            Node key = node;
            for (int level = 0; level < this.maxLevel; ++level) {
                List<TaskInProgress> cacheForLevel = this.nonRunningMapCache.get(key);
                if (cacheForLevel != null && (tip = this.findTaskFromList(cacheForLevel, taskTracker, level == 0)) != null) {
                    this.scheduleMap(tip);
                    if (cacheForLevel.size() == 0) {
                        this.nonRunningMapCache.remove(key);
                    }
                    if (level == 0) {
                        LOG.info((Object)("Choosing data-local task " + tip.getTIPId()));
                        this.jobCounters.incrCounter(Counter.DATA_LOCAL_MAPS, 1L);
                    } else if (level == 1) {
                        LOG.info((Object)("Choosing rack-local task " + tip.getTIPId()));
                        this.jobCounters.incrCounter(Counter.RACK_LOCAL_MAPS, 1L);
                    } else {
                        LOG.info((Object)("Choosing cached task at level " + level + tip.getTIPId()));
                        this.jobCounters.incrCounter(Counter.OTHER_LOCAL_MAPS, 1L);
                    }
                    return tip.getIdWithinJob();
                }
                key = key.getParent();
            }
        }
        Node nodeParentAtMaxLevel = JobTracker.getParentNode(node, this.maxLevel - 1);
        Collection<Node> nodesAtMaxLevel = this.jobtracker.getNodesAtMaxLevel();
        for (Node parent : nodesAtMaxLevel) {
            List<TaskInProgress> cache;
            if (parent == nodeParentAtMaxLevel || (cache = this.nonRunningMapCache.get(parent)) == null || (tip = this.findTaskFromList(cache, taskTracker, false)) == null) continue;
            this.scheduleMap(tip);
            if (cache.size() == 0) {
                this.nonRunningMapCache.remove(parent);
            }
            LOG.info((Object)("Choosing a non-local task " + tip.getTIPId()));
            return tip.getIdWithinJob();
        }
        tip = this.findTaskFromList(this.nonLocalMaps, taskTracker, false);
        if (tip != null) {
            this.scheduleMap(tip);
            LOG.info((Object)("Choosing a non-local task " + tip.getTIPId()));
            return tip.getIdWithinJob();
        }
        if (this.hasSpeculativeMaps) {
            long currentTime = System.currentTimeMillis();
            if (node != null) {
                Node key = node;
                for (int level = 0; level < this.maxLevel; ++level) {
                    Set<TaskInProgress> cacheForLevel = this.runningMapCache.get(key);
                    if (cacheForLevel != null && (tip = this.findSpeculativeTask(cacheForLevel, taskTracker, avgProgress, currentTime, level == 0)) != null) {
                        if (cacheForLevel.size() == 0) {
                            this.runningMapCache.remove(key);
                        }
                        if (level == 0) {
                            LOG.info((Object)("Choosing a data-local task " + tip.getTIPId() + " for speculation"));
                        } else if (level == 1) {
                            LOG.info((Object)("Choosing a rack-local task " + tip.getTIPId() + " for speculation"));
                        } else {
                            LOG.info((Object)("Choosing a cached task at level " + level + tip.getTIPId() + " for speculation"));
                        }
                        return tip.getIdWithinJob();
                    }
                    key = key.getParent();
                }
            }
            for (Node parent : nodesAtMaxLevel) {
                Set<TaskInProgress> cache;
                if (parent == nodeParentAtMaxLevel || (cache = this.runningMapCache.get(parent)) == null || (tip = this.findSpeculativeTask(cache, taskTracker, avgProgress, currentTime, false)) == null) continue;
                if (cache.size() == 0) {
                    this.runningMapCache.remove(parent);
                }
                LOG.info((Object)("Choosing a non-local task " + tip.getTIPId() + " for speculation"));
                return tip.getIdWithinJob();
            }
            tip = this.findSpeculativeTask(this.nonLocalRunningMaps, taskTracker, avgProgress, currentTime, false);
            if (tip != null) {
                LOG.info((Object)("Choosing a non-local task " + tip.getTIPId() + " for speculation"));
                return tip.getIdWithinJob();
            }
        }
        return -1;
    }

    private synchronized int findNewReduceTask(TaskTrackerStatus tts, int clusterSize, double avgProgress) {
        String taskTracker = tts.getTrackerName();
        TaskInProgress tip = null;
        this.clusterSize = clusterSize;
        if (!this.shouldRunOnTaskTracker(taskTracker)) {
            return -1;
        }
        tip = this.findTaskFromList(this.nonRunningReduces, taskTracker, false);
        if (tip != null) {
            this.scheduleReduce(tip);
            return tip.getIdWithinJob();
        }
        if (this.hasSpeculativeReduces && (tip = this.findSpeculativeTask(this.runningReduces, taskTracker, avgProgress, System.currentTimeMillis(), false)) != null) {
            this.scheduleReduce(tip);
            return tip.getIdWithinJob();
        }
        return -1;
    }

    private boolean shouldRunOnTaskTracker(String taskTracker) {
        int taskTrackerFailedTasks = this.getTrackerTaskFailures(taskTracker);
        if ((double)this.flakyTaskTrackers < (double)this.clusterSize * 0.25 && taskTrackerFailedTasks >= this.conf.getMaxTaskFailuresPerTracker()) {
            if (LOG.isDebugEnabled()) {
                String flakyTracker = this.convertTrackerNameToHostName(taskTracker);
                LOG.debug((Object)("Ignoring the black-listed tasktracker: '" + flakyTracker + "' for assigning a new task"));
            }
            return false;
        }
        return true;
    }

    public synchronized boolean completedTask(TaskInProgress tip, TaskStatus status, JobTracker.JobTrackerMetrics metrics) {
        TaskAttemptID taskid = status.getTaskID();
        if (tip.isComplete()) {
            tip.alreadyCompletedTask(taskid);
            if (this.status.getRunState() != 1) {
                this.jobtracker.markCompletedTaskAttempt(status.getTaskTracker(), taskid);
            }
            return false;
        }
        LOG.info((Object)("Task '" + taskid + "' has completed " + tip.getTIPId() + " successfully."));
        tip.completed(taskid);
        String taskTrackerName = this.jobtracker.getNode(this.jobtracker.getTaskTracker(status.getTaskTracker()).getHost()).toString();
        if (status.getIsMap()) {
            JobHistory.MapAttempt.logStarted(status.getTaskID(), status.getStartTime(), taskTrackerName);
            JobHistory.MapAttempt.logFinished(status.getTaskID(), status.getFinishTime(), taskTrackerName);
            JobHistory.Task.logFinished(tip.getTIPId(), JobHistory.Values.MAP.name(), status.getFinishTime(), status.getCounters());
        } else {
            JobHistory.ReduceAttempt.logStarted(status.getTaskID(), status.getStartTime(), taskTrackerName);
            JobHistory.ReduceAttempt.logFinished(status.getTaskID(), status.getShuffleFinishTime(), status.getSortFinishTime(), status.getFinishTime(), taskTrackerName);
            JobHistory.Task.logFinished(tip.getTIPId(), JobHistory.Values.REDUCE.name(), status.getFinishTime(), status.getCounters());
        }
        if (tip.isMapTask()) {
            --this.runningMapTasks;
            ++this.finishedMapTasks;
            metrics.completeMap();
            this.retireMap(tip);
        } else {
            --this.runningReduceTasks;
            ++this.finishedReduceTasks;
            metrics.completeReduce();
            this.retireReduce(tip);
        }
        this.isJobComplete(tip, metrics);
        if (this.status.getRunState() != 1) {
            this.jobtracker.markCompletedTaskAttempt(status.getTaskTracker(), taskid);
            return false;
        }
        return true;
    }

    private boolean isJobComplete(TaskInProgress tip, JobTracker.JobTrackerMetrics metrics) {
        boolean allDone;
        boolean bl = allDone = this.finishedMapTasks + this.failedMapTIPs == this.numMapTasks;
        if (allDone) {
            if (tip.isMapTask()) {
                this.status.setMapProgress(1.0f);
            }
            boolean bl2 = allDone = this.finishedReduceTasks + this.failedReduceTIPs == this.numReduceTasks;
        }
        if (this.status.getRunState() == 1 && allDone) {
            this.status.setRunState(2);
            this.status.setReduceProgress(1.0f);
            this.finishTime = System.currentTimeMillis();
            this.garbageCollect();
            LOG.info((Object)("Job " + this.status.getJobID() + " has completed successfully."));
            JobHistory.JobInfo.logFinished(this.status.getJobID(), this.finishTime, this.finishedMapTasks, this.finishedReduceTasks, this.failedMapTasks, this.failedReduceTasks, this.getCounters());
            metrics.completeJob();
            return true;
        }
        return false;
    }

    public synchronized void kill() {
        if (this.status.getRunState() == 1 || this.status.getRunState() == 4) {
            int i;
            LOG.info((Object)("Killing job '" + this.status.getJobID() + "'"));
            this.status = new JobStatus(this.status.getJobID(), 1.0f, 1.0f, 3);
            this.finishTime = System.currentTimeMillis();
            this.runningMapTasks = 0;
            this.runningReduceTasks = 0;
            for (i = 0; i < this.maps.length; ++i) {
                this.maps[i].kill();
            }
            for (i = 0; i < this.reduces.length; ++i) {
                this.reduces[i].kill();
            }
            JobHistory.JobInfo.logFailed(this.status.getJobID(), this.finishTime, this.finishedMapTasks, this.finishedReduceTasks);
            this.garbageCollect();
        }
    }

    private void failedTask(TaskInProgress tip, TaskAttemptID taskid, TaskStatus status, String trackerName, boolean wasRunning, boolean wasComplete, JobTracker.JobTrackerMetrics metrics) {
        boolean wasFailed = tip.isFailed();
        tip.incompleteSubTask(taskid, trackerName, this.status);
        boolean isRunning = tip.isRunning();
        boolean isComplete = tip.isComplete();
        if (wasRunning && !isRunning) {
            if (tip.isMapTask()) {
                --this.runningMapTasks;
                if (!isComplete) {
                    this.retireMap(tip);
                    this.failMap(tip);
                }
            } else {
                --this.runningReduceTasks;
                if (!isComplete) {
                    this.retireReduce(tip);
                    this.failReduce(tip);
                }
            }
        }
        if (wasComplete && !isComplete && tip.isMapTask()) {
            this.failMap(tip);
            --this.finishedMapTasks;
        }
        String taskTrackerName = this.jobtracker.getNode(this.jobtracker.getTaskTracker(status.getTaskTracker()).getHost()).toString();
        if (status.getIsMap()) {
            JobHistory.MapAttempt.logStarted(status.getTaskID(), status.getStartTime(), taskTrackerName);
            if (status.getRunState() == TaskStatus.State.FAILED) {
                JobHistory.MapAttempt.logFailed(status.getTaskID(), System.currentTimeMillis(), taskTrackerName, status.getDiagnosticInfo());
            } else {
                JobHistory.MapAttempt.logKilled(status.getTaskID(), System.currentTimeMillis(), taskTrackerName, status.getDiagnosticInfo());
            }
        } else {
            JobHistory.ReduceAttempt.logStarted(status.getTaskID(), status.getStartTime(), taskTrackerName);
            if (status.getRunState() == TaskStatus.State.FAILED) {
                JobHistory.ReduceAttempt.logFailed(status.getTaskID(), System.currentTimeMillis(), taskTrackerName, status.getDiagnosticInfo());
            } else {
                JobHistory.ReduceAttempt.logKilled(status.getTaskID(), System.currentTimeMillis(), taskTrackerName, status.getDiagnosticInfo());
            }
        }
        if (tip.isMapTask()) {
            ++this.failedMapTasks;
        } else {
            ++this.failedReduceTasks;
        }
        if (status.getRunState() == TaskStatus.State.FAILED) {
            this.addTrackerTaskFailure(trackerName);
        }
        this.jobtracker.markCompletedTaskAttempt(status.getTaskTracker(), taskid);
        if (!wasFailed && tip.isFailed()) {
            boolean killJob;
            boolean bl = tip.isMapTask() ? ++this.failedMapTIPs * 100 > this.mapFailuresPercent * this.numMapTasks : (killJob = ++this.failedReduceTIPs * 100 > this.reduceFailuresPercent * this.numReduceTasks);
            if (killJob) {
                LOG.info((Object)("Aborting job " + this.profile.getJobID()));
                JobHistory.Task.logFailed(tip.getTIPId(), tip.isMapTask() ? JobHistory.Values.MAP.name() : JobHistory.Values.REDUCE.name(), System.currentTimeMillis(), status.getDiagnosticInfo());
                JobHistory.JobInfo.logFailed(this.profile.getJobID(), System.currentTimeMillis(), this.finishedMapTasks, this.finishedReduceTasks);
                this.kill();
            } else {
                this.isJobComplete(tip, metrics);
            }
            if (tip.isMapTask()) {
                this.jobCounters.incrCounter(Counter.NUM_FAILED_MAPS, 1L);
            } else {
                this.jobCounters.incrCounter(Counter.NUM_FAILED_REDUCES, 1L);
            }
        }
    }

    public void failedTask(TaskInProgress tip, TaskAttemptID taskid, String reason, TaskStatus.Phase phase, TaskStatus.State state, String trackerName, JobTracker.JobTrackerMetrics metrics) {
        TaskStatus status = TaskStatus.createTaskStatus(tip.isMapTask(), taskid, 0.0f, state, reason, reason, trackerName, phase, null);
        this.updateTaskStatus(tip, status, metrics);
        JobHistory.Task.logFailed(tip.getTIPId(), tip.isMapTask() ? JobHistory.Values.MAP.name() : JobHistory.Values.REDUCE.name(), System.currentTimeMillis(), reason);
    }

    synchronized void garbageCollect() {
        this.jobtracker.finalizeJob(this);
        try {
            Path tmpDir;
            FileSystem fileSys;
            if (this.localJobFile != null) {
                this.localFs.delete(this.localJobFile, true);
                this.localJobFile = null;
            }
            if (this.localJarFile != null) {
                this.localFs.delete(this.localJarFile, true);
                this.localJarFile = null;
            }
            Path tempDir = new Path(this.jobtracker.getSystemDir(), this.jobId.toString());
            FileSystem fs = tempDir.getFileSystem(this.conf);
            fs.delete(tempDir, true);
            Path outputPath = FileOutputFormat.getOutputPath(this.conf);
            if (outputPath != null && (fileSys = (tmpDir = new Path(outputPath, "_temporary")).getFileSystem(this.conf)).exists(tmpDir)) {
                FileUtil.fullyDelete(fileSys, tmpDir);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Error cleaning up " + this.profile.getJobID() + ": " + e));
        }
        this.cleanUpMetrics();
        this.nonRunningMapCache = null;
        this.runningMapCache = null;
        this.nonRunningReduces = null;
        this.runningReduces = null;
    }

    public TaskInProgress getTaskInProgress(TaskID tipid) {
        if (tipid.isMap()) {
            for (int i = 0; i < this.maps.length; ++i) {
                if (!tipid.equals(this.maps[i].getTIPId())) continue;
                return this.maps[i];
            }
        } else {
            for (int i = 0; i < this.reduces.length; ++i) {
                if (!tipid.equals(this.reduces[i].getTIPId())) continue;
                return this.reduces[i];
            }
        }
        return null;
    }

    public TaskStatus findFinishedMap(int mapId) {
        TaskInProgress tip = this.maps[mapId];
        if (tip.isComplete()) {
            TaskStatus[] statuses = tip.getTaskStatuses();
            for (int i = 0; i < statuses.length; ++i) {
                if (statuses[i].getRunState() != TaskStatus.State.SUCCEEDED) continue;
                return statuses[i];
            }
        }
        return null;
    }

    public synchronized TaskCompletionEvent[] getTaskCompletionEvents(int fromEventId, int maxEvents) {
        TaskCompletionEvent[] events = TaskCompletionEvent.EMPTY_ARRAY;
        if (this.taskCompletionEvents.size() > fromEventId) {
            int actualMax = Math.min(maxEvents, this.taskCompletionEvents.size() - fromEventId);
            events = this.taskCompletionEvents.subList(fromEventId, actualMax + fromEventId).toArray(events);
        }
        return events;
    }

    synchronized void fetchFailureNotification(TaskInProgress tip, TaskAttemptID mapTaskId, String trackerName, JobTracker.JobTrackerMetrics metrics) {
        boolean isMapFaulty;
        Integer fetchFailures = this.mapTaskIdToFetchFailuresMap.get(mapTaskId);
        fetchFailures = fetchFailures == null ? 1 : fetchFailures + 1;
        this.mapTaskIdToFetchFailuresMap.put(mapTaskId, fetchFailures);
        LOG.info((Object)("Failed fetch notification #" + fetchFailures + " for task " + mapTaskId));
        float failureRate = (float)fetchFailures.intValue() / (float)this.runningReduceTasks;
        boolean bl = isMapFaulty = (double)failureRate >= 0.5;
        if (fetchFailures >= 3 && isMapFaulty) {
            LOG.info((Object)("Too many fetch-failures for output of task: " + mapTaskId + " ... killing it"));
            this.failedTask(tip, mapTaskId, "Too many fetch-failures", tip.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.REDUCE, TaskStatus.State.FAILED, trackerName, metrics);
            this.mapTaskIdToFetchFailuresMap.remove(mapTaskId);
        }
    }

    static class JobWithTaskContext {
        private JobInProgress job;
        private TaskInProgress tip;
        private TaskAttemptID taskId;
        private JobTracker.JobTrackerMetrics metrics;

        JobWithTaskContext(JobInProgress job, TaskInProgress tip, TaskAttemptID taskId, JobTracker.JobTrackerMetrics metrics) {
            this.job = job;
            this.tip = tip;
            this.taskId = taskId;
            this.metrics = metrics;
        }

        JobInProgress getJob() {
            return this.job;
        }

        TaskInProgress getTIP() {
            return this.tip;
        }

        TaskAttemptID getTaskID() {
            return this.taskId;
        }

        JobTracker.JobTrackerMetrics getJobTrackerMetrics() {
            return this.metrics;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Counter {
        NUM_FAILED_MAPS,
        NUM_FAILED_REDUCES,
        TOTAL_LAUNCHED_MAPS,
        TOTAL_LAUNCHED_REDUCES,
        OTHER_LOCAL_MAPS,
        DATA_LOCAL_MAPS,
        RACK_LOCAL_MAPS;

    }
}

