/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URL;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.mapred.JobID;

public class JobProfile
implements Writable {
    String user;
    JobID jobid;
    String jobFile;
    String url;
    String name;

    public JobProfile() {
    }

    public JobProfile(String user, JobID jobid, String jobFile, String url, String name) {
        this.user = user;
        this.jobid = jobid;
        this.jobFile = jobFile;
        this.url = url;
        this.name = name;
    }

    @Deprecated
    public JobProfile(String user, String jobid, String jobFile, String url, String name) {
        this(user, JobID.forName(jobid), jobFile, url, name);
    }

    public String getUser() {
        return this.user;
    }

    public JobID getJobID() {
        return this.jobid;
    }

    @Deprecated
    public String getJobId() {
        return this.jobid.toString();
    }

    public String getJobFile() {
        return this.jobFile;
    }

    public URL getURL() {
        try {
            return new URL(this.url);
        }
        catch (IOException ie) {
            return null;
        }
    }

    public String getJobName() {
        return this.name;
    }

    public void write(DataOutput out) throws IOException {
        this.jobid.write(out);
        Text.writeString(out, this.jobFile);
        Text.writeString(out, this.url);
        Text.writeString(out, this.user);
        Text.writeString(out, this.name);
    }

    public void readFields(DataInput in) throws IOException {
        this.jobid = JobID.read(in);
        this.jobFile = Text.readString(in);
        this.url = Text.readString(in);
        this.user = Text.readString(in);
        this.name = Text.readString(in);
    }

    static {
        WritableFactories.setFactory(JobProfile.class, new WritableFactory(){

            public Writable newInstance() {
                return new JobProfile();
            }
        });
    }
}

