/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.mapred.JobID;

public class JobStatus
implements Writable {
    public static final int RUNNING = 1;
    public static final int SUCCEEDED = 2;
    public static final int FAILED = 3;
    public static final int PREP = 4;
    private JobID jobid;
    private float mapProgress;
    private float reduceProgress;
    private int runState;
    private long startTime;
    private String user;

    public JobStatus() {
    }

    public JobStatus(JobID jobid, float mapProgress, float reduceProgress, int runState) {
        this.jobid = jobid;
        this.mapProgress = mapProgress;
        this.reduceProgress = reduceProgress;
        this.runState = runState;
        this.user = "nobody";
    }

    @Deprecated
    public String getJobId() {
        return this.jobid.toString();
    }

    public JobID getJobID() {
        return this.jobid;
    }

    public synchronized float mapProgress() {
        return this.mapProgress;
    }

    synchronized void setMapProgress(float p) {
        this.mapProgress = (float)Math.min(1.0, Math.max(0.0, (double)p));
    }

    public synchronized float reduceProgress() {
        return this.reduceProgress;
    }

    synchronized void setReduceProgress(float p) {
        this.reduceProgress = (float)Math.min(1.0, Math.max(0.0, (double)p));
    }

    public synchronized int getRunState() {
        return this.runState;
    }

    public synchronized void setRunState(int state) {
        this.runState = state;
    }

    synchronized void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public synchronized long getStartTime() {
        return this.startTime;
    }

    synchronized void setUsername(String userName) {
        this.user = userName;
    }

    public synchronized String getUsername() {
        return this.user;
    }

    public void write(DataOutput out) throws IOException {
        this.jobid.write(out);
        out.writeFloat(this.mapProgress);
        out.writeFloat(this.reduceProgress);
        out.writeInt(this.runState);
        out.writeLong(this.startTime);
        Text.writeString(out, this.user);
    }

    public void readFields(DataInput in) throws IOException {
        this.jobid = JobID.read(in);
        this.mapProgress = in.readFloat();
        this.reduceProgress = in.readFloat();
        this.runState = in.readInt();
        this.startTime = in.readLong();
        this.user = Text.readString(in);
    }

    static {
        WritableFactories.setFactory(JobStatus.class, new WritableFactory(){

            public Writable newInstance() {
                return new JobStatus();
            }
        });
    }
}

