/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineRecordReader
implements RecordReader<LongWritable, Text> {
    private static final Log LOG = LogFactory.getLog((String)LineRecordReader.class.getName());
    private CompressionCodecFactory compressionCodecs = null;
    private long start;
    private long pos;
    private long end;
    private LineReader in;
    int maxLineLength;

    public LineRecordReader(Configuration job, FileSplit split) throws IOException {
        this.maxLineLength = job.getInt("mapred.linerecordreader.maxlength", Integer.MAX_VALUE);
        this.start = split.getStart();
        this.end = this.start + split.getLength();
        Path file = split.getPath();
        this.compressionCodecs = new CompressionCodecFactory(job);
        CompressionCodec codec = this.compressionCodecs.getCodec(file);
        FileSystem fs = file.getFileSystem(job);
        FSDataInputStream fileIn = fs.open(split.getPath());
        boolean skipFirstLine = false;
        if (codec != null) {
            this.in = new LineReader((InputStream)codec.createInputStream(fileIn), job);
            this.end = Long.MAX_VALUE;
        } else {
            if (this.start != 0L) {
                skipFirstLine = true;
                --this.start;
                fileIn.seek(this.start);
            }
            this.in = new LineReader((InputStream)fileIn, job);
        }
        if (skipFirstLine) {
            this.start += (long)this.in.readLine(new Text(), 0, (int)Math.min(Integer.MAX_VALUE, this.end - this.start));
        }
        this.pos = this.start;
    }

    public LineRecordReader(InputStream in, long offset, long endOffset, int maxLineLength) {
        this.maxLineLength = maxLineLength;
        this.in = new LineReader(in, 65536);
        this.start = offset;
        this.pos = offset;
        this.end = endOffset;
    }

    public LineRecordReader(InputStream in, long offset, long endOffset, Configuration job) throws IOException {
        this.maxLineLength = job.getInt("mapred.linerecordreader.maxlength", Integer.MAX_VALUE);
        this.in = new LineReader(in, job);
        this.start = offset;
        this.pos = offset;
        this.end = endOffset;
    }

    @Override
    public LongWritable createKey() {
        return new LongWritable();
    }

    @Override
    public Text createValue() {
        return new Text();
    }

    @Override
    public synchronized boolean next(LongWritable key, Text value) throws IOException {
        while (this.pos < this.end) {
            key.set(this.pos);
            int newSize = this.in.readLine(value, this.maxLineLength, Math.max((int)Math.min(Integer.MAX_VALUE, this.end - this.pos), this.maxLineLength));
            if (newSize == 0) {
                return false;
            }
            this.pos += (long)newSize;
            if (newSize < this.maxLineLength) {
                return true;
            }
            LOG.info((Object)("Skipped line of size " + newSize + " at pos " + (this.pos - (long)newSize)));
        }
        return false;
    }

    @Override
    public float getProgress() {
        if (this.start == this.end) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.pos - this.start) / (float)(this.end - this.start));
    }

    @Override
    public synchronized long getPos() throws IOException {
        return this.pos;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    public static class LineReader {
        private static final int DEFAULT_BUFFER_SIZE = 65536;
        private int bufferSize = 65536;
        private InputStream in;
        private byte[] buffer;
        private int bufferLength = 0;
        private int bufferPosn = 0;

        LineReader(InputStream in, int bufferSize) {
            this.in = in;
            this.bufferSize = bufferSize;
            this.buffer = new byte[this.bufferSize];
        }

        public LineReader(InputStream in, Configuration conf) throws IOException {
            this(in, conf.getInt("io.file.buffer.size", 65536));
        }

        boolean backfill() throws IOException {
            this.bufferPosn = 0;
            this.bufferLength = this.in.read(this.buffer);
            return this.bufferLength > 0;
        }

        public void close() throws IOException {
            this.in.close();
        }

        public int readLine(Text str, int maxLineLength, int maxBytesToConsume) throws IOException {
            long bytesConsumed;
            int startPosn;
            boolean hitEndOfFile;
            boolean hadFinalReturn;
            boolean hadFinalNewline;
            block12: {
                str.clear();
                hadFinalNewline = false;
                hadFinalReturn = false;
                hitEndOfFile = false;
                startPosn = this.bufferPosn;
                bytesConsumed = 0L;
                do {
                    if (this.bufferPosn >= this.bufferLength && !this.backfill()) {
                        hitEndOfFile = true;
                        break block12;
                    }
                    startPosn = this.bufferPosn;
                    while (this.bufferPosn < this.bufferLength) {
                        switch (this.buffer[this.bufferPosn]) {
                            case 10: {
                                hadFinalNewline = true;
                                ++this.bufferPosn;
                                break block12;
                            }
                            case 13: {
                                if (!hadFinalReturn) {
                                    hadFinalReturn = true;
                                    break;
                                }
                                break block12;
                            }
                            default: {
                                if (hadFinalReturn) break block12;
                            }
                        }
                        ++this.bufferPosn;
                    }
                    bytesConsumed += (long)(this.bufferPosn - startPosn);
                    int length = this.bufferPosn - startPosn - (hadFinalReturn ? 1 : 0);
                    if ((length = Math.min(length, maxLineLength - str.getLength())) < 0) continue;
                    str.append(this.buffer, startPosn, length);
                } while (bytesConsumed < (long)maxBytesToConsume);
                return (int)Math.min(bytesConsumed, Integer.MAX_VALUE);
            }
            int newlineLength = (hadFinalNewline ? 1 : 0) + (hadFinalReturn ? 1 : 0);
            if (!hitEndOfFile) {
                bytesConsumed += (long)(this.bufferPosn - startPosn);
                int length = this.bufferPosn - startPosn - newlineLength;
                if ((length = Math.min(length, maxLineLength - str.getLength())) > 0) {
                    str.append(this.buffer, startPosn, length);
                }
            }
            return (int)Math.min(bytesConsumed, Integer.MAX_VALUE);
        }

        public int readLine(Text str, int maxLineLength) throws IOException {
            return this.readLine(str, maxLineLength, Integer.MAX_VALUE);
        }

        public int readLine(Text str) throws IOException {
            return this.readLine(str, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
    }
}

