/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobEndNotifier;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobSubmissionProtocol;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;

class LocalJobRunner
implements JobSubmissionProtocol {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.LocalJobRunner");
    private FileSystem fs;
    private HashMap<JobID, Job> jobs = new HashMap();
    private JobConf conf;
    private int map_tasks = 0;
    private int reduce_tasks = 0;
    private JobTracker.JobTrackerMetrics myMetrics = null;
    private static final String jobDir = "localRunner/";
    private static int jobid = 0;

    public long getProtocolVersion(String protocol, long clientVersion) {
        return 10L;
    }

    public LocalJobRunner(JobConf conf) throws IOException {
        this.fs = FileSystem.get(conf);
        this.conf = conf;
        this.myMetrics = new JobTracker.JobTrackerMetrics(null, new JobConf(conf));
    }

    public synchronized JobID getNewJobId() {
        return new JobID("local", ++jobid);
    }

    public JobStatus submitJob(JobID jobid) throws IOException {
        return new Job(jobid, this.conf).status;
    }

    public void killJob(JobID id) {
        this.jobs.get(id).stop();
    }

    public boolean killTask(TaskAttemptID taskId, boolean shouldFail) throws IOException {
        throw new UnsupportedOperationException("Killing tasks in LocalJobRunner is not supported");
    }

    public JobProfile getJobProfile(JobID id) {
        Job job = this.jobs.get(id);
        if (job != null) {
            return job.getProfile();
        }
        return null;
    }

    public TaskReport[] getMapTaskReports(JobID id) {
        return new TaskReport[0];
    }

    public TaskReport[] getReduceTaskReports(JobID id) {
        return new TaskReport[0];
    }

    public JobStatus getJobStatus(JobID id) {
        Job job = this.jobs.get(id);
        if (job != null) {
            return job.status;
        }
        return null;
    }

    public Counters getJobCounters(JobID id) {
        Job job = this.jobs.get(id);
        return job.currentCounters;
    }

    public String getFilesystemName() throws IOException {
        return this.fs.getUri().toString();
    }

    public ClusterStatus getClusterStatus() {
        return new ClusterStatus(1, this.map_tasks, this.reduce_tasks, 1, 1, JobTracker.State.RUNNING);
    }

    public JobStatus[] jobsToComplete() {
        return null;
    }

    public TaskCompletionEvent[] getTaskCompletionEvents(JobID jobid, int fromEventId, int maxEvents) throws IOException {
        return TaskCompletionEvent.EMPTY_ARRAY;
    }

    public JobStatus[] getAllJobs() {
        return null;
    }

    public String[] getTaskDiagnostics(TaskAttemptID taskid) throws IOException {
        return new String[0];
    }

    public String getSystemDir() {
        Path sysDir = new Path(this.conf.get("mapred.system.dir", "/tmp/hadoop/mapred/system"));
        return this.fs.makeQualified(sysDir).toString();
    }

    private class Job
    extends Thread
    implements TaskUmbilicalProtocol {
        private Path file;
        private JobID id;
        private JobConf job;
        private JobStatus status;
        private ArrayList<TaskAttemptID> mapIds = new ArrayList();
        private MapOutputFile mapoutputFile;
        private JobProfile profile;
        private Path localFile;
        private FileSystem localFs;
        private Counters completedTaskCounters = new Counters();
        private Counters currentCounters = new Counters();

        public long getProtocolVersion(String protocol, long clientVersion) {
            return 9L;
        }

        public Job(JobID jobid, JobConf conf) throws IOException {
            this.file = new Path(LocalJobRunner.this.getSystemDir(), jobid + "/job.xml");
            this.id = jobid;
            this.mapoutputFile = new MapOutputFile(jobid);
            this.mapoutputFile.setConf(conf);
            this.localFile = new JobConf(conf).getLocalPath(LocalJobRunner.jobDir + this.id + ".xml");
            this.localFs = FileSystem.getLocal(conf);
            LocalJobRunner.this.fs.copyToLocalFile(this.file, this.localFile);
            this.job = new JobConf(this.localFile);
            this.profile = new JobProfile(this.job.getUser(), this.id, this.file.toString(), "http://localhost:8080/", this.job.getJobName());
            this.status = new JobStatus(this.id, 0.0f, 0.0f, 1);
            LocalJobRunner.this.jobs.put(this.id, this);
            this.start();
        }

        JobProfile getProfile() {
            return this.profile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                InputSplit[] splits = this.job.getInputFormat().getSplits(this.job, 1);
                JobID jobId = this.profile.getJobID();
                int numReduceTasks = this.job.getNumReduceTasks();
                if (numReduceTasks > 1 || numReduceTasks < 0) {
                    numReduceTasks = 1;
                    this.job.setNumReduceTasks(1);
                }
                Path outputPath = FileOutputFormat.getOutputPath(this.job);
                FileSystem outputFs = null;
                Path tmpDir = null;
                if (outputPath != null && !(outputFs = (tmpDir = new Path(outputPath, "_temporary")).getFileSystem(this.job)).mkdirs(tmpDir)) {
                    LOG.error((Object)("Mkdirs failed to create " + tmpDir.toString()));
                }
                DataOutputBuffer buffer = new DataOutputBuffer();
                for (int i = 0; i < splits.length; ++i) {
                    TaskAttemptID mapId = new TaskAttemptID(new TaskID(jobId, true, i), 0);
                    this.mapIds.add(mapId);
                    buffer.reset();
                    splits[i].write(buffer);
                    BytesWritable split = new BytesWritable();
                    split.set(buffer.getData(), 0, buffer.getLength());
                    MapTask map = new MapTask(this.file.toString(), mapId, i, splits[i].getClass().getName(), split);
                    JobConf localConf = new JobConf(this.job);
                    if (outputFs != null) {
                        if (outputFs.exists(tmpDir)) {
                            Path taskTmpDir = new Path(tmpDir, "_" + mapId);
                            if (!outputFs.mkdirs(taskTmpDir)) {
                                throw new IOException("Mkdirs failed to create " + taskTmpDir.toString());
                            }
                        } else {
                            throw new IOException("The directory " + tmpDir.toString() + " doesnt exist ");
                        }
                    }
                    map.setJobFile(this.localFile.toString());
                    map.localizeConfiguration(localConf);
                    map.setConf(localConf);
                    LocalJobRunner.this.map_tasks += 1;
                    LocalJobRunner.this.myMetrics.launchMap();
                    map.run(localConf, this);
                    map.saveTaskOutput();
                    LocalJobRunner.this.myMetrics.completeMap();
                    LocalJobRunner.this.map_tasks -= 1;
                    this.updateCounters(map);
                }
                TaskAttemptID reduceId = new TaskAttemptID(new TaskID(jobId, false, 0), 0);
                try {
                    if (numReduceTasks > 0) {
                        for (int i = 0; i < this.mapIds.size(); ++i) {
                            TaskAttemptID mapId = this.mapIds.get(i);
                            Path mapOut = this.mapoutputFile.getOutputFile(mapId);
                            Path reduceIn = this.mapoutputFile.getInputFileForWrite(mapId.getTaskID(), reduceId, this.localFs.getLength(mapOut));
                            if (!this.localFs.mkdirs(reduceIn.getParent())) {
                                throw new IOException("Mkdirs failed to create " + reduceIn.getParent().toString());
                            }
                            if (this.localFs.rename(mapOut, reduceIn)) continue;
                            throw new IOException("Couldn't rename " + mapOut);
                        }
                        ReduceTask reduce = new ReduceTask(this.file.toString(), reduceId, 0, this.mapIds.size());
                        JobConf localConf = new JobConf(this.job);
                        if (outputFs != null) {
                            if (outputFs.exists(tmpDir)) {
                                Path taskTmpDir = new Path(tmpDir, "_" + reduceId);
                                if (!outputFs.mkdirs(taskTmpDir)) {
                                    throw new IOException("Mkdirs failed to create " + taskTmpDir.toString());
                                }
                            } else {
                                throw new IOException("The directory " + tmpDir.toString() + " doesnt exist ");
                            }
                        }
                        reduce.setJobFile(this.localFile.toString());
                        reduce.localizeConfiguration(localConf);
                        reduce.setConf(localConf);
                        LocalJobRunner.this.reduce_tasks += 1;
                        LocalJobRunner.this.myMetrics.launchReduce();
                        reduce.run(localConf, this);
                        reduce.saveTaskOutput();
                        LocalJobRunner.this.myMetrics.completeReduce();
                        LocalJobRunner.this.reduce_tasks -= 1;
                        this.updateCounters(reduce);
                    }
                }
                finally {
                    for (TaskAttemptID mapId : this.mapIds) {
                        this.mapoutputFile.removeAll(mapId);
                    }
                    if (numReduceTasks == 1) {
                        this.mapoutputFile.removeAll(reduceId);
                    }
                }
                try {
                    if (outputFs != null && outputFs.exists(tmpDir)) {
                        FileUtil.fullyDelete(outputFs, tmpDir);
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)("Exception in deleting " + tmpDir.toString()));
                }
                this.status.setRunState(2);
                JobEndNotifier.localRunnerNotification(this.job, this.status);
            }
            catch (Throwable t) {
                this.status.setRunState(3);
                LOG.warn((Object)this.id, t);
                JobEndNotifier.localRunnerNotification(this.job, this.status);
            }
            finally {
                try {
                    LocalJobRunner.this.fs.delete(this.file.getParent(), true);
                    this.localFs.delete(this.localFile, true);
                }
                catch (IOException e) {
                    LOG.warn((Object)("Error cleaning up " + this.id + ": " + e));
                }
            }
        }

        public Task getTask(TaskAttemptID taskid) {
            return null;
        }

        public boolean statusUpdate(TaskAttemptID taskId, TaskStatus taskStatus) throws IOException, InterruptedException {
            LOG.info((Object)taskStatus.getStateString());
            float taskIndex = this.mapIds.indexOf(taskId);
            if (taskIndex >= 0.0f) {
                float numTasks = this.mapIds.size();
                this.status.setMapProgress(taskIndex / numTasks + taskStatus.getProgress() / numTasks);
            } else {
                this.status.setReduceProgress(taskStatus.getProgress());
            }
            this.currentCounters = Counters.sum(this.completedTaskCounters, taskStatus.getCounters());
            return true;
        }

        private void updateCounters(Task task) {
            this.completedTaskCounters.incrAllCounters(task.getCounters());
        }

        public void reportDiagnosticInfo(TaskAttemptID taskid, String trace) {
        }

        public boolean ping(TaskAttemptID taskid) throws IOException {
            return true;
        }

        public void done(TaskAttemptID taskId, boolean shouldPromote) throws IOException {
            int taskIndex = this.mapIds.indexOf(taskId);
            if (taskIndex >= 0) {
                this.status.setMapProgress(1.0f);
            } else {
                this.status.setReduceProgress(1.0f);
            }
        }

        public synchronized void fsError(TaskAttemptID taskId, String message) throws IOException {
            LOG.fatal((Object)("FSError: " + message + "from task: " + taskId));
        }

        public void shuffleError(TaskAttemptID taskId, String message) throws IOException {
            LOG.fatal((Object)("shuffleError: " + message + "from task: " + taskId));
        }

        public TaskCompletionEvent[] getMapCompletionEvents(JobID jobId, int fromEventId, int maxLocs) throws IOException {
            return TaskCompletionEvent.EMPTY_ARRAY;
        }
    }
}

