/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.IFile;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapRunnable;
import org.apache.hadoop.mapred.MapTaskRunner;
import org.apache.hadoop.mapred.Merger;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.util.IndexedSortable;
import org.apache.hadoop.util.Progress;
import org.apache.hadoop.util.QuickSort;
import org.apache.hadoop.util.ReflectionUtils;

class MapTask
extends Task {
    public static final int MAP_OUTPUT_INDEX_RECORD_LENGTH = 24;
    private BytesWritable split = new BytesWritable();
    private String splitClass;
    private InputSplit instantiatedSplit = null;
    private static final int APPROX_HEADER_LENGTH = 150;
    private static final Log LOG = LogFactory.getLog((String)MapTask.class.getName());

    public MapTask() {
        this.setPhase(TaskStatus.Phase.MAP);
    }

    public MapTask(String jobFile, TaskAttemptID taskId, int partition, String splitClass, BytesWritable split) throws IOException {
        super(jobFile, taskId, partition);
        this.setPhase(TaskStatus.Phase.MAP);
        this.splitClass = splitClass;
        this.split.set(split);
    }

    public boolean isMapTask() {
        return true;
    }

    public void localizeConfiguration(JobConf conf) throws IOException {
        super.localizeConfiguration(conf);
        Path localSplit = new Path(new Path(this.getJobFile()).getParent(), "split.dta");
        LOG.debug((Object)("Writing local split to " + localSplit));
        FSDataOutputStream out = FileSystem.getLocal(conf).create(localSplit);
        Text.writeString(out, this.splitClass);
        this.split.write(out);
        ((FilterOutputStream)out).close();
    }

    public TaskRunner createRunner(TaskTracker tracker) {
        return new MapTaskRunner(this, tracker, this.conf);
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        Text.writeString(out, this.splitClass);
        this.split.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.splitClass = Text.readString(in);
        this.split.readFields(in);
    }

    InputSplit getInputSplit() throws UnsupportedOperationException {
        return this.instantiatedSplit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(JobConf job, TaskUmbilicalProtocol umbilical) throws IOException {
        Reporter reporter = this.getReporter(umbilical);
        this.startCommunicationThread(umbilical);
        int numReduceTasks = this.conf.getNumReduceTasks();
        LOG.info((Object)("numReduceTasks: " + numReduceTasks));
        MapOutputCollector collector = null;
        collector = numReduceTasks > 0 ? new MapOutputBuffer(umbilical, job, reporter) : new DirectMapOutputCollector(umbilical, job, reporter);
        try {
            this.instantiatedSplit = (InputSplit)ReflectionUtils.newInstance(job.getClassByName(this.splitClass), job);
        }
        catch (ClassNotFoundException exp) {
            IOException wrap = new IOException("Split class " + this.splitClass + " not found");
            wrap.initCause(exp);
            throw wrap;
        }
        DataInputBuffer splitBuffer = new DataInputBuffer();
        splitBuffer.reset(this.split.get(), 0, this.split.getSize());
        this.instantiatedSplit.readFields(splitBuffer);
        if (this.instantiatedSplit instanceof FileSplit) {
            FileSplit fileSplit = (FileSplit)this.instantiatedSplit;
            job.set("map.input.file", fileSplit.getPath().toString());
            job.setLong("map.input.start", fileSplit.getStart());
            job.setLong("map.input.length", fileSplit.getLength());
        }
        RecordReader rawIn = job.getInputFormat().getRecordReader(this.instantiatedSplit, job, reporter);
        TrackedRecordReader in = new TrackedRecordReader(rawIn, this.getCounters());
        MapRunnable runner = (MapRunnable)ReflectionUtils.newInstance(job.getMapRunnerClass(), job);
        try {
            runner.run(in, collector, reporter);
            collector.flush();
        }
        finally {
            in.close();
            collector.close();
        }
        this.done(umbilical);
    }

    private static class MapBufferTooSmallException
    extends IOException {
        public MapBufferTooSmallException(String s) {
            super(s);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MapOutputBuffer<K, V>
    implements MapOutputCollector<K, V>,
    IndexedSortable {
        private final int partitions;
        private final Partitioner<K, V> partitioner;
        private final JobConf job;
        private final Reporter reporter;
        private final Class<K> keyClass;
        private final Class<V> valClass;
        private final RawComparator<K> comparator;
        private final SerializationFactory serializationFactory;
        private final Serializer<K> keySerializer;
        private final Serializer<V> valSerializer;
        private final Class<? extends Reducer> combinerClass;
        private final Task.CombineOutputCollector<K, V> combineCollector;
        private CompressionCodec codec = null;
        private volatile int kvstart = 0;
        private volatile int kvend = 0;
        private int kvindex = 0;
        private final int[] kvoffsets;
        private final int[] kvindices;
        private volatile int bufstart = 0;
        private volatile int bufend = 0;
        private volatile int bufvoid = 0;
        private int bufindex = 0;
        private int bufmark = 0;
        private byte[] kvbuffer;
        private static final int PARTITION = 0;
        private static final int KEYSTART = 1;
        private static final int VALSTART = 2;
        private static final int ACCTSIZE = 3;
        private static final int RECSIZE = 16;
        private volatile int numSpills = 0;
        private volatile Throwable sortSpillException = null;
        private final int softRecordLimit;
        private final int softBufferLimit;
        private final int minSpillsForCombine;
        private final Object spillLock = new Object();
        private final QuickSort sorter = new QuickSort();
        private final BlockingBuffer bb = new BlockingBuffer();
        private final FileSystem localFs;
        private final Counters.Counter mapOutputByteCounter;
        private final Counters.Counter mapOutputRecordCounter;
        private final Counters.Counter combineInputCounter;
        private final Counters.Counter combineOutputCounter;

        public MapOutputBuffer(TaskUmbilicalProtocol umbilical, JobConf job, Reporter reporter) throws IOException {
            this.job = job;
            this.reporter = reporter;
            this.localFs = FileSystem.getLocal(job);
            this.partitions = job.getNumReduceTasks();
            this.partitioner = (Partitioner)ReflectionUtils.newInstance(job.getPartitionerClass(), job);
            float spillper = job.getFloat("io.sort.spill.percent", 0.8f);
            float recper = job.getFloat("io.sort.record.percent", 0.05f);
            int sortmb = job.getInt("io.sort.mb", 100);
            if (spillper > 1.0f || spillper < 0.0f) {
                throw new IOException("Invalid \"io.sort.spill.percent\": " + spillper);
            }
            if (recper > 1.0f || recper < 0.01f) {
                throw new IOException("Invalid \"io.sort.record.percent\": " + recper);
            }
            if ((sortmb & 0x7FF) != sortmb) {
                throw new IOException("Invalid \"io.sort.mb\": " + sortmb);
            }
            LOG.info((Object)("io.sort.mb = " + sortmb));
            int maxMemUsage = sortmb << 20;
            int recordCapacity = (int)((float)maxMemUsage * recper);
            recordCapacity -= recordCapacity % 16;
            this.kvbuffer = new byte[maxMemUsage - recordCapacity];
            this.bufvoid = this.kvbuffer.length;
            this.kvoffsets = new int[recordCapacity /= 16];
            this.kvindices = new int[recordCapacity * 3];
            this.softBufferLimit = (int)((float)this.kvbuffer.length * spillper);
            this.softRecordLimit = (int)((float)this.kvoffsets.length * spillper);
            LOG.info((Object)("data buffer = " + this.softBufferLimit + "/" + this.kvbuffer.length));
            LOG.info((Object)("record buffer = " + this.softRecordLimit + "/" + this.kvoffsets.length));
            this.comparator = job.getOutputKeyComparator();
            this.keyClass = job.getMapOutputKeyClass();
            this.valClass = job.getMapOutputValueClass();
            this.serializationFactory = new SerializationFactory(job);
            this.keySerializer = this.serializationFactory.getSerializer(this.keyClass);
            this.keySerializer.open(this.bb);
            this.valSerializer = this.serializationFactory.getSerializer(this.valClass);
            this.valSerializer.open(this.bb);
            Counters counters = MapTask.this.getCounters();
            this.mapOutputByteCounter = counters.findCounter(Task.Counter.MAP_OUTPUT_BYTES);
            this.mapOutputRecordCounter = counters.findCounter(Task.Counter.MAP_OUTPUT_RECORDS);
            this.combineInputCounter = counters.findCounter(Task.Counter.COMBINE_INPUT_RECORDS);
            this.combineOutputCounter = counters.findCounter(Task.Counter.COMBINE_OUTPUT_RECORDS);
            if (job.getCompressMapOutput()) {
                Class<? extends CompressionCodec> codecClass = job.getMapOutputCompressorClass(DefaultCodec.class);
                this.codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, job);
            }
            this.combinerClass = job.getCombinerClass();
            this.combineCollector = null != this.combinerClass ? new Task.CombineOutputCollector(this.combineOutputCounter) : null;
            this.minSpillsForCombine = job.getInt("min.num.spills.for.combine", 3);
        }

        @Override
        public synchronized void collect(K key, V value) throws IOException {
            this.reporter.progress();
            if (key.getClass() != this.keyClass) {
                throw new IOException("Type mismatch in key from map: expected " + this.keyClass.getName() + ", recieved " + key.getClass().getName());
            }
            if (value.getClass() != this.valClass) {
                throw new IOException("Type mismatch in value from map: expected " + this.valClass.getName() + ", recieved " + value.getClass().getName());
            }
            if (this.sortSpillException != null) {
                throw (IOException)new IOException("Spill failed").initCause(this.sortSpillException);
            }
            try {
                int ind;
                int keystart = this.bufindex;
                this.keySerializer.serialize(key);
                if (this.bufindex < keystart) {
                    this.bb.reset();
                    keystart = 0;
                }
                int valstart = this.bufindex;
                this.valSerializer.serialize(value);
                int valend = this.bb.markRecord();
                this.mapOutputByteCounter.increment(valend > keystart ? (long)(valend - keystart) : (long)(this.bufvoid - keystart + valend));
                int partition = this.partitioner.getPartition(key, value, this.partitions);
                if (partition < 0 || partition >= this.partitions) {
                    throw new IOException("Illegal partition for " + key + " (" + partition + ")");
                }
                this.mapOutputRecordCounter.increment(1L);
                this.kvoffsets[this.kvindex] = ind = this.kvindex * 3;
                this.kvindices[ind + 0] = partition;
                this.kvindices[ind + 1] = keystart;
                this.kvindices[ind + 2] = valstart;
                this.kvindex = (this.kvindex + 1) % this.kvoffsets.length;
            }
            catch (MapBufferTooSmallException e) {
                LOG.debug((Object)("Record too large for in-memory buffer: " + e.getMessage()));
                this.spillSingleRecord(key, value);
                this.mapOutputRecordCounter.increment(1L);
                return;
            }
        }

        @Override
        public int compare(int i, int j) {
            int ii = this.kvoffsets[i % this.kvoffsets.length];
            int ij = this.kvoffsets[j % this.kvoffsets.length];
            if (this.kvindices[ii + 0] != this.kvindices[ij + 0]) {
                return this.kvindices[ii + 0] - this.kvindices[ij + 0];
            }
            return this.comparator.compare(this.kvbuffer, this.kvindices[ii + 1], this.kvindices[ii + 2] - this.kvindices[ii + 1], this.kvbuffer, this.kvindices[ij + 1], this.kvindices[ij + 2] - this.kvindices[ij + 1]);
        }

        @Override
        public void swap(int i, int j) {
            int tmp = this.kvoffsets[i %= this.kvoffsets.length];
            this.kvoffsets[i] = this.kvoffsets[j %= this.kvoffsets.length];
            this.kvoffsets[j] = tmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void flush() throws IOException {
            LOG.info((Object)"Starting flush of map output");
            Object object = this.spillLock;
            synchronized (object) {
                while (this.kvstart != this.kvend) {
                    try {
                        this.reporter.progress();
                        this.spillLock.wait();
                    }
                    catch (InterruptedException e) {
                        throw (IOException)new IOException("Buffer interrupted while waiting for the writer").initCause(e);
                    }
                }
            }
            if (this.sortSpillException != null) {
                throw (IOException)new IOException("Spill failed").initCause(this.sortSpillException);
            }
            if (this.kvend != this.kvindex) {
                this.kvend = this.kvindex;
                this.bufend = this.bufmark;
                this.sortAndSpill();
            }
            this.kvbuffer = null;
            this.mergeParts();
        }

        @Override
        public void close() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sortAndSpill() throws IOException {
            long size = (this.bufend > this.bufstart ? this.bufend - this.bufstart : this.bufvoid - this.bufend + this.bufstart) + this.partitions * 150;
            FSDataOutputStream out = null;
            FSDataOutputStream indexOut = null;
            try {
                Path filename = MapTask.this.mapOutputFile.getSpillFileForWrite(MapTask.this.getTaskID(), this.numSpills, size);
                out = this.localFs.create(filename);
                Path indexFilename = MapTask.this.mapOutputFile.getSpillIndexFileForWrite(MapTask.this.getTaskID(), this.numSpills, this.partitions * 24);
                indexOut = this.localFs.create(indexFilename);
                int endPosition = this.kvend > this.kvstart ? this.kvend : this.kvoffsets.length + this.kvend;
                this.sorter.sort(this, this.kvstart, endPosition, this.reporter);
                int spindex = this.kvstart;
                InMemValBytes value = new InMemValBytes();
                for (int i = 0; i < this.partitions; ++i) {
                    IFile.Writer<K, V> writer = null;
                    try {
                        long segmentStart = out.getPos();
                        writer = new IFile.Writer<K, V>(this.job, out, this.keyClass, this.valClass, this.codec);
                        if (null == this.combinerClass) {
                            DataInputBuffer key = new DataInputBuffer();
                            long recordNo = 0L;
                            while (spindex < endPosition && this.kvindices[this.kvoffsets[spindex % this.kvoffsets.length] + 0] == i) {
                                int kvoff = this.kvoffsets[spindex % this.kvoffsets.length];
                                this.getVBytesForOffset(kvoff, value);
                                key.reset(this.kvbuffer, this.kvindices[kvoff + 1], this.kvindices[kvoff + 2] - this.kvindices[kvoff + 1]);
                                writer.append(key, value);
                                ++spindex;
                                ++recordNo;
                            }
                        } else {
                            int spstart = spindex;
                            while (spindex < endPosition && this.kvindices[this.kvoffsets[spindex % this.kvoffsets.length] + 0] == i) {
                                ++spindex;
                            }
                            if (spstart != spindex) {
                                this.combineCollector.setWriter(writer);
                                MRResultIterator kvIter = new MRResultIterator(spstart, spindex);
                                this.combineAndSpill(kvIter, this.combineInputCounter);
                            }
                        }
                        writer.close();
                        this.writeIndexRecord(indexOut, out, segmentStart, writer);
                        writer = null;
                        continue;
                    }
                    finally {
                        if (null != writer) {
                            writer.close();
                        }
                    }
                }
                ++this.numSpills;
                LOG.info((Object)("Finished spill " + this.numSpills));
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (indexOut != null) {
                    indexOut.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void spillSingleRecord(K key, V value) throws IOException {
            long size = this.kvbuffer.length + this.partitions * 150;
            FSDataOutputStream out = null;
            FSDataOutputStream indexOut = null;
            int partition = this.partitioner.getPartition(key, value, this.partitions);
            try {
                Path filename = MapTask.this.mapOutputFile.getSpillFileForWrite(MapTask.this.getTaskID(), this.numSpills, size);
                out = this.localFs.create(filename);
                Path indexFilename = MapTask.this.mapOutputFile.getSpillIndexFileForWrite(MapTask.this.getTaskID(), this.numSpills, this.partitions * 24);
                indexOut = this.localFs.create(indexFilename);
                for (int i = 0; i < this.partitions; ++i) {
                    IFile.Writer<K, V> writer = null;
                    try {
                        long segmentStart = out.getPos();
                        writer = new IFile.Writer<K, V>(this.job, out, this.keyClass, this.valClass, this.codec);
                        if (i == partition) {
                            long recordStart = out.getPos();
                            writer.append(key, value);
                            this.mapOutputByteCounter.increment(out.getPos() - recordStart);
                        }
                        writer.close();
                        this.writeIndexRecord(indexOut, out, segmentStart, writer);
                        continue;
                    }
                    catch (IOException e) {
                        if (null != writer) {
                            writer.close();
                        }
                        throw e;
                    }
                }
                ++this.numSpills;
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (indexOut != null) {
                    indexOut.close();
                }
            }
        }

        private void getVBytesForOffset(int kvoff, InMemValBytes vbytes) {
            int nextindex = kvoff / 3 == this.kvend - 1 ? this.bufend : this.kvindices[(kvoff + 3 + 1) % this.kvindices.length];
            int vallen = nextindex > this.kvindices[kvoff + 2] ? nextindex - this.kvindices[kvoff + 2] : this.bufvoid - this.kvindices[kvoff + 2] + nextindex;
            vbytes.reset(this.kvbuffer, this.kvindices[kvoff + 2], vallen);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void combineAndSpill(RawKeyValueIterator kvIter, Counters.Counter inCounter) throws IOException {
            Reducer combiner = (Reducer)ReflectionUtils.newInstance(this.combinerClass, this.job);
            try {
                Task.CombineValuesIterator<K, V> values = new Task.CombineValuesIterator<K, V>(kvIter, this.comparator, this.keyClass, this.valClass, this.job, this.reporter, inCounter);
                while (values.more()) {
                    combiner.reduce(values.getKey(), values, this.combineCollector, this.reporter);
                    values.nextKey();
                    this.reporter.progress();
                }
            }
            finally {
                combiner.close();
            }
        }

        private void mergeParts() throws IOException {
            long finalOutFileSize = 0L;
            long finalIndexFileSize = 0L;
            Path[] filename = new Path[this.numSpills];
            Path[] indexFileName = new Path[this.numSpills];
            LocalFileSystem localFs = FileSystem.getLocal(this.job);
            for (int i = 0; i < this.numSpills; ++i) {
                filename[i] = MapTask.this.mapOutputFile.getSpillFile(MapTask.this.getTaskID(), i);
                indexFileName[i] = MapTask.this.mapOutputFile.getSpillIndexFile(MapTask.this.getTaskID(), i);
                finalOutFileSize += ((FileSystem)localFs).getFileStatus(filename[i]).getLen();
            }
            if (this.numSpills == 1) {
                ((FileSystem)localFs).rename(filename[0], new Path(filename[0].getParent(), "file.out"));
                ((FileSystem)localFs).rename(indexFileName[0], new Path(indexFileName[0].getParent(), "file.out.index"));
                return;
            }
            finalIndexFileSize = this.partitions * 24;
            Path finalOutputFile = MapTask.this.mapOutputFile.getOutputFileForWrite(MapTask.this.getTaskID(), finalOutFileSize += (long)(this.partitions * 150));
            Path finalIndexFile = MapTask.this.mapOutputFile.getOutputIndexFileForWrite(MapTask.this.getTaskID(), finalIndexFileSize);
            FSDataOutputStream finalOut = localFs.create(finalOutputFile, true, 4096);
            FSDataOutputStream finalIndexOut = localFs.create(finalIndexFile, true, 4096);
            if (this.numSpills == 0) {
                for (int i = 0; i < this.partitions; ++i) {
                    long segmentStart = finalOut.getPos();
                    IFile.Writer<K, V> writer = new IFile.Writer<K, V>(this.job, finalOut, this.keyClass, this.valClass, null);
                    finalIndexOut.writeLong(segmentStart);
                    finalIndexOut.writeLong(finalOut.getPos() - segmentStart);
                    finalIndexOut.writeLong(finalOut.getPos() - segmentStart);
                    writer.close();
                }
                finalOut.close();
                finalIndexOut.close();
                return;
            }
            for (int parts = 0; parts < this.partitions; ++parts) {
                ArrayList segmentList = new ArrayList(this.numSpills);
                for (int i = 0; i < this.numSpills; ++i) {
                    FSDataInputStream indexIn = localFs.open(indexFileName[i]);
                    indexIn.seek(parts * 24);
                    long segmentOffset = indexIn.readLong();
                    long rawSegmentLength = indexIn.readLong();
                    long segmentLength = indexIn.readLong();
                    indexIn.close();
                    FSDataInputStream in = localFs.open(filename[i]);
                    in.seek(segmentOffset);
                    Merger.Segment s = new Merger.Segment(new IFile.Reader((Configuration)this.job, in, segmentLength, this.codec), true);
                    segmentList.add(i, s);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Index: (" + indexFileName[i] + ", " + segmentOffset + rawSegmentLength + ", " + segmentLength + ")"));
                }
                RawKeyValueIterator kvIter = Merger.merge(this.job, localFs, this.keyClass, this.valClass, segmentList, this.job.getInt("io.sort.factor", 100), new Path(MapTask.this.getTaskID().toString()), this.job.getOutputKeyComparator(), this.reporter);
                long segmentStart = finalOut.getPos();
                IFile.Writer<K, V> writer = new IFile.Writer<K, V>(this.job, finalOut, this.keyClass, this.valClass, this.codec);
                if (null == this.combinerClass || this.numSpills < this.minSpillsForCombine) {
                    Merger.writeFile(kvIter, writer, this.reporter);
                } else {
                    this.combineCollector.setWriter(writer);
                    this.combineAndSpill(kvIter, this.combineInputCounter);
                }
                writer.close();
                this.writeIndexRecord(finalIndexOut, finalOut, segmentStart, writer);
            }
            finalOut.close();
            finalIndexOut.close();
            for (int i = 0; i < this.numSpills; ++i) {
                ((FileSystem)localFs).delete(filename[i], true);
                ((FileSystem)localFs).delete(indexFileName[i], true);
            }
        }

        private void writeIndexRecord(FSDataOutputStream indexOut, FSDataOutputStream out, long start, IFile.Writer<K, V> writer) throws IOException {
            indexOut.writeLong(start);
            indexOut.writeLong(writer.getRawLength());
            long segmentLength = out.getPos() - start;
            indexOut.writeLong(segmentLength);
        }

        protected class MRResultIterator
        implements RawKeyValueIterator {
            private final DataInputBuffer keybuf = new DataInputBuffer();
            private final InMemValBytes vbytes = new InMemValBytes();
            private final int end;
            private int current;

            public MRResultIterator(int start, int end) {
                this.end = end;
                this.current = start - 1;
            }

            public boolean next() throws IOException {
                return ++this.current < this.end;
            }

            public DataInputBuffer getKey() throws IOException {
                int kvoff = MapOutputBuffer.this.kvoffsets[this.current % MapOutputBuffer.this.kvoffsets.length];
                this.keybuf.reset(MapOutputBuffer.this.kvbuffer, MapOutputBuffer.this.kvindices[kvoff + 1], MapOutputBuffer.this.kvindices[kvoff + 2] - MapOutputBuffer.this.kvindices[kvoff + 1]);
                return this.keybuf;
            }

            public DataInputBuffer getValue() throws IOException {
                MapOutputBuffer.this.getVBytesForOffset(MapOutputBuffer.this.kvoffsets[this.current % MapOutputBuffer.this.kvoffsets.length], this.vbytes);
                return this.vbytes;
            }

            public Progress getProgress() {
                return null;
            }

            public void close() {
            }
        }

        protected class InMemValBytes
        extends DataInputBuffer {
            private byte[] buffer;
            private int start;
            private int length;

            protected InMemValBytes() {
            }

            public void reset(byte[] buffer, int start, int length) {
                this.buffer = buffer;
                this.start = start;
                this.length = length;
                if (start + length > MapOutputBuffer.this.bufvoid) {
                    this.buffer = new byte[this.length];
                    int taillen = MapOutputBuffer.this.bufvoid - start;
                    System.arraycopy(buffer, start, this.buffer, 0, taillen);
                    System.arraycopy(buffer, 0, this.buffer, taillen, length - taillen);
                    this.start = 0;
                }
                super.reset(this.buffer, this.start, this.length);
            }
        }

        protected class SpillThread
        extends Thread {
            protected SpillThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        MapOutputBuffer.this.sortAndSpill();
                    }
                    catch (Throwable e) {
                        MapOutputBuffer.this.sortSpillException = e;
                        Object var3_2 = null;
                        Object object2 = MapOutputBuffer.this.spillLock;
                        synchronized (object2) {
                            if (MapOutputBuffer.this.bufend < MapOutputBuffer.this.bufindex && MapOutputBuffer.this.bufindex < MapOutputBuffer.this.bufstart) {
                                MapOutputBuffer.this.bufvoid = MapOutputBuffer.this.kvbuffer.length;
                            }
                            MapOutputBuffer.this.kvstart = MapOutputBuffer.this.kvend;
                            MapOutputBuffer.this.bufstart = MapOutputBuffer.this.bufend;
                            MapOutputBuffer.this.spillLock.notify();
                            return;
                        }
                    }
                    Object var3_1 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    Object object = MapOutputBuffer.this.spillLock;
                    synchronized (object) {
                        if (MapOutputBuffer.this.bufend < MapOutputBuffer.this.bufindex && MapOutputBuffer.this.bufindex < MapOutputBuffer.this.bufstart) {
                            MapOutputBuffer.this.bufvoid = MapOutputBuffer.this.kvbuffer.length;
                        }
                        MapOutputBuffer.this.kvstart = MapOutputBuffer.this.kvend;
                        MapOutputBuffer.this.bufstart = MapOutputBuffer.this.bufend;
                        MapOutputBuffer.this.spillLock.notify();
                        throw throwable;
                    }
                }
                Object object = MapOutputBuffer.this.spillLock;
                synchronized (object) {
                    if (MapOutputBuffer.this.bufend < MapOutputBuffer.this.bufindex && MapOutputBuffer.this.bufindex < MapOutputBuffer.this.bufstart) {
                        MapOutputBuffer.this.bufvoid = MapOutputBuffer.this.kvbuffer.length;
                    }
                    MapOutputBuffer.this.kvstart = MapOutputBuffer.this.kvend;
                    MapOutputBuffer.this.bufstart = MapOutputBuffer.this.bufend;
                    MapOutputBuffer.this.spillLock.notify();
                    return;
                }
            }
        }

        public class Buffer
        extends OutputStream {
            private final byte[] scratch = new byte[1];

            public synchronized void write(int v) throws IOException {
                this.scratch[0] = (byte)v;
                this.write(this.scratch, 0, 1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized void write(byte[] b, int off, int len) throws IOException {
                boolean kvfull = false;
                boolean buffull = false;
                boolean wrap = false;
                Object object = MapOutputBuffer.this.spillLock;
                synchronized (object) {
                    do {
                        if (MapOutputBuffer.this.sortSpillException != null) {
                            throw (IOException)new IOException("Spill failed").initCause(MapOutputBuffer.this.sortSpillException);
                        }
                        boolean bl = kvfull = (MapOutputBuffer.this.kvindex + 1) % MapOutputBuffer.this.kvoffsets.length == MapOutputBuffer.this.kvstart;
                        if (MapOutputBuffer.this.bufstart <= MapOutputBuffer.this.bufend && MapOutputBuffer.this.bufend <= MapOutputBuffer.this.bufindex) {
                            buffull = MapOutputBuffer.this.bufindex + len > MapOutputBuffer.this.bufvoid;
                            wrap = MapOutputBuffer.this.bufvoid - MapOutputBuffer.this.bufindex + MapOutputBuffer.this.bufstart > len;
                        } else {
                            wrap = false;
                            boolean bl2 = buffull = MapOutputBuffer.this.bufindex + len > MapOutputBuffer.this.bufstart;
                        }
                        if (MapOutputBuffer.this.kvstart == MapOutputBuffer.this.kvend) {
                            if (MapOutputBuffer.this.kvend != MapOutputBuffer.this.kvindex) {
                                boolean bufsoftlimit;
                                boolean kvsoftlimit;
                                boolean bl3 = MapOutputBuffer.this.kvindex > MapOutputBuffer.this.kvend ? MapOutputBuffer.this.kvindex - MapOutputBuffer.this.kvend > MapOutputBuffer.this.softRecordLimit : (kvsoftlimit = MapOutputBuffer.this.kvend - MapOutputBuffer.this.kvindex < MapOutputBuffer.this.kvoffsets.length - MapOutputBuffer.this.softRecordLimit);
                                boolean bl4 = MapOutputBuffer.this.bufindex > MapOutputBuffer.this.bufend ? MapOutputBuffer.this.bufindex - MapOutputBuffer.this.bufend > MapOutputBuffer.this.softBufferLimit : (bufsoftlimit = MapOutputBuffer.this.bufend - MapOutputBuffer.this.bufindex < MapOutputBuffer.this.bufvoid - MapOutputBuffer.this.softBufferLimit);
                                if (kvsoftlimit || bufsoftlimit || buffull && !wrap) {
                                    LOG.info((Object)("Spilling map output: buffer full = " + bufsoftlimit + " and record full = " + kvsoftlimit));
                                    LOG.info((Object)("bufindex = " + MapOutputBuffer.this.bufindex + "; bufend = " + MapOutputBuffer.this.bufend + "; bufvoid = " + MapOutputBuffer.this.bufvoid));
                                    LOG.info((Object)("kvindex = " + MapOutputBuffer.this.kvindex + "; kvend = " + MapOutputBuffer.this.kvend + "; length = " + MapOutputBuffer.this.kvoffsets.length));
                                    MapOutputBuffer.this.kvend = MapOutputBuffer.this.kvindex;
                                    MapOutputBuffer.this.bufend = MapOutputBuffer.this.bufmark;
                                    SpillThread t = new SpillThread();
                                    t.setDaemon(true);
                                    t.setName("SpillThread");
                                    t.start();
                                }
                            } else if (buffull && !wrap) {
                                int size = (MapOutputBuffer.this.bufend <= MapOutputBuffer.this.bufindex ? MapOutputBuffer.this.bufindex - MapOutputBuffer.this.bufend : MapOutputBuffer.this.bufvoid - MapOutputBuffer.this.bufend + MapOutputBuffer.this.bufindex) + len;
                                MapOutputBuffer.this.bufstart = (MapOutputBuffer.this.bufend = (MapOutputBuffer.this.bufindex = (MapOutputBuffer.this.bufmark = 0)));
                                MapOutputBuffer.this.kvstart = (MapOutputBuffer.this.kvend = (MapOutputBuffer.this.kvindex = 0));
                                MapOutputBuffer.this.bufvoid = MapOutputBuffer.this.kvbuffer.length;
                                throw new MapBufferTooSmallException(size + " bytes");
                            }
                        }
                        if (!kvfull && (!buffull || wrap)) continue;
                        while (MapOutputBuffer.this.kvstart != MapOutputBuffer.this.kvend) {
                            MapOutputBuffer.this.reporter.progress();
                            try {
                                MapOutputBuffer.this.spillLock.wait();
                            }
                            catch (InterruptedException e) {
                                throw (IOException)new IOException("Buffer interrupted while waiting for the writer").initCause(e);
                            }
                        }
                    } while (kvfull || buffull && !wrap);
                }
                if (buffull) {
                    int gaplen = MapOutputBuffer.this.bufvoid - MapOutputBuffer.this.bufindex;
                    System.arraycopy(b, off, MapOutputBuffer.this.kvbuffer, MapOutputBuffer.this.bufindex, gaplen);
                    len -= gaplen;
                    off += gaplen;
                    MapOutputBuffer.this.bufindex = 0;
                }
                System.arraycopy(b, off, MapOutputBuffer.this.kvbuffer, MapOutputBuffer.this.bufindex, len);
                MapOutputBuffer.this.bufindex += len;
            }
        }

        protected class BlockingBuffer
        extends DataOutputStream {
            public BlockingBuffer() {
                this(mapOutputBuffer.new Buffer());
            }

            private BlockingBuffer(OutputStream out) {
                super(out);
            }

            public int markRecord() {
                MapOutputBuffer.this.bufmark = MapOutputBuffer.this.bufindex;
                return MapOutputBuffer.this.bufindex;
            }

            protected synchronized void reset() throws IOException {
                int headbytelen = MapOutputBuffer.this.bufvoid - MapOutputBuffer.this.bufmark;
                MapOutputBuffer.this.bufvoid = MapOutputBuffer.this.bufmark;
                if (MapOutputBuffer.this.bufindex + headbytelen < MapOutputBuffer.this.bufstart) {
                    System.arraycopy(MapOutputBuffer.this.kvbuffer, 0, MapOutputBuffer.this.kvbuffer, headbytelen, MapOutputBuffer.this.bufindex);
                    System.arraycopy(MapOutputBuffer.this.kvbuffer, MapOutputBuffer.this.bufvoid, MapOutputBuffer.this.kvbuffer, 0, headbytelen);
                    MapOutputBuffer.this.bufindex += headbytelen;
                } else {
                    byte[] keytmp = new byte[MapOutputBuffer.this.bufindex];
                    System.arraycopy(MapOutputBuffer.this.kvbuffer, 0, keytmp, 0, MapOutputBuffer.this.bufindex);
                    MapOutputBuffer.this.bufindex = 0;
                    this.out.write(MapOutputBuffer.this.kvbuffer, MapOutputBuffer.this.bufmark, headbytelen);
                    this.out.write(keytmp);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DirectMapOutputCollector<K, V>
    implements MapOutputCollector<K, V> {
        private RecordWriter<K, V> out = null;
        private Reporter reporter = null;
        private final Counters.Counter mapOutputRecordCounter;

        public DirectMapOutputCollector(TaskUmbilicalProtocol umbilical, JobConf job, Reporter reporter) throws IOException {
            this.reporter = reporter;
            String finalName = Task.getOutputName(MapTask.this.getPartition());
            FileSystem fs = FileSystem.get(job);
            this.out = job.getOutputFormat().getRecordWriter(fs, job, finalName, reporter);
            Counters counters = MapTask.this.getCounters();
            this.mapOutputRecordCounter = counters.findCounter(Task.Counter.MAP_OUTPUT_RECORDS);
        }

        @Override
        public void close() throws IOException {
            if (this.out != null) {
                this.out.close(this.reporter);
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void collect(K key, V value) throws IOException {
            this.reporter.progress();
            this.out.write(key, value);
            this.mapOutputRecordCounter.increment(1L);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface MapOutputCollector<K, V>
    extends OutputCollector<K, V> {
        public void close() throws IOException;

        public void flush() throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TrackedRecordReader<K, V>
    implements RecordReader<K, V> {
        private RecordReader<K, V> rawIn;
        private Counters.Counter inputByteCounter;
        private Counters.Counter inputRecordCounter;

        TrackedRecordReader(RecordReader<K, V> raw, Counters counters) {
            this.rawIn = raw;
            this.inputRecordCounter = counters.findCounter(Task.Counter.MAP_INPUT_RECORDS);
            this.inputByteCounter = counters.findCounter(Task.Counter.MAP_INPUT_BYTES);
        }

        @Override
        public K createKey() {
            return this.rawIn.createKey();
        }

        @Override
        public V createValue() {
            return this.rawIn.createValue();
        }

        @Override
        public synchronized boolean next(K key, V value) throws IOException {
            MapTask.this.setProgress(this.getProgress());
            long beforePos = this.getPos();
            boolean ret = this.rawIn.next(key, value);
            if (ret) {
                this.inputRecordCounter.increment(1L);
                this.inputByteCounter.increment(this.getPos() - beforePos);
            }
            return ret;
        }

        @Override
        public long getPos() throws IOException {
            return this.rawIn.getPos();
        }

        @Override
        public void close() throws IOException {
            this.rawIn.close();
        }

        @Override
        public float getProgress() throws IOException {
            return this.rawIn.getProgress();
        }
    }
}

