/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.FileAlreadyExistsException;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.util.Progressable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class OutputFormatBase<K, V>
implements OutputFormat<K, V> {
    public static void setCompressOutput(JobConf conf, boolean compress) {
        conf.setBoolean("mapred.output.compress", compress);
    }

    public static boolean getCompressOutput(JobConf conf) {
        return conf.getBoolean("mapred.output.compress", false);
    }

    public static void setOutputCompressorClass(JobConf conf, Class<? extends CompressionCodec> codecClass) {
        OutputFormatBase.setCompressOutput(conf, true);
        conf.setClass("mapred.output.compression.codec", codecClass, CompressionCodec.class);
    }

    public static Class<? extends CompressionCodec> getOutputCompressorClass(JobConf conf, Class<? extends CompressionCodec> defaultValue) {
        Class<? extends CompressionCodec> codecClass = defaultValue;
        String name = conf.get("mapred.output.compression.codec");
        if (name != null) {
            try {
                codecClass = conf.getClassByName(name).asSubclass(CompressionCodec.class);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Compression codec " + name + " was not found.", e);
            }
        }
        return codecClass;
    }

    @Override
    public abstract RecordWriter<K, V> getRecordWriter(FileSystem var1, JobConf var2, String var3, Progressable var4) throws IOException;

    @Override
    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws FileAlreadyExistsException, InvalidJobConfException, IOException {
        Path outDir = FileOutputFormat.getOutputPath(job);
        if (outDir == null && job.getNumReduceTasks() != 0) {
            throw new InvalidJobConfException("Output directory not set in JobConf.");
        }
        if (outDir != null && outDir.getFileSystem(job).exists(outDir)) {
            throw new FileAlreadyExistsException("Output directory " + outDir + " already exists");
        }
    }
}

