/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumFileSystem;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.IFile;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MRConstants;
import org.apache.hadoop.mapred.Merger;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RamManager;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.ReduceTaskRunner;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.util.Progress;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

class ReduceTask
extends Task {
    private static final Log LOG;
    private int numMaps;
    private ReduceCopier reduceCopier;
    private CompressionCodec codec;
    private Progress copyPhase;
    private Progress sortPhase;
    private Progress reducePhase;
    private Counters.Counter reduceInputKeyCounter;
    private Counters.Counter reduceInputValueCounter;
    private Counters.Counter reduceOutputCounter;
    private Counters.Counter reduceCombineInputCounter;
    private Counters.Counter reduceCombineOutputCounter;
    private Comparator<FileStatus> mapOutputFileComparator;
    private final SortedSet<FileStatus> mapOutputFilesOnDisk;

    public ReduceTask() {
        this.getProgress().setStatus("reduce");
        this.setPhase(TaskStatus.Phase.SHUFFLE);
        this.copyPhase = this.getProgress().addPhase("copy");
        this.sortPhase = this.getProgress().addPhase("sort");
        this.reducePhase = this.getProgress().addPhase("reduce");
        this.reduceInputKeyCounter = this.getCounters().findCounter(Task.Counter.REDUCE_INPUT_GROUPS);
        this.reduceInputValueCounter = this.getCounters().findCounter(Task.Counter.REDUCE_INPUT_RECORDS);
        this.reduceOutputCounter = this.getCounters().findCounter(Task.Counter.REDUCE_OUTPUT_RECORDS);
        this.reduceCombineInputCounter = this.getCounters().findCounter(Task.Counter.COMBINE_INPUT_RECORDS);
        this.reduceCombineOutputCounter = this.getCounters().findCounter(Task.Counter.COMBINE_OUTPUT_RECORDS);
        this.mapOutputFileComparator = new Comparator<FileStatus>(){

            @Override
            public int compare(FileStatus a, FileStatus b) {
                if (a.getLen() < b.getLen()) {
                    return -1;
                }
                if (a.getLen() == b.getLen()) {
                    if (a.getPath().toString().equals(b.getPath().toString())) {
                        return 0;
                    }
                    return -1;
                }
                return 1;
            }
        };
        this.mapOutputFilesOnDisk = new TreeSet<FileStatus>(this.mapOutputFileComparator);
    }

    public ReduceTask(String jobFile, TaskAttemptID taskId, int partition, int numMaps) {
        super(jobFile, taskId, partition);
        this.getProgress().setStatus("reduce");
        this.setPhase(TaskStatus.Phase.SHUFFLE);
        this.copyPhase = this.getProgress().addPhase("copy");
        this.sortPhase = this.getProgress().addPhase("sort");
        this.reducePhase = this.getProgress().addPhase("reduce");
        this.reduceInputKeyCounter = this.getCounters().findCounter(Task.Counter.REDUCE_INPUT_GROUPS);
        this.reduceInputValueCounter = this.getCounters().findCounter(Task.Counter.REDUCE_INPUT_RECORDS);
        this.reduceOutputCounter = this.getCounters().findCounter(Task.Counter.REDUCE_OUTPUT_RECORDS);
        this.reduceCombineInputCounter = this.getCounters().findCounter(Task.Counter.COMBINE_INPUT_RECORDS);
        this.reduceCombineOutputCounter = this.getCounters().findCounter(Task.Counter.COMBINE_OUTPUT_RECORDS);
        this.mapOutputFileComparator = new /* invalid duplicate definition of identical inner class */;
        this.mapOutputFilesOnDisk = new TreeSet<FileStatus>(this.mapOutputFileComparator);
        this.numMaps = numMaps;
    }

    private CompressionCodec initCodec() {
        if (this.conf.getCompressMapOutput()) {
            Class<? extends CompressionCodec> codecClass = this.conf.getMapOutputCompressorClass(DefaultCodec.class);
            return (CompressionCodec)ReflectionUtils.newInstance(codecClass, this.conf);
        }
        return null;
    }

    public TaskRunner createRunner(TaskTracker tracker) throws IOException {
        return new ReduceTaskRunner(this, tracker, this.conf);
    }

    public boolean isMapTask() {
        return false;
    }

    public int getNumMaps() {
        return this.numMaps;
    }

    public void localizeConfiguration(JobConf conf) throws IOException {
        super.localizeConfiguration(conf);
        conf.setNumMapTasks(this.numMaps);
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.numMaps);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.numMaps = in.readInt();
    }

    private Path[] getMapFiles(FileSystem fs, boolean isLocal) throws IOException {
        ArrayList<Path> fileList = new ArrayList<Path>();
        if (isLocal) {
            for (int i = 0; i < this.numMaps; ++i) {
                fileList.add(this.mapOutputFile.getInputFile(i, this.getTaskID()));
            }
        } else {
            for (FileStatus filestatus : this.mapOutputFilesOnDisk) {
                fileList.add(filestatus.getPath());
            }
        }
        return fileList.toArray(new Path[0]);
    }

    public void run(JobConf job, TaskUmbilicalProtocol umbilical) throws IOException {
        Reducer reducer = (Reducer)ReflectionUtils.newInstance(job.getReducerClass(), job);
        this.startCommunicationThread(umbilical);
        LocalFileSystem lfs = FileSystem.getLocal(job);
        this.codec = this.initCodec();
        boolean isLocal = true;
        if (!job.get("mapred.job.tracker", "local").equals("local")) {
            this.reduceCopier = new ReduceCopier(umbilical, job);
            if (!this.reduceCopier.fetchOutputs()) {
                throw new IOException(this.getTaskID() + "The reduce copier failed");
            }
            isLocal = false;
        }
        this.copyPhase.complete();
        Path[] mapFiles = this.getMapFiles(lfs, isLocal);
        Path tempDir = new Path(this.getTaskID().toString());
        this.setPhase(TaskStatus.Phase.SORT);
        final Reporter reporter = this.getReporter(umbilical);
        LOG.info((Object)("Initiating final on-disk merge with " + mapFiles.length + " files"));
        RawKeyValueIterator rIter = Merger.merge(job, lfs, job.getMapOutputKeyClass(), job.getMapOutputValueClass(), this.codec, mapFiles, !this.conf.getKeepFailedTaskFiles(), job.getInt("io.sort.factor", 100), tempDir, job.getOutputKeyComparator(), reporter);
        this.mapOutputFilesOnDisk.clear();
        mapFiles = null;
        this.sortPhase.complete();
        this.setPhase(TaskStatus.Phase.REDUCE);
        String finalName = ReduceTask.getOutputName(this.getPartition());
        FileSystem fs = FileSystem.get(job);
        final RecordWriter out = job.getOutputFormat().getRecordWriter(fs, job, finalName, reporter);
        OutputCollector collector = new OutputCollector(){

            public void collect(Object key, Object value) throws IOException {
                out.write(key, value);
                ReduceTask.this.reduceOutputCounter.increment(1L);
                reporter.progress();
            }
        };
        try {
            Class<?> keyClass = job.getMapOutputKeyClass();
            Class<?> valClass = job.getMapOutputValueClass();
            ReduceValuesIterator values = new ReduceValuesIterator(rIter, job.getOutputValueGroupingComparator(), keyClass, valClass, job, reporter);
            values.informReduceProgress();
            while (values.more()) {
                this.reduceInputKeyCounter.increment(1L);
                reducer.reduce(values.getKey(), values, collector, reporter);
                values.nextKey();
                values.informReduceProgress();
            }
            reducer.close();
            out.close(reporter);
        }
        catch (IOException ioe) {
            try {
                reducer.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            try {
                out.close(reporter);
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw ioe;
        }
        this.done(umbilical);
    }

    private static int getClosestPowerOf2(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("Undefined for " + value);
        }
        int hob = Integer.highestOneBit(value);
        return Integer.numberOfTrailingZeros(hob) + ((hob >>> 1 & value) == 0 ? 0 : 1);
    }

    static {
        WritableFactories.setFactory(ReduceTask.class, new WritableFactory(){

            public Writable newInstance() {
                return new ReduceTask();
            }
        });
        LOG = LogFactory.getLog((String)ReduceTask.class.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ReduceCopier<K, V>
    implements MRConstants {
        private TaskUmbilicalProtocol umbilical;
        private static final int STALLED_COPY_TIMEOUT = 180000;
        private static final int MAX_EVENTS_TO_FETCH = 10000;
        private ReduceTask reduceTask;
        private List<MapOutputLocation> scheduledCopies;
        private List<CopyResult> copyResults;
        private int numCopiers;
        private int maxInFlight;
        private int maxBackoff;
        private Map<String, Long> penaltyBox;
        private Set<String> uniqueHosts;
        private long lastPollTime;
        private ShuffleRamManager ramManager;
        private FileSystem localFileSys;
        private int ioSortFactor;
        private volatile Throwable mergeThrowable;
        private volatile boolean exitLocalFSMerge = false;
        private volatile boolean exitInMemMerge = false;
        private int mergeThreshold = 500;
        private List<MapOutputCopier> copiers = null;
        private ShuffleClientMetrics shuffleClientMetrics = null;
        private static final long MIN_POLL_INTERVAL = 1000L;
        private List<MapOutputLocation> retryFetches = new ArrayList<MapOutputLocation>();
        private Set<TaskID> copiedMapOutputs = Collections.synchronizedSet(new TreeSet());
        private Set<TaskAttemptID> obsoleteMapIds = Collections.synchronizedSet(new TreeSet());
        private Random random = null;
        private long ramfsMergeOutputSize;
        private int maxMapRuntime;
        private int maxFetchRetriesPerMap;
        private final Class<? extends Reducer> combinerClass;
        private final Task.CombineOutputCollector combineCollector;
        private static final float MAX_ALLOWED_FAILED_FETCH_ATTEMPT_PERCENT = 0.5f;
        private static final float MIN_REQUIRED_PROGRESS_PERCENT = 0.5f;
        private static final float MAX_ALLOWED_STALL_TIME_PERCENT = 0.5f;
        private static final int MAX_FAILED_UNIQUE_FETCHES = 5;
        Set<TaskID> fetchFailedMaps = new TreeSet<TaskID>();
        Map<TaskAttemptID, Integer> mapTaskToFailedFetchesMap = new HashMap<TaskAttemptID, Integer>();
        private static final int BACKOFF_INIT = 4000;
        private static final int MIN_LOG_TIME = 60000;
        private final List<MapOutput> mapOutputsFilesInMemory = Collections.synchronizedList(new LinkedList());
        private int nextMapOutputCopierId = 0;

        private void configureClasspath(JobConf conf) throws IOException {
            ReduceTask task = ReduceTask.this;
            ClassLoader parent = conf.getClassLoader();
            File workDir = new File(task.getJobFile()).getParentFile();
            ArrayList<URL> urllist = new ArrayList<URL>();
            String jar = conf.getJar();
            if (jar != null) {
                File jobCacheDir = new File(new Path(jar).getParent().toString());
                File[] libs = new File(jobCacheDir, "lib").listFiles();
                if (libs != null) {
                    for (int i = 0; i < libs.length; ++i) {
                        urllist.add(libs[i].toURL());
                    }
                }
                urllist.add(new File(jobCacheDir, "classes").toURL());
                urllist.add(jobCacheDir.toURL());
            }
            urllist.add(workDir.toURL());
            URL[] urls = urllist.toArray(new URL[urllist.size()]);
            URLClassLoader loader = new URLClassLoader(urls, parent);
            conf.setClassLoader(loader);
        }

        public ReduceCopier(TaskUmbilicalProtocol umbilical, JobConf conf) throws IOException {
            this.configureClasspath(conf);
            this.shuffleClientMetrics = new ShuffleClientMetrics(conf);
            this.umbilical = umbilical;
            this.reduceTask = ReduceTask.this;
            this.scheduledCopies = new ArrayList<MapOutputLocation>(100);
            this.copyResults = new ArrayList<CopyResult>(100);
            this.numCopiers = conf.getInt("mapred.reduce.parallel.copies", 5);
            this.maxInFlight = 4 * this.numCopiers;
            this.maxBackoff = conf.getInt("mapred.reduce.copy.backoff", 300);
            this.combinerClass = conf.getCombinerClass();
            this.combineCollector = null != this.combinerClass ? new Task.CombineOutputCollector(ReduceTask.this.reduceCombineOutputCounter) : null;
            this.ioSortFactor = conf.getInt("io.sort.factor", 10);
            this.maxFetchRetriesPerMap = ReduceTask.getClosestPowerOf2(this.maxBackoff * 1000 / 4000 + 1);
            this.mergeThreshold = conf.getInt("mapred.inmem.merge.threshold", 1000);
            this.ramManager = new ShuffleRamManager(conf);
            this.ramfsMergeOutputSize = (long)(0.66f * (float)this.ramManager.getMemoryLimit());
            this.localFileSys = FileSystem.getLocal(conf);
            this.penaltyBox = new LinkedHashMap<String, Long>();
            this.uniqueHosts = new HashSet<String>();
            this.lastPollTime = 0L;
            long randomSeed = System.nanoTime() + (long)Math.pow(this.reduceTask.getPartition(), this.reduceTask.getPartition() % 10);
            this.random = new Random(randomSeed);
            this.maxMapRuntime = 0;
        }

        private boolean busyEnough(int numInFlight) {
            return numInFlight > this.maxInFlight;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean fetchOutputs() throws IOException {
            long startTime;
            int numOutputs = this.reduceTask.getNumMaps();
            ArrayList<MapOutputLocation> knownOutputs = new ArrayList<MapOutputLocation>(this.numCopiers);
            int totalFailures = 0;
            int numInFlight = 0;
            int numCopied = 0;
            long bytesTransferred = 0L;
            DecimalFormat mbpsFormat = new DecimalFormat("0.00");
            Progress copyPhase = this.reduceTask.getProgress().phase();
            LocalFSMerger localFSMergerThread = null;
            InMemFSMergeThread inMemFSMergeThread = null;
            for (int i = 0; i < numOutputs; ++i) {
                copyPhase.addPhase();
            }
            this.copiers = new ArrayList<MapOutputCopier>(this.numCopiers);
            Reporter reporter = ReduceTask.this.getReporter(this.umbilical);
            for (int i = 0; i < this.numCopiers; ++i) {
                MapOutputCopier copier = new MapOutputCopier(ReduceTask.this.conf, reporter);
                this.copiers.add(copier);
                copier.start();
            }
            localFSMergerThread = new LocalFSMerger((LocalFileSystem)this.localFileSys);
            inMemFSMergeThread = new InMemFSMergeThread();
            localFSMergerThread.start();
            inMemFSMergeThread.start();
            long currentTime = startTime = System.currentTimeMillis();
            long lastProgressTime = startTime;
            long lastOutputTime = 0L;
            IntWritable fromEventId = new IntWritable(0);
            block23: while (this.copiedMapOutputs.size() < numOutputs && this.mergeThrowable == null) {
                currentTime = System.currentTimeMillis();
                boolean logNow = false;
                if (currentTime - lastOutputTime > 60000L) {
                    lastOutputTime = currentTime;
                    logNow = true;
                }
                if (logNow) {
                    LOG.info((Object)(this.reduceTask.getTaskID() + " Need another " + (numOutputs - this.copiedMapOutputs.size()) + " map output(s) " + "where " + numInFlight + " is already in progress"));
                }
                try {
                    int numNewObsoleteMaps;
                    knownOutputs.addAll(this.retryFetches);
                    int currentNumKnownMaps = knownOutputs.size();
                    int currentNumObsoleteMapIds = this.obsoleteMapIds.size();
                    this.getMapCompletionEvents(fromEventId, knownOutputs);
                    int numNewOutputs = knownOutputs.size() - currentNumKnownMaps;
                    if (numNewOutputs > 0 || logNow) {
                        LOG.info((Object)(this.reduceTask.getTaskID() + ": " + "Got " + numNewOutputs + " new map-outputs & number of known map outputs is " + knownOutputs.size()));
                    }
                    if ((numNewObsoleteMaps = this.obsoleteMapIds.size() - currentNumObsoleteMapIds) > 0) {
                        LOG.info((Object)(this.reduceTask.getTaskID() + ": " + "Got " + numNewObsoleteMaps + " obsolete map-outputs from tasktracker "));
                    }
                    if (this.retryFetches.size() > 0) {
                        LOG.info((Object)(this.reduceTask.getTaskID() + ": " + "Got " + this.retryFetches.size() + " map-outputs from previous failures"));
                    }
                    this.retryFetches.clear();
                }
                catch (IOException ie) {
                    LOG.warn((Object)(this.reduceTask.getTaskID() + " Problem locating map outputs: " + StringUtils.stringifyException(ie)));
                }
                int numKnown = knownOutputs.size();
                int numScheduled = 0;
                int numDups = 0;
                List<MapOutputLocation> numNewObsoleteMaps = this.scheduledCopies;
                synchronized (numNewObsoleteMaps) {
                    Collections.shuffle(knownOutputs, this.random);
                    Iterator locIt = knownOutputs.iterator();
                    while (locIt.hasNext()) {
                        MapOutputLocation loc = (MapOutputLocation)locIt.next();
                        if (this.obsoleteMapIds.contains(loc.getTaskAttemptId())) {
                            locIt.remove();
                            continue;
                        }
                        Long penaltyEnd = this.penaltyBox.get(loc.getHost());
                        boolean penalized = false;
                        boolean duplicate = false;
                        if (penaltyEnd != null) {
                            if (currentTime < penaltyEnd) {
                                penalized = true;
                            } else {
                                this.penaltyBox.remove(loc.getHost());
                            }
                        }
                        if (this.uniqueHosts.contains(loc.getHost())) {
                            duplicate = true;
                            ++numDups;
                        }
                        if (penalized || duplicate) continue;
                        this.uniqueHosts.add(loc.getHost());
                        this.scheduledCopies.add(loc);
                        locIt.remove();
                        ++numInFlight;
                        ++numScheduled;
                    }
                    this.scheduledCopies.notifyAll();
                }
                if (numScheduled > 0 || logNow) {
                    LOG.info((Object)(this.reduceTask.getTaskID() + " Scheduled " + numScheduled + " of " + numKnown + " known outputs (" + this.penaltyBox.size() + " slow hosts and " + numDups + " dup hosts)"));
                }
                if (this.penaltyBox.size() > 0 && logNow) {
                    LOG.info((Object)"Penalized(slow) Hosts: ");
                    for (String host : this.penaltyBox.keySet()) {
                        LOG.info((Object)(host + " Will be considered after: " + (this.penaltyBox.get(host) - currentTime) / 1000L + " seconds."));
                    }
                }
                try {
                    if (numInFlight == 0 && numScheduled == 0) {
                        reporter.progress();
                        Thread.sleep(5000L);
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                while (numInFlight > 0 && this.mergeThrowable == null) {
                    LOG.debug((Object)(this.reduceTask.getTaskID() + " numInFlight = " + numInFlight));
                    CopyResult cr = this.getCopyResult(numInFlight);
                    if (cr == null) continue block23;
                    if (cr.getSuccess()) {
                        ++numCopied;
                        lastProgressTime = System.currentTimeMillis();
                        long secsSinceStart = (System.currentTimeMillis() - startTime) / 1000L + 1L;
                        float mbs = (float)(bytesTransferred += cr.getSize()) / 1048576.0f;
                        float transferRate = mbs / (float)secsSinceStart;
                        copyPhase.startNextPhase();
                        copyPhase.setStatus("copy (" + numCopied + " of " + numOutputs + " at " + mbpsFormat.format(transferRate) + " MB/s)");
                        this.fetchFailedMaps.remove(cr.getLocation().getTaskId());
                    } else if (cr.isObsolete()) {
                        LOG.info((Object)(this.reduceTask.getTaskID() + " Ignoring obsolete copy result for Map Task: " + cr.getLocation().getTaskAttemptId() + " from host: " + cr.getHost()));
                    } else {
                        this.retryFetches.add(cr.getLocation());
                        TaskAttemptID mapTaskId = cr.getLocation().getTaskAttemptId();
                        TaskID mapId = cr.getLocation().getTaskId();
                        ++totalFailures;
                        Integer noFailedFetches = this.mapTaskToFailedFetchesMap.get(mapTaskId);
                        noFailedFetches = noFailedFetches == null ? 1 : noFailedFetches + 1;
                        this.mapTaskToFailedFetchesMap.put(mapTaskId, noFailedFetches);
                        LOG.info((Object)("Task " + ReduceTask.this.getTaskID() + ": Failed fetch #" + noFailedFetches + " from " + mapTaskId));
                        if (noFailedFetches >= this.maxFetchRetriesPerMap && (noFailedFetches - this.maxFetchRetriesPerMap) % 2 == 0) {
                            ReduceTask transferRate = ReduceTask.this;
                            synchronized (transferRate) {
                                ReduceTask.this.taskStatus.addFetchFailedMap(mapTaskId);
                                LOG.info((Object)("Failed to fetch map-output from " + mapTaskId + " even after MAX_FETCH_RETRIES_PER_MAP retries... " + " reporting to the JobTracker"));
                            }
                        }
                        if (noFailedFetches == this.maxFetchRetriesPerMap) {
                            boolean reducerStalled;
                            this.fetchFailedMaps.add(mapId);
                            boolean reducerHealthy = (float)totalFailures / (float)(totalFailures + numCopied) < 0.5f;
                            boolean reducerProgressedEnough = (float)numCopied / (float)ReduceTask.this.numMaps >= 0.5f;
                            int stallDuration = (int)(System.currentTimeMillis() - lastProgressTime);
                            int shuffleProgressDuration = (int)(lastProgressTime - startTime);
                            int minShuffleRunDuration = shuffleProgressDuration > this.maxMapRuntime ? shuffleProgressDuration : this.maxMapRuntime;
                            boolean bl = reducerStalled = (float)stallDuration / (float)minShuffleRunDuration >= 0.5f;
                            if (!(this.fetchFailedMaps.size() < 5 || reducerHealthy || reducerProgressedEnough && !reducerStalled)) {
                                LOG.fatal((Object)("Shuffle failed with too many fetch failures and insufficient progress!Killing task " + ReduceTask.this.getTaskID() + "."));
                                this.umbilical.shuffleError(ReduceTask.this.getTaskID(), "Exceeded MAX_FAILED_UNIQUE_FETCHES; bailing-out.");
                            }
                        }
                        currentTime = System.currentTimeMillis();
                        int currentBackOff = noFailedFetches <= this.maxFetchRetriesPerMap ? 4000 * (1 << noFailedFetches - 1) : this.maxBackoff * 1000 / 2;
                        this.penaltyBox.put(cr.getHost(), currentTime + (long)currentBackOff);
                        LOG.warn((Object)(this.reduceTask.getTaskID() + " adding host " + cr.getHost() + " to penalty box, next contact in " + currentBackOff / 1000 + " seconds"));
                        Iterator locIt = knownOutputs.iterator();
                        while (locIt.hasNext()) {
                            MapOutputLocation loc = (MapOutputLocation)locIt.next();
                            if (!cr.getHost().equals(loc.getHost())) continue;
                            this.retryFetches.add(loc);
                            locIt.remove();
                        }
                    }
                    this.uniqueHosts.remove(cr.getHost());
                    --numInFlight;
                }
            }
            SequencedCollection<MapOutputCopier> logNow = this.copiers;
            synchronized (logNow) {
                List<MapOutputLocation> list = this.scheduledCopies;
                synchronized (list) {
                    for (MapOutputCopier copier : this.copiers) {
                        copier.interrupt();
                    }
                    this.copiers.clear();
                }
            }
            logNow = ReduceTask.this.mapOutputFilesOnDisk;
            synchronized (logNow) {
                this.exitLocalFSMerge = true;
                ReduceTask.this.mapOutputFilesOnDisk.notify();
            }
            this.exitInMemMerge = true;
            this.ramManager.close();
            if (this.mergeThrowable == null) {
                try {
                    localFSMergerThread.join();
                    inMemFSMergeThread.join();
                }
                catch (Throwable t) {
                    LOG.warn((Object)(this.reduceTask.getTaskID() + " Final merge of the inmemory files threw an exception: " + StringUtils.stringifyException(t)));
                    if (this.mergeThrowable != null) {
                        this.mergeThrowable = t;
                    }
                    return false;
                }
            }
            return this.mergeThrowable == null && this.copiedMapOutputs.size() == numOutputs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Merger.Segment<K, V>> createInMemorySegments() {
            LinkedList<Merger.Segment<K, V>> inMemorySegments = new LinkedList<Merger.Segment<K, V>>();
            List<MapOutput> list = this.mapOutputsFilesInMemory;
            synchronized (list) {
                while (this.mapOutputsFilesInMemory.size() > 0) {
                    MapOutput mo = this.mapOutputsFilesInMemory.remove(0);
                    IFile.InMemoryReader reader = new IFile.InMemoryReader(this.ramManager, mo.data, 0, mo.data.length);
                    Merger.Segment segment = new Merger.Segment(reader, true);
                    inMemorySegments.add(segment);
                }
            }
            return inMemorySegments;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CopyResult getCopyResult(int numInFlight) {
            List<CopyResult> list = this.copyResults;
            synchronized (list) {
                while (this.copyResults.isEmpty()) {
                    try {
                        if (this.busyEnough(numInFlight)) {
                            this.copyResults.wait();
                            continue;
                        }
                        return null;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                return this.copyResults.remove(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addToMapOutputFilesOnDisk(FileStatus status) {
            SortedSet sortedSet = ReduceTask.this.mapOutputFilesOnDisk;
            synchronized (sortedSet) {
                ReduceTask.this.mapOutputFilesOnDisk.add(status);
                ReduceTask.this.mapOutputFilesOnDisk.notify();
            }
        }

        private void getMapCompletionEvents(IntWritable fromEventId, List<MapOutputLocation> knownOutputs) throws IOException {
            long currentTime = System.currentTimeMillis();
            long pollTime = this.lastPollTime + 1000L;
            while (currentTime < pollTime) {
                try {
                    Thread.sleep(pollTime - currentTime);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                currentTime = System.currentTimeMillis();
            }
            TaskCompletionEvent[] events = this.umbilical.getMapCompletionEvents(this.reduceTask.getJobID(), fromEventId.get(), 10000);
            this.lastPollTime = currentTime;
            fromEventId.set(fromEventId.get() + events.length);
            block8: for (TaskCompletionEvent event : events) {
                switch (event.getTaskStatus()) {
                    case SUCCEEDED: {
                        URI u = URI.create(event.getTaskTrackerHttp());
                        String host = u.getHost();
                        TaskAttemptID taskId = event.getTaskAttemptId();
                        int duration = event.getTaskRunTime();
                        if (duration > this.maxMapRuntime) {
                            this.maxMapRuntime = duration;
                            this.maxFetchRetriesPerMap = ReduceTask.getClosestPowerOf2(this.maxMapRuntime / 4000 + 1);
                        }
                        URL mapOutputLocation = new URL(event.getTaskTrackerHttp() + "/mapOutput?job=" + taskId.getJobID() + "&map=" + taskId + "&reduce=" + ReduceTask.this.getPartition());
                        knownOutputs.add(new MapOutputLocation(taskId, host, mapOutputLocation));
                        continue block8;
                    }
                    case FAILED: 
                    case KILLED: 
                    case OBSOLETE: {
                        this.obsoleteMapIds.add(event.getTaskAttemptId());
                        LOG.info((Object)("Ignoring obsolete output of " + (Object)((Object)event.getTaskStatus()) + " map-task: '" + event.getTaskAttemptId() + "'"));
                        continue block8;
                    }
                    case TIPFAILED: {
                        this.copiedMapOutputs.add(event.getTaskAttemptId().getTaskID());
                        LOG.info((Object)("Ignoring output of failed map TIP: '" + event.getTaskAttemptId() + "'"));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void combineAndSpill(RawKeyValueIterator kvIter, Counters.Counter inCounter) throws IOException {
            JobConf job = (JobConf)ReduceTask.this.getConf();
            Reducer combiner = (Reducer)ReflectionUtils.newInstance(this.combinerClass, job);
            Class<?> keyClass = job.getMapOutputKeyClass();
            Class<?> valClass = job.getMapOutputValueClass();
            RawComparator comparator = job.getOutputKeyComparator();
            try {
                Task.CombineValuesIterator values = new Task.CombineValuesIterator(kvIter, comparator, keyClass, valClass, job, Reporter.NULL, inCounter);
                while (values.more()) {
                    combiner.reduce(values.getKey(), values, this.combineCollector, Reporter.NULL);
                    values.nextKey();
                }
            }
            finally {
                combiner.close();
            }
        }

        static /* synthetic */ int access$608(ReduceCopier x0) {
            return x0.nextMapOutputCopierId++;
        }

        static /* synthetic */ List access$900(ReduceCopier x0) {
            return x0.scheduledCopies;
        }

        private class InMemFSMergeThread
        extends Thread {
            public InMemFSMergeThread() {
                this.setName("Thread for merging in memory files");
                this.setDaemon(true);
            }

            public void run() {
                LOG.info((Object)(ReduceCopier.this.reduceTask.getTaskID() + " Thread started: " + this.getName()));
                try {
                    while (!ReduceCopier.this.exitInMemMerge) {
                        ReduceCopier.this.ramManager.waitForDataToMerge();
                        this.doInMemMerge();
                    }
                }
                catch (Throwable t) {
                    LOG.warn((Object)(ReduceCopier.this.reduceTask.getTaskID() + " Merge of the inmemory files threw an exception: " + StringUtils.stringifyException(t)));
                    ReduceCopier.this.mergeThrowable = t;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void doInMemMerge() throws IOException {
                if (ReduceCopier.this.mapOutputsFilesInMemory.size() == 0) {
                    LOG.info((Object)"Noting to merge... ");
                    return;
                }
                TaskID mapId = ((MapOutput)((ReduceCopier)ReduceCopier.this).mapOutputsFilesInMemory.get((int)0)).mapId;
                Path outputPath = ReduceTask.this.mapOutputFile.getInputFileForWrite(mapId, ReduceCopier.this.reduceTask.getTaskID(), ReduceCopier.this.ramfsMergeOutputSize);
                IFile.Writer writer = new IFile.Writer(ReduceTask.this.conf, ReduceCopier.this.localFileSys, outputPath, ReduceTask.this.conf.getMapOutputKeyClass(), ReduceTask.this.conf.getMapOutputValueClass(), ReduceTask.this.codec);
                List inMemorySegments = ReduceCopier.this.createInMemorySegments();
                int noInMemorySegments = inMemorySegments.size();
                RawKeyValueIterator rIter = null;
                Reporter reporter = ReduceTask.this.getReporter(ReduceCopier.this.umbilical);
                try {
                    rIter = Merger.merge(ReduceTask.this.conf, ReduceCopier.this.localFileSys, ReduceTask.this.conf.getMapOutputKeyClass(), ReduceTask.this.conf.getMapOutputValueClass(), inMemorySegments, inMemorySegments.size(), new Path(ReduceCopier.this.reduceTask.getTaskID().toString()), ReduceTask.this.conf.getOutputKeyComparator(), reporter);
                    if (null == ReduceCopier.this.combinerClass) {
                        Merger.writeFile(rIter, writer, reporter);
                    } else {
                        ReduceCopier.this.combineCollector.setWriter(writer);
                        ReduceCopier.this.combineAndSpill(rIter, ReduceTask.this.reduceCombineInputCounter);
                    }
                    writer.close();
                }
                catch (Exception e) {
                    ReduceCopier.this.localFileSys.delete(outputPath, true);
                    throw (IOException)new IOException("Intermedate merge failed").initCause(e);
                }
                LOG.info((Object)(ReduceCopier.this.reduceTask.getTaskID() + " Merge of the " + noInMemorySegments + " files in-memory complete." + " Local file is " + outputPath + " of size " + ReduceCopier.this.localFileSys.getFileStatus(outputPath).getLen()));
                FileStatus status = ReduceCopier.this.localFileSys.getFileStatus(outputPath);
                SortedSet sortedSet = ReduceTask.this.mapOutputFilesOnDisk;
                synchronized (sortedSet) {
                    ReduceCopier.this.addToMapOutputFilesOnDisk(status);
                }
            }
        }

        private class LocalFSMerger
        extends Thread {
            private LocalFileSystem localFileSys;

            public LocalFSMerger(LocalFileSystem fs) {
                this.localFileSys = fs;
                this.setName("Thread for merging on-disk files");
                this.setDaemon(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block17: {
                    try {
                        LOG.info((Object)(ReduceCopier.this.reduceTask.getTaskID() + " Thread started: " + this.getName()));
                        while (!ReduceCopier.this.exitLocalFSMerge) {
                            SortedSet sortedSet = ReduceTask.this.mapOutputFilesOnDisk;
                            synchronized (sortedSet) {
                                while (!ReduceCopier.this.exitLocalFSMerge && ReduceTask.this.mapOutputFilesOnDisk.size() < 2 * ReduceCopier.this.ioSortFactor - 1) {
                                    LOG.info((Object)(ReduceCopier.this.reduceTask.getTaskID() + " Thread waiting: " + this.getName()));
                                    ReduceTask.this.mapOutputFilesOnDisk.wait();
                                }
                            }
                            if (ReduceCopier.this.exitLocalFSMerge) break;
                            ArrayList<Path> mapFiles = new ArrayList<Path>();
                            long approxOutputSize = 0L;
                            int bytesPerSum = ReduceCopier.this.reduceTask.getConf().getInt("io.bytes.per.checksum", 512);
                            LOG.info((Object)(ReduceCopier.this.reduceTask.getTaskID() + "We have  " + ReduceTask.this.mapOutputFilesOnDisk.size() + " map outputs on disk. " + "Triggering merge of " + ReduceCopier.this.ioSortFactor + " files"));
                            SortedSet sortedSet2 = ReduceTask.this.mapOutputFilesOnDisk;
                            synchronized (sortedSet2) {
                                for (int i = 0; i < ReduceCopier.this.ioSortFactor; ++i) {
                                    FileStatus filestatus = (FileStatus)ReduceTask.this.mapOutputFilesOnDisk.first();
                                    ReduceTask.this.mapOutputFilesOnDisk.remove(filestatus);
                                    mapFiles.add(filestatus.getPath());
                                    approxOutputSize += filestatus.getLen();
                                }
                            }
                            if (mapFiles.size() == 0) {
                                return;
                            }
                            approxOutputSize += ChecksumFileSystem.getChecksumLength(approxOutputSize, bytesPerSum);
                            Path outputPath = ReduceTask.this.lDirAlloc.getLocalPathForWrite(((Path)mapFiles.get(0)).toString(), approxOutputSize, ReduceTask.this.conf).suffix(".merged");
                            IFile.Writer writer = new IFile.Writer(ReduceTask.this.conf, this.localFileSys, outputPath, ReduceTask.this.conf.getMapOutputKeyClass(), ReduceTask.this.conf.getMapOutputValueClass(), ReduceTask.this.codec);
                            RawKeyValueIterator iter = null;
                            Path tmpDir = new Path(ReduceCopier.this.reduceTask.getTaskID().toString());
                            Reporter reporter = ReduceTask.this.getReporter(ReduceCopier.this.umbilical);
                            try {
                                iter = Merger.merge(ReduceTask.this.conf, this.localFileSys, ReduceTask.this.conf.getMapOutputKeyClass(), ReduceTask.this.conf.getMapOutputValueClass(), ReduceTask.this.codec, mapFiles.toArray(new Path[mapFiles.size()]), true, ReduceCopier.this.ioSortFactor, tmpDir, ReduceTask.this.conf.getOutputKeyComparator(), reporter);
                                Merger.writeFile(iter, writer, reporter);
                                writer.close();
                            }
                            catch (Exception e) {
                                this.localFileSys.delete(outputPath, true);
                                throw new IOException(StringUtils.stringifyException(e));
                            }
                            SortedSet sortedSet3 = ReduceTask.this.mapOutputFilesOnDisk;
                            synchronized (sortedSet3) {
                                ReduceCopier.this.addToMapOutputFilesOnDisk(this.localFileSys.getFileStatus(outputPath));
                            }
                            LOG.info((Object)(ReduceCopier.this.reduceTask.getTaskID() + " Finished merging " + mapFiles.size() + " map output files on disk of total-size " + approxOutputSize + "." + " Local output file is " + outputPath + " of size " + this.localFileSys.getFileStatus(outputPath).getLen()));
                        }
                    }
                    catch (Throwable t) {
                        LOG.warn((Object)(ReduceCopier.this.reduceTask.getTaskID() + " Merging of the local FS files threw an exception: " + StringUtils.stringifyException(t)));
                        if (ReduceCopier.this.mergeThrowable != null) break block17;
                        ReduceCopier.this.mergeThrowable = t;
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class MapOutputCopier
        extends Thread {
            private static final int UNIT_CONNECT_TIMEOUT = 30000;
            private static final int DEFAULT_READ_TIMEOUT = 180000;
            private MapOutputLocation currentLocation = null;
            private int id = ReduceCopier.access$608(ReduceCopier.this);
            private Reporter reporter;
            private CompressionCodec codec = null;
            private Decompressor decompressor = null;

            public MapOutputCopier(JobConf job, Reporter reporter) {
                this.setName("MapOutputCopier " + ReduceCopier.this.reduceTask.getTaskID() + "." + this.id);
                LOG.debug((Object)(this.getName() + " created"));
                this.reporter = reporter;
                if (job.getCompressMapOutput()) {
                    Class<? extends CompressionCodec> codecClass = job.getMapOutputCompressorClass(DefaultCodec.class);
                    this.codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, job);
                    this.decompressor = CodecPool.getDecompressor(this.codec);
                }
            }

            public synchronized boolean fail() {
                if (this.currentLocation != null) {
                    this.finish(-1L);
                    return true;
                }
                return false;
            }

            public synchronized MapOutputLocation getLocation() {
                return this.currentLocation;
            }

            private synchronized void start(MapOutputLocation loc) {
                this.currentLocation = loc;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private synchronized void finish(long size) {
                if (this.currentLocation != null) {
                    LOG.debug((Object)(this.getName() + " finishing " + this.currentLocation + " =" + size));
                    List list = ReduceCopier.this.copyResults;
                    synchronized (list) {
                        ReduceCopier.this.copyResults.add(new CopyResult(this.currentLocation, size));
                        ReduceCopier.this.copyResults.notify();
                    }
                    this.currentLocation = null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) lbl-1000:
                        // 4 sources

                        {
                            loc = null;
                            size = -1L;
                            var4_5 = ReduceCopier.access$900(ReduceCopier.this);
                            synchronized (var4_5) {
                                while (ReduceCopier.access$900(ReduceCopier.this).isEmpty()) {
                                    ReduceCopier.access$900(ReduceCopier.this).wait();
                                }
                                loc = (MapOutputLocation)ReduceCopier.access$900(ReduceCopier.this).remove(0);
                            }
                            try {
                                ReduceCopier.access$1000(ReduceCopier.this).threadBusy();
                                this.start(loc);
                                size = this.copyOutput(loc);
                                ReduceCopier.access$1000(ReduceCopier.this).successFetch();
                            }
                            catch (IOException e) {
                                ReduceTask.access$400().warn((Object)(ReduceCopier.access$700(ReduceCopier.this).getTaskID() + " copy failed: " + loc.getTaskAttemptId() + " from " + loc.getHost()));
                                ReduceTask.access$400().warn((Object)StringUtils.stringifyException(e));
                                ReduceCopier.access$1000(ReduceCopier.this).failedFetch();
                                size = -1L;
                            }
                            finally {
                                ReduceCopier.access$1000(ReduceCopier.this).threadFree();
                                this.finish(size);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    catch (Throwable th) {
                        ReduceTask.access$400().error((Object)("Map output copy failure: " + StringUtils.stringifyException(th)));
                        continue;
                    }
                    ** GOTO lbl-1000
                    break;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private long copyOutput(MapOutputLocation loc) throws IOException, InterruptedException {
                if (ReduceCopier.this.copiedMapOutputs.contains(loc.getTaskId()) || ReduceCopier.this.obsoleteMapIds.contains(loc.getTaskAttemptId())) {
                    return -2L;
                }
                TaskAttemptID reduceId = ReduceCopier.this.reduceTask.getTaskID();
                Path filename = new Path("/" + TaskTracker.getJobCacheSubdir() + "/" + ReduceTask.this.getTaskID().getJobID() + "/" + reduceId + "/" + "output" + "/map_" + loc.getTaskId().getId() + ".out");
                Path tmpMapOutput = new Path(filename + "-" + this.id);
                MapOutput mapOutput = this.getMapOutput(loc, tmpMapOutput);
                if (mapOutput == null) {
                    throw new IOException("Failed to fetch map-output for " + loc.getTaskAttemptId() + " from " + loc.getHost());
                }
                long bytes = mapOutput.size;
                ReduceTask reduceTask = ReduceTask.this;
                synchronized (reduceTask) {
                    if (ReduceCopier.this.copiedMapOutputs.contains(loc.getTaskId())) {
                        mapOutput.discard();
                        return -2L;
                    }
                    if (bytes == 0L) {
                        try {
                            mapOutput.discard();
                        }
                        catch (IOException ioe) {
                            LOG.info((Object)("Couldn't discard output of " + loc.getTaskId()));
                        }
                        ReduceCopier.this.copiedMapOutputs.add(loc.getTaskId());
                        return bytes;
                    }
                    if (mapOutput.inMemory) {
                        ReduceCopier.this.mapOutputsFilesInMemory.add(mapOutput);
                    } else {
                        tmpMapOutput = mapOutput.file;
                        filename = new Path(tmpMapOutput.getParent(), filename.getName());
                        if (!ReduceCopier.this.localFileSys.rename(tmpMapOutput, filename)) {
                            ReduceCopier.this.localFileSys.delete(tmpMapOutput, true);
                            bytes = -1L;
                            throw new IOException("Failed to rename map output " + tmpMapOutput + " to " + filename);
                        }
                        SortedSet sortedSet = ReduceTask.this.mapOutputFilesOnDisk;
                        synchronized (sortedSet) {
                            ReduceCopier.this.addToMapOutputFilesOnDisk(ReduceCopier.this.localFileSys.getFileStatus(filename));
                        }
                    }
                    ReduceCopier.this.copiedMapOutputs.add(loc.getTaskId());
                }
                return bytes;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private MapOutput getMapOutput(MapOutputLocation mapOutputLoc, Path localFilename) throws IOException, InterruptedException {
                boolean good = false;
                DataOutputStream output = null;
                MapOutput mapOutput = null;
                try {
                    URLConnection connection = mapOutputLoc.getOutputLocation().openConnection();
                    InputStream input = this.getInputStream(connection, 180000, 180000);
                    long decompressedLength = Long.parseLong(connection.getHeaderField("Raw-Map-Output-Length"));
                    long compressedLength = Long.parseLong(connection.getHeaderField("Map-Output-Length"));
                    boolean canFitInMemory = ReduceCopier.this.ramManager.canFitInMemory(decompressedLength);
                    if (canFitInMemory) {
                        int requestedSize = (int)decompressedLength;
                        boolean createdNow = ReduceCopier.this.ramManager.reserve(requestedSize, input);
                        LOG.info((Object)("Shuffling " + requestedSize + " bytes (" + compressedLength + " raw bytes) " + "into RAM-FS from " + mapOutputLoc.getTaskAttemptId()));
                        if (!createdNow) {
                            try {
                                connection = mapOutputLoc.getOutputLocation().openConnection();
                                input = this.getInputStream(connection, 180000, 180000);
                            }
                            catch (Throwable t) {
                                ReduceCopier.this.ramManager.closeInMemoryFile(requestedSize);
                                ReduceCopier.this.ramManager.unreserve(requestedSize);
                                IOException ioe = new IOException("Failed to re-open connection to " + mapOutputLoc.getHost());
                                ioe.initCause(t);
                                throw ioe;
                            }
                        }
                        if (this.codec != null) {
                            this.decompressor.reset();
                            input = this.codec.createInputStream(input, this.decompressor);
                        }
                        output = new DataOutputBuffer((int)decompressedLength);
                    } else {
                        localFilename = ReduceTask.this.lDirAlloc.getLocalPathForWrite(localFilename.toUri().getPath(), decompressedLength, ReduceTask.this.conf);
                        LOG.info((Object)("Shuffling " + decompressedLength + " bytes (" + compressedLength + " raw bytes) " + "into Local-FS from " + mapOutputLoc.getTaskAttemptId()));
                        output = ReduceCopier.this.localFileSys.create(localFilename);
                    }
                    long bytesRead = 0L;
                    try {
                        try {
                            byte[] buf = new byte[65536];
                            int n = input.read(buf, 0, buf.length);
                            while (n > 0) {
                                bytesRead += (long)n;
                                ReduceCopier.this.shuffleClientMetrics.inputBytes(n);
                                ((OutputStream)output).write(buf, 0, n);
                                this.reporter.progress();
                                n = input.read(buf, 0, buf.length);
                            }
                            LOG.info((Object)("Read " + bytesRead + " bytes from map-output " + "for " + mapOutputLoc.getTaskAttemptId()));
                            if (canFitInMemory) {
                                byte[] shuffleData = ((DataOutputBuffer)output).getData();
                                mapOutput = new MapOutput(mapOutputLoc.getTaskId(), ((DataOutputBuffer)output).getData());
                                ReduceCopier.this.ramManager.closeInMemoryFile(shuffleData.length);
                            } else {
                                mapOutput = new MapOutput(mapOutputLoc.getTaskId(), ReduceTask.this.conf, ReduceCopier.this.localFileSys.makeQualified(localFilename), compressedLength);
                            }
                        }
                        finally {
                            ((OutputStream)output).close();
                        }
                    }
                    finally {
                        input.close();
                    }
                    boolean bl = canFitInMemory ? bytesRead == decompressedLength : (good = bytesRead == compressedLength);
                    if (!good) {
                        throw new IOException("Incomplete map output received for " + mapOutputLoc.getTaskAttemptId() + " from " + mapOutputLoc.getOutputLocation() + " (" + bytesRead + " instead of " + decompressedLength + ")");
                    }
                }
                finally {
                    if (!good) {
                        try {
                            if (mapOutput != null) {
                                mapOutput.discard();
                            }
                        }
                        catch (Throwable th) {}
                    }
                }
                return mapOutput;
            }

            private InputStream getInputStream(URLConnection connection, int connectionTimeout, int readTimeout) throws IOException {
                int unit = 0;
                if (connectionTimeout < 0) {
                    throw new IOException("Invalid timeout [timeout = " + connectionTimeout + " ms]");
                }
                if (connectionTimeout > 0) {
                    unit = 30000 > connectionTimeout ? connectionTimeout : 30000;
                }
                connection.setReadTimeout(readTimeout);
                connection.setConnectTimeout(unit);
                while (true) {
                    try {
                        return connection.getInputStream();
                    }
                    catch (IOException ioe) {
                        if ((connectionTimeout -= unit) == 0) {
                            throw ioe;
                        }
                        if (connectionTimeout >= unit) continue;
                        unit = connectionTimeout;
                        connection.setConnectTimeout(unit);
                        continue;
                    }
                    break;
                }
            }
        }

        class ShuffleRamManager
        implements RamManager {
            private static final float MAX_SINGLE_SHUFFLE_SEGMENT_PERCENT = 0.25f;
            private boolean closed = false;
            private volatile int numClosed = 0;
            private volatile int size = 0;
            private final int maxSize;
            private final int maxSingleShuffleLimit;
            private Object dataAvailable = new Object();
            private volatile int fullSize = 0;

            public ShuffleRamManager(Configuration conf) {
                this.maxSize = conf.getInt("fs.inmemory.size.mb", 100) * 1024 * 1024;
                this.maxSingleShuffleLimit = (int)((float)this.maxSize * 0.25f);
                LOG.info((Object)("ShuffleRamManager: MemoryLimit=" + this.maxSize + ", MaxSingleShuffleLimit=" + this.maxSingleShuffleLimit));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized boolean reserve(int requestedSize, InputStream in) {
                while (this.size + requestedSize > this.maxSize) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException ie) {
                                LOG.info((Object)("Failed to close connection with: " + ie));
                            }
                            finally {
                                in = null;
                            }
                        }
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.size += requestedSize;
                return in != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized void unreserve(int requestedSize) {
                this.size -= requestedSize;
                Object object = this.dataAvailable;
                synchronized (object) {
                    this.fullSize -= requestedSize;
                    --this.numClosed;
                }
                this.notifyAll();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void waitForDataToMerge() {
                Object object = this.dataAvailable;
                synchronized (object) {
                    while (!(this.closed || !(this.getPercentUsed() < 0.66f) && this.getReservedFiles() >= 2 || ReduceCopier.this.mergeThreshold > 0 && this.getReservedFiles() >= ReduceCopier.this.mergeThreshold)) {
                        try {
                            this.dataAvailable.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void closeInMemoryFile(int requestedSize) {
                Object object = this.dataAvailable;
                synchronized (object) {
                    this.fullSize += requestedSize;
                    ++this.numClosed;
                    this.dataAvailable.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() {
                Object object = this.dataAvailable;
                synchronized (object) {
                    this.closed = true;
                    LOG.info((Object)"Closed ram manager");
                    this.dataAvailable.notify();
                }
            }

            float getPercentUsed() {
                return (float)this.fullSize / (float)this.maxSize;
            }

            int getReservedFiles() {
                return this.numClosed;
            }

            int getMemoryLimit() {
                return this.maxSize;
            }

            boolean canFitInMemory(long requestedSize) {
                return requestedSize < Integer.MAX_VALUE && requestedSize < (long)this.maxSingleShuffleLimit;
            }
        }

        private class MapOutput {
            final TaskID mapId;
            final Path file;
            final Configuration conf;
            byte[] data;
            final boolean inMemory;
            long size;

            public MapOutput(TaskID mapId, Configuration conf, Path file, long size) {
                this.mapId = mapId;
                this.conf = conf;
                this.file = file;
                this.size = size;
                this.data = null;
                this.inMemory = false;
            }

            public MapOutput(TaskID mapId, byte[] data) {
                this.mapId = mapId;
                this.file = null;
                this.conf = null;
                this.data = data;
                this.size = data.length;
                this.inMemory = true;
            }

            public void discard() throws IOException {
                if (this.inMemory) {
                    this.data = null;
                } else {
                    FileSystem fs = this.file.getFileSystem(this.conf);
                    fs.delete(this.file, true);
                }
            }
        }

        private class MapOutputLocation {
            TaskAttemptID taskAttemptId;
            TaskID taskId;
            String ttHost;
            URL taskOutput;

            public MapOutputLocation(TaskAttemptID taskAttemptId, String ttHost, URL taskOutput) {
                this.taskAttemptId = taskAttemptId;
                this.taskId = this.taskAttemptId.getTaskID();
                this.ttHost = ttHost;
                this.taskOutput = taskOutput;
            }

            public TaskAttemptID getTaskAttemptId() {
                return this.taskAttemptId;
            }

            public TaskID getTaskId() {
                return this.taskId;
            }

            public String getHost() {
                return this.ttHost;
            }

            public URL getOutputLocation() {
                return this.taskOutput;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class CopyResult {
            private final MapOutputLocation loc;
            private final long size;
            private static final int OBSOLETE = -2;

            CopyResult(MapOutputLocation loc, long size) {
                this.loc = loc;
                this.size = size;
            }

            public boolean getSuccess() {
                return this.size >= 0L;
            }

            public boolean isObsolete() {
                return this.size == -2L;
            }

            public long getSize() {
                return this.size;
            }

            public String getHost() {
                return this.loc.getHost();
            }

            public MapOutputLocation getLocation() {
                return this.loc;
            }
        }

        class ShuffleClientMetrics
        implements Updater {
            private MetricsRecord shuffleMetrics = null;
            private int numFailedFetches = 0;
            private int numSuccessFetches = 0;
            private long numBytes = 0L;
            private int numThreadsBusy = 0;

            ShuffleClientMetrics(JobConf conf) {
                MetricsContext metricsContext = MetricsUtil.getContext("mapred");
                this.shuffleMetrics = MetricsUtil.createRecord(metricsContext, "shuffleInput");
                this.shuffleMetrics.setTag("user", conf.getUser());
                this.shuffleMetrics.setTag("jobName", conf.getJobName());
                this.shuffleMetrics.setTag("jobId", ReduceTask.this.getJobID().toString());
                this.shuffleMetrics.setTag("taskId", ReduceTask.this.getTaskID().toString());
                this.shuffleMetrics.setTag("sessionId", conf.getSessionId());
                metricsContext.registerUpdater(this);
            }

            public synchronized void inputBytes(long numBytes) {
                this.numBytes += numBytes;
            }

            public synchronized void failedFetch() {
                ++this.numFailedFetches;
            }

            public synchronized void successFetch() {
                ++this.numSuccessFetches;
            }

            public synchronized void threadBusy() {
                ++this.numThreadsBusy;
            }

            public synchronized void threadFree() {
                --this.numThreadsBusy;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doUpdates(MetricsContext unused) {
                ShuffleClientMetrics shuffleClientMetrics = this;
                synchronized (shuffleClientMetrics) {
                    this.shuffleMetrics.incrMetric("shuffle_input_bytes", this.numBytes);
                    this.shuffleMetrics.incrMetric("shuffle_failed_fetches", this.numFailedFetches);
                    this.shuffleMetrics.incrMetric("shuffle_success_fetches", this.numSuccessFetches);
                    if (ReduceCopier.this.numCopiers != 0) {
                        this.shuffleMetrics.setMetric("shuffle_fetchers_busy_percent", 100.0f * ((float)this.numThreadsBusy / (float)ReduceCopier.this.numCopiers));
                    } else {
                        this.shuffleMetrics.setMetric("shuffle_fetchers_busy_percent", 0);
                    }
                    this.numBytes = 0L;
                    this.numSuccessFetches = 0;
                    this.numFailedFetches = 0;
                }
                this.shuffleMetrics.update();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReduceValuesIterator<KEY, VALUE>
    extends Task.ValuesIterator<KEY, VALUE> {
        public ReduceValuesIterator(RawKeyValueIterator in, RawComparator<KEY> comparator, Class<KEY> keyClass, Class<VALUE> valClass, Configuration conf, Progressable reporter) throws IOException {
            super(in, comparator, keyClass, valClass, conf, reporter);
        }

        @Override
        public VALUE next() {
            ReduceTask.this.reduceInputValueCounter.increment(1L);
            return super.next();
        }

        public void informReduceProgress() {
            ReduceTask.this.reducePhase.set(this.in.getProgress().get());
            this.reporter.progress();
        }
    }
}

