/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceFileAsBinaryOutputFormat
extends SequenceFileOutputFormat<BytesWritable, BytesWritable> {
    public static void setSequenceFileOutputKeyClass(JobConf conf, Class<?> theClass) {
        conf.setClass("mapred.seqbinary.output.key.class", theClass, Object.class);
    }

    public static void setSequenceFileOutputValueClass(JobConf conf, Class<?> theClass) {
        conf.setClass("mapred.seqbinary.output.value.class", theClass, Object.class);
    }

    public static Class<?> getSequenceFileOutputKeyClass(JobConf conf) {
        return conf.getClass("mapred.seqbinary.output.key.class", conf.getOutputKeyClass(), Object.class);
    }

    public static Class<?> getSequenceFileOutputValueClass(JobConf conf) {
        return conf.getClass("mapred.seqbinary.output.value.class", conf.getOutputValueClass(), Object.class);
    }

    @Override
    public RecordWriter<BytesWritable, BytesWritable> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        Path outputPath = SequenceFileAsBinaryOutputFormat.getWorkOutputPath(job);
        FileSystem fs = outputPath.getFileSystem(job);
        if (!fs.exists(outputPath)) {
            throw new IOException("Output directory doesnt exist");
        }
        Path file = new Path(outputPath, name);
        CompressionCodec codec = null;
        SequenceFile.CompressionType compressionType = SequenceFile.CompressionType.NONE;
        if (SequenceFileAsBinaryOutputFormat.getCompressOutput(job)) {
            compressionType = SequenceFileAsBinaryOutputFormat.getOutputCompressionType(job);
            Class<CompressionCodec> codecClass = SequenceFileAsBinaryOutputFormat.getOutputCompressorClass(job, DefaultCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, job);
        }
        final SequenceFile.Writer out = SequenceFile.createWriter(fs, job, file, SequenceFileAsBinaryOutputFormat.getSequenceFileOutputKeyClass(job), SequenceFileAsBinaryOutputFormat.getSequenceFileOutputValueClass(job), compressionType, codec, progress);
        return new RecordWriter<BytesWritable, BytesWritable>(){
            private WritableValueBytes wvaluebytes = new WritableValueBytes();

            @Override
            public void write(BytesWritable bkey, BytesWritable bvalue) throws IOException {
                this.wvaluebytes.reset(bvalue);
                out.appendRaw(bkey.get(), 0, bkey.getSize(), this.wvaluebytes);
                this.wvaluebytes.reset(null);
            }

            @Override
            public void close(Reporter reporter) throws IOException {
                out.close();
            }
        };
    }

    @Override
    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        super.checkOutputSpecs(ignored, job);
        if (SequenceFileAsBinaryOutputFormat.getCompressOutput(job) && SequenceFileAsBinaryOutputFormat.getOutputCompressionType(job) == SequenceFile.CompressionType.RECORD) {
            throw new InvalidJobConfException("SequenceFileAsBinaryOutputFormat doesn't support Record Compression");
        }
    }

    protected static class WritableValueBytes
    implements SequenceFile.ValueBytes {
        private BytesWritable value;

        public WritableValueBytes() {
            this.value = null;
        }

        public WritableValueBytes(BytesWritable value) {
            this.value = value;
        }

        public void reset(BytesWritable value) {
            this.value = value;
        }

        public void writeUncompressedBytes(DataOutputStream outStream) throws IOException {
            outStream.write(this.value.get(), 0, this.value.getSize());
        }

        public void writeCompressedBytes(DataOutputStream outStream) throws IllegalArgumentException, IOException {
            throw new UnsupportedOperationException("WritableValueBytes doesn't support RECORD compression");
        }

        public int getSize() {
            return this.value.getSize();
        }
    }
}

