/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.dfs.DistributedFileSystem;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.kfs.KosmosFileSystem;
import org.apache.hadoop.fs.s3.S3FileSystem;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.IFile;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.Progress;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

abstract class Task
implements Writable,
Configurable {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.TaskRunner");
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    private String jobFile;
    private TaskAttemptID taskId;
    private int partition;
    TaskStatus taskStatus;
    private Path taskOutputPath;
    protected JobConf conf;
    protected MapOutputFile mapOutputFile = new MapOutputFile();
    protected LocalDirAllocator lDirAlloc;
    public static final int PROGRESS_INTERVAL = 3000;
    private transient Progress taskProgress = new Progress();
    private transient Counters counters = new Counters();
    private AtomicBoolean progressFlag = new AtomicBoolean(false);
    private AtomicBoolean taskDone = new AtomicBoolean(false);
    private List<FileSystemStatisticUpdater> statisticUpdaters = new ArrayList<FileSystemStatisticUpdater>();

    static synchronized String getOutputName(int partition) {
        return "part-" + NUMBER_FORMAT.format(partition);
    }

    public Task() {
        this.statisticUpdaters.add(new FileSystemStatisticUpdater(FileSystemCounter.LOCAL_READ, FileSystemCounter.LOCAL_WRITE, RawLocalFileSystem.class));
        this.statisticUpdaters.add(new FileSystemStatisticUpdater(FileSystemCounter.HDFS_READ, FileSystemCounter.HDFS_WRITE, DistributedFileSystem.class));
        this.statisticUpdaters.add(new FileSystemStatisticUpdater(FileSystemCounter.KFS_READ, FileSystemCounter.KFSWRITE, KosmosFileSystem.class));
        this.statisticUpdaters.add(new FileSystemStatisticUpdater(FileSystemCounter.S3_READ, FileSystemCounter.S3_WRITE, S3FileSystem.class));
        this.taskStatus = TaskStatus.createTaskStatus(this.isMapTask());
    }

    public Task(String jobFile, TaskAttemptID taskId, int partition) {
        this.statisticUpdaters.add(new FileSystemStatisticUpdater(FileSystemCounter.LOCAL_READ, FileSystemCounter.LOCAL_WRITE, RawLocalFileSystem.class));
        this.statisticUpdaters.add(new FileSystemStatisticUpdater(FileSystemCounter.HDFS_READ, FileSystemCounter.HDFS_WRITE, DistributedFileSystem.class));
        this.statisticUpdaters.add(new FileSystemStatisticUpdater(FileSystemCounter.KFS_READ, FileSystemCounter.KFSWRITE, KosmosFileSystem.class));
        this.statisticUpdaters.add(new FileSystemStatisticUpdater(FileSystemCounter.S3_READ, FileSystemCounter.S3_WRITE, S3FileSystem.class));
        this.jobFile = jobFile;
        this.taskId = taskId;
        this.partition = partition;
        this.taskStatus = TaskStatus.createTaskStatus(this.isMapTask(), this.taskId, 0.0f, TaskStatus.State.UNASSIGNED, "", "", "", this.isMapTask() ? TaskStatus.Phase.MAP : TaskStatus.Phase.SHUFFLE, this.counters);
        this.mapOutputFile.setJobId(taskId.getJobID());
    }

    public void setJobFile(String jobFile) {
        this.jobFile = jobFile;
    }

    public String getJobFile() {
        return this.jobFile;
    }

    public TaskAttemptID getTaskID() {
        return this.taskId;
    }

    public Counters getCounters() {
        return this.counters;
    }

    public JobID getJobID() {
        return this.taskId.getJobID();
    }

    public int getPartition() {
        return this.partition;
    }

    public synchronized TaskStatus.Phase getPhase() {
        return this.taskStatus.getPhase();
    }

    protected synchronized void setPhase(TaskStatus.Phase phase) {
        this.taskStatus.setPhase(phase);
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString(out, this.jobFile);
        this.taskId.write(out);
        out.writeInt(this.partition);
        if (this.taskOutputPath != null) {
            Text.writeString(out, this.taskOutputPath.toString());
        } else {
            Text.writeString(out, "");
        }
        this.taskStatus.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.jobFile = Text.readString(in);
        this.taskId = TaskAttemptID.read(in);
        this.partition = in.readInt();
        String outPath = Text.readString(in);
        this.taskOutputPath = outPath.length() != 0 ? new Path(outPath) : null;
        this.taskStatus.readFields(in);
        this.mapOutputFile.setJobId(this.taskId.getJobID());
    }

    public String toString() {
        return this.taskId.toString();
    }

    private Path getTaskOutputPath(JobConf conf) {
        Path p = new Path(FileOutputFormat.getOutputPath(conf), "_temporary/_" + this.taskId);
        try {
            FileSystem fs = p.getFileSystem(conf);
            return p.makeQualified(fs);
        }
        catch (IOException ie) {
            LOG.warn((Object)StringUtils.stringifyException(ie));
            return p;
        }
    }

    public void localizeConfiguration(JobConf conf) throws IOException {
        conf.set("mapred.tip.id", this.taskId.getTaskID().toString());
        conf.set("mapred.task.id", this.taskId.toString());
        conf.setBoolean("mapred.task.is.map", this.isMapTask());
        conf.setInt("mapred.task.partition", this.partition);
        conf.set("mapred.job.id", this.taskId.getJobID().toString());
        if (FileOutputFormat.getOutputPath(conf) != null) {
            this.taskOutputPath = this.getTaskOutputPath(conf);
            FileOutputFormat.setWorkOutputPath(conf, this.taskOutputPath);
        }
    }

    public abstract void run(JobConf var1, TaskUmbilicalProtocol var2) throws IOException;

    public abstract TaskRunner createRunner(TaskTracker var1) throws IOException;

    private void setProgressFlag() {
        this.progressFlag.set(true);
    }

    private boolean resetProgressFlag() {
        return this.progressFlag.getAndSet(false);
    }

    public abstract boolean isMapTask();

    public Progress getProgress() {
        return this.taskProgress;
    }

    InputSplit getInputSplit() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Input only available on map");
    }

    protected void startCommunicationThread(final TaskUmbilicalProtocol umbilical) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                int MAX_RETRIES = 3;
                int remainingRetries = 3;
                boolean sendProgress = Task.this.resetProgressFlag();
                while (!Task.this.taskDone.get()) {
                    try {
                        boolean taskFound = true;
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException e) {
                            LOG.debug((Object)(Task.this.getTaskID() + " Progress/ping thread exiting " + "since it got interrupted"));
                            break;
                        }
                        if (sendProgress) {
                            Task.this.updateCounters();
                            Task.this.taskStatus.statusUpdate(Task.this.taskProgress.get(), Task.this.taskProgress.toString(), Task.this.counters);
                            taskFound = umbilical.statusUpdate(Task.this.taskId, Task.this.taskStatus);
                            Task.this.taskStatus.clearStatus();
                        } else {
                            taskFound = umbilical.ping(Task.this.taskId);
                        }
                        if (!taskFound) {
                            LOG.warn((Object)("Parent died.  Exiting " + Task.this.taskId));
                            System.exit(66);
                        }
                        sendProgress = Task.this.resetProgressFlag();
                        remainingRetries = 3;
                    }
                    catch (Throwable t) {
                        LOG.info((Object)("Communication exception: " + StringUtils.stringifyException(t)));
                        if (--remainingRetries != 0) continue;
                        ReflectionUtils.logThreadInfo(LOG, "Communication exception", 0L);
                        LOG.warn((Object)("Last retry, killing " + Task.this.taskId));
                        System.exit(65);
                    }
                }
            }
        }, "Comm thread for " + this.taskId);
        thread.setDaemon(true);
        thread.start();
        LOG.debug((Object)(this.getTaskID() + " Progress/ping thread started"));
    }

    protected Reporter getReporter(TaskUmbilicalProtocol umbilical) throws IOException {
        return new Reporter(){

            public void setStatus(String status) {
                Task.this.taskProgress.setStatus(status);
                Task.this.setProgressFlag();
            }

            public void progress() {
                Task.this.setProgressFlag();
            }

            public void incrCounter(Enum key, long amount) {
                if (Task.this.counters != null) {
                    Task.this.counters.incrCounter(key, amount);
                }
                Task.this.setProgressFlag();
            }

            public void incrCounter(String group, String counter, long amount) {
                if (Task.this.counters != null) {
                    Task.this.counters.incrCounter(group, counter, amount);
                }
                Task.this.setProgressFlag();
            }

            public InputSplit getInputSplit() throws UnsupportedOperationException {
                return Task.this.getInputSplit();
            }
        };
    }

    public void setProgress(float progress) {
        this.taskProgress.set(progress);
        this.setProgressFlag();
    }

    private synchronized void updateCounters() {
        for (FileSystemStatisticUpdater updater : this.statisticUpdaters) {
            updater.updateCounters();
        }
    }

    public void done(TaskUmbilicalProtocol umbilical) throws IOException {
        int retries = 10;
        boolean needProgress = true;
        this.updateCounters();
        this.taskDone.set(true);
        while (true) {
            try {
                if (needProgress) {
                    this.taskStatus.statusUpdate(this.taskProgress.get(), this.taskProgress.toString(), this.counters);
                    try {
                        if (!umbilical.statusUpdate(this.getTaskID(), this.taskStatus)) {
                            LOG.warn((Object)("Parent died.  Exiting " + this.taskId));
                            System.exit(66);
                        }
                        this.taskStatus.clearStatus();
                        needProgress = false;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
                boolean shouldBePromoted = false;
                try {
                    ContentSummary summary;
                    FileSystem fs;
                    if (this.taskOutputPath != null && (fs = this.taskOutputPath.getFileSystem(this.conf)).exists(this.taskOutputPath) && (summary = fs.getContentSummary(this.taskOutputPath)) != null && summary.getFileCount() + summary.getDirectoryCount() - 1L > 0L) {
                        shouldBePromoted = true;
                    }
                }
                catch (IOException ioe) {
                    shouldBePromoted = true;
                }
                umbilical.done(this.taskId, shouldBePromoted);
                LOG.info((Object)("Task '" + this.getTaskID() + "' done."));
                return;
            }
            catch (IOException ie) {
                LOG.warn((Object)("Failure signalling completion: " + StringUtils.stringifyException(ie)));
                if (--retries != 0) continue;
                throw ie;
            }
            break;
        }
    }

    public void setConf(Configuration conf) {
        if (conf instanceof JobConf) {
            this.conf = (JobConf)conf;
            if (this.taskId != null && this.taskOutputPath == null && FileOutputFormat.getOutputPath(this.conf) != null) {
                this.taskOutputPath = this.getTaskOutputPath(this.conf);
            }
        } else {
            this.conf = new JobConf(conf);
        }
        this.mapOutputFile.setConf(this.conf);
        this.lDirAlloc = new LocalDirAllocator("mapred.local.dir");
        String[] hostToResolved = conf.getStrings("hadoop.net.static.resolutions");
        if (hostToResolved != null) {
            for (String str : hostToResolved) {
                String name = str.substring(0, str.indexOf(61));
                String resolvedName = str.substring(str.indexOf(61) + 1);
                NetUtils.addStaticResolution(name, resolvedName);
            }
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    void saveTaskOutput() throws IOException {
        FileSystem fs;
        if (this.taskOutputPath != null && (fs = this.taskOutputPath.getFileSystem(this.conf)).exists(this.taskOutputPath)) {
            Path jobOutputPath = this.taskOutputPath.getParent().getParent();
            this.moveTaskOutputs(fs, jobOutputPath, this.taskOutputPath);
            if (!fs.delete(this.taskOutputPath, true)) {
                LOG.info((Object)("Failed to delete the temporary output directory of task: " + this.getTaskID() + " - " + this.taskOutputPath));
            }
            LOG.info((Object)("Saved output of task '" + this.getTaskID() + "' to " + jobOutputPath));
        }
    }

    private Path getFinalPath(Path jobOutputDir, Path taskOutput) {
        URI relativePath = this.taskOutputPath.toUri().relativize(taskOutput.toUri());
        if (relativePath.getPath().length() > 0) {
            return new Path(jobOutputDir, relativePath.getPath());
        }
        return jobOutputDir;
    }

    private void moveTaskOutputs(FileSystem fs, Path jobOutputDir, Path taskOutput) throws IOException {
        if (fs.isFile(taskOutput)) {
            Path finalOutputPath = this.getFinalPath(jobOutputDir, taskOutput);
            if (!fs.rename(taskOutput, finalOutputPath)) {
                if (!fs.delete(finalOutputPath, true)) {
                    throw new IOException("Failed to delete earlier output of task: " + this.getTaskID());
                }
                if (!fs.rename(taskOutput, finalOutputPath)) {
                    throw new IOException("Failed to save output of task: " + this.getTaskID());
                }
            }
            LOG.debug((Object)("Moved " + taskOutput + " to " + finalOutputPath));
        } else if (fs.isDirectory(taskOutput)) {
            FileStatus[] paths = fs.listStatus(taskOutput);
            Path finalOutputPath = this.getFinalPath(jobOutputDir, taskOutput);
            fs.mkdirs(finalOutputPath);
            if (paths != null) {
                for (FileStatus path : paths) {
                    this.moveTaskOutputs(fs, jobOutputDir, path.getPath());
                }
            }
        }
    }

    static {
        NUMBER_FORMAT.setMinimumIntegerDigits(5);
        NUMBER_FORMAT.setGroupingUsed(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CombineValuesIterator<KEY, VALUE>
    extends ValuesIterator<KEY, VALUE> {
        private final Counters.Counter combineInputCounter;

        public CombineValuesIterator(RawKeyValueIterator in, RawComparator<KEY> comparator, Class<KEY> keyClass, Class<VALUE> valClass, Configuration conf, Reporter reporter, Counters.Counter combineInputCounter) throws IOException {
            super(in, comparator, keyClass, valClass, conf, reporter);
            this.combineInputCounter = combineInputCounter;
        }

        @Override
        public VALUE next() {
            this.combineInputCounter.increment(1L);
            return super.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ValuesIterator<KEY, VALUE>
    implements Iterator<VALUE> {
        protected RawKeyValueIterator in;
        private KEY key;
        private KEY nextKey;
        private VALUE value;
        private boolean hasNext;
        private boolean more;
        private RawComparator<KEY> comparator;
        protected Progressable reporter;
        private Deserializer<KEY> keyDeserializer;
        private Deserializer<VALUE> valDeserializer;
        private DataInputBuffer keyIn = new DataInputBuffer();
        private DataInputBuffer valueIn = new DataInputBuffer();
        private int ctr = 0;

        public ValuesIterator(RawKeyValueIterator in, RawComparator<KEY> comparator, Class<KEY> keyClass, Class<VALUE> valClass, Configuration conf, Progressable reporter) throws IOException {
            this.in = in;
            this.comparator = comparator;
            this.reporter = reporter;
            SerializationFactory serializationFactory = new SerializationFactory(conf);
            this.keyDeserializer = serializationFactory.getDeserializer(keyClass);
            this.keyDeserializer.open(this.keyIn);
            this.valDeserializer = serializationFactory.getDeserializer(valClass);
            this.valDeserializer.open(this.valueIn);
            this.readNextKey();
            this.key = this.nextKey;
            this.nextKey = null;
            this.hasNext = this.more;
        }

        RawKeyValueIterator getRawIterator() {
            return this.in;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public VALUE next() {
            if (!this.hasNext) {
                throw new NoSuchElementException("iterate past last value");
            }
            try {
                this.readNextValue();
                this.readNextKey();
            }
            catch (IOException ie) {
                throw new RuntimeException("problem advancing post rec#" + this.ctr, ie);
            }
            this.reporter.progress();
            return this.value;
        }

        @Override
        public void remove() {
            throw new RuntimeException("not implemented");
        }

        void nextKey() throws IOException {
            while (this.hasNext) {
                this.readNextKey();
            }
            ++this.ctr;
            KEY tmpKey = this.key;
            this.key = this.nextKey;
            this.nextKey = tmpKey;
            this.hasNext = this.more;
        }

        boolean more() {
            return this.more;
        }

        KEY getKey() {
            return this.key;
        }

        private void readNextKey() throws IOException {
            this.more = this.in.next();
            if (this.more) {
                DataInputBuffer nextKeyBytes = this.in.getKey();
                this.keyIn.reset(nextKeyBytes.getData(), nextKeyBytes.getPosition(), nextKeyBytes.getLength());
                this.nextKey = this.keyDeserializer.deserialize(this.nextKey);
                this.hasNext = this.key != null && this.comparator.compare(this.key, this.nextKey) == 0;
            } else {
                this.hasNext = false;
            }
        }

        private void readNextValue() throws IOException {
            DataInputBuffer nextValueBytes = this.in.getValue();
            this.valueIn.reset(nextValueBytes.getData(), nextValueBytes.getPosition(), nextValueBytes.getLength());
            this.value = this.valDeserializer.deserialize(this.value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CombineOutputCollector<K, V>
    implements OutputCollector<K, V> {
        private IFile.Writer<K, V> writer;
        private Counters.Counter outCounter;

        public CombineOutputCollector(Counters.Counter outCounter) {
            this.outCounter = outCounter;
        }

        public synchronized void setWriter(IFile.Writer<K, V> writer) {
            this.writer = writer;
        }

        @Override
        public synchronized void collect(K key, V value) throws IOException {
            this.outCounter.increment(1L);
            this.writer.append(key, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FileSystemStatisticUpdater {
        private long prevReadBytes = 0L;
        private long prevWriteBytes = 0L;
        private FileSystem.Statistics stats;
        private Counters.Counter readCounter = null;
        private Counters.Counter writeCounter = null;
        private FileSystemCounter read;
        private FileSystemCounter write;

        FileSystemStatisticUpdater(FileSystemCounter read, FileSystemCounter write, Class<? extends FileSystem> cls) {
            this.stats = FileSystem.getStatistics(cls);
            this.read = read;
            this.write = write;
        }

        void updateCounters() {
            long newReadBytes = this.stats.getBytesRead();
            long newWriteBytes = this.stats.getBytesWritten();
            if (this.prevReadBytes != newReadBytes) {
                if (this.readCounter == null) {
                    this.readCounter = Task.this.counters.findCounter(this.read);
                }
                this.readCounter.increment(newReadBytes - this.prevReadBytes);
                this.prevReadBytes = newReadBytes;
            }
            if (this.prevWriteBytes != newWriteBytes) {
                if (this.writeCounter == null) {
                    this.writeCounter = Task.this.counters.findCounter(this.write);
                }
                this.writeCounter.increment(newWriteBytes - this.prevWriteBytes);
                this.prevWriteBytes = newWriteBytes;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum FileSystemCounter {
        LOCAL_READ,
        LOCAL_WRITE,
        HDFS_READ,
        HDFS_WRITE,
        S3_READ,
        S3_WRITE,
        KFS_READ,
        KFSWRITE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Counter {
        MAP_INPUT_RECORDS,
        MAP_OUTPUT_RECORDS,
        MAP_INPUT_BYTES,
        MAP_OUTPUT_BYTES,
        COMBINE_INPUT_RECORDS,
        COMBINE_OUTPUT_RECORDS,
        REDUCE_INPUT_GROUPS,
        REDUCE_INPUT_RECORDS,
        REDUCE_OUTPUT_RECORDS;

    }
}

