/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.mapred.ID;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.TaskID;

public class TaskAttemptID
extends ID {
    private static final String ATTEMPT = "attempt";
    private TaskID taskId;
    private static final char UNDERSCORE = '_';

    public TaskAttemptID(TaskID taskId, int id) {
        super(id);
        if (taskId == null) {
            throw new IllegalArgumentException("taskId cannot be null");
        }
        this.taskId = taskId;
    }

    public TaskAttemptID(String jtIdentifier, int jobId, boolean isMap, int taskId, int id) {
        this(new TaskID(jtIdentifier, jobId, isMap, taskId), id);
    }

    private TaskAttemptID() {
    }

    public JobID getJobID() {
        return this.taskId.getJobID();
    }

    public TaskID getTaskID() {
        return this.taskId;
    }

    public boolean isMap() {
        return this.taskId.isMap();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass().equals(TaskAttemptID.class)) {
            TaskAttemptID that = (TaskAttemptID)o;
            return this.id == that.id && this.taskId.equals(that.taskId);
        }
        return false;
    }

    public int compareTo(ID o) {
        TaskAttemptID that = (TaskAttemptID)o;
        int tipComp = this.taskId.compareTo(that.taskId);
        if (tipComp == 0) {
            return this.id - that.id;
        }
        return tipComp;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        return builder.append(ATTEMPT).append('_').append((CharSequence)this.toStringWOPrefix()).toString();
    }

    StringBuilder toStringWOPrefix() {
        StringBuilder builder = new StringBuilder();
        return builder.append((CharSequence)this.taskId.toStringWOPrefix()).append('_').append(this.id);
    }

    public int hashCode() {
        return this.toStringWOPrefix().toString().hashCode();
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.taskId = TaskID.read(in);
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.taskId.write(out);
    }

    public static TaskAttemptID read(DataInput in) throws IOException {
        TaskAttemptID taskId = new TaskAttemptID();
        taskId.readFields(in);
        return taskId;
    }

    public static TaskAttemptID forName(String str) throws IllegalArgumentException {
        if (str == null) {
            return null;
        }
        try {
            String[] parts = str.split("_");
            if (parts.length == 6 && parts[0].equals(ATTEMPT)) {
                boolean isMap = false;
                if (parts[3].equals("m")) {
                    isMap = true;
                } else if (parts[3].equals("r")) {
                    isMap = false;
                } else {
                    throw new Exception();
                }
                return new TaskAttemptID(parts[1], Integer.parseInt(parts[2]), isMap, Integer.parseInt(parts[4]), Integer.parseInt(parts[5]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException("TaskAttemptId string : " + str + " is not properly formed");
    }

    public static String getTaskAttemptIDsPattern(String jtIdentifier, Integer jobId, Boolean isMap, Integer taskId, Integer attemptId) {
        StringBuilder builder = new StringBuilder(ATTEMPT).append('_');
        builder.append((CharSequence)TaskAttemptID.getTaskAttemptIDsPatternWOPrefix(jtIdentifier, jobId, isMap, taskId, attemptId));
        return builder.toString();
    }

    static StringBuilder getTaskAttemptIDsPatternWOPrefix(String jtIdentifier, Integer jobId, Boolean isMap, Integer taskId, Integer attemptId) {
        StringBuilder builder = new StringBuilder();
        builder.append((CharSequence)TaskID.getTaskIDsPatternWOPrefix(jtIdentifier, jobId, isMap, taskId)).append('_').append(attemptId != null ? attemptId : "[0-9]*");
        return builder;
    }
}

