/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.NumberFormat;
import org.apache.hadoop.mapred.ID;
import org.apache.hadoop.mapred.JobID;

public class TaskID
extends ID {
    private static final String TASK = "task";
    private static char UNDERSCORE = (char)95;
    private static NumberFormat idFormat = NumberFormat.getInstance();
    private JobID jobId;
    private boolean isMap;

    public TaskID(JobID jobId, boolean isMap, int id) {
        super(id);
        if (jobId == null) {
            throw new IllegalArgumentException("jobId cannot be null");
        }
        this.jobId = jobId;
        this.isMap = isMap;
    }

    public TaskID(String jtIdentifier, int jobId, boolean isMap, int id) {
        this(new JobID(jtIdentifier, jobId), isMap, id);
    }

    private TaskID() {
    }

    public JobID getJobID() {
        return this.jobId;
    }

    public boolean isMap() {
        return this.isMap;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass().equals(TaskID.class)) {
            TaskID that = (TaskID)o;
            return this.id == that.id && this.isMap == that.isMap && this.jobId.equals(that.jobId);
        }
        return false;
    }

    public int compareTo(ID o) {
        TaskID that = (TaskID)o;
        int jobComp = this.jobId.compareTo(that.jobId);
        if (jobComp == 0) {
            if (this.isMap == that.isMap) {
                return this.id - that.id;
            }
            return this.isMap ? -1 : 1;
        }
        return jobComp;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        return builder.append(TASK).append(UNDERSCORE).append((CharSequence)this.toStringWOPrefix()).toString();
    }

    StringBuilder toStringWOPrefix() {
        StringBuilder builder = new StringBuilder();
        builder.append((CharSequence)this.jobId.toStringWOPrefix()).append(this.isMap ? "_m_" : "_r_");
        return builder.append(idFormat.format(this.id));
    }

    public int hashCode() {
        return this.toStringWOPrefix().toString().hashCode();
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.jobId = JobID.read(in);
        this.isMap = in.readBoolean();
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.jobId.write(out);
        out.writeBoolean(this.isMap);
    }

    public static TaskID read(DataInput in) throws IOException {
        TaskID tipId = new TaskID();
        tipId.readFields(in);
        return tipId;
    }

    public static TaskID forName(String str) throws IllegalArgumentException {
        if (str == null) {
            return null;
        }
        try {
            String[] parts = str.split("_");
            if (parts.length == 5 && parts[0].equals(TASK)) {
                boolean isMap = false;
                if (parts[3].equals("m")) {
                    isMap = true;
                } else if (parts[3].equals("r")) {
                    isMap = false;
                } else {
                    throw new Exception();
                }
                return new TaskID(parts[1], Integer.parseInt(parts[2]), isMap, Integer.parseInt(parts[4]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException("TaskId string : " + str + " is not properly formed");
    }

    public static String getTaskIDsPattern(String jtIdentifier, Integer jobId, Boolean isMap, Integer taskId) {
        StringBuilder builder = new StringBuilder(TASK).append(UNDERSCORE).append((CharSequence)TaskID.getTaskIDsPatternWOPrefix(jtIdentifier, jobId, isMap, taskId));
        return builder.toString();
    }

    static StringBuilder getTaskIDsPatternWOPrefix(String jtIdentifier, Integer jobId, Boolean isMap, Integer taskId) {
        StringBuilder builder = new StringBuilder();
        builder.append((CharSequence)JobID.getJobIDsPatternWOPrefix(jtIdentifier, jobId)).append(UNDERSCORE).append(isMap != null ? (isMap.booleanValue() ? "m" : "r") : "(m|r)").append(UNDERSCORE).append(taskId != null ? idFormat.format(taskId) : "[0-9]*");
        return builder;
    }

    static {
        idFormat.setGroupingUsed(false);
        idFormat.setMinimumIntegerDigits(6);
    }
}

