/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.util.StringUtils;

public class TaskLogServlet
extends HttpServlet {
    private static final long serialVersionUID = -6615764817774487321L;

    private boolean haveTaskLog(TaskAttemptID taskId, TaskLog.LogName type) {
        File f = TaskLog.getTaskLogFile(taskId, type);
        return f.canRead();
    }

    private static int findFirstQuotable(byte[] data, int offset, int end) {
        while (offset < end) {
            switch (data[offset]) {
                case 38: 
                case 60: 
                case 62: {
                    return offset;
                }
            }
            ++offset;
        }
        return offset;
    }

    private static void quotedWrite(OutputStream out, byte[] data, int offset, int length) throws IOException {
        int end = offset + length;
        while (offset < end) {
            int next = TaskLogServlet.findFirstQuotable(data, offset, end);
            out.write(data, offset, next - offset);
            offset = next;
            if (offset >= end) continue;
            switch (data[offset]) {
                case 60: {
                    out.write("&lt;".getBytes());
                    break;
                }
                case 62: {
                    out.write("&gt;".getBytes());
                    break;
                }
                case 38: {
                    out.write("&amp;".getBytes());
                    break;
                }
                default: {
                    out.write(data[offset]);
                }
            }
            ++offset;
        }
    }

    private void printTaskLog(HttpServletResponse response, OutputStream out, TaskAttemptID taskId, long start, long end, boolean plainText, TaskLog.LogName filter) throws IOException {
        if (!plainText) {
            out.write(("<br><b><u>" + (Object)((Object)filter) + " logs</u></b><br>\n" + "<pre>\n").getBytes());
        }
        try {
            int result;
            TaskLog.Reader taskLogReader = new TaskLog.Reader(taskId, filter, start, end);
            byte[] b = new byte[65536];
            while ((result = taskLogReader.read(b)) > 0) {
                if (plainText) {
                    out.write(b, 0, result);
                    continue;
                }
                TaskLogServlet.quotedWrite(out, b, 0, result);
            }
            ((InputStream)taskLogReader).close();
            if (!plainText) {
                out.write("</pre></td></tr></table><hr><br>\n".getBytes());
            }
        }
        catch (IOException ioe) {
            if (filter == TaskLog.LogName.DEBUGOUT) {
                if (!plainText) {
                    out.write("</pre><hr><br>\n".getBytes());
                }
            }
            response.sendError(410, "Failed to retrieve " + (Object)((Object)filter) + " log for task: " + taskId);
            out.write(("TaskLogServlet exception:\n" + StringUtils.stringifyException(ioe) + "\n").getBytes());
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String sPlainText;
        String sLogEnd;
        String sLogOff;
        long start = 0L;
        long end = -1L;
        boolean plainText = false;
        TaskLog.LogName filter = null;
        String taskIdStr = request.getParameter("taskid");
        if (taskIdStr == null) {
            response.sendError(400, "Argument taskid is required");
            return;
        }
        TaskAttemptID taskId = TaskAttemptID.forName(taskIdStr);
        String logFilter = request.getParameter("filter");
        if (logFilter != null) {
            try {
                filter = TaskLog.LogName.valueOf(TaskLog.LogName.class, logFilter.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                response.sendError(400, "Illegal value for filter: " + logFilter);
                return;
            }
        }
        if ((sLogOff = request.getParameter("start")) != null) {
            start = Long.valueOf(sLogOff);
        }
        if ((sLogEnd = request.getParameter("end")) != null) {
            end = Long.valueOf(sLogEnd);
        }
        if ((sPlainText = request.getParameter("plaintext")) != null) {
            plainText = Boolean.valueOf(sPlainText);
        }
        ServletOutputStream out = response.getOutputStream();
        if (!plainText) {
            out.write(("<html>\n<title>Task Logs: '" + taskId + "'</title>\n" + "<body>\n" + "<h1>Task Logs: '" + taskId + "'</h1><br>\n").getBytes());
            if (filter == null) {
                this.printTaskLog(response, (OutputStream)out, taskId, start, end, plainText, TaskLog.LogName.STDOUT);
                this.printTaskLog(response, (OutputStream)out, taskId, start, end, plainText, TaskLog.LogName.STDERR);
                this.printTaskLog(response, (OutputStream)out, taskId, start, end, plainText, TaskLog.LogName.SYSLOG);
                if (this.haveTaskLog(taskId, TaskLog.LogName.DEBUGOUT)) {
                    this.printTaskLog(response, (OutputStream)out, taskId, start, end, plainText, TaskLog.LogName.DEBUGOUT);
                }
                if (this.haveTaskLog(taskId, TaskLog.LogName.PROFILE)) {
                    this.printTaskLog(response, (OutputStream)out, taskId, start, end, plainText, TaskLog.LogName.PROFILE);
                }
            } else {
                this.printTaskLog(response, (OutputStream)out, taskId, start, end, plainText, filter);
            }
            out.write("</body></html>\n".getBytes());
            out.close();
        } else if (filter == null) {
            response.sendError(400, "You must supply a value for `filter' (STDOUT, STDERR, or SYSLOG) if you set plainText = true");
        } else {
            this.printTaskLog(response, (OutputStream)out, taskId, start, end, plainText, filter);
        }
    }
}

