/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.join;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.join.ResetableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamBackedIterator<X extends Writable>
implements ResetableIterator<X> {
    private ByteArrayOutputStream outbuf = new ByteArrayOutputStream();
    private DataOutputStream outfbuf = new DataOutputStream(this.outbuf);
    private ReplayableByteInputStream inbuf;
    private DataInputStream infbuf;

    @Override
    public boolean hasNext() {
        return this.infbuf != null && this.inbuf.available() > 0;
    }

    @Override
    public boolean next(X val) throws IOException {
        if (this.hasNext()) {
            this.inbuf.mark(0);
            val.readFields(this.infbuf);
            return true;
        }
        return false;
    }

    @Override
    public void replay(X val) throws IOException {
        this.inbuf.reset();
        val.readFields(this.infbuf);
    }

    @Override
    public void reset() {
        if (null != this.outfbuf) {
            this.inbuf = new ReplayableByteInputStream(this.outbuf.toByteArray());
            this.infbuf = new DataInputStream(this.inbuf);
            this.outfbuf = null;
        }
        this.inbuf.resetStream();
    }

    @Override
    public void add(X item) throws IOException {
        item.write(this.outfbuf);
    }

    @Override
    public void close() throws IOException {
        if (null != this.infbuf) {
            this.infbuf.close();
        }
        if (null != this.outfbuf) {
            this.outfbuf.close();
        }
    }

    @Override
    public void clear() {
        if (null != this.inbuf) {
            this.inbuf.resetStream();
        }
        this.outbuf.reset();
        this.outfbuf = new DataOutputStream(this.outbuf);
    }

    private static class ReplayableByteInputStream
    extends ByteArrayInputStream {
        public ReplayableByteInputStream(byte[] arr) {
            super(arr);
        }

        public void resetStream() {
            this.mark = 0;
            this.reset();
        }
    }
}

